from warnings import warn
from xml.sax import saxutils
from xml.sax import make_parser
from xml.sax.handler import feature_namespaces
import os

GTODO_CATEGORY="Personal"

global memo

def warnFalse (res, msg=""):
	if not res:
		warn ("WARNIMG: %s" % msg)

def warnTrue (res, msg=""):
	if res:
		warn ("WARNIMG: %s" % msg)


class PyTodo (saxutils.DefaultHandler):
	def __init__ (self, category=None):
#		print "INIT"
		self.category = category
		self.memoList = []
		self.inGTodo = 0
		self.currentItem = None
		self.validCategory = 0
		self.inComment = 0
		self.inSummary = 0

	

	def startElement (self, name, attrs):
#		print "startElement %s:" % name, attrs.getNames()
	
		if name == "gtodo":
#			warnTrue (self.inGTodo, "Already in gtodo")
			self.inGTodo = 1
		elif name == "config":
			pass
		elif name == "category":
#			warnFalse (self.inGTodo, "Not in gtodo for category")
#			warnTrue (self.validCategory, "Already in a valid category")
			
			if ((self.category == None) or (attrs.get("title") == self.category)):
				self.validCategory = 1
		elif name == "item":
#			warnFalse (self.currentItem==None, "Already in an item")
			if self.validCategory:
				self.currentItem = [0,0,0,0]
		elif name == "attribute":
#			warnTrue (self.currentItem==None, "Mot in an item")

#			print self.currentItem
			if self.currentItem != None:
				self.currentItem[2] = int(attrs.get("priority")) + 1
				self.currentItem[3] = int(attrs.get("done"))
		elif name == "summary":
#			warnTrue (self.currentItem==None, "Mot in an item")
#			warnTrue (self.inComment, "Already in a comment")
#			warnTrue (self.inSummary, "Already in a summary")
			if self.currentItem != None:
				self.inSummary = 1
				self.currentItem[0] = ""
		elif name == "comment":
#			 warnTrue (self.currentItem==None, "Mot in an item")
#			 warnTrue (self.inComment, "Already in a comment")
#			 warnTrue (self.inSummary, "Already in a summary")
		
			if self.currentItem != None:
				self.inComment = 1
				self.currentItem[1] = ""
		
	def characters (self, ch):
#		print "charecters %s & %d, %d" % (ch, self.inSummary, self.inComment)
		if self.inSummary:
			self.currentItem[0] += ch
		elif self.inComment:
			self.currentItem[1] += ch
	
	def endElement (self, name):
		if name == "gtodo":
#			warnFalse (self.inGTodo, "Not in gtodo")
			self.inGTodo = 0
		elif name == "config":
			pass
		elif name == "category":
#			warnFalse (self.inGTodo, "Not in gtodo for category")
			
			self.validCategory = 0
		elif name == "item":
#			warnTrue (self.currentItem==None, "Not in an item")
			if self.currentItem != None:
				self.memoList.append(self.currentItem)
				self.currentItem = None
		elif name == "summary":
			self.inSummary = 0
			pass
		elif name =="comment":
			self.inComment = 0
			pass

parser = make_parser()
parser.setFeature(feature_namespaces, 0)
dh = PyTodo(GTODO_CATEGORY)
parser.setContentHandler(dh)

parser.parse(os.getenv("HOME")+"/.gtodo/todos")
memo = dh.memoList
#print file("/home/dbrody/.gtodo/todos").readlines()

