/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- March 1998
 */

/*
 * CheckoutDlg.h : the cvs checkout dialog
 */

#include "stdafx.h"

#ifdef WIN32
#	include "wincvs.h"
#	include <sys\stat.h>
#	include <direct.h>
#	include <errno.h>
#endif /* WIN32 */

#if qUnix
#	include "UCvsDialogs.h"
#endif

#ifdef qMacCvsPP
#	include <UModalDialogs.h>
#	include <LMultiPanelView.h>
#	include <LPopupGroupBox.h>
#	include <LCheckBox.h>
#	include <LTextEditView.h>
#	include <LEditText.h>
#	include <LPushButton.h>
#	include "LPopupFiller.h"

#	include "MacCvsApp.h"
#endif /* qMacCvsPP */

#include "CheckoutDlg.h"
#include "CvsPrefs.h"
#include "UpdateDlg.h"
#include "MultiString.h"
#include "PromptFiles.h"
#include "MakeSurePathExists.h"

CMString gOldModules(10, "P_OldModules");

#ifdef WIN32
#	include "GetPrefs.h"
#	ifdef _DEBUG
#	define new DEBUG_NEW
#	undef THIS_FILE
	static char THIS_FILE[] = __FILE__;
#	endif

IMPLEMENT_DYNCREATE(CCheckout_MAIN, CPropertyPage)

CCheckout_MAIN::CCheckout_MAIN(const char * modname, const char * path) :
	CPropertyPage(CCheckout_MAIN::IDD)
{
	//{{AFX_DATA_INIT(CCheckout_MAIN)    
	m_norecurs = FALSE;
	m_stdout = FALSE;
	m_overrideCheckoutDir = FALSE;
	m_checkoutDir = _T("");
	//}}AFX_DATA_INIT
	m_modname = modname;
	m_path = path;
	if( m_path.IsEmpty() )
	{
		CWincvsApp* app = (CWincvsApp *)AfxGetApp();
		if( 0L != app )
			m_path = app->GetRoot();
	}
}

CCheckout_MAIN::CCheckout_MAIN() : CPropertyPage(CCheckout_MAIN::IDD)
{
}

CCheckout_MAIN::~CCheckout_MAIN()
{
}

void CCheckout_MAIN::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);

	//{{AFX_DATA_MAP(CCheckout_MAIN)
    DDX_Control(pDX, IDC_PATH, m_editPath);
	DDX_Control(pDX, IDC_MODNAME, m_modcombo);	    
	DDX_Text(pDX, IDC_MODNAME, m_modname);
	DDV_MinChars(pDX, m_modname, 1);
	DDX_Text(pDX, IDC_PATH, m_path);
	DDX_Check(pDX, IDC_NORECURS, m_norecurs);
	DDX_Check(pDX, IDC_STDOUT, m_stdout);
	DDX_Check(pDX, IDC_CHECK_OVERRIDECHECKOUTDIR, m_overrideCheckoutDir);
	DDX_Text(pDX, IDC_EDIT_CHECKOUTDIR, m_checkoutDir);
	//}}AFX_DATA_MAP
	DDX_ComboMString(pDX, IDC_MODNAME, gOldModules, m_modcombo);

	if (pDX->m_bSaveAndValidate)
	{
		if (!CompatMakeSurePathExists(m_path))
		{
			AfxMessageBox("Cannot find folder " + m_path);
			pDX->PrepareEditCtrl(IDC_PATH);
			pDX->Fail();
		}
	}
	else
	{
		//see if we are overriding the checkout directory
		OnCheckOverridecheckoutdir();
	}
}


BEGIN_MESSAGE_MAP(CCheckout_MAIN, CPropertyPage)
	//{{AFX_MSG_MAP(CCheckout_MAIN)
	ON_BN_CLICKED(IDC_BTNPATH, OnBtnPath)
	ON_BN_CLICKED(IDC_CHECK_OVERRIDECHECKOUTDIR, OnCheckOverridecheckoutdir)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCheckout_MAIN message handlers

void CCheckout_MAIN::OnBtnPath() 
{
	// copy controls to member variables, then update those and finally refresh controls
    TCHAR path[_MAX_PATH];
    m_editPath.GetWindowText(path, _MAX_PATH);
    BOOL selected = BrowserGetDirectory("Select a directory to checkout :", path, MAX_PATH, IsWindow(this->m_hWnd) ? this : NULL );
	if (selected)
	{
		m_path = path;
		m_editPath.SetWindowText(path);
	}
}

void CCheckout_MAIN::OnCheckOverridecheckoutdir() 
{
	// TODO: Add your control notification handler code here
	CButton* but = (CButton *)GetDlgItem(IDC_CHECK_OVERRIDECHECKOUTDIR);
	CWnd* wnd = GetDlgItem(IDC_EDIT_CHECKOUTDIR);
	BOOL enableCheckoutDir = but->GetCheck() == 1;

	wnd->EnableWindow(enableCheckoutDir);
	if( enableCheckoutDir )
	{
		CString strCheckoutDir;
		wnd->GetWindowText(strCheckoutDir);
		if( strCheckoutDir.IsEmpty() )
		{
			CString strModuleName;
			if( GetDlgItemText(IDC_MODNAME, strModuleName) )
			{
				wnd->SetWindowText(strModuleName);
				GotoDlgCtrl(wnd);
			}
		}
	}
}

IMPLEMENT_DYNCREATE(CCheckout_OPTIONS, CPropertyPage)

CCheckout_OPTIONS::CCheckout_OPTIONS(const char *rev, const char *date) : CPropertyPage(CCheckout_OPTIONS::IDD)
{
	//{{AFX_DATA_INIT(CCheckout_OPTIONS)
	m_date = date;
	m_rev = rev;
	m_hasdate = FALSE;
	m_match = FALSE;
	m_hasrev = FALSE;
	m_export = FALSE;
	m_forceroot = FALSE;
	//}}AFX_DATA_INIT
}

CCheckout_OPTIONS::CCheckout_OPTIONS() : CPropertyPage(CCheckout_OPTIONS::IDD)
{
}

CCheckout_OPTIONS::~CCheckout_OPTIONS()
{
}

void CCheckout_OPTIONS::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCheckout_OPTIONS)
	DDX_Control(pDX, IDC_COMBOREV, m_revdef);
	DDX_Control(pDX, IDC_COMBODATE, m_datedef);
	DDX_CBString(pDX, IDC_COMBODATE, m_date);
	DDX_CBString(pDX, IDC_COMBOREV, m_rev);
	DDX_Check(pDX, IDC_DATE, m_hasdate);
	DDX_Check(pDX, IDC_MATCH, m_match);
	DDX_Check(pDX, IDC_REV, m_hasrev);
	DDX_Check(pDX, IDC_EXPORT, m_export);
	DDX_Check(pDX, IDC_FORCEROOT, m_forceroot);
	//}}AFX_DATA_MAP
	if(m_hasrev)
		DDV_MinChars(pDX, m_rev, 1);
	if(m_hasdate)
		DDV_MinChars(pDX, m_date, 1);
	if(!pDX->m_bSaveAndValidate)
	{
		OnDate();
		OnRev();
	}
	DDX_ComboMString(pDX, IDC_COMBOREV, gRevNames, m_revdef);
	DDX_ComboMString(pDX, IDC_COMBODATE, gDateNames, m_datedef);
}


BEGIN_MESSAGE_MAP(CCheckout_OPTIONS, CPropertyPage)
	//{{AFX_MSG_MAP(CCheckout_OPTIONS)
	ON_BN_CLICKED(IDC_DATE, OnDate)
	ON_BN_CLICKED(IDC_REV, OnRev)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCheckout_OPTIONS message handlers

void CCheckout_OPTIONS::OnDate() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_DATE);
	CWnd* wnd = GetDlgItem(IDC_COMBODATE);
	wnd->EnableWindow(but->GetCheck() == 1);
}

void CCheckout_OPTIONS::OnRev() 
{
	CButton* but = (CButton *)GetDlgItem(IDC_REV);
	CWnd* wnd = GetDlgItem(IDC_COMBOREV);
	wnd->EnableWindow(but->GetCheck() == 1);
}
#endif /* WIN32 */

#ifdef qMacCvsPP
static void DoDataExchange_CheckoutMain(LWindow *theDialog, CPStr & modname,
	bool & norecurs, bool & toStdout, bool putValue)
{
	LEditText *mname = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_ModuleName));
	LCheckBox *chkNoRecurs = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_NoRecurs));
	LCheckBox *chkToStdout = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_ToStout));
	LPopupFiller *filler = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_PopModName));
	
	filler->DoDataExchange(gOldModules, putValue);

	if(putValue)
	{
		mname->SetText((Ptr)(const char *)modname, modname.length());	
		chkNoRecurs->SetValue(norecurs ? Button_On : Button_Off);
		chkToStdout->SetValue(toStdout ? Button_On : Button_Off);
		theDialog->SetLatentSub(mname);
		
		// this will take care about an empty module name
		mname->AddListener(CMacCvsApp::app);
		if(modname.length() == 0)
		{
			LPushButton *theOK = dynamic_cast<LPushButton*>
										(theDialog->FindPaneByID(item_OK));
			Assert_(theOK != 0L);
			theOK->Disable();
		}
	}
	else
	{
		char buf[512];
		Size len;
		mname->GetText(buf, 511, &len);
		modname.set(buf, len);
		
		norecurs = chkNoRecurs->GetValue() == Button_On;
		toStdout = chkToStdout->GetValue() == Button_On;
	}
}

static void DoDataExchange_CheckoutOptions(LWindow *theDialog, bool & hasDate, bool & hasRev,
	CPStr & sLastDate, CPStr & sLastRev, bool & useMostRecent, bool putValue)
{
	LCheckBox *chkHasDate = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_CheckDate));
	LCheckBox *chkHasRev = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_CheckRevTag));
	LCheckBox *chkMostRecent = dynamic_cast<LCheckBox*>
		(theDialog->FindPaneByID(item_MostRecentRev));
	LEditText *editDate = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_EditDate));
	LEditText *editRev = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_EditRevTag));
	LPopupFiller *fillTag = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerTag));
	LPopupFiller *fillDate = dynamic_cast<LPopupFiller*>
		(theDialog->FindPaneByID(item_FillerDate));
	
	fillTag->DoDataExchange(gRevNames, putValue);
	fillDate->DoDataExchange(gDateNames, putValue);

	if(putValue)
	{
		chkHasDate->SetValue(hasDate ? Button_On : Button_Off);
		chkHasRev->SetValue(hasRev ? Button_On : Button_Off);
		chkMostRecent->SetValue(useMostRecent ? Button_On : Button_Off);
		editDate->SetText((Ptr)(const char *)sLastDate, sLastDate.length());
		editRev->SetText((Ptr)(const char *)sLastRev, sLastRev.length());
	}
	else
	{
		hasDate = chkHasDate->GetValue() == Button_On;
		hasRev = chkHasRev->GetValue() == Button_On;
		useMostRecent = chkMostRecent->GetValue() == Button_On;

		char str[255];
		Size len;
		
		editDate->GetText(str, 254, &len);
		sLastDate.set(str, len);
		editRev->GetText(str, 254, &len);
		sLastRev.set(str, len);
	}
}
#endif /* qMacCvsPP */

#if qUnix
class UCvsCheckout : public UWidget
{
	UDECLARE_DYNAMIC(UCvsCheckout)
public:
	UCvsCheckout() : UWidget(::UEventGetWidID()) {}
	virtual ~UCvsCheckout() {}

	enum
	{
		kOK = EV_COMMAND_START,	// 0
		kCancel,				// 1
		kTabGeneral				// 2
	};

	virtual void DoDataExchange(bool fill);

protected:
	ev_msg int OnOK(void);
	ev_msg int OnCancel(void);

	UDECLARE_MESSAGE_MAP()
};

UIMPLEMENT_DYNAMIC(UCvsCheckout, UWidget)

UBEGIN_MESSAGE_MAP(UCvsCheckout, UWidget)
	ON_UCOMMAND(UCvsCheckout::kOK, UCvsCheckout::OnOK)
	ON_UCOMMAND(UCvsCheckout::kCancel, UCvsCheckout::OnCancel)
UEND_MESSAGE_MAP()

int UCvsCheckout::OnOK(void)
{
	EndModal(true);
	return 0;
}

int UCvsCheckout::OnCancel(void)
{
	EndModal(false);
	return 0;
}

void UCvsCheckout::DoDataExchange(bool fill)
{
	if(fill)
	{
	}
	else
	{
	}
}

class UCvsCheckout_MAIN : public UWidget
{
	UDECLARE_DYNAMIC(UCvsCheckout_MAIN)
public:
	UCvsCheckout_MAIN(const char * modname, const char * path);
	virtual ~UCvsCheckout_MAIN() {}

	enum
	{
		kComboPath = EV_COMMAND_START,	// 0
		kStaticPath,			// 1
		kBtnPath,				// 2
		kCheckStdout,			// 3
		kCheckRecurse			// 4
	};

	virtual void DoDataExchange(bool fill);

	UStr m_path;
	UStr m_modname;
	bool m_norecurs;
	bool m_stdout;

protected:
	ev_msg int OnPath(void);

	UDECLARE_MESSAGE_MAP()
};

UIMPLEMENT_DYNAMIC(UCvsCheckout_MAIN, UWidget)

UBEGIN_MESSAGE_MAP(UCvsCheckout_MAIN, UWidget)
	ON_UCOMMAND(UCvsCheckout_MAIN::kBtnPath, UCvsCheckout_MAIN::OnPath)
UEND_MESSAGE_MAP()

UCvsCheckout_MAIN::UCvsCheckout_MAIN(const char * modname, const char * path) : UWidget(::UEventGetWidID())
{
	m_path = path;
	m_modname = modname;
	m_norecurs = false;
	m_stdout = false;
}

int UCvsCheckout_MAIN::OnPath(void)
{
	const char *dir = BrowserGetDirectory("Select a directory to checkout to :");
	if(dir != 0L)
		UEventSendMessage(GetWidID(), EV_SETTEXT, kStaticPath, (void *)dir);
	
	return 0;
}

void UCvsCheckout_MAIN::DoDataExchange(bool fill)
{
	::DoDataExchange(fill, GetWidID(), kComboPath, gOldModules);

	if(fill)
	{
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckStdout, m_stdout), 0L);
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckRecurse, m_norecurs), 0L);

		UEventSendMessage(GetWidID(), EV_SETTEXT, kComboPath, (void *)(const char *)m_modname);
		UEventSendMessage(GetWidID(), EV_SETTEXT, kStaticPath, (void *)(const char *)m_path);
	}
	else
	{
		m_stdout = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckStdout, 0L) != 0;
		m_norecurs = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckRecurse, 0L) != 0;

		UEventSendMessage(GetWidID(), EV_GETTEXT, kComboPath, &m_modname);
		UEventSendMessage(GetWidID(), EV_GETTEXT, kStaticPath, &m_path);
	}
}

class UCvsCheckout_STICKY : public UWidget
{
	UDECLARE_DYNAMIC(UCvsCheckout_STICKY)
public:
	UCvsCheckout_STICKY(const char *rev, const char *date);
	virtual ~UCvsCheckout_STICKY() {}

	enum
	{
		kCheckDate = EV_COMMAND_START,	// 0
		kComboDate,			// 1
		kCheckRev,			// 2
		kComboRev,			// 3
		kCheckMatch			// 4
	};

	virtual void DoDataExchange(bool fill);

	UStr m_date;
	UStr m_rev;
	bool m_hasdate;
	bool m_hasrev;
	bool m_match;
protected:

	ev_msg int OnDate(void);
	ev_msg int OnRev(void);

	UDECLARE_MESSAGE_MAP()
};

UIMPLEMENT_DYNAMIC(UCvsCheckout_STICKY, UWidget)

UBEGIN_MESSAGE_MAP(UCvsCheckout_STICKY, UWidget)
	ON_UCOMMAND(UCvsCheckout_STICKY::kCheckDate, UCvsCheckout_STICKY::OnDate)
	ON_UCOMMAND(UCvsCheckout_STICKY::kCheckRev, UCvsCheckout_STICKY::OnRev)
UEND_MESSAGE_MAP()

UCvsCheckout_STICKY::UCvsCheckout_STICKY(const char *rev, const char *date) : UWidget(::UEventGetWidID())
{
	m_date = date;
	m_rev = rev;
	m_hasdate = false;
	m_hasrev = false;
	m_match = false;
}

int UCvsCheckout_STICKY::OnDate()
{
	int state = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckDate, 0L);
	UEventSendMessage(GetWidID(), EV_ENABLECMD, UMAKEINT(kComboDate, state), 0L);
	return 0;
}

int UCvsCheckout_STICKY::OnRev()
{
	int state = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckRev, 0L);
	UEventSendMessage(GetWidID(), EV_ENABLECMD, UMAKEINT(kComboRev, state), 0L);
	return 0;
}

void UCvsCheckout_STICKY::DoDataExchange(bool fill)
{
	::DoDataExchange(fill, GetWidID(), kComboRev, gRevNames);
	::DoDataExchange(fill, GetWidID(), kComboDate, gDateNames);

	if(fill)
	{
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckDate, m_hasdate), 0L);
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckRev, m_hasrev), 0L);
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckMatch, m_match), 0L);

		OnDate();
		OnRev();
	}
	else
	{
		m_hasdate = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckDate, 0L);
		m_hasrev = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckRev, 0L);
		m_match = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckMatch, 0L);

		UEventSendMessage(GetWidID(), EV_GETTEXT, kComboDate, &m_date);
		UEventSendMessage(GetWidID(), EV_GETTEXT, kComboRev, &m_rev);
	}
}

class UCvsCheckout_OPTIONS : public UWidget
{
	UDECLARE_DYNAMIC(UCvsCheckout_OPTIONS)
public:
	UCvsCheckout_OPTIONS();
	virtual ~UCvsCheckout_OPTIONS() {}

	enum
	{
		kCheckForce = EV_COMMAND_START,	// 0
		kCheckExport		// 1
	};

	virtual void DoDataExchange(bool fill);

	bool m_export;
	bool m_forceroot;
protected:

	UDECLARE_MESSAGE_MAP()
};

UIMPLEMENT_DYNAMIC(UCvsCheckout_OPTIONS, UWidget)

UBEGIN_MESSAGE_MAP(UCvsCheckout_OPTIONS, UWidget)
UEND_MESSAGE_MAP()

UCvsCheckout_OPTIONS::UCvsCheckout_OPTIONS() : UWidget(::UEventGetWidID())
{
	m_export = false;
	m_forceroot = false;
}

void UCvsCheckout_OPTIONS::DoDataExchange(bool fill)
{
	if(fill)
	{
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckForce, m_forceroot), 0L);
		UEventSendMessage(GetWidID(), EV_SETSTATE, UMAKEINT(kCheckExport, m_export), 0L);
	}
	else
	{
		m_forceroot = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckForce, 0L);
		m_export = UEventSendMessage(GetWidID(), EV_QUERYSTATE, kCheckExport, 0L);
	}
}
#endif // qUnix

bool CompatGetCheckout(CPStr & modname, CPStr & path, bool & norecurs,
					   bool & toStdout, CPStr & date, CPStr & rev,
					   bool & useMostRecent, bool & doexport, bool & forceCvsroot,
					   bool & overrideCheckoutDir, CPStr & checkoutDir)
{
	bool userHitOK = false;

	date = "";
	rev = "";
	modname = "";
	norecurs = false;
	toStdout = false;
	useMostRecent = false;
	doexport = false;
	forceCvsroot = false;
	overrideCheckoutDir = false;
	
	bool hasDate = false;
	bool hasRev = false;
	static CPStr sLastModName;
	static CPStr sLastRev;
	static CPStr sLastDate;

#ifdef WIN32
	CPropertySheet pages("Checkout settings");
	pages.m_psh.dwFlags |= PSH_NOAPPLYNOW;
	CCheckout_MAIN page1(sLastModName, path);
	CCheckout_OPTIONS page2(sLastRev, sLastDate);
	CGetPrefs_CVSROOT page3;
	CGetPrefs_GLOBALS page4;
	pages.AddPage(&page1);
	pages.AddPage(&page2);
	pages.AddPage(&page3);
	pages.AddPage(&page4);
	if(pages.DoModal() == IDOK)
	{
		sLastModName = (const char *)page1.m_modname;
		path = (const char *)page1.m_path;
		norecurs = page1.m_norecurs == TRUE;
		toStdout = page1.m_stdout == TRUE;
		overrideCheckoutDir = page1.m_overrideCheckoutDir == TRUE;
		checkoutDir = (const char *)page1.m_checkoutDir;

		sLastDate = page2.m_date;
		sLastRev = page2.m_rev;
		hasDate = page2.m_hasdate == TRUE;
		hasRev = page2.m_hasrev == TRUE;
		useMostRecent = page2.m_match == TRUE;
		doexport = page2.m_export == TRUE;
		forceCvsroot = page2.m_forceroot == TRUE;

		page3.StoreValues();
		page4.StoreValues();
		userHitOK = true;
	}
#endif /* WIN32 */
#ifdef qMacCvsPP
	StDialogHandler	theHandler(dlg_Checkout, CMacCvsApp::app);
	LWindow *theDialog = theHandler.GetDialog();
	ThrowIfNil_(theDialog);
	static UInt16 sRuntimePanel = 1;
	
	LMultiPanelView *multiView = dynamic_cast<LMultiPanelView*>
		(theDialog->FindPaneByID(item_MultiViewPrefs));
	LPopupGroupBox *groupView = dynamic_cast<LPopupGroupBox*>
		(theDialog->FindPaneByID(item_GroupViewPrefs));
	
	multiView->SwitchToPanel(3);
	DoDataExchange_Globals(theDialog, true);
	multiView->SwitchToPanel(2);
	DoDataExchange_CheckoutOptions(theDialog, hasDate, hasRev,
		sLastDate, sLastRev, useMostRecent, true);
	multiView->SwitchToPanel(1);
	DoDataExchange_CheckoutMain(theDialog, sLastModName, norecurs, toStdout, true);
	
	
	groupView->SetValue(sRuntimePanel);
	theDialog->Show();
	MessageT hitMessage;
	while (true)
	{		// Let DialogHandler process events
		hitMessage = theHandler.DoDialog();
		
		if (hitMessage == msg_OK || hitMessage == msg_Cancel)
			break;
	}
	theDialog->Hide();
	sRuntimePanel = groupView->GetValue();
	
	if(hitMessage == msg_OK)
	{
		multiView->SwitchToPanel(1);
		DoDataExchange_CheckoutMain(theDialog, sLastModName, norecurs, toStdout, false);
		multiView->SwitchToPanel(2);
		DoDataExchange_CheckoutOptions(theDialog, hasDate, hasRev,
			sLastDate, sLastRev, useMostRecent, false);
		multiView->SwitchToPanel(3);
		DoDataExchange_Globals(theDialog, false);
		
		Assert_(sLastModName.length() != 0);
		
		userHitOK = true;
	}
#endif /* qMacCvsPP */
#if qUnix
	void *wid = UCreate_CheckoutDlg();

	UCvsCheckout *dlg = new UCvsCheckout();
	UCvsCheckout_MAIN *tab1 = new UCvsCheckout_MAIN(sLastModName, path);
	UCvsCheckout_STICKY *tab2 = new UCvsCheckout_STICKY(sLastRev, sLastDate);
	UCvsCheckout_OPTIONS *tab3 = new UCvsCheckout_OPTIONS();
	UEventSendMessage(dlg->GetWidID(), EV_INIT_WIDGET, kUMainWidget, wid);	
	dlg->AddPage(tab1, UCvsCheckout::kTabGeneral, 0);
	dlg->AddPage(tab2, UCvsCheckout::kTabGeneral, 1);
	dlg->AddPage(tab3, UCvsCheckout::kTabGeneral, 2);

	if(dlg->DoModal())
	{
		sLastModName = tab1->m_modname;
		path = tab1->m_path;
		norecurs = tab1->m_norecurs;
		toStdout = tab1->m_stdout;

		sLastDate = tab2->m_date;
		sLastRev = tab2->m_rev;
		hasDate = tab2->m_hasdate;
		hasRev = tab2->m_hasrev;
		useMostRecent = tab2->m_match;

		doexport = tab3->m_export;
		forceCvsroot = tab3->m_forceroot;

		userHitOK = true;
	}

	delete dlg;
#endif // qUnix

	if(userHitOK)
	{
		if(hasDate && !sLastDate.empty())
			date = sLastDate;
		if(hasRev && !sLastRev.empty())
			rev = sLastRev;

		modname = sLastModName;

		gCvsPrefs.save();
	}
	return userHitOK;
}


