package GCPlugins::GCgames::GCJeuxVideoCom;

###################################################
#
#  Copyright 2005-2006 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;
use utf8;

use GCPlugins::GCgames::GCgamesCommon;

{
    package GCPlugins::GCgames::GCPluginJeuxVideoCom;

    use base 'GCPlugins::GCgames::GCgamesPluginsBase';

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;
        if ($self->{parsingList})
        {
            if ($tagname eq 'ul')
            {
                    if ( $attr->{class} eq 'liste_liens' )
                    {
                        $self->{isGame} = 1 ;
                    }
            }
            elsif ($tagname eq 'img')
            {
                    if ( $attr->{alt}  )
                    {
                        $self->{SavePlatform} = $attr->{alt} ;
                    }
            }
            elsif ($self->{isGame})
            {
                if ($tagname eq 'a')
                {
                    $self->{itemIdx}++;
                    $self->{itemsList}[$self->{itemIdx}]->{url} = $attr->{href};
                    $self->{itemsList}[$self->{itemIdx}]->{platform} = $self->{SavePlatform};
                    $self->{itemsList}[$self->{itemIdx}]->{platform} =~ s/Playstation Portable/PSP/;
                    $self->{isName} = 1 ;
                }
            }
        }
        elsif ($self->{parsingTips})
        {
            if (($tagname eq 'h2') && ($self->{isTip} ne 3))
            {
                $self->{isTip} = 2;
            }
            elsif ( (($tagname eq 'p') || ($tagname eq 'h4') || ($tagname eq 'h3') ) && ($self->{isTip} ne 3))
            {
                $self->{isTip} = 1;
            }
            elsif ($tagname eq 'noscript')
            {
                $self->{isTip} = 3;
            }
            elsif ($tagname eq 'head')
            {
                $self->{isTip} = 0;
                $self->{urlTips} = '';
            }

        }
        else
        {

            if ( ($tagname eq 'h2') && ($attr->{id} eq 'titre_jeu') )
            {
                    $self->{is} = 'name';
            }
            elsif ( ($tagname eq 'img') && ($self->{curInfo}->{name}) && ($self->{curInfo}->{platform} eq '') )
            {
                    $self->{curInfo}->{platform} = $attr->{alt};
                    $self->{curInfo}->{platform} =~ s/Playstation Portable/PSP/;
            }
            elsif ($tagname eq 'strong')
            {
                   $self->{isStrong} = 1;
            }
            elsif ( ($tagname eq 'a') && ($self->{isEditor}) )
            {
                    $self->{is} = 'editor';
                    $self->{isEditor} = 0;
            }
            elsif ( ($tagname eq 'td') && ($self->{isGenre}) )
            {
                    $self->{is} = 'genre';
                    $self->{isGenre} = 0;
            }
            elsif ( ($tagname eq 'td') && ($self->{isDate}) )
            {
                    $self->{is} = 'released';
                    $self->{isDate} = 0;
            }
            elsif ( ($tagname eq 'div') && ($attr->{id} eq 'commander') )
            {
                    $self->{isBox} = 1;
            }
            elsif ( ($tagname eq 'img') && ($self->{isBox}) )
            {
                    if (( $attr->{src} ne "http://image.jeuxvideo.com/pics/pasdimage2.gif" ) && ($attr->{src} ne "http://image.jeuxvideo.com/pics/pasdimage.gif"))
                    {
                        $self->{curInfo}->{boxpic} = $attr->{src};
                    }
                    $self->{isBox} = 0;
            }
            elsif ( ($tagname eq 'div') && ($attr->{id} eq 'quelques_images') )
            {
                    $self->{isScreen} = 1;
            }
            elsif ( ($tagname eq 'img') && ($self->{isScreen}) )
            {
                    if ($self->{curInfo}->{screenshot1} eq '')
                    {
                        $self->{curInfo}->{screenshot1} = $attr->{src};
                        $self->{curInfo}->{screenshot1} =~ s/.gif/.jpg/;
                    }
                    elsif ($self->{curInfo}->{screenshot2} eq '')
                    {
                        $self->{curInfo}->{screenshot2} = $attr->{src};
                        $self->{curInfo}->{screenshot2} =~ s/.gif/.jpg/;
                        $self->{isScreen} = 0;
                    }
            }
            elsif ( ($tagname eq 'p') && ($attr->{class} eq 'lien_base') )
            {
                    $self->{isTest} = 2;
            }
            elsif ( ($tagname eq 'a') && ($self->{urlTips} eq '1') )
            {
                    $self->{urlTips} = $attr->{href};
            }
            elsif ( ($tagname eq 'a') && ($self->{isTest} eq '1') )
            {
                    my $html = $self->loadPage($attr->{href});
                    my $found = index($html,"<p id=\"chapo\">");
                    if ( $found >= 0 )
                    {
                       my $html_Desc = substr($html, $found +length('<p id="chapo">'),length($html)- $found -length('<p id="chapo">'));
                       $html_Desc = substr($html_Desc,index($html_Desc,"<strong>") + length("<strong>"),index($html_Desc,"</strong>")-index($html_Desc,"<strong>")-length("<strong>") );
                       $self->{curInfo}->{description} = $html_Desc;
                    }
                    $found = index($html,"<dt>Multijoueurs :</dt>");
                    if ( $found >= 0 )
                    {
                       my $html_Nbr = substr($html, $found + length("<dt>Multijoueurs :</dt>"), length($html)- $found -length("<dt>Multijoueurs :</dt>"));
                       $html_Nbr = substr($html_Nbr,index($html_Nbr,"<dd>") + length("<dd>") ,index($html_Nbr,"</dd>")-index($html_Nbr,"<dd>")-length("<dd>") );
                       $html_Nbr =~ s/-/1/;
                       $html_Nbr =~ s/Non/1/;
                       $html_Nbr =~ s/non/1/;
                       $html_Nbr =~ s/Oui/Multijoueurs/;
                       $html_Nbr =~ s/oui/Multijoueurs/;
                       $self->{curInfo}->{players} = $html_Nbr;
                    }
                    $self->{isTest} = 0;
            }

        }
    }

    sub end
    {
	my ($self, $tagname) = @_;
		
        $self->{inside}->{$tagname}--;
        if ($self->{parsingList})
        {
            if ($tagname eq 'ul')
            {
              $self->{isGame} = 0;
            }
        }
    }

    sub text
    {
        my ($self, $origtext) = @_;

        if ($self->{parsingList})
        {
            if ($self->{isName})
            {
                $self->{itemsList}[$self->{itemIdx}]->{name} = $origtext;
                $self->{isName} = 0;
            }
            elsif ($self->{isDate})
            {
                $self->{itemsList}[$self->{itemIdx}]->{released} = $origtext;
                $self->{isDate} = 0;
            }
            elsif ($self->{isGenre})
            {
                $self->{itemsList}[$self->{itemIdx}]->{genre} = $origtext;
                $self->{isGenre} = 0;
            }
        }
        elsif ($self->{parsingTips})
        {
            if ($self->{isTip} eq 2)
            {
                $self->{curInfo}->{secrets} .= "\n\n" if $self->{curInfo}->{secrets};
                $self->{curInfo}->{secrets} .= $origtext;
                $self->{isTip} = 0;
            }
            elsif ($self->{isTip} eq 1)
            {
                chomp($origtext);
                if ( ($self->{curInfo}->{secrets}) && ($origtext ne "") )
                {
                   $self->{curInfo}->{secrets} .= "\n"
                }
                $self->{curInfo}->{secrets} .= $origtext;
                $self->{isTip} = 0;
            }
        }
        else
        {
            if ($self->{is})
            {
                $origtext =~ s/^\s*//;
                
                $self->{curInfo}->{$self->{is}} = $origtext;
                $self->{is} = '';
            }
            elsif ($self->{isStrong})
            {
                $self->{isDate} = 1 if $origtext =~ /Sortie :/;
                $self->{isGenre} = 1 if $origtext =~ /Type :/;
                $self->{isEditor} = 1 if $origtext =~ /Editeur :/;
                $self->{isStrong} = 0;
            }
            elsif ($self->{isTest} eq '2')
            {
                if ($origtext eq 'Voir toutes les ')
                {
                    $self->{urlTips} = 1;
                    $self->{isTest} = 0;
                }
                elsif ($origtext eq 'Lire le ')
                {
                    $self->{isTest} = 1;
                }
                else
                {
                    $self->{isTest} = 0;
                }
                
            }
        }
    } 

    sub getTipsUrl
    {
        my $self = shift;
        
        my $html = $self->loadPage($self->{urlTips});
        my $found = index($html,"\" onClick=");
        if ( $found >= 0 )
        {
          $html = substr($html, 0, $found );
          $html = reverse($html);
          $html = substr($html,0, index($html,"\"=ferh a<"));
          $html = reverse($html);
        }
        else
        {
          $html = "";
        }

        return $html;
    }

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{hasField} = {
            name => 1,
            platform => 1
        };

        $self->{isName} = 0;
        $self->{isGame} = 0;
        $self->{isEditor} = 0;
        $self->{isDate} = 0;
        $self->{isGenre} = 0;
        $self->{isBox} = 0;
        $self->{isScreen} = 0;
        $self->{isTip} = 0;
        $self->{SavePlatform} = "";
        $self->{is} = '';
        $self->{isStrong} = '';
        $self->{isTest} = 0;
        $self->{urlTips} = "";

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;

        if ($self->{parsingTips})
        {
            $html =~ s|<br />|<p>|g;
            $html =~ s|</kbd>||g;
            $html =~ s|</b>||g;
            $html =~ s|<img src="../pics/psx/cercle.gif" />|cercle|g;
            $html =~ s|<img src="../pics/psx/croix.gif" />|croix|g;
            $html =~ s|<img src="../pics/psx/carre.gif" />|carre|g;
            $html =~ s|<img src="../pics/psx/triangle.gif" />|triangle|g;

        }
        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;

        return 'http://www.jeuxvideo.com/recherche/0-'.$word.'.htm';
    }
    
    sub getItemUrl
    {
		my ($self, $url) = @_;
		
        return $url;
    }

    sub getName
    {
        return 'jeuxvideo.com';
    }
    
    sub getAuthor
    {
        return 'TPF';
    }
    
    sub getLang
    {
        return 'FR';
    }

    sub getCharset
    {
        my $self = shift;
    
        return "ISO-8859-1";
    }
}

1;
