package GCPlugins::GCfilms::GCMediadis;

###################################################
#
#  Copyright 2005-2006 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use GCPlugins::GCfilms::GCfilmsCommon;

{
    package GCPlugins::GCfilms::GCPluginMediadis;

    use base qw(GCPlugins::GCfilms::GCfilmsPluginsBase);

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;

        if ($self->{parsingList})
        {
            if ($tagname eq "a")
            {
                if (($attr->{href} =~ m|http://www\.mediadis\.com/video/detail\.asp|)
                 && ($attr->{class} eq 'a-blue'))
                {
                    my $url = $attr->{href};
                    $self->{isMovie} = 1;
                    $self->{isInfo} = 1;
                    $self->{itemIdx}++;
                    $self->{itemsList}[$self->{itemIdx}]->{url} = $url;
                }
            }
            if (($tagname eq 'td') && ($attr->{align} eq 'center') && ($attr->{class} eq 'search-list'))
            {
                $self->{couldBeYear} = 1;
            }
        }
        else
        {
            if ($tagname eq "img")
            {
                if ($attr->{src} =~ /^http:\/\/www\.(dvdzone2|mediadis)\.com\/pictures\/big\//)
                {
                    $self->{curInfo}->{image} = $attr->{src};
                }
            }
            elsif ($tagname eq "p")
            {
                $self->{insideSynopsis} = 1;
            }
            elsif ($tagname eq "span")
            {
                if (($attr->{class} eq "detail-title"))
                {
                    $self->{insideName}=1;
            	}
            }
        }
    }

    sub end
    {
		my ($self, $tagname) = @_;
		
        $self->{inside}->{$tagname}--;
    }

    sub text
    {
        my ($self, $origtext) = @_;

        return if length($origtext) < 2;
           
        if ($self->{parsingList})
        {
            if ($self->{isMovie})
            {
                $self->{itemsList}[$self->{itemIdx}]->{"title"} = $self->capWord($origtext);
                $self->{isMovie} = 0;
                $self->{isInfo} = 1;
                return;
            }
            elsif (($self->{couldBeYear}))
            {
                $self->{itemsList}[$self->{itemIdx}]->{'year'} = $1 if $origtext =~ m/([0-9]{4})/;
                $self->{couldBeYear} = 0;
            }
        }
        else
        {
            $origtext =~ s/ : //g if !$self->{insideSynopsis};
            if ($self->{insideType})
            {
                $origtext =~ s/ - /,/g;
                $self->{curInfo}->{type} .= $origtext;
                $self->{insideType} = 0;
            }
            elsif ($self->{insideDate})
            {
                $self->{curInfo}->{date} = $origtext;
                $self->{insideDate} = 0;
            }
            elsif ($self->{insideDirector})
            {
                $origtext =~ s/ - /, /g;
                $self->{curInfo}->{director} = $origtext if !$self->{curInfo}->{director};
                $self->{insideDirector} = 0;
            }
            elsif ($self->{insideSynopsis})
            {
                $self->{curInfo}->{synopsis} .= $origtext . "\n\n";
                $self->{insideSynopsis} = 0;
            }
            elsif ($self->{insideNat})
            {
                $self->{curInfo}->{country} = $origtext;
                $self->{insideNat} = 0;
            }
            elsif ($self->{insideTime})
            {
                $self->{curInfo}->{time} = $origtext;
                $self->{insideTime} = 0;
            }
            elsif ($self->{insideActors})
            {
                $origtext =~ s/ - /, /g;
                $self->{curInfo}->{actors} = $origtext if !$self->{curInfo}->{actors};
                $self->{insideActors} = 0;
            }
            elsif ($self->{insideOrig})
            {
                $self->{curInfo}->{original} = $self->capWord($origtext) if !$self->{curInfo}->{original};
                $self->{insideOrig} = 0;
            }
            elsif (($self->{inside}->{span}) && ($self->{insideName}))
            {
                $self->{curInfo}->{title} = $self->capWord($origtext) if !$self->{curInfo}->{title};
            }
            elsif ($self->{inside}->{strong})
            {
                $self->{insideDate}=1 if $origtext =~ m/Year/;
                $self->{insideDirector} = 1 if $origtext =~ m/Director\(s\)/;
                $self->{insideType} = 1 if $origtext =~ m/Genres/;
                $self->{insideOrig} = 1 if $origtext =~ m/Original title/;
                $self->{insideTime} = 1 if $origtext =~ m/Duration/;
                $self->{insideNat} = 1 if $origtext =~ m/Country/;
                $self->{insideActors} = 1 if $origtext =~ m/Actors/;
            }
        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{hasField} = {
            title => 1,
            date => 1,
            director => 0,
            actors => 0
        };

        $self->{isInfo} = 0;
        $self->{isMovie} = 0;
        $self->{curName} = undef;
        $self->{curUrl} = undef;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;

        $html =~ s|<a class="underline" href="http://www\.mediadis\.com/products/search\.asp\?par=[0-9]*" title="Filmography">([^<]*)</a>|$1|g;
        $html =~ s/&nbsp;/ /g;
        
        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
        return "http://www.mediadis.com/video/search.asp?t=19&pl=all&kw=$word";
    }
    
    sub getItemUrl
    {
		my ($self, $url) = @_;
		
        return $url unless $url eq '';
        return 'http://www.mediadis.com/video/';
    }

    sub getName
    {
        return 'Mediadis';
    }
    
    sub getImageFile
    {
        return "dvdzone2.png";
    }

    sub getAuthor
    {
        return 'Tian';
    }
    
    sub getLang
    {
        return 'EN';
    }
    
}

1;
