// -*- C++ -*-

/* 
 * GChemPaint library
 * reaction-operator.h 
 *
 * Copyright (C) 2004 Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#ifndef GCHEMPAINT_REACTION_OPERATOR_H
#define GCHEMPAINT_REACTION_OPERATOR_H

#include <gcu/object.h>

using namespace gcu;

class gcpReaction;

class gcpReactionOperator: public Object
{
public:
	gcpReactionOperator ();
	virtual ~gcpReactionOperator ();
	
	virtual void Add (GtkWidget* w);
	virtual void Update (GtkWidget* w);
	virtual void Move (double x, double y, double z = 0);
	virtual void SetSelected (GtkWidget* w, int state);
	void SetCoords (double x, double y);
	bool GetCoords (double* x, double* y);
	virtual double GetYAlign ();
	
private:
	double m_x, m_y;
};

#endif	//	GCHEMPAINT_REACTION_OPERATOR_H
