MACRO(GCC_MAKE_CONFIG_H output blocker typedefs tm_defines xm_defines
                        files extras specific cpu)
  SET(GCC_CONFIG_BLOCKER "${blocker}")
  SET(GCC_CONFIG_AUTO)
  SET(GCC_CONFIG_TYPEDEFS "${typedefs}")
  SET(GCC_CONFIG_TM_DEFINES)
  SET(GCC_CONFIG_XM_DEFINES)
  SET(GCC_CONFIG_INCLUDES)
  SET(GCC_CONFIG_EXTRAS)
  SET(GCC_CONFIG_SPECIFIC "${specific}")
  SET(GCC_CONFIG_CPU ${cpu})
  IF(GCC_CONFIG_CPU)
    SET(GCC_CONFIG_TM_DEFINES "#define TARGET_CPU_DEFAULT ${GCC_CONFIG_CPU}\n")
  ENDIF(GCC_CONFIG_CPU)
  FOREACH(d ${tm_defines})
    STRING(REGEX REPLACE "=.*" "" name "${d}")
    STRING(REGEX REPLACE "=" " " define "${d}")
    SET(GCC_CONFIG_TM_DEFINES
      "${GCC_CONFIG_TM_DEFINES}#ifndef ${name}\n# define ${define}\n#endif\n")
  ENDFOREACH(d)
  FOREACH(d ${xm_defines})
    STRING(REGEX REPLACE "=.*" "" name "${d}")
    STRING(REGEX REPLACE "=" " " define "${d}")
    SET(GCC_CONFIG_XM_DEFINES
      "${GCC_CONFIG_XM_DEFINES}#ifndef ${name}\n# define ${define}\n#endif\n")
  ENDFOREACH(d)
  FOREACH(f ${files})
    IF("${f}" MATCHES "^auto")
      SET(GCC_CONFIG_AUTO "${GCC_CONFIG_AUTO}#include \"${f}\"\n")
    ELSE("${f}" MATCHES "^auto")
      IF(EXISTS "${GCC_SOURCE_DIR}/gcc/config/${f}")
        SET(GCC_CONFIG_INCLUDES "${GCC_CONFIG_INCLUDES}# include \"config/${f}\"\n")
      ELSE(EXISTS "${GCC_SOURCE_DIR}/gcc/config/${f}")
        SET(GCC_CONFIG_INCLUDES "${GCC_CONFIG_INCLUDES}# include \"${f}\"\n")
      ENDIF(EXISTS "${GCC_SOURCE_DIR}/gcc/config/${f}")
    ENDIF("${f}" MATCHES "^auto")
  ENDFOREACH(f)
  FOREACH(f ${extras})
    IF("${f}" MATCHES "^auto")
      SET(GCC_CONFIG_AUTO "${GCC_CONFIG_AUTO}#include \"${f}\"\n")
    ELSE("${f}" MATCHES "^auto")
      SET(GCC_CONFIG_EXTRAS "${GCC_CONFIG_EXTRAS}#include \"${f}\"\n")
    ENDIF("${f}" MATCHES "^auto")
  ENDFOREACH(f)
  CONFIGURE_FILE(${GCCCONFIG_SOURCE_DIR}/gcc_config.h.in
                 ${GCC_BINARY_DIR}/gcc/${output} @ONLY IMMEDIATE)
ENDMACRO(GCC_MAKE_CONFIG_H)
