{ Test of the Pipe unit. }

program PipeTest2;

uses GPC, Pipe;

const
  ResultMessage : array [TWaitPIDResult] of TString =
    ('did not terminate with status ',
     'terminated with status ',
     'was teminated by signal ',
     'was stopped by signal ',
     'did something unexpected with status ');

var
  ToInput, f : Text;
  Process : PPipeProcess;
  WaitPIDResult : TWaitPIDResult;
  Status : Integer;
  IsEOF : Boolean;
  Result : TString;
  Parameters : TPStrings (2);

begin
  Parameters [1] := NewString ('-c');
  Parameters [2] := NewString ('exit 42');
  {$I-}
  Pipe (ToInput, f, f, 'sh', Parameters, GetCEnvironment, Process, nil);
  {$I+}
  if IOResult <> 0 then
    begin
      Writeln ('Could not create pipe.');
      Halt (1)
    end;
  Process^.Result := @WaitPIDResult;
  Process^.Status := @Status;
  Close (ToInput);
  IsEOF := EOF (f);
  if not IsEOF then Readln (f, Result);
  Close (f);
  if not IsEOF then
    Writeln ('Unexpected output `', Result, '''')
  else if (WaitPIDResult = PIDExited) and (Status = 42) then
    Writeln ('OK')
  else
    Writeln ('The process ', ResultMessage [WaitPIDResult], Status, '.');
end.
