"""
 * Copyright (C) 2008 Varun Hiremath.
 * Copyright (C) 2008 A Venkattraman.
 * Copyright (C) 2008 C Shyam Sundar.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * Authors: Varun Hiremath, Venkattraman A, Shyam Sundar C
 * Version 0.1

"""


from gastables.FannoFlow import FannoFlow
from scipy import arange

def get_allValues_from_M(M, gamma):
    fanno = FannoFlow(gamma)
    VALUES = {}
    VALUES["M"] = M
    VALUES["P/Pstar"] = fanno.get_P_by_Pstar_from_M(M)
    VALUES["T/Tstar"] = fanno.get_T_by_Tstar_from_M(M)
    VALUES["rho/rhostar"] = fanno.get_rho_by_rhostar_from_M(M)
    VALUES["Po/Postar"] = fanno.get_Po_by_Postar_from_M(M)
    VALUES["F/Fstar"] = fanno.get_F_by_Fstar_from_M(M)
    VALUES["4fLmax/D"] = fanno.get_4fLmax_by_D_from_M(M)

    return VALUES


def get_allValues_from_P_by_Pstar(P_by_Pstar,gamma):
	fanno = FannoFlow(gamma)
	return get_allValues_from_M(fanno.get_M_from_P_by_Pstar(P_by_Pstar),gamma)

def get_allValues_from_rho_by_rhostar(rho_by_rhostar,gamma):
	fanno = FannoFlow(gamma)
	return get_allValues_from_M(fanno.get_M_from_rho_by_rhostar(rho_by_rhostar),gamma)

def get_allValues_from_T_by_Tstar(T_by_Tstar,gamma):
	fanno = FannoFlow(gamma)
	return get_allValues_from_M(fanno.get_M_from_T_by_Tstar(T_by_Tstar),gamma)

def get_allValues_from_Po_by_Postar(Po_by_Postar,gamma):
	fanno = FannoFlow(gamma)
    	VALUES = {}
    	SECOND_VALUES = None
    	Mach_Nos = fanno.get_M_from_Po_by_Postar(Po_by_Postar)
	
    	if(type(Mach_Nos) == tuple):
		M1 = Mach_Nos[0]
		M2 = Mach_Nos[1]
		VALUES = get_allValues_from_M(M1, gamma)
		SECOND_VALUES = get_allValues_from_M(M2, gamma)
    	else:
		VALUES = get_allValues_from_M(Mach_Nos, gamma)

    	return VALUES, SECOND_VALUES
	
def get_allValues_from_F_by_Fstar(F_by_Fstar,gamma):
	fanno = FannoFlow(gamma)
    	VALUES = {}
    	SECOND_VALUES = None
    	Mach_Nos = fanno.get_M_from_F_by_Fstar(F_by_Fstar)
	
    	if(type(Mach_Nos) == tuple):
		M1 = Mach_Nos[0]
		M2 = Mach_Nos[1]
		VALUES = get_allValues_from_M(M1, gamma)
		SECOND_VALUES = get_allValues_from_M(M2, gamma)
    	else:
		VALUES = get_allValues_from_M(Mach_Nos, gamma)

    	return VALUES, SECOND_VALUES

def get_allValues_from_4fLmax_by_D(temp,gamma):
	fanno = FannoFlow(gamma)
    	VALUES = {}
    	SECOND_VALUES = None
    	Mach_Nos = fanno.get_M_from_4fLmax_by_D(temp)
	
    	if(type(Mach_Nos) == tuple):
		M1 = Mach_Nos[0]
		M2 = Mach_Nos[1]
		VALUES = get_allValues_from_M(M1, gamma)
		SECOND_VALUES = get_allValues_from_M(M2, gamma)
    	else:
		VALUES = get_allValues_from_M(Mach_Nos, gamma)

    	return VALUES, SECOND_VALUES

def get_plotData_from_M(gamma):
    MRange = arange(0.1,5.01,0.1)
    VALUES = {"M" : MRange, "P/Pstar" : [], "rho/rhostar": [], "T/Tstar" : [], "Po/Postar" : [], "F/Fstar" : [], "4fLmax/D" : [] }
    fanno = FannoFlow(gamma)
    
    for M in MRange:
        VALUES["P/Pstar"].append(fanno.get_P_by_Pstar_from_M(M))
        VALUES["T/Tstar"].append(fanno.get_T_by_Tstar_from_M(M))
	VALUES["rho/rhostar"].append(fanno.get_rho_by_rhostar_from_M(M))
        VALUES["Po/Postar"].append(fanno.get_Po_by_Postar_from_M(M))
        VALUES["F/Fstar"].append(fanno.get_F_by_Fstar_from_M(M))
	VALUES["4fLmax/D"].append(fanno.get_4fLmax_by_D_from_M(M))
    return VALUES
