''' -*- python -*-                        vim:set ts=4 sw=4:

    FILE: "/home/life/projects/garchiver/garchiver-0.5/src/tree_interface.py"
    LAST MODIFICATION: "Sat, 22 Sep 2001 16:30:57 +0200 (life)"

    Copyright (C) 2000 by Heinz Meulke

    Support for drag and drop, multiple archives and general 
    additions/fixes/restructuring by Danie Roux.

$Id: tree_interface.py,v 1.53 2001/07/04 13:03:41 uid43216 Exp $

This is the tree-like interface.
'''

# Don't let the tree refresh when you add or delete a file

if __name__ == '__main__' :
    raise 'You should run the command: garchiver'

from garchiver import *
from settings import *

import os
import shutil
import stat
import string
import time
from gnome.ui import *
from gtk import *
from GDK import *
from DirListing import *

import gettext
_ = gettext.gettext

class Tree (Interface):
    ''' The tree interface extends from the base class Interface and
    provides the user with a explorer type layout making the tree structure
    within an archive visible '''

    ''' create a dictonary of the layout of the archive with directory=key
    and the gtkctree_Node as the value'''
    active_archive_layout = {}

    '''create a dictionary to keep a list of all the files in a directory
     key = directory         value = [file1,file2....]
     Note that the directory value must look like this
     /folder1/folder2        Must start with a / but not end with a /
     the same way that you would list dirs with stat'''
    active_archive_files = {}

    # Dictionary of open archives
    # The key is the name of the archive, the data is 
    # [archive_object, base_tree_node, archive_layout, archive_files]
    list_of_archives = {}

    file_tree = None
    file_clist = None
    archive_ctree_root = None
    archive_clist = None

    def set_active_archive (self, new_active_archive_name):
        ''' Gets called by archive_tree.update '''

        self.active_archive, na, self.active_archive_layout, self.active_archive_files = \
            self.list_of_archives [new_active_archive_name]

        # Re-add the archive_clist. So that the headers of list can be
        # correct
        self.Archive_fl_scrolled_win.remove (self.archive_clist)
        del self.archive_clist
        self.archive_clist = ArchiveList (self, self.active_archive)
        self.Archive_fl_scrolled_win.add (self.archive_clist)
        self.Archive_fl_scrolled_win.show_all ()

    def open (self, archive):

        def secret_function (self, archive):
            ''' Let it draw in the background '''

            self.active_archive = archive

            self.app.set_title ('garchiver: ' + self.active_archive.name)

            self.Archive_fl_scrolled_win.hide ()

            if self.archive_clist != None:
                self.Archive_fl_scrolled_win.remove (self.archive_clist)
                del self.archive_clist

            self.archive_clist = ArchiveList (self, archive)
            self.Archive_fl_scrolled_win.add (self.archive_clist)

            self.active_archive_layout = {}
            self.active_archive_files = {}

            self.archive_clist.hide ()

            archivename = self.active_archive.name[string.rfind (self.active_archive.name, '/') + 1:]

            node1 = self.archive_ctree_root.insert_node (None, None,
                                                            [archivename], 10,
                                                            self.open_icon,
                                                            self.open_icon_mask,
                                                            self.closed_icon,
                                                            self.closed_icon_mask,
                                                            FALSE, TRUE)

            node_data = self.active_archive.name + ':' + '/'

            self.active_archive_layout [node_data] = node1
            self.archive_ctree_root.node_set_row_data (node1, node_data)

            try:
                for n in self.active_archive.list_dir ():
                    self.recursive_build_archive_tree (node1, n, '')
            except IndexError:
                self.app.error ("I can't create a tree from nothing!")
                raise

            # The next piece of code builds an internal structure for the file_listing
            # Key = path
            # value = FileInfo
            # e.g. layout['/'] = ('Filename, Size, path....)
            for file in self.active_archive.list ():

                folder = file [2]
                del file [2]

                # Adds the file to it's corresponding folderlist
                # file [2] is the directory
                if self.active_archive_files.has_key (folder): 
                    self.active_archive_files [folder].append (file)

                # No folder, goes into the root
                elif folder == '':
                    if self.active_archive_files.has_key ('/'):
                        self.active_archive_files['/'].append (file)
                    else: self.active_archive_files['/'] = [file]

                # Folder has not been encountered yet, create new list
                else: self.active_archive_files[folder] = [file]

            self.archive_ctree_root.update (None, node1, None)

            self.archive_clist.thaw ()
            self.archive_clist.show ()
            self.archive_ctree_root.show ()
            self.Archive_fl_scrolled_win.show ()

            # Add archive to list of archives
            self.list_of_archives [self.active_archive.name] = \
                [self.active_archive, node1, self.active_archive_layout, self.active_archive_files]

        self.gui_handle (secret_function, (self, archive))

    def close (self, archive):
        self.archive_ctree_root.remove_node \
            (self.list_of_archives [archive.name][1])
        del self.list_of_archives [archive.name]

    def recursive_build_archive_tree (self, parentNode, path, callback_path):
        '''The idea is to send this method a path eg. level1/level2/level3/
        this will be broken up into pieces to make a ctree in the GUI
        if possible this will be used with a map  while the callback path will
        be built up and attached'''

        if len(path) <= 1 : pass # Lowest level, unwinding starts

        else:
            dirname = path[0:string.find (path, '/')]
            remainder = path[string.find (path, '/') + 1:]

            # Give the node data of the form
            # maze3d.tar.gz:/home/life/projects/maze3d
            # This of course means that we can't have two archives
            # with the same name open!
            node_data = self.active_archive.name + ':' + callback_path + '/' + dirname

            if not self.active_archive_layout.has_key (node_data):

                node1 = self.archive_ctree_root.insert_node (parentNode, None,
                                                            [dirname], 10,
                                                            self.open_icon,
                                                            self.open_icon_mask,
                                                            self.closed_icon,
                                                            self.closed_icon_mask,
                                                            FALSE, TRUE)

                self.archive_ctree_root.node_set_row_data (node1, node_data)

                self.active_archive_layout [node_data] = node1

                self.recursive_build_archive_tree (node1, remainder, callback_path + '/' + dirname)
            else:
                node1 = self.active_archive_layout [node_data]
                self.recursive_build_archive_tree (node1, remainder, callback_path + '/' + dirname)

    def extract (self, to, with_path, only_selected):
        '''This next function specifies what has to be done on the event of
         a the user requesting a extract this function wiil be called after
         the gui closes up'''

        # Doesn't matter if selected is an empty list, archive will handle that
        if self.active_archive != None:
            timeout_add (25, self.update_progress, self.appbar)
            if not only_selected:
                self.gui_handle (self.active_archive.extract, (to, with_path, []))
            else:
                files = self.archive_clist.get_selected_values ()

                self.gui_handle (self.active_archive.extract, \
                                        (to, with_path, files))

                # So that the drag function can know what files to pass back and
                # delete
                try: 
                    if with_path: return files
                    else: return map (os.path.basename, files)
                except: pass

        else: self.app.error ("Tried to extract a Non-existent archive")
        

    def on_delete_event (self, *args):
        '''The main application quit callback'''

        if not self.sandbox.cleaned ():
            # Warn that there is still files open.
            if not self.sandbox_warning (self.sandbox.litter ()):
                # Doesn't want to quit.
                return

        gnome.config.set_string ('/garchiver/accessed/tree_interface_path',
            self.file_tree.get_current_dir ())
        gnome.config.sync_file ('/garchiver')

        if PS('confirm_quit_tree'):
            dlg = GnomeMessageBox (_("Are you sure you want to quit?"),
                                MESSAGE_BOX_QUESTION, STOCK_BUTTON_YES,
                                STOCK_BUTTON_NO)

            ret = dlg.run ()
            if ret == 1: # No
                return TRUE

        mainquit ()
        return FALSE

    def add_and_refresh (self, list, base = '/', location_in_archive = '/'):
        '''A lot of the time files needs to be added and the archive display
        refreshed, this routine will simply add files and the refresh the display
        default adds files to the root of the archive'''

        if os.path.basename (base) == list [0]: base = os.path.dirname (base)

        # TODO Add the files directly to the GUI, might be complicated
        self.gui_handle (self.active_archive.add, (list, base))
        self.archive_ctree_root.refresh (self.active_archive)

    def Addfiles_to_Archive_cb (self, *widget):
        '''When the user selects a bunch of files and press the add button the
        user expects the files to be added to the archive the selected files has to
        be retrieved and the files has to be added to the archive if the parm has
        a directory the whole directory will be added recursively'''

        if self.active_archive != None:
            selected = self.file_clist.get_selected_values ()
            viewpoint = self.file_tree.get_current_dir ()
            if selected [0] == viewpoint: # then the last selected was a directory
                    if string.rfind (viewpoint, '/') == 0: viewpoint = '/'
                    else: viewpoint = viewpoint[:string.rfind (viewpoint, '/')]
            self.add_and_refresh (selected, viewpoint, self.archive_ctree_root.get_current_dir ())
        else: self.app.error (_("There is no open archive!"))

    def remove_files_from_archive (self, na=None):
        if (self.active_archive == None):
            self.app.error (_("Can't remove files, no archive is open!"))
            return FALSE
        else:
            rem_files = self.archive_clist.get_selected_values ()
            try:
                self.gui_handle (self.active_archive.remove, (rem_files,))
                self.close (self.active_archive)
                self.open (self.active_archive)
            except NotImplementedError: 
                self.app.error (_("This function is not available for this type of archive."))

    def on_delete (self, widget):
        if PS ('confirm_file_delete'):

            dlg = GnomeQuestionDialog \
                (_("Are you sure you want to delete these files?"), \
                    lambda x: None, self.app)

            if dlg.run_and_close () == 1:
                return

        timeout_add (50, self.update_progress, self.appbar)
        self.remove_files_from_archive ()

    def About_cb(self, *args):
        self.Settings.settings_dialog (None, TRUE)

    def create_main_menu (self):

        action_menu = [
            (APP_UI_ITEM, _("_Extract"), _("Extract file or files from archive"), \
                self.on_extract, None, APP_PIXMAP_NONE, None, E, CONTROL_MASK),
            (APP_UI_ITEM, _("Ad_d"), _("Add file or files to the archive"), \
                self.Addfiles_to_Archive_cb, None, APP_PIXMAP_NONE, None, D, CONTROL_MASK),
            (APP_UI_ITEM, _("_Remove"), _("Permanently remove file or files from archive"), \
                self.remove_files_from_archive, None, APP_PIXMAP_NONE, None, R, CONTROL_MASK),
            UIINFO_SEPARATOR,
            (APP_UI_ITEM, _("_View log"),_("Views the log of the previous action"), \
                self.view_log, None, APP_PIXMAP_STOCK, \
                STOCK_MENU_BOOK_OPEN, L, CONTROL_MASK),
        ]

        settings_menu = [
            UIINFO_MENU_PREFERENCES_ITEM (self.Settings.settings_dialog, None),
            (APP_UI_ITEM, _("_To classic interface"),
                _("Changes to the classic interface"),
                self.__switch_to_classic, None, APP_PIXMAP_STOCK,
                STOCK_PIXMAP_JUMP_TO, 0, 0),
        ]

        help_menu = [
            UIINFO_HELP('garchiver'),
            UIINFO_MENU_ABOUT_ITEM (self.About_cb, None),
        ]

        menu = [
            UIINFO_SUBTREE (_("_Action"), action_menu),
            UIINFO_SUBTREE (_("_Settings"), settings_menu),
            UIINFO_SUBTREE (_("_Help"), help_menu)
        ]

        self.app.create_menus (menu)
        self.insert_file_menu ()

    def __switch_to_classic (self, widget):

        gnome.config.set_string ('/garchiver/accessed/tree_interface_path',
            self.file_tree.get_current_dir ())
        gnome.config.sync_file ('/garchiver')

        if PS('confirm_switching_interfaces'):
            dlg = GnomeMessageBox (_("Are you sure you want to switch?"),
                                MESSAGE_BOX_QUESTION, STOCK_BUTTON_YES,
                                STOCK_BUTTON_NO)

            ret = dlg.run ()
            if ret == 0:
                mainquit ()
                self.switch = TRUE
        else:
            mainquit ()
            self.switch = TRUE

    def create_main_toolbar(self):

        toolbar = GtkToolbar (style = PS ('toolbar_type'))
        self.toolbar = toolbar

        # New Button
        toolbar.append_item (_("New"), _("Create a new archive"), None, GnomeStock \
                (STOCK_PIXMAP_NEW), self.on_new)
        # Open Button
        toolbar.append_item (_("Open"),_("Opens an existing archive"), None, GnomeStock\
                 (STOCK_PIXMAP_OPEN), self.on_open_activated)
        # Extract Button
        toolbar.append_item (_("Extract"),_("Extract an archive to ..."), None, GnomeStock\
                 (STOCK_PIXMAP_CONVERT), self.on_extract)
        # Log Button
        toolbar.append_item (_("View log"), _("Views the log of the active archive to"), None, GnomeStock\
                 (STOCK_PIXMAP_BOOK_OPEN), self.view_log)

        toolbar.show()
        self.app.add_toolbar (toolbar, 'toolbar', DOCK_ITEM_BEH_EXCLUSIVE, DOCK_TOP, 1, 0, 0)

    def __init__ (self):
        '''This is from where the application is initiated and stats to run
            the gui is created and the signals connected'''

        self.type = 'Tree'
        Interface.__init__ (self)

        '''
        archive_popup_info = [
            UIINFO_ITEM (_ ("_Extract"), 'Extract file or files', \
                garchiver.on_extract, None),
            UIINFO_ITEM (_ ("_Delete"), 'Delete file (s) from archive', \
                None, None),
            UIINFO_ITEM (_ ("_View"), 'Views current file', None, None)
        ]
        file_popup_info = [
            UIINFO_ITEM (_ ("_Extract"), 'Extract file or files', \
                self.on_extract, None),
            UIINFO_ITEM (_ ("_Delete"), 'Delete file (s) from archive', \
                None, None),
            UIINFO_ITEM (_ ("_View"), 'Views current file', None, None)
        ]
        '''

        self.open_icon, self.open_icon_mask = \
            create_pixmap_from_xpm_d (self.app, None, closed_dir_xpm)
        self.closed_icon, self.closed_icon_mask = \
            create_pixmap_from_xpm_d (self.app, None, open_dir_xpm)

        # TODO Should be a setting
        self.app.set_default_size (625, 500)
        self.app.connect ("delete_event", self.on_delete_event)
        top_layer_vbox = GtkVBox (FALSE, 0)
        self.app.set_contents (top_layer_vbox)
        self.app.set_statusbar (self.appbar)

        top_layer_vbox.show ()

        # divide the window in two upper and lower
        paned_vertical = GtkVPaned ()
        paned_vertical.set_handle_size (14)
        paned_vertical.set_gutter_size (10)
        top_layer_vbox.pack_start (paned_vertical, TRUE, TRUE, 0)
        paned_vertical.show ()

        # divide the upper window in two upperleft and upperright
        paned_horizontal1 = GtkHPaned ()
        paned_horizontal1.set_handle_size (14)
        paned_horizontal1.set_gutter_size (10)
        paned_horizontal1.show ()
        paned_vertical.add1 (paned_horizontal1)
        paned_horizontal2 = GtkHPaned ()
        paned_horizontal2.set_handle_size (14)
        paned_horizontal2.set_gutter_size (10)
        paned_horizontal2.show ()
        paned_vertical.add2 (paned_horizontal2)

        # This next scrolled window will contain the directory listing widget
        dl_scrolled_win = GtkScrolledWindow ()
        dl_scrolled_win.set_usize (250, 200)
        dl_scrolled_win.set_policy (POLICY_AUTOMATIC, POLICY_AUTOMATIC)

        self.file_clist = FileList (self)
        self.file_tree = FileTree (self)

        dl_scrolled_win.add_with_viewport (self.file_tree)
        dl_scrolled_win.show ()
        paned_horizontal1.add1 (dl_scrolled_win)

        # This next scrolled window will contain the file listing widget
        fl_scrolled_win = GtkScrolledWindow ()
        fl_scrolled_win.set_policy (POLICY_AUTOMATIC, POLICY_AUTOMATIC)
        fl_scrolled_win.show ()

        fl_scrolled_win.add (self.file_clist)
        paned_horizontal1.add2 (fl_scrolled_win)

        # The next scrolled window will contain the Archive Directory listing widget
        Archive_dl_scrolled_win = GtkScrolledWindow ()
        Archive_dl_scrolled_win.set_usize (250, 200)
        dl_scrolled_win.set_policy (POLICY_AUTOMATIC, POLICY_AUTOMATIC)
        Archive_dl_scrolled_win.show ()
        Archive_dl_scrolled_win.set_policy (POLICY_AUTOMATIC, POLICY_AUTOMATIC)

        self.archive_ctree_root = ArchiveTree (self)

        Archive_dl_scrolled_win.add (self.archive_ctree_root)
        paned_horizontal2.add1 (Archive_dl_scrolled_win)

        # This next scrolled window will contain the Archive file listing widget
        self.Archive_fl_scrolled_win = GtkScrolledWindow ()
        self.Archive_fl_scrolled_win.set_policy (POLICY_AUTOMATIC, POLICY_AUTOMATIC)
        self.Archive_fl_scrolled_win.show ()

        paned_horizontal2.add2 (self.Archive_fl_scrolled_win)

        self.create_main_menu ()
        self.create_main_toolbar ()

        self.app.show ()

    def run (self):
        self.file_tree.ctree.select (self.file_tree.ctree.selection [0])
        mainloop ()

class ArchiveTree (GtkCTree):
    def __init__ (self, interface):
        self.interface = interface

        self.current_dir = '/'

        GtkCTree.__init__ (self, 1, 0)

        self.set_line_style (CTREE_LINES_DOTTED)
        self.set_selection_mode (SELECTION_SINGLE)

        self.drag_dest_set (DEST_DEFAULT_ALL,
          self.interface.targets, ACTION_COPY | ACTION_MOVE)
        self.connect ('drag_data_received', self.data_received)

        ''' TODO
        self.drag_source_set (BUTTON1_MASK | BUTTON3_MASK, self.interface.targets,
            ACTION_COPY | ACTION_MOVE)
        self.connect ('drag_data_get', self.dnd_data_get)
        '''

        self.connect ('tree_select_row', self.update)

    def get_current_dir (self):
        return self.current_dir

    def data_received(self, w, context, x, y, data, info, time):
        self.interface.app.error ("Dropping on the archive tree is planned for the next version\n" + 
                                    "It would then be possible to drag and drop between archives.")

    def dnd_data_get (self, w, context, data, info, time):
        print 'Dragging from archive listing'

    def update (self, widget, node, other):

        node_data = self.node_get_row_data (node)
        archive_name = node_data [:string.index (node_data, ':')]

        active_archive = self.interface.active_archive

        if active_archive != None and archive_name != active_archive.name:
            self.interface.set_active_archive (archive_name)

        # Strip away the archive name
        # Makes maze3d.tar.gz:/home/life into /home/life
        location = node_data [string.index (node_data, ':')+1 :]

        if location != '/': location = location[1:]

        self.current_dir = location

        self.interface.archive_clist.update (location)

    def refresh (self, archive):
        ''' Refresh the display of the archive to show the changes to it
        '''
        node_data_wanted = archive.name + ':' + '/'

        base_nodes = self.base_nodes ()
        archive_node = None
        for node in base_nodes:
            data = self.node_get_row_data (node)
            if data == node_data_wanted:
                archive_node = node
                break

        if archive_node != None:
            self.remove_node (archive_node)
            del self.interface.list_of_archives [archive.name]

        self.interface.open (archive)

class ArchiveList (the_clist):
    def __init__ (self, interface, archive):
        self.interface = interface

        # Archive this clist is a partial representation of
        self.connected_archive = archive

        hdrs = self.connected_archive.standard_headers + self.connected_archive.list_headers ()

        # The path
        del hdrs [2]
        the_clist.__init__ (self, hdrs, None)

        self.set_column_width (0, 140)
        self.set_column_width (1, 80)
        self.set_column_width (2, 80)

        self.connect ('button_press_event', self.popup_menu)

        self.drag_dest_set (DEST_DEFAULT_ALL, self.interface.targets,
          GDK.ACTION_COPY | GDK.ACTION_MOVE)

        self.connect ('drag_data_received', self.dnd_data_received)

        self.drag_source_set (BUTTON1_MASK | BUTTON3_MASK, self.interface.targets,
            ACTION_COPY | GDK.ACTION_MOVE )
        self.connect ('drag_data_get', self.dnd_data_get)

    def _open_from_archive (self, widget, file):

        # Maybe warn that this is a tempfile TODO
        tempfile = self.interface.active_archive.view (file)
        self.interface.open_file (tempfile)

    def popup_menu (self, widget, event):

        if event.type == BUTTON_PRESS:
            if event.button == 3:
                try:
                    row, col = self.get_selection_info \
                        (event.x, event.y)
                    file = self.get_text (row, 0)
                    if string.rfind (self.interface.archive_ctree_root.get_current_dir (), '/') == 0:
                        file = (self.interface.archive_ctree_root.get_current_dir () + file)[1:]
                    else: file = self.interface.archive_ctree_root.get_current_dir () + '/' + file
                except TypeError:
                    # Clicked on area of clist without an entry
                    return TRUE

                extract = GtkMenuItem (_("Extract"))
                extract.connect ('activate', self.interface.on_extract)

                view = GtkMenuItem (_("View") + " " + file)
                view.connect ('activate',self.interface.on_view, file)

                delete = GtkMenuItem (_("Delete"))
                delete.connect ('activate', self.interface.on_delete)

                menu = GtkMenu ()

                menu.add (extract)
                menu.add (view)
                menu.add (delete)

                if self.interface.get_archive_type_of_file (file) != None:
                    open = GtkMenuItem (_("Open") + " " + file)
                    open.connect ('activate', self._open_from_archive, file)
                    menu.add (open)

                menu.show_all ()

                menu.popup (None, None, None, event.button, event.time)

    def dnd_data_received  (self, w, context, x, y, data, info, time):
        '''When the user drags a file onto the arhive the user expects the file
        that is dropped onto the archive to be added into the archive'''

        #TODO add the files relative to the location in the archive

        # str converts data.type to a string representation. data.type is
        # a GdkAtom which is a longint. Not that back quotes doesn't work
        if str (data.type) == 'garchiver_internal' or str (data.type) == 'STRING':
            # If the type is garchiver_internal, that means the data comes
            # from the file_clist. And should be add relatively, without
            # the whole path
            list = string.split (data.data, '\n')
            base = self.interface.file_tree.get_current_dir ()

        else:
            # For Drops from the tree, or somewhere foreign like a file
            # manager
            list, base = self.interface.common_dnd_data_received (x, data.data)

        if list == []:
            # No file dropped, probably a URL
            return

        self.interface.add_and_refresh (list, base, self.interface.archive_ctree_root.get_current_dir ())

    def dnd_data_get (self, widget, context, selection_data, info, time):
        if info == self.interface.TARGET_URL:
            self.interface.common_dnd_data_get (selection_data)
        elif info == self.interface.TARGET_INTERNAL:
            # Reset target to internal
            self.interface.common_dnd_data_get (selection_data,
                self.interface.TARGET_INTERNAL)


    def drag_data_delete (self, *args):
        pass

    def update (self, folder):
        ''' Updates this listing to show what is in 'folder' '''

        self.clear()

        try:
            self.append_list (self.interface.active_archive_files [folder])

            self.columns_autosize ()
        except KeyError: pass # No files in this folder

    def select_all_cb (self, *widget):
        self.select_all ()

    def unselect_all_cb (self, *widget):
        self.unselect_all ()

    def get_selected_values (self):
        ''' Returns a list of all files selected '''

        selection = self.__getattr__ ('selection')

        if len (selection) != 0:
            list_files = []
            for entries in selection:

                filename = self.get_text (entries, 0)

                if self.interface.archive_ctree_root.get_current_dir () == '/':
                    list_files.append ('/' + filename)
                else:
                    list_files.append \
                    (self.interface.archive_ctree_root.get_current_dir () +
                        "/" + filename)

            return list_files
        else:
            # No files Selected so user must opt for the whole dir selected
            return [self.interface.archive_ctree_root.get_current_dir ()]

class FileTree (GtkDirListing):
    def __init__ (self, interface):

        self.interface = interface

        if gnome.config.has_section ('/garchiver/accessed'):
            self.current_dir = gnome.config.get_string ('/garchiver/accessed/tree_interface_path')
            # tree_interface_path not set yet.
            if self.current_dir == None: self.current_dir = '/'
        else: self.current_dir = '/'

        GtkDirListing.__init__ (self, self.current_dir)

        self.show ()

        # add the select signal so the filelisting can be updated
        self.connect ('dir_selected', self.update)
        self.update (self, self.current_dir)

        # TODO
        #self.drag_dest_set (DEST_DEFAULT_ALL, self.interface.targets, GDK.ACTION_COPY|GDK.ACTION_MOVE)
        #self.connect ('drag_data_received', self.dnd_data_received)
        #self.ctree.drag_source_set (BUTTON1_MASK | BUTTON3_MASK, self.interface.targets,
        #    ACTION_COPY | ACTION_MOVE)
        #self.ctree.connect ('drag_data_get', self.dnd_data_get)

    def get_current_dir (self):
        return self.current_dir

    def update (self, widget, dir):
        '''The clist widget that displays the files in the current directory
        that the user clicked on is updated by this callback function'''

        self.current_dir = dir
        # Update file listing
        self.interface.file_clist.update (dir)

    def dnd_data_received(self, w, context, x, y, data, info, time):
        print "Should not see this: DND data received in DirListing un-implemented."

    def dnd_data_get (self, w, context, selection_data, info, time):

        # TODO The 8 is a dumb number
        selection_data.set (selection_data.target, 8, 'file:' + self.current_dir)

class FileList (the_clist):
    def __init__ (self, interface):
        self.interface = interface

        the_clist.__init__ (self, ['Name', 'Size', 'Time'], None, has_pixmap=TRUE)

        self.show_dotfiles = FALSE

        # TODO Should be written to the configuration and read back
        self.set_column_width (0, 140)
        self.set_column_width (1, 80)
        self.set_column_width (2, 80)
        self.set_selection_mode (SELECTION_EXTENDED)
        self.connect ('button_press_event', self.mouse_click)
        self.connect_after ('button_press_event', self._sort_myself)

        # Drag and drop stuff, todo with the file_clist widget
        self.drag_dest_set (DEST_DEFAULT_ALL, self.interface.targets,
            GDK.ACTION_COPY | GDK.ACTION_MOVE)
        self.connect ('drag_data_received', self.dnd_data_received)
        self.drag_source_set (BUTTON1_MASK | BUTTON3_MASK,
            self.interface.internal, ACTION_COPY | ACTION_MOVE)
        self.connect ('drag_data_get', self.dnd_data_get);

        self.show ()

    def _sort_myself (self, widget, event):
        if (event.type == 5): # 2BUTTONPRESS or double click
            self.sort_list ()
        self.thaw ()

    def show_hide (self, widget, na):
        if self.show_dotfiles: self.show_dotfiles = FALSE
        else: self.show_dotfiles = TRUE
        self.update (self.parent_dir)

    def mouse_click (self, widget, event):
        if ((event.type == BUTTON_PRESS) & (event.button == 3)):

            try:
                try:
                    row, col = self.get_selection_info (event.x, event.y)

                # Handled the event but not applicable, outside our borders
                except TypeError: return TRUE
            except ValueError: return TRUE

            menu = GtkMenu ()

            show_hide = GtkMenuItem (_("Show/hide hidden files"))
            show_hide.connect ('activate', self.show_hide, None)
            menu.add (show_hide)

            if widget.get_cell_type (row, 0) == CELL_TEXT:

                filename = self.get_text (row, 0)

                full_file = os.path.join \
                    (self.interface.file_tree.get_current_dir (), filename)
                archive = self.interface.get_archive_type_of_file (filename)

                if (archive != None): # The file under the cursor is an archive

                    open = GtkMenuItem (_("Open archive ") + filename)

                    open.connect ('activate', self.quick_open, full_file)

                    menu.add (open)

                else:
                    view = GtkMenuItem ('View ' + filename)

                    view.connect ('activate', self.on_file_view, full_file)

                    menu.add (view)

            menu.show_all ()
            menu.popup (None, None, None, event.button, event.time)

        elif (event.type == 5): # 2BUTTONPRESS or double click
            try:

                row, col = self.get_selection_info (event.x, event.y)

                if (row == 0): # The ..
                    folder = os.path.dirname (self.interface.file_tree.current_dir)
                elif (self.get_cell_type (row, 0)) == CELL_PIXTEXT:
                    folder, type, pix, mask = self.get_pixtext (row, 0)

                else:
                    # On double-click of an archive, open that file
                    filename = self.get_text (row, 0)
                    full_file = os.path.join \
                        (self.interface.file_tree.get_current_dir (), filename)
                    self.interface.open_file (full_file)
                    return TRUE

                # Will get thawed in _sort_myself
                self.freeze ()

                self.interface.file_tree.cd \
                    (os.path.join (self.interface.file_tree.current_dir, folder))

            except TypeError: raise

    def quick_open (self, widget, file):
        self.interface.open_file (file)

    def on_file_view (self, widget, file):
        '''Views a file on the filesystem'''

        if PS ('confirm_file_view'):
            dlg = GnomeMessageBox \
                (_("Do you want to view the file " + file + "?"),
                MESSAGE_BOX_QUESTION, STOCK_BUTTON_YES, STOCK_BUTTON_NO)
            ret = dlg.run ()
            if ret == 1:
                return

        self.interface.view (file)

    def dnd_data_received (self, w, context, x, y, data, info, time):
        if data.type == self.interface.TARGET_INTERNAL:
            for file in map (lambda x: x[8:], string.split (data.data)):
                shutil.copy (file, self.parent_dir)
            self.update (self.parent_dir)

    def dnd_data_get (self, w, context, selection_data, info, time):

        list = self.get_selected_values ()

        list = filter (lambda x: x != '..', list)
        if list != []: list = reduce (lambda x, y: x + '\n' + y, list)
        else: return

        selection_data.set (selection_data.target, self.interface.TARGET_INTERNAL, list)

    def select_all_cb (self, *widget):
        self.select_all ()

    def unselect_all_cb (self, *widget):
        self.unselect_all ()

    def get_selected_values (self):
        '''This method simply returns the files selected from filesystem
        if no individual files are selected then the directory is added'''
        add_list = []

        for files in self.interface.file_clist.__getattr__ ('selection'):

            try: 
                text = self.interface.file_clist.get_text (files, 0)
            except ValueError: 
                text, number, pix1, pix2 = self.interface.file_clist.get_pixtext (files, 0)

            add_list.append (text)

        if len (add_list) == 0:

            if self.interface.file_tree.get_current_dir () == '/': foldername = '/'
            else: foldername = os.path.basename (self.interface.file_tree.get_current_dir ())

            add_list.append (foldername)

        return add_list

    def update (self, dir):
        ''' Updates the widget to show the contents of the folder given as
        a parameter
        '''

        self.freeze ()
        self.clear ()

        row = 0

        self.parent_dir = dir

        for file in os.listdir (dir):
            if not self.show_dotfiles:
                if file [0] == '.': continue

            try: # Sometimes you get dangling links
                mode = os.stat ('%s/%s' %(dir, file))[stat.ST_MODE]
                size = os.stat ('%s/%s' %(dir, file))[stat.ST_SIZE]
                gtime = os.stat ('%s/%s' %(dir, file))[stat.ST_CTIME]
            except: continue

            if stat.S_ISREG (mode) or stat.S_ISDIR (mode):
                self.append ([file, `size`, time.ctime (gtime)])
                if stat.S_ISDIR (mode):
                    self.set_pixtext (row, 0, file, 3,
                        self.interface.open_icon,
                        self.interface.open_icon_mask)

                row = row +1

        if (dir != '/'): self.insert (0, ['..', '', ''])

        self.sort_list (dir)
        self.thaw ()

    def sort_list (self, dummy=None, col=-2):
        ''' Remove the .., then sort '''
        if self.parent_dir != '/': self.remove (0)
        the_clist.sort_list (self, dummy, col)
        if self.parent_dir != '/': self.insert (0, ['..', '', ''])
