# Generated automatically from settings.py.in by configure.

''' -*- python -*-                       vim:set tw=4 sw=4:

    FILE: "/home/life/projects/garchiver/garchiver-0.5/src/settings.py.in"
    LAST MODIFICATION: "Fri, 21 Sep 2001 23:48:44 +0200 (life)"

    (C) 2000 by Danie Roux <droux@tuks.co.za>

    $Id: settings.py.in,v 1.4 2001/06/27 11:00:25 droux Exp $

    The settings module. Sets, reads and provides all settings.
'''

# This module will be imported with: from settings import *
# This module provides variables that's used for customization.

import libglade

import os
import os.path

from gtk import *
from gnome.config import *

import gettext
_ = gettext.gettext

# Location of all the libraries needed for garchiver. Gets set when you
# ./configure
GARCHIVER_DATADIR = '/usr/local/share/garchiver'

# Version of this program, also gets set when you ./configure
VERSION = 0.5

# All about gettext
PACKAGE = 'garchiver'
PACKAGE_LOCALE_DIR = '/usr/local/share/locale'

TRUE = 1
FALSE = 0

_settings = {

'toolbar_type':TOOLBAR_BOTH,
'drop_opens':TRUE,

'tar_path':'/bin/tar',
'gzip_path':'/bin/gzip',
'gunzip_path':'/bin/gunzip',
'bzip_path':'/usr/bin/bzip2',
'bunzip_path':'/usr/bin/bunzip2',
'compress_path':'/bin/compress',
'uncompress_path':'/bin/uncompress',
'zip_path':'/usr/bin/zip',
'unzip_path':'/usr/bin/unzip',
'unarj_path':'/usr/bin/unarj',
'unrar_path':'/usr/bin/unrar',

'confirm_quit_classic': FALSE,
'confirm_quit_tree': TRUE,
'confirm_switching_interfaces': TRUE,
'confirm_file_view': TRUE,
'confirm_file_delete': TRUE
}

settings_read = FALSE

class Settings:

    def __init__ (self, aggregate):
        self.aggregate = aggregate

    def setsettings (self, widget, glade):

        global _settings

        push_prefix ('/garchiver/preferences/')

        text_only = glade.get_widget ('toolbar_text_only')
        if text_only.active:
            _settings ['toolbar_type'] = TOOLBAR_TEXT
        else:
            text_and_icons = glade.get_widget ('toolbar_text_and_icons')
            if text_and_icons.active:
                _settings ['toolbar_type'] = TOOLBAR_BOTH
            else:
                icons_only = glade.get_widget ('toolbar_icons_only')
                if icons_only.active:
                    _settings ['toolbar_type'] = TOOLBAR_ICONS

        set_int ('toolbar_type', _settings ['toolbar_type'])

        _settings ['drop_opens'] = glade.get_widget ('drop_opens').get_active()
        set_bool ('drop_opens', _settings ['drop_opens'])

        for path in ['tar_path', 'gzip_path', 'gunzip_path', 'bzip_path',
                    'bunzip_path', 'compress_path', 'uncompress_path',
                    'zip_path', 'unzip_path', 'unarj_path',
                    'unrar_path']:
            selected = glade.get_widget (path).get_text ()
            _settings [path] = selected
            set_string (path, _settings [path])

        for confirm in ['confirm_quit_classic', 'confirm_quit_tree',
                        'confirm_switching_interfaces', 'confirm_file_view',
                        'confirm_file_delete']:
            _settings [confirm] = glade.get_widget (confirm).get_active ()
            set_bool (confirm, _settings [confirm])

        sync_file ('/garchiver')
        pop_prefix ()

        # Ugly hack, rewrite when you had some sleep. TODO
        self.aggregate.toolbar.set_style (_settings ['toolbar_type'])

    def settings_dialog (self, widget, about=FALSE):

        path_to_glade = os.path.join \
            (GARCHIVER_DATADIR, 'settings.glade')

        if not os.access (path_to_glade , os.R_OK):
            self.aggregate.app.error (_("Can't find settings.glade in " +
                path_to_glade + " - Did you specify the correct prefix when you ran ./configure?"))
            return

        glade = libglade.GladeXML (path_to_glade)

        settings = glade.get_widget ('settings')

        ok = glade.get_widget ('ok_button')
        ok.connect ('clicked', self.setsettings, glade)
        ok.connect ('clicked', settings.destroy)

        cancel = glade.get_widget ('cancel_button')
        cancel.connect ('clicked', settings.destroy )

        apply = glade.get_widget ('apply_button')
        apply.connect ('clicked', self.setsettings, glade)

        toolbar_style = setting ('toolbar_type')
        if toolbar_style == TOOLBAR_TEXT:
            toolbar_string = 'toolbar_text_only'
        elif toolbar_style == TOOLBAR_BOTH:
            toolbar_string = 'toolbar_text_and_icons'
        else:
            toolbar_string = 'toolbar_icons_only'
        glade.get_widget (toolbar_string).set_active (TRUE)

        glade.get_widget ('drop_opens').set_active (setting ('drop_opens'))

        for path in ['tar_path', 'gzip_path', 'gunzip_path', 'bzip_path',
                'bunzip_path', 'compress_path', 'uncompress_path', 'zip_path',
                'unzip_path', 'unarj_path', 'unrar_path']:
            glade.get_widget (path).set_text (setting (path))

        for confirm in ['confirm_quit_classic', 'confirm_quit_tree',
                        'confirm_switching_interfaces', 'confirm_file_view',
                        'confirm_file_delete']:
            glade.get_widget (confirm).set_active (setting (confirm))

        if about:
            notebook = glade.get_widget ('notebook')
            notebook.set_page (3)

        settings.show ()

def readsettings ():

    # Very sloppy, but hey it's Mon Oct 30 02:39:54 SAST 2000

    if has_section ('/garchiver/preferences'):
        push_prefix ('/garchiver/preferences/')

        _settings ['toolbar_type'] = get_int ('toolbar_type')
        _settings ['drop_opens'] = get_bool ('drop_opens')

        for path in ['tar_path', 'gzip_path', 'gunzip_path', 'bzip_path',
                    'bunzip_path', 'compress_path', 'uncompress_path',
                    'zip_path', 'unzip_path', 'unarj_path', 'unrar_path']:
            _settings [path] = get_string (path)

        for confirm in ['confirm_quit_classic', 'confirm_quit_tree',
                        'confirm_switching_interfaces', 'confirm_file_view',
                        'confirm_file_delete']:
            _settings [confirm] = get_bool (confirm)

        pop_prefix ()

# Read settings from config file
def setting (of):
    ''' Send in a string to find the setting of that string.

    i.e: setting ('tar_path') would return '/bin/tar'
    and  setting ('toolbar') would give TOOLBAR_BOTH
    '''

    if not settings_read:
        readsettings ()

    return _settings [of]

# To make settings easier to work with. Same effect as gettext.
PS = setting
