/* -*- C -*-                                        vim:set ts=4 sw=4:
 *
 * FILE: "/home/life/projects/garchiver-0.4/src/garchiver_extra_gtk.c"
 * LAST MODIFICATION: "Sun, 17 Jun 2001 01:09:03 +0200 (life)"

 * (C) 2000 by Danie Roux <droux@tuks.co.za>
 *
 * $Id: garchiver_extra_gtk.c,v 1.5 2001/06/19 13:18:20 droux Exp $
 *
 * Extra functions not in pygtk that I need.
 *
 */

#include <Python.h>

#include <pygtk/pygtk.h>
#include <pygtk/pygdkimlib.h>

#include <gtk/gtk.h>
#include <glib.h>

gint
int_compare (GtkCList *clist, gconstpointer p1, gconstpointer p2)
{
    char *text1 = NULL;
    char *text2 = NULL;
    long int int1, int2;

    GtkCListRow *row1 = (GtkCListRow *) p1;
    GtkCListRow *row2 = (GtkCListRow *) p2;

    /* Only plain text cells can be considered */
    g_assert ((row1->cell [clist->sort_column].type) == GTK_CELL_TEXT);
    g_assert ((row2->cell [clist->sort_column].type) == GTK_CELL_TEXT);

    text1 = GTK_CELL_TEXT (row1->cell [clist->sort_column])->text;
    text2 = GTK_CELL_TEXT (row2->cell [clist->sort_column])->text;

    /* TODO I don't think this works as expected. What is should do is
     * stop the program if conversion was not possible */
    int1 = strtol (text1, NULL, 10);
    g_assert (errno == 0);
    int2 = strtol (text2, NULL, 10);
    g_assert (errno == 0);

    if (int1 == int2) return 0;
    else if (int1 < int2) return -1;
    else return 1;
}

gint
pix_and_text_compare (GtkCList *clist, gconstpointer p1, gconstpointer p2)
{
    char *text1 = NULL;
    char *text2 = NULL;

    GtkCListRow *row1 = (GtkCListRow *) p1;
    GtkCListRow *row2 = (GtkCListRow *) p2;

    if ((row1->cell [clist->sort_column].type == GTK_CELL_PIXTEXT) &&
        (row2->cell [clist->sort_column].type == GTK_CELL_TEXT))
            return -1;

    if ((row1->cell [clist->sort_column].type == GTK_CELL_TEXT) &&
        (row2->cell [clist->sort_column].type == GTK_CELL_PIXTEXT))
            return 1;

    text1 = GTK_CELL_TEXT (row1->cell [clist->sort_column])->text;
    text2 = GTK_CELL_TEXT (row2->cell [clist->sort_column])->text;

    return strcmp (text1, text2);
}

static PyObject*
wrap_garchiver_gtk_clist_set_sort_as (PyObject *self, PyObject *args)
{
    PyObject *widget;
    int as;

    if (!PyArg_ParseTuple (args, "O!i:garchiver_set_sort_as", &PyGtk_Type,
                           &widget, &as))
        return NULL;

    if (as == 1) gtk_clist_set_compare_func (GTK_CLIST (PyGtk_Get (widget)),
                                             int_compare);
    else if (as == 2) gtk_clist_set_compare_func (GTK_CLIST (PyGtk_Get (widget)),
                                             pix_and_text_compare);
    else gtk_clist_set_compare_func (GTK_CLIST (PyGtk_Get (widget)),
                                     NULL);

    Py_INCREF (Py_None);
    return Py_None;
}

static PyMethodDef garchiver_extra_gtk_methods [] = {
      {"garchiver_set_sort_as", wrap_garchiver_gtk_clist_set_sort_as,
        METH_VARARGS},
      {NULL, NULL}
};

void
init_garchiver_extra_gtk ()
{
    init_pygtk ();
    init_pygdkimlib ();

    Py_InitModule ("_garchiver_extra_gtk", garchiver_extra_gtk_methods);
}
