/* -*- C -*-

 * FILE: "/home/life/projects/garchiver-0.4/src/dir_listing_wrap.c"
 * LAST MODIFICATION: "Sun, 17 Jun 2001 03:53:59 +0200 (life)"

 * (C) 2000 by Danie Roux <droux@tuks.co.za>
 *
 * $Id: dir_listing_wrap.c,v 1.10 2001/06/19 13:16:01 droux Exp $
 *
 * The wrapping of the directory listing widget with python.
 *
 */

#include <Python.h>

#include <pygtk/pygtk.h>
#include <pygtk/pygdkimlib.h>

#include "dir_listing.h"

static PyObject*
wrap_dir_listing_new (PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple (args, ":gtk_dir_listing_new"))
        return NULL; /* If any arguments are sent, can't create object */
    return PyGtk_New ((GtkObject *) gtk_dir_listing_new ());
}

static PyObject*
wrap_dir_listing_new_with_dotfiles (PyObject *self, PyObject *args)
{
    int toggle;

    if (!PyArg_ParseTuple (args, "i:gtk_dir_listing_new_with_dotfiles", &toggle))
        return NULL; /* If any arguments are sent, can't create object */
    return PyGtk_New ((GtkObject *) gtk_dir_listing_new_with_dotfiles (toggle));
}

static PyObject*
wrap_dir_listing_get_type (PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple (args, ":gtk_dir_listing_get_type"))
        return NULL;
    return PyInt_FromLong (gtk_dir_listing_get_type ());
}

static PyObject*
wrap_dir_listing_cd (PyObject *self, PyObject *args)
{
    char *path;
    PyObject *dl;

    if (!PyArg_ParseTuple (args, "O!s:gtk_dir_listing_cd", &PyGtk_Type,
                           &dl, &path))
        return NULL; /* If any arguments are sent, can't create object */
    gtk_dir_listing_cd (GTK_DIR_LISTING (PyGtk_Get (dl)), path);
    /* 'Return' void */
    Py_INCREF (Py_None);
    return Py_None;
}

static PyObject*
wrap_dir_listing_get_ctree (PyObject *self, PyObject *args)
{
    PyObject *obj;

    if (!PyArg_ParseTuple (args, "O!:gtk_dir_listing_get_ctree",
                           &PyGtk_Type, &obj))
        return NULL;

    return PyGtk_New ((GtkObject *) GTK_DIR_LISTING (PyGtk_Get
                                                     (obj))->ctree);
}

static PyObject*
wrap_dir_listing_show_dotfiles (PyObject *self, PyObject *args)
{
    PyObject *dl;
    int toggle;

    if (!PyArg_ParseTuple (args, "O!i:gtk_dir_listing_show_dotfiles", &PyGtk_Type,
                           &dl, &toggle))
        return NULL;

    gtk_dir_listing_show_dotfiles (GTK_DIR_LISTING (PyGtk_Get (dl)), toggle);

    Py_INCREF (Py_None);
    return Py_None;
}

static PyMethodDef DirListingMethods [] = {
      {"gtk_dir_listing_new", wrap_dir_listing_new, METH_VARARGS},
      {"gtk_dir_listing_new_with_dotfiles", wrap_dir_listing_new_with_dotfiles, METH_VARARGS},
      {"gtk_dir_listing_get_type", wrap_dir_listing_get_type, METH_VARARGS},
      {"gtk_dir_listing_cd", wrap_dir_listing_cd, METH_VARARGS},
      {"gtk_dir_listing_get_ctree", wrap_dir_listing_get_ctree, METH_VARARGS},
      {"gtk_dir_listing_show_dotfiles", wrap_dir_listing_show_dotfiles, METH_VARARGS},
      {NULL, NULL}
};

void
init_gtk_dir_listing ()
{
    /* TODO */
    init_pygtk ();
    init_pygdkimlib();

    Py_InitModule ("_gtk_dir_listing", DirListingMethods);
}

