''' -*- python -*-                        vim:set ts=4 sw=4:

    FILE: '/home/life/garchiver/src/python/classic_interface.py'
    LAST MODIFICATION: 'Tue, 15 Aug 2000 22:12:51 +0200 (life)'

    (C) 2000 by Danie Roux <droux@tuks.co.za>

$Id: classic_interface.py,v 1.38 2001/06/27 11:02:12 droux Exp $

The 'classic' interface. WinZip like.
'''

if __name__ == '__main__' : 
    raise 'You should run the command: garchiver'

from garchiver import *
from settings import *

from gnome.ui import *
from gtk import *
from GDK import *

import gnome.config
import gnome.mime
import string
import libglade
import os
import os.path
import sys
import stat

import gettext
_ = gettext.gettext

class Classic (Interface):
    ''' The interface that copies WinZip's ideas. '''

    # The clist
    clist = None
    scrolled_window = GtkScrolledWindow ()
    toolbar_extract_button = None
    toolbar_save_button = None

    # Variables that specify in which column the name and path of a file is
    # within the clist
    NAME = 0
    PATH = 2

    def about (self, item):
        self.Settings.settings_dialog (None, TRUE)

    def on_delete_event (self, na):

        if not self.sandbox.cleaned ():
            # Warn that there is still files open.
            if not self.sandbox_warning (self.sandbox.litter ()):
                # Doesn't want to quit.
                return

        if PS('confirm_quit_classic'):
            dlg = GnomeMessageBox (_("Are you sure you want to quit?"),
                                   MESSAGE_BOX_QUESTION, STOCK_BUTTON_YES,
                                   STOCK_BUTTON_NO)

            ret = dlg.run ()
            if ret == 0:
                mainquit ()
                return FALSE
            else:
                return TRUE
        else: 
            mainquit ()
            return FALSE

    def on_save (self, widget):
        ''' Tar can be saved to purify the archive. '''
        if self.active_archive != None:
            self.clist.clear ()
            self.gui_handle (self.active_archive.save, ())
            self.gui_handle (self.clist.append_list, \
                (self.active_archive.list (),))

        else: raise \
            'Somebody did something wrong, on_save should not be callable now.'

    def on_delete (self, widget):
        ''' Delete files from an archive '''

        if PS ('confirm_file_delete'):

            dlg = GnomeQuestionDialog \
                (_("Are you sure you want to delete these files?"), \
                    lambda x: None, self.app)

            if dlg.run_and_close () == 1:
                return

        timeout_add (50, self.update_progress, self.appbar)

        files = map (self.qualify, self.clist.selection)

        self.clist.clear ()

        self.gui_handle (self.active_archive.remove, (files,))
        self.gui_handle (self.clist.append_list, \
            (self.active_archive.list (),))

    def qualify (self, row):
        ''' Returns the whole path to the file from the clist '''
        # qualified meaning whole path to file
        qualified = self.clist.get_text (row, self.PATH)
        if qualified != '': qualified = qualified + '/'
        qualified = qualified + self.clist.get_text (row, self.NAME)
        return qualified

    def extract (self, to, with_path, certain_files):
        ''' Extract. See the abstract definition for further information.
        '''

        timeout_add (50, self.update_progress, self.appbar)

        if certain_files:
            files = map (self.qualify, self.clist.selection)
            self.gui_handle (self.active_archive.extract, 
                (to, with_path, files))
        else: self.gui_handle (self.active_archive.extract, (to,
                with_path, []))

        # So that the drag function can know what files to pass back and
        # delete
        try: 
            if with_path: return files
            else: return map (os.path.basename, files)
        except: pass

    def popup_menu (self, widget, event):
        ''' The popup menu method. '''
        if event.type == BUTTON_PRESS:
            if event.button == 3:
                try:
                    row, col = self.clist.get_selection_info \
                        (event.x, event.y) 
                    file = self.qualify (row)
                except TypeError:
                    # Clicked on area of clist without an entry
                    return

                extract = GtkMenuItem (_("Extract"))
                extract.connect ('activate', self.on_extract)

                view = GtkMenuItem (_("View"))
                view.connect ('activate', self.on_view, file)

                delete = GtkMenuItem (_("Delete"))
                delete.connect ('activate', self.on_delete)

                menu = GtkMenu ()

                menu.add (extract)
                menu.add (view)
                menu.add (delete)
                menu.show_all ()

                menu.popup (None, None, None, event.button, event.time)

    def dnd_data_get (self, widget, context, selection_data, info, time):
        if info == self.TARGET_URL:
            self.common_dnd_data_get (selection_data)

    def dnd_drag_delete (self, *args):
        try:
            os.system ('rm -rf ' + self.dnd_extract_folder)
            del self.dnd_extract_folder
        except: pass # DND not completed

    def __common_clist (self, archive):
        ''' Common operations between the open and new commands '''

        try: self.scrolled_window.remove (self.clist)
        except: pass # There have not been a clist yet

        self.active_archive = archive

        hdrs = self.active_archive.standard_headers + \
            self.active_archive.list_headers ()

        self.clist = the_clist (hdrs, None)

        # Get the full list of what the headers of the clist must be
        # TODO Popups makes the world crash
        self.clist.connect ('button_press_event', self.popup_menu)

        self.toolbar_extract_button.set_sensitive (TRUE)
        self.toolbar_add_button.set_sensitive (TRUE)
        self.toolbar_view_log_button.set_sensitive (TRUE)

        self.app.set_title ('garchiver: ' + self.active_archive.name)

        self.clist.connect ('drag_data_get', self.dnd_data_get)
        self.clist.connect ('drag_data_delete', self.dnd_drag_delete)

        self.clist.drag_source_set (GDK.BUTTON1_MASK|GDK.BUTTON3_MASK,
                self.targets, GDK.ACTION_COPY)

    def open (self, archive):

        def secret_function (self, archive):

            self.__common_clist (archive)

            entries = self.active_archive.list ()

            self.clist.append_list (entries)
            self.clist.columns_autosize ()

            self.clist.show ()
            self.scrolled_window.add (self.clist)

        timeout_add (50, self.update_progress, self.appbar)

        self.gui_handle (secret_function, (self, archive))

        # TODO self.toolbar_save_button.set_sensitive (1)

    def dnd_drag_data_received (self, w, context, x, y, data, info, time):
        ''' The dnd method for the classic interface '''

        list, base = self.common_dnd_data_received (x, data.data)

        if list == []:
            # No files, exit
            return

        # So now everything happens relative to root_directory.
        # This means that all the files that was send in is
        # incorrect. And the root_directory part must be stripped
        # of. I'm assuming that the root is 

        if PS ('drop_opens') and \
                len (list) == 1 and \
                self.get_archive_type_of_file (list [0]) != None:
            self.open_file (list [0])
            return

        self.clist.clear ()

        self.gui_handle (self.active_archive.add, (list, base))
        self.gui_handle (map, (self.clist.append, 
            self.active_archive.list ()))

        self.clist.columns_autosize ()

    def __switch_to_tree (self, widget):
        ''' Switch to the tree interface '''
        if PS('confirm_switching_interfaces'):
            dlg = GnomeMessageBox (_("Are you sure you want to switch?"),
                                   MESSAGE_BOX_QUESTION, STOCK_BUTTON_YES,
                                   STOCK_BUTTON_NO)

            ret = dlg.run ()
            if ret == 0:
                mainquit ()
                self.switch = TRUE
        else: 
            mainquit ()
            self.switch = TRUE

    def __init__ (self):
        ''' Init the class. Builds the GUI basically. '''

        self.type = 'Classic'
        Interface.__init__ (self)

        self.app.set_wmclass ('garchiver', 'garchiver_classic_interface')

        help_menu = [
            UIINFO_HELP('garchiver'),
            UIINFO_MENU_ABOUT_ITEM (self.about, None),
        ]

        settings_menu = [
            UIINFO_MENU_PREFERENCES_ITEM (self.Settings.settings_dialog, None),
            (APP_UI_ITEM, _("_To tree interface"), 
                _("Changes to the tree interface"), 
                self.__switch_to_tree, None, APP_PIXMAP_STOCK,
                STOCK_PIXMAP_JUMP_TO, 0, 0),
        ]

        action_menu = [
            (APP_UI_ITEM, _("_Add"), _("Add files"), self.on_add, None, \
                APP_PIXMAP_STOCK, STOCK_PIXMAP_ADD, A, CONTROL_MASK),
            (APP_UI_ITEM, _("_Extract"), _("Extract file or files"), \
                self.on_extract, None, APP_PIXMAP_STOCK, \
                STOCK_MENU_CONVERT, E, CONTROL_MASK), 
            (APP_UI_ITEM, _("_View log"), \
                _("Views the log of the previous action"), \
                self.view_log, None, APP_PIXMAP_STOCK, \
                STOCK_MENU_BOOK_OPEN, L, CONTROL_MASK), 
            # TODO
            ##################################################################
            # (APP_UI_ITEM, _("_Save"), _("Saves file that needs saving"), \ #
            #     self.on_save, None, APP_PIXMAP_STOCK, \                    #
            #     STOCK_MENU_SAVE, S, CONTROL_MASK),                         #
            ##################################################################
        ]

        menu = [
            UIINFO_SUBTREE(_("_Action"), action_menu),
            UIINFO_SUBTREE(_("_Settings"), settings_menu),
            UIINFO_SUBTREE(_("_Help"), help_menu)
        ]

        popup_info = [
            UIINFO_ITEM (_("_Extract"), 'Extract file or files', \
                self.on_extract, None),
            UIINFO_ITEM (_("_Delete"), 'Delete file(s) from archive', \
                self.on_delete, None),
            UIINFO_ITEM (_("_View"), 'Views current file', self.on_view, None)
        ]

        self.app.connect ('drag_data_received', self.dnd_drag_data_received)

        self.app.connect ('delete_event', mainquit)

        self.app.set_default_size (400,450)

        dock = self.app.get_dock ()

        self.app.create_menus (menu)
        # Done seperately, 'cause it gets recreated a lot
        self.insert_file_menu ()

        toolbar = GtkToolbar (style = PS ('toolbar_type'))
        self.toolbar = toolbar

        icon = GnomeStock (STOCK_PIXMAP_NEW)
        _toolbar_new_button = \
            toolbar.append_item (_("New archive"), \
            'Creates a new archive', \
            None, icon, self.on_new)

        icon = GnomeStock (STOCK_PIXMAP_OPEN)
        _toolbar_open_button = \
            toolbar.append_item (_("Open Archive"), _("Open an archive"),
                None, icon, self.on_open_activated)

        icon = GnomeStock (STOCK_PIXMAP_ADD)
        self.toolbar_add_button = \
            toolbar.append_item (_("Add files"), 
                _("Add files to the archive"), None, icon,
                self.on_add)

        icon = GnomeStock (STOCK_PIXMAP_CONVERT)
        self.toolbar_extract_button = toolbar.append_item ( \
            _("Extract Archive"), _("Extracts an archive"), None, icon, \
            self.on_extract)

        icon = GnomeStock (STOCK_PIXMAP_BOOK_OPEN)
        self.toolbar_view_log_button = toolbar.append_item ( \
            _("View logs"), _("View logs of previous actions"), None, \
            icon, self.view_log)

        # TODO
        #icon = GnomeStock (STOCK_PIXMAP_SAVE)
        #self.toolbar_save_button = toolbar.append_item (_("Save Archive"), 
        #    _("Saves a modified archive. This is not necessary for most formats, but for tar it is."), None, icon, self.on_save)

        self.app.add_toolbar (toolbar, 'toolbar', DOCK_ITEM_BEH_EXCLUSIVE, \
            DOCK_TOP, 1, 0, 0)

        #self.toolbar_save_button.set_sensitive (FALSE)
        self.toolbar_extract_button.set_sensitive (FALSE)
        self.toolbar_add_button.set_sensitive (FALSE)
        self.toolbar_view_log_button.set_sensitive (FALSE)

        self.app.set_contents (self.scrolled_window)
        self.app.set_statusbar (self.appbar)

        self.app.show_all ()
