/**
 * File:          $RCSfile: image_io.h,v $
 * Module:        Image file I/O functions
 * Part of:       Gandalf Library
 *
 * Revision:      $Revision: 1.16 $
 * Last edited:   $Date: 2002/06/25 09:27:36 $
 * Author:        $Author: pm $
 * Copyright:     (c) 2000 Imagineer Software Limited
 */

/* This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _GAN_IMAGE_IO_H
#define _GAN_IMAGE_IO_H

#include <gandalf/image/image_defs.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * \addtogroup ImagePackage
 * \{
 */

/**
 * \addtogroup ImageIO
 * \{
 */

/**
 * \brief Image file formats supported by Gandalf
 */
typedef enum
{
   GAN_PNG_FORMAT,  /**< PNG image format */
   GAN_PBM_FORMAT,  /**< Portable bitmap image format */
   GAN_PGM_FORMAT,  /**< Portable greymap image format */
   GAN_PPM_FORMAT,  /**< Portable pixmap image format */
   GAN_TIFF_FORMAT, /**< TIFF image format */
   GAN_JPEG_FORMAT, /**< JPEG image format */
   GAN_UNKNOWN_FORMAT /**< Unknown Image Format */
} Gan_ImageFileFormat;

Gan_ImageFileFormat
  gan_image_interpret_format_string ( const char *format_string );
Gan_Image *gan_image_read ( const char *filename,
                            Gan_ImageFileFormat file_format,
                            Gan_Image *image );
Gan_Image *gan_image_read_stream ( FILE *infile,
                                   Gan_ImageFileFormat file_format,
                                   Gan_Image *image );
Gan_Bool gan_image_write ( const char *filename,
                           Gan_ImageFileFormat file_format,
                           Gan_Image *image );
Gan_Bool gan_image_write_stream ( FILE *outfile,
                                  Gan_ImageFileFormat file_format,
                                  Gan_Image *image );

/**
 * \}
 */

/**
 * \}
 */

#ifdef __cplusplus
}
#endif

#endif /* #ifndef _GAN_IMAGE_IO_H */
