;==============================================================================

; File: "syntax-case.scm", Time-stamp: <2005-04-27 17:57:01 feeley>

; Copyright (C) 1998-2005 by Marc Feeley, All Rights Reserved.

; Version 3.0 (April 27, 2005)

; This is an implementation of "syntax-case" for the Gambit-C 4.0
; system based on the portable implementation "psyntax.ss".  At the
; top of the file "psyntax.ss" can be found this information:
;
;      Portable implementation of syntax-case
;      Extracted from Chez Scheme Version 6.9c (Sep 02, 2004)
;      Authors: R. Kent Dybvig, Oscar Waddell, Bob Hieb, Carl Bruggeman

; This file can be used to replace the builtin macro expander of the
; interpreter and compiler.  Source code correlation information
; (filename and position in file) is preserved by the expander.  The
; expander mangles non-global variable names and this complicates
; debugging somewhat.  Note that Gambit's normal parser processes the
; input after expansion by the syntax-case expander.  Since the
; syntax-case expander does not know about Gambit's syntactic
; extensions (like DSSSL parameters, forms like "namespace",
; "define-macro", "define-type", and "c-lambda"), those syntactic
; extensions cannot be used.  On the other hand, the syntax-case
; expander defines some new special forms, such as "module",
; "alias", and "eval-when".

; You can simply load this file at the REPL with:
;
;   (load "syntax-case")
;
; For faster macro processing it is worthwhile to compile the file
; with the compiler.  You can also rename this file to "gambcext.scm"
; and put it in the Gambit installation directory so that it is loaded
; every time the interpreter and compiler are started.
;
; Alternatively, the expander can be loaded from the command line
; like this:
;
;   % gsi ~~/syntax-case -
;   > (pp (lambda (x y) (if (< x y) (let ((z (* x x))) z))))
;   (lambda (%%x0 %%y1)
;     (if (< %%x0 %%y1) ((lambda (%%z2) %%z2) (* %%x0 %%x0)) (void)))

;==============================================================================

(##declare
 (standard-bindings)
 (extended-bindings)
 (block)
)

(##namespace ("sc#"))

(##namespace ("" ; these bindings are from R4RS

; special forms
and
begin
case
cond
define
do
if
lambda
let
let*
letrec
or
quasiquote
quote
set!
unquote
unquote-splicing

; procedures
*
+
-
/
<
<=
=
>
>=
abs
acos
angle
append
apply
asin
assoc
assq
assv
atan
boolean?
caaaar
caaadr
caaar
caadar
caaddr
caadr
caar
cadaar
cadadr
cadar
caddar
cadddr
caddr
cadr
call-with-current-continuation
call-with-input-file
call-with-output-file
car
cdaaar
cdaadr
cdaar
cdadar
cdaddr
cdadr
cdar
cddaar
cddadr
cddar
cdddar
cddddr
cdddr
cddr
cdr
ceiling
char->integer
char-alphabetic?
char-ci<=?
char-ci<?
char-ci=?
char-ci>=?
char-ci>?
char-downcase
char-lower-case?
char-numeric?
char-ready?
char-upcase
char-upper-case?
char-whitespace?
char<=?
char<?
char=?
char>=?
char>?
char?
close-input-port
close-output-port
complex?
cons
cos
current-input-port
current-output-port
denominator
display
eof-object?
eq?
equal?
eqv?
even?
exact->inexact
exact?
exp
expt
floor
for-each
force
gcd
imag-part
inexact->exact
inexact?
input-port?
integer->char
integer?
lcm
length
list
list->string
list->vector
list-ref
list-tail
list?
load
log
magnitude
make-polar
make-rectangular
make-string
make-vector
map
max
member
memq
memv
min
modulo
negative?
newline
not
null?
number->string
number?
numerator
odd?
open-input-file
open-output-file
output-port?
pair?
peek-char
positive?
procedure?
quotient
rational?
rationalize
read
read-char
real-part
real?
remainder
reverse
round
set-car!
set-cdr!
sin
sqrt
string
string->list
string->number
string->symbol
string-append
string-ci<=?
string-ci<?
string-ci=?
string-ci>=?
string-ci>?
string-copy
string-fill!
string-length
string-ref
string-set!
string<=?
string<?
string=?
string>=?
string>?
string?
substring
symbol->string
symbol?
tan
transcript-off
transcript-on
truncate
vector
vector->list
vector-fill!
vector-length
vector-ref
vector-set!
vector?
with-input-from-file
with-output-to-file
write
write-char
zero?

))

(##namespace ("" ; these identifier bindings are new in R5RS

; special forms
define-syntax
let-syntax
letrec-syntax
syntax-rules

; procedures
call-with-values
dynamic-wind
eval
interaction-environment
null-environment
scheme-report-environment
values

))

(##namespace ("" ; these identifier bindings are specific to Gambit

; special forms
cond-expand
declare
define-macro
define-record-type
define-structure
define-type
include
namespace
parameterize
receive
time

six.!x
six.&x
six.*x
six.++x
six.+x
six.--x
six.-x
six.arrow
six.call
six.compound
six.cons
six.define-procedure
six.define-variable
six.do-while
six.dot
six.for
six.identifier
six.if
six.index
six.list
six.literal
six.new
six.null
six.prefix
six.procedure
six.procedure-body
six.while
six.x!=y
six.x%=y
six.x%y
six.x&&y
six.x&=y
six.x&y
six.x*=y
six.x*y
six.x++
six.x+=y
six.x+y
|six.x,y|
six.x--
six.x-=y
six.x-y
six.x/=y
six.x/y
six.x:=y
six.x:y
six.x<<=y
six.x<<y
six.x<=y
six.x<y
six.x==y
six.x=y
six.x>=y
six.x>>=y
six.x>>y
six.x>y
six.x?y:z
six.x^=y
six.x^y
|six.x\|=y|
|six.x\|\|y|
|six.x\|y|
six.~x

six.!
six.break
six.case
six.clause
six.continue
six.goto
six.label
six.return
six.switch
six.x:-y

; procedures
abs
acos
all-bits-set?
angle
any-bits-set?
arithmetic-shift
asin
atan
bit-count
bit-set?
bitwise-and
bitwise-ior
bitwise-merge
bitwise-not
bitwise-xor
call-with-current-continuation
ceiling
char-ready?
clear-bit-field
close-input-port
close-output-port
close-port
copy-bit-field
copy-file
cos
create-directory
create-link
create-symbolic-link
default-random-source
delete-directory
delete-file
denominator
directory-files
eq?
equal?
eqv?
error
even?
exact->inexact
exp
expt
f32vector
f32vector->list
f32vector-append
f32vector-length
f32vector-ref
f32vector-set!
f64vector
f64vector->list
f64vector-append
f64vector-length
f64vector-ref
f64vector-set!
first-set-bit
floor
force-output
foreign-release!
gensym
get-output-string
get-output-u8vector
get-output-vector
getenv
group-info
host-info
imag-part
inexact->exact
input-port-byte-position
integer-length
integer-nth-root
integer-sqrt
keyword->string
lc
list
list->f32vector
list->f64vector
list->s16vector
list->s32vector
list->s64vector
list->s8vector
list->table
list->u16vector
list->u32vector
list->u64vector
list->u8vector
load
log
magnitude
make-f32vector
make-f64vector
make-parameter
make-polar
make-rectangular
make-s16vector
make-s32vector
make-s64vector
make-s8vector
make-table
make-u16vector
make-u32vector
make-u64vector
make-u8vector
make-will
modulo
negative?
network-info
numerator
odd?
open-directory
open-file
open-input-file
open-input-string
open-input-u8vector
open-input-vector
open-output-file
open-output-string
open-output-u8vector
open-output-vector
open-string
open-string-pipe
open-u8vector
open-u8vector-pipe
open-vector
open-vector-pipe
output-port-byte-position
output-port-width
path-expand
path-normalize
pcase10
pcase11
pcase12
pcase13
pcase3
pcase4
pcase5
pcase6
pcase7
pcase8
pcase9
peek-char
positive?
pp
protocol-info
quotient
random-source-state-set!
rationalize
read
read-char
read-subu8vector
real-part
remainder
rename-file
replace-bit-field
round
s16vector
s16vector->list
s16vector-append
s16vector-length
s16vector-ref
s16vector-set!
s32vector
s32vector->list
s32vector-append
s32vector-length
s32vector-ref
s32vector-set!
s64vector
s64vector->list
s64vector-append
s64vector-length
s64vector-ref
s64vector-set!
s8vector
s8vector->list
s8vector-append
s8vector-length
s8vector-ref
s8vector-set!
serial-number->object
service-info
set-box!
setenv
shell-command
sin
sqrt
string->keyword
string-append
string-ci=?
string-ci=?-hash
string=?
string=?-hash
table-ref
tan
thread-join!
thread-start!
truncate
u16vector
u16vector->list
u16vector-append
u16vector-length
u16vector-ref
u16vector-set!
u32vector
u32vector->list
u32vector-append
u32vector-length
u32vector-ref
u32vector-set!
u64vector
u64vector->list
u64vector-append
u64vector-length
u64vector-ref
u64vector-set!
u8vector
u8vector->list
u8vector-append
u8vector-length
u8vector-ref
u8vector-set!
unbox
user-info
vector-append
will-testator
write
write-char
write-subu8vector
zero?

*
+
-
/
<
<=
=
>
>=
abandoned-mutex-exception?
abort
append
apply
assoc
assq
assv
boolean?
box
box?
break
caaaar
caaadr
caaar
caadar
caaddr
caadr
caar
cadaar
cadadr
cadar
caddar
cadddr
caddr
cadr
call-with-input-file
call-with-input-string
call-with-input-u8vector
call-with-input-vector
call-with-output-file
call-with-output-string
call-with-output-u8vector
call-with-output-vector
call-with-values
call/cc
car
cdaaar
cdaadr
cdaar
cdadar
cdaddr
cdadr
cdar
cddaar
cddadr
cddar
cdddar
cddddr
cdddr
cddr
cdr
cfun-conversion-exception-arguments
cfun-conversion-exception-code
cfun-conversion-exception-message
cfun-conversion-exception-procedure
cfun-conversion-exception?
char->integer
char-alphabetic?
char-ci<=?
char-ci<?
char-ci=?
char-ci>=?
char-ci>?
char-downcase
char-lower-case?
char-numeric?
char-upcase
char-upper-case?
char-whitespace?
char<=?
char<?
char=?
char>=?
char>?
char?
command-line
complex?
condition-variable-broadcast!
condition-variable-name
condition-variable-signal!
condition-variable-specific
condition-variable-specific-set!
condition-variable?
cons
console-port
cpu-time
create-fifo
current-directory
current-error-port
current-exception-handler
current-input-port
current-output-port
current-readtable
current-thread
current-time
current-user-interrupt-handler
datum-parsing-exception-kind
datum-parsing-exception-parameters
datum-parsing-exception-readenv
datum-parsing-exception?
deadlock-exception?
display
display-environment-set!
divide-by-zero-exception-arguments
divide-by-zero-exception-procedure
divide-by-zero-exception?
dynamic-wind
eof-object?
eq?-hash
equal?-hash
eqv?-hash
err-code->string
error-exception-message
error-exception-parameters
error-exception?
eval
exact?
exit
expression-parsing-exception-kind
expression-parsing-exception-parameters
expression-parsing-exception-source
expression-parsing-exception?
extract-bit-field
f32vector-copy
f32vector-fill!
f32vector?
f64vector-copy
f64vector-fill!
f64vector?
file-attributes
file-creation-time
file-device
file-exists?
file-group
file-info
file-info-attributes
file-info-creation-time
file-info-device
file-info-group
file-info-inode
file-info-last-access-time
file-info-last-change-time
file-info-last-modification-time
file-info-mode
file-info-number-of-links
file-info-owner
file-info-size
file-info-type
file-info?
file-inode
file-last-access-time
file-last-change-time
file-last-modification-time
file-mode
file-number-of-links
file-owner
file-size
file-type
for-each
force
foreign-address
foreign-released?
gc-report-set!
gcd
group-info-gid
group-info-members
group-info-name
group-info?
heap-overflow-exception?
host-info-addresses
host-info-aliases
host-info-name
host-info?
improper-length-list-exception-arg-num
improper-length-list-exception-arguments
improper-length-list-exception-procedure
improper-length-list-exception?
inexact?
input-port-column
input-port-line
input-port-readtable
input-port-readtable-set!
input-port-timeout-set!
input-port?
integer->char
integer?
interaction-environment
invalid-hash-number-exception-arguments
invalid-hash-number-exception-procedure
invalid-hash-number-exception?
join-timeout-exception-arguments
join-timeout-exception-procedure
join-timeout-exception?
keyword-expected-exception-arguments
keyword-expected-exception-procedure
keyword-expected-exception?
keyword-hash
keyword?
lcm
length
list->string
list->vector
list-ref
list-tail
list?
make-condition-variable
make-mutex
make-random-source
make-string
make-thread
make-thread-group
make-vector
map
max
member
memq
memv
min
multiple-c-return-exception?
mutex-lock!
mutex-name
mutex-specific
mutex-specific-set!
mutex-state
mutex-unlock!
mutex?
network-info-aliases
network-info-name
network-info-net
network-info?
newline
no-such-file-or-directory-exception-arguments
no-such-file-or-directory-exception-procedure
no-such-file-or-directory-exception?
noncontinuable-exception-reason
noncontinuable-exception?
nonprocedure-operator-exception-arguments
nonprocedure-operator-exception-code
nonprocedure-operator-exception-operator
nonprocedure-operator-exception-rte
nonprocedure-operator-exception?
not
null-environment
null?
number->string
number-of-arguments-limit-exception-arguments
number-of-arguments-limit-exception-procedure
number-of-arguments-limit-exception?
number?
object->serial-number
object->string
open-process
open-tcp-client
open-tcp-server
os-exception-arguments
os-exception-code
os-exception-message
os-exception-procedure
os-exception?
output-port-column
output-port-line
output-port-readtable
output-port-readtable-set!
output-port-timeout-set!
output-port?
pair?
path-directory
path-extension
path-strip-directory
path-strip-extension
path-strip-volume
path-volume
port-encoding-set!
port?
pretty-print
primordial-exception-handler
procedure?
process-times
proper-tail-calls-set!
protocol-info-aliases
protocol-info-name
protocol-info-number
protocol-info?
raise
random-integer
random-real
random-source-make-integers
random-source-make-reals
random-source-pseudo-randomize!
random-source-randomize!
random-source-state-ref
random-source?
range-exception-arg-num
range-exception-arguments
range-exception-procedure
range-exception?
rational?
read-all
read-byte
read-line
readtable-case-conversion?
readtable-case-conversion?-set
readtable-eval-allowed?
readtable-eval-allowed?-set
readtable-keywords-allowed?
readtable-keywords-allowed?-set
readtable-max-write-length
readtable-max-write-length-set
readtable-max-write-level
readtable-max-write-level-set
readtable-sharing-allowed?
readtable-sharing-allowed?-set
readtable-start-syntax
readtable-start-syntax-set
readtable?
real-time
real?
repl-input-port
repl-output-port
reverse
s16vector-copy
s16vector-fill!
s16vector?
s32vector-copy
s32vector-fill!
s32vector?
s64vector-copy
s64vector-fill!
s64vector?
s8vector-copy
s8vector-fill!
s8vector?
scheduler-exception-reason
scheduler-exception?
scheme-report-environment
seconds->time
service-info-aliases
service-info-name
service-info-port
service-info-protocol
service-info?
set-car!
set-cdr!
sfun-conversion-exception-arguments
sfun-conversion-exception-code
sfun-conversion-exception-message
sfun-conversion-exception-procedure
sfun-conversion-exception?
six.make-array
stack-overflow-exception?
started-thread-exception-arguments
started-thread-exception-procedure
started-thread-exception?
step
step-level-set!
string
string->list
string->number
string->symbol
string-ci<=?
string-ci<?
string-ci>=?
string-ci>?
string-copy
string-fill!
string-length
string-ref
string-set!
string<=?
string<?
string>=?
string>?
string?
subf32vector
subf64vector
subs16vector
subs32vector
subs64vector
subs8vector
substring
subu16vector
subu32vector
subu64vector
subu8vector
subvector
symbol->string
symbol-hash
symbol?
system-version
system-version-string
table->list
table-for-each
table-length
table-search
table-set!
table?
terminated-thread-exception-arguments
terminated-thread-exception-procedure
terminated-thread-exception?
test-bit-field?
thread-base-priority
thread-base-priority-set!
thread-group-name
thread-group-parent
thread-group-resume!
thread-group-suspend!
thread-group-terminate!
thread-group?
thread-name
thread-priority-boost
thread-priority-boost-set!
thread-quantum
thread-quantum-set!
thread-resume!
thread-sleep!
thread-specific
thread-specific-set!
thread-suspend!
thread-terminate!
thread-thread-group
thread-yield!
thread?
time->seconds
touch
trace
transcript-off
transcript-on
tty-history
tty-history-set!
tty-max-history-length-set!
tty-mode-set!
tty-paren-balance-duration-set!
tty-text-attributes-set!
tty-type-set!
tty?
type-exception-arg-num
type-exception-arguments
type-exception-procedure
type-exception-type-id
type-exception?
u16vector-copy
u16vector-fill!
u16vector?
u32vector-copy
u32vector-fill!
u32vector?
u64vector-copy
u64vector-fill!
u64vector?
u8vector-copy
u8vector-fill!
u8vector?
unbound-global-exception-code
unbound-global-exception-rte
unbound-global-exception-variable
unbound-global-exception?
unbound-os-environment-variable-exception-arguments
unbound-os-environment-variable-exception-procedure
unbound-os-environment-variable-exception?
unbound-serial-number-exception-arguments
unbound-serial-number-exception-procedure
unbound-serial-number-exception?
unbound-table-key-exception-arguments
unbound-table-key-exception-procedure
unbound-table-key-exception?
unbreak
uncaught-exception-arguments
uncaught-exception-procedure
uncaught-exception-reason
uncaught-exception?
uninterned-keyword?
uninterned-symbol?
unknown-keyword-argument-exception-arguments
unknown-keyword-argument-exception-procedure
unknown-keyword-argument-exception?
untrace
user-info-gid
user-info-home
user-info-name
user-info-shell
user-info-uid
user-info?
values
vector
vector->list
vector-copy
vector-fill!
vector-length
vector-ref
vector-set!
vector?
void
will-execute!
will?
with-exception-catcher
with-exception-handler
with-input-from-file
with-input-from-port
with-input-from-string
with-input-from-u8vector
with-input-from-vector
with-output-to-file
with-output-to-port
with-output-to-string
with-output-to-u8vector
with-output-to-vector
write-byte
write-substring
wrong-number-of-arguments-exception-arguments
wrong-number-of-arguments-exception-procedure
wrong-number-of-arguments-exception?

))

(##namespace (""

$make-environment
$sc-put-cte
$syntax-dispatch
bound-identifier=?
datum->syntax-object
environment?
free-identifier=?
generate-temporaries
identifier?
interaction-environment
literal-identifier=?
sc-expand
syntax-error
syntax-object->datum

))

(##namespace ("sc#"

interaction-environment
eval
gensym

))

;==============================================================================

; The following procedures are needed by the syntax-case system.

(define andmap
  (lambda (f first . rest)
    (or (null? first)
        (if (null? rest)
            (let andmap ((first first))
              (let ((x (car first)) (first (cdr first)))
                (if (null? first)
                    (f x)
                    (and (f x) (andmap first)))))
            (let andmap ((first first) (rest rest))
              (let ((x (car first))
                    (xr (map car rest))
                    (first (cdr first))
                    (rest (map cdr rest)))
                (if (null? first)
                    (apply f (cons x xr))
                    (and (apply f (cons x xr)) (andmap first rest)))))))))

(define ormap
  (lambda (proc list1)
    (and (not (null? list1))
         (or (proc (car list1)) (ormap proc (cdr list1))))))

(define eval
  (lambda (expr)
    (cond ((and (##pair? expr)
                (##equal? (##car expr) "noexpand")
                (##pair? (##cdr expr))
                (##null? (##cddr expr)))
           (##eval (##cadr expr)))
          ((and (##source? expr)
                (##pair? (##source-code expr))
                (##source? (##car (##source-code expr)))
                (##equal? (##source-code (##car (##source-code expr))) "noexpand")
                (##pair? (##cdr (##source-code expr)))
                (##null? (##cddr (##source-code expr))))
           (##eval (##cadr (##source-code expr))))
          (else
           (##raise-error-exception
            "eval expects an expression of the form (\"noexpand\" <expr>)"
            (##list expr))))))

(define gensym-count 0)

(define gensym
  (lambda id
    (let ((n gensym-count))
      (set! gensym-count (+ n 1))
      (string->symbol
       (string-append "%%"
                      (if (null? id) "" (symbol->string (car id)))
                      (number->string n))))))

(define gensym?
  (lambda (obj)
    (and (symbol? obj)
         (let ((str (symbol->string obj)))
           (and (> (string-length str) 2)
                (string=? (substring str 0 2) "%%"))))))

(define prop-table (make-table))

(define remprop
  (lambda (sym key)
    (let ((sym-key (cons sym key)))
      (table-set! prop-table sym-key))))

(define putprop
  (lambda (sym key val)
    (let ((sym-key (cons sym key)))
      (table-set! prop-table sym-key val))))

(define getprop
  (lambda (sym key)
    (let ((sym-key (cons sym key)))
      (table-ref prop-table sym-key #f))))

(define format
  (lambda (format-string . objects)
    (let ((buffer (open-output-string)))
      (let loop ((format-list (string->list format-string))
                 (objects objects))
        (cond ((null? format-list) (get-output-string buffer))
              ((char=? (car format-list) #\~)
               (if (null? (cdr format-list))
                   (error "Incomplete escape sequence")
                   (case (cadr format-list)
                     ((#\a)
                      (if (null? objects)
                          (error "No value for escape sequence")
                          (begin
                            (display (car objects) buffer)
                            (loop (cddr format-list) (cdr objects)))))
                     ((#\s)
                      (if (null? objects)
                          (error "No value for escape sequence")
                          (begin
                            (write (car objects) buffer)
                            (loop (cddr format-list) (cdr objects)))))
                     ((#\%)
                      (newline buffer)
                      (loop (cddr format-list) objects))
                     ((#\~)
                      (write-char #\~ buffer)
                      (loop (cddr format-list) objects))
                     (else
                      (error "Unrecognized escape sequence")))))
              (else (write-char (car format-list) buffer)
                    (loop (cdr format-list) objects)))))))

(define list*
  (lambda (arg1 . other-args)

    (define (fix lst)
      (if (null? (cdr lst))
          (car lst)
          (cons (car lst) (fix (cdr lst)))))

    (fix (cons arg1 other-args))))

(define remq
  (lambda (obj lst)
    (cond ((null? lst)
           '())
          ((eq? (car lst) obj)
           (remq obj (cdr lst)))
          (else
           (cons (car lst) (remq obj (cdr lst)))))))

;------------------------------------------------------------------------------

; These initial definitions are needed because these variables are
; mutated with a "set!" without a prior definition.

(define $sc-put-cte #f)
(define sc-expand #f)
(define $make-environment #f)
(define environment? #f)
(define interaction-environment #f)
(define identifier? #f)
(define syntax-object->datum #f)
(define datum->syntax-object #f)
(define generate-temporaries #f)
(define free-identifier=? #f)
(define bound-identifier=? #f)
(define literal-identifier=? #f)
(define syntax-error #f)
(define $syntax-dispatch #f)

;------------------------------------------------------------------------------

; Interface to Gambit's source code annotations.

(define annotation?
  (lambda (x)
    (##source? x)))

(define annotation-expression
  (lambda (x)
    (##source-code x)))

(define annotation-stripped
  (lambda (x)
    (##desourcify x)))

(define build-source
  (lambda (ae x)
    (if (##source? ae)
        (##make-source x (##source-locat ae))
        (##make-source x #f))))

(define attach-source
  (lambda (ae datum)
    (let ((src
           (if (##source? ae)
               ae
               (##make-source ae #f))))

      (define (datum->source x)
        (##make-source (cond ((pair? x)
                              (list-convert x))
                             ((box? x)
                              (box (datum->source (unbox x))))
                             ((vector? x)
                              (vector-convert x))
                             (else
                              x))
                       (##source-locat src)))

      (define (list-convert lst)
        (cons (datum->source (car lst))
              (list-tail-convert (cdr lst))))

      (define (list-tail-convert lst)
        (cond ((pair? lst)
               (if (quoting-form? lst)
                   (datum->source lst)
                   (cons (datum->source (car lst))
                         (list-tail-convert (cdr lst)))))
              ((null? lst)
               '())
              (else
               (datum->source lst))))

      (define (quoting-form? x)
        (let ((first (car x))
              (rest (cdr x)))
          (and (pair? rest)
               (null? (cdr rest))
               (or (eq? first 'quote)
                   (eq? first 'quasiquote)
                   (eq? first 'unquote)
                   (eq? first 'unquote-splicing)))))

      (define (vector-convert vect)
        (let* ((len (vector-length vect))
               (v (make-vector len)))
          (let loop ((i (- len 1)))
            (if (>= i 0)
              (begin
                (vector-set! v i (datum->source (vector-ref vect i)))
                (loop (- i 1)))))
          v))

      (datum->source datum))))

;------------------------------------------------------------------------------

(define self-eval?
  (lambda (x)
    (or (number? x)
        (string? x)
        (char? x)
        (keyword? x)
        (memq x
              '(#f
                #t
                #!eof
                #!void
                #!unbound
                #!unbound2
                #!optional
                #!rest
                #!key)))))

;==============================================================================
(begin ((lambda ()
          (letrec ((%%noexpand69 '"noexpand")
                   (%%make-syntax-object100
                    (lambda (%%expression2012 %%wrap2011)
                      (vector 'syntax-object %%expression2012 %%wrap2011)))
                   (%%syntax-object?101
                    (lambda (%%x2010)
                      (if (vector? %%x2010)
                          (if (= (vector-length %%x2010) '3)
                              (eq? (vector-ref %%x2010 '0) 'syntax-object)
                              '#f)
                          '#f)))
                   (%%syntax-object-expression102
                    (lambda (%%x2009) (vector-ref %%x2009 '1)))
                   (%%syntax-object-wrap103
                    (lambda (%%x2008) (vector-ref %%x2008 '2)))
                   (%%set-syntax-object-expression!104
                    (lambda (%%x2007 %%update2006)
                      (vector-set! %%x2007 '1 %%update2006)))
                   (%%set-syntax-object-wrap!105
                    (lambda (%%x2005 %%update2004)
                      (vector-set! %%x2005 '2 %%update2004)))
                   (%%top-level-eval-hook169
                    (lambda (%%x2003) (eval (list %%noexpand69 %%x2003))))
                   (%%local-eval-hook170
                    (lambda (%%x2002) (eval (list %%noexpand69 %%x2002))))
                   (%%define-top-level-value-hook171
                    (lambda (%%sym2001 %%val2000)
                      (%%top-level-eval-hook169
                        (build-source
                          '#f
                          (list (build-source '#f 'define)
                                (build-source '#f %%sym2001)
                                (build-source
                                  '#f
                                  (list (build-source '#f 'quote)
                                        (attach-source
                                          '#f
                                          %%val2000))))))))
                   (%%put-cte-hook176
                    (lambda (%%symbol1999 %%val1998)
                      ($sc-put-cte %%symbol1999 %%val1998 '*top*)))
                   (%%get-global-definition-hook177
                    (lambda (%%symbol1997)
                      (getprop %%symbol1997 '*sc-expander*)))
                   (%%put-global-definition-hook178
                    (lambda (%%symbol1996 %%x1995)
                      (if (not %%x1995)
                          (remprop %%symbol1996 '*sc-expander*)
                          (putprop %%symbol1996 '*sc-expander* %%x1995))))
                   (%%read-only-binding?179 (lambda (%%symbol1994) '#f))
                   (%%get-import-binding180
                    (lambda (%%symbol1993 %%token1992)
                      (getprop %%symbol1993 %%token1992)))
                   (%%put-import-binding181
                    (lambda (%%symbol1991 %%token1990 %%x1989)
                      (if (not %%x1989)
                          (remprop %%symbol1991 %%token1990)
                          (putprop %%symbol1991 %%token1990 %%x1989))))
                   (%%generate-id182
                    ((lambda (%%digits1975)
                       ((lambda (%%base1977 %%session-key1976)
                          (letrec ((%%make-digit1978
                                    (lambda (%%x1986)
                                      (string-ref %%digits1975 %%x1986)))
                                   (%%fmt1979
                                    (lambda (%%n1980)
                                      ((letrec ((%%fmt1981
                                                 (lambda (%%n1983 %%a1982)
                                                   (if (< %%n1983
                                                          %%base1977)
                                                       (list->string
                                                         (cons (%%make-digit1978
                                                                 %%n1983)
                                                               %%a1982))
                                                       ((lambda (%%r1985
                                                                 %%rest1984)
                                                          (%%fmt1981
                                                            %%rest1984
                                                            (cons (%%make-digit1978
                                                                    %%r1985)
                                                                  %%a1982)))
                                                        (modulo
                                                          %%n1983
                                                          %%base1977)
                                                        (quotient
                                                          %%n1983
                                                          %%base1977))))))
                                         %%fmt1981)
                                       %%n1980
                                       '()))))
                            ((lambda (%%n1987)
                               (lambda (%%name1988)
                                 (begin (set! %%n1987 (+ %%n1987 '1))
                                        (string->symbol
                                          (string-append
                                            %%session-key1976
                                            (%%fmt1979 %%n1987))))))
                             '-1)))
                        (string-length %%digits1975)
                        '"_"))
                     '"0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!$%&*/:<=>?~_^.+-"))
                   (%%build-params256
                    (lambda (%%ae1971 %%vars1970)
                      (letrec ((%%fix1972
                                (lambda (%%vars1973)
                                  (if (null? %%vars1973)
                                      '()
                                      (if (pair? %%vars1973)
                                          (cons (build-source
                                                  %%ae1971
                                                  (car %%vars1973))
                                                (%%fix1972
                                                  (cdr %%vars1973)))
                                          (build-source
                                            %%ae1971
                                            %%vars1973))))))
                        (if ((lambda (%%t1974)
                               (if %%t1974 %%t1974 (pair? %%vars1970)))
                             (null? %%vars1970))
                            (build-source %%ae1971 (%%fix1972 %%vars1970))
                            (%%fix1972 %%vars1970)))))
                   (%%built-lambda?257
                    (lambda (%%x1968)
                      ((lambda (%%t1969)
                         (if %%t1969
                             %%t1969
                             (if (annotation? %%x1968)
                                 (if (pair? (annotation-expression %%x1968))
                                     (if (annotation?
                                           (car (annotation-expression %%x1968)))
                                         (eq? (annotation-expression
                                                (car (annotation-expression
                                                       %%x1968)))
                                              'lambda)
                                         '#f)
                                     '#f)
                                 '#f)))
                       (if (pair? %%x1968)
                           (eq? (car %%x1968) 'lambda)
                           '#f))))
                   (%%build-sequence275
                    (lambda (%%ae1964 %%exps1963)
                      ((letrec ((%%loop1965
                                 (lambda (%%exps1966)
                                   (if (null? (cdr %%exps1966))
                                       (car %%exps1966)
                                       (if ((lambda (%%t1967)
                                              (if %%t1967
                                                  %%t1967
                                                  (if (annotation?
                                                        (car %%exps1966))
                                                      (if (pair?
                                                            (annotation-expression
                                                              (car %%exps1966)))
                                                          (if (annotation?
                                                                (car (annotation-expression
                                                                       (car %%exps1966))))
                                                              (if (eq? (annotation-expression
                                                                         (car (annotation-expression
                                                                                (car %%exps1966))))
                                                                       'void)
                                                                  (null?
                                                                    (cdr (annotation-expression
                                                                           (car %%exps1966))))
                                                                  '#f)
                                                              '#f)
                                                          '#f)
                                                      '#f)))
                                            (equal?
                                              (car %%exps1966)
                                              '(void)))
                                           (%%loop1965 (cdr %%exps1966))
                                           (build-source
                                             %%ae1964
                                             (cons (build-source
                                                     %%ae1964
                                                     'begin)
                                                   %%exps1966)))))))
                         %%loop1965)
                       %%exps1963)))
                   (%%build-letrec276
                    (lambda (%%ae1960
                             %%vars1959
                             %%val-exps1958
                             %%body-exp1957)
                      (if (null? %%vars1959)
                          %%body-exp1957
                          (build-source
                            %%ae1960
                            (list (build-source %%ae1960 'letrec)
                                  (build-source
                                    %%ae1960
                                    (map (lambda (%%var1962 %%val1961)
                                           (build-source
                                             %%ae1960
                                             (list (build-source
                                                     %%ae1960
                                                     %%var1962)
                                                   %%val1961)))
                                         %%vars1959
                                         %%val-exps1958))
                                  %%body-exp1957)))))
                   (%%build-body277
                    (lambda (%%ae1956
                             %%vars1955
                             %%val-exps1954
                             %%body-exp1953)
                      (%%build-letrec276
                        %%ae1956
                        %%vars1955
                        %%val-exps1954
                        %%body-exp1953)))
                   (%%build-top-module278
                    (lambda (%%ae1941
                             %%types1940
                             %%vars1939
                             %%val-exps1938
                             %%body-exp1937)
                      (call-with-values
                        (lambda ()
                          ((letrec ((%%f1945
                                     (lambda (%%types1947 %%vars1946)
                                       (if (null? %%types1947)
                                           (values '() '() '())
                                           ((lambda (%%var1948)
                                              (call-with-values
                                                (lambda ()
                                                  (%%f1945
                                                    (cdr %%types1947)
                                                    (cdr %%vars1946)))
                                                (lambda (%%vars1951
                                                         %%defns1950
                                                         %%sets1949)
                                                  (if (eq? (car %%types1947)
                                                           'global)
                                                      ((lambda (%%x1952)
                                                         (values
                                                           (cons %%x1952
                                                                 %%vars1951)
                                                           (cons (build-source
                                                                   '#f
                                                                   (list (build-source
                                                                           '#f
                                                                           'define)
                                                                         (build-source
                                                                           '#f
                                                                           %%var1948)
                                                                         (%%chi-void552)))
                                                                 %%defns1950)
                                                           (cons (build-source
                                                                   '#f
                                                                   (list (build-source
                                                                           '#f
                                                                           'set!)
                                                                         (build-source
                                                                           '#f
                                                                           %%var1948)
                                                                         (build-source
                                                                           '#f
                                                                           %%x1952)))
                                                                 %%sets1949)))
                                                       (gensym %%var1948))
                                                      (values
                                                        (cons %%var1948
                                                              %%vars1951)
                                                        %%defns1950
                                                        %%sets1949)))))
                                            (car %%vars1946))))))
                             %%f1945)
                           %%types1940
                           %%vars1939))
                        (lambda (%%vars1944 %%defns1943 %%sets1942)
                          (if (null? %%defns1943)
                              (%%build-letrec276
                                %%ae1941
                                %%vars1944
                                %%val-exps1938
                                %%body-exp1937)
                              (%%build-sequence275
                                '#f
                                (append
                                  %%defns1943
                                  (list (%%build-letrec276
                                          %%ae1941
                                          %%vars1944
                                          %%val-exps1938
                                          (%%build-sequence275
                                            '#f
                                            (append
                                              %%sets1942
                                              (list %%body-exp1937))))))))))))
                   (%%sanitize-binding311
                    (lambda (%%b1933)
                      (if (procedure? %%b1933)
                          (cons 'macro %%b1933)
                          (if (%%binding?325 %%b1933)
                              (if ((lambda (%%t1934)
                                     (if (memv %%t1934
                                               '(core macro
                                                      macro!
                                                      deferred))
                                         (procedure?
                                           (%%binding-value322 %%b1933))
                                         (if (memv %%t1934 '($module))
                                             (%%interface?489
                                               (%%binding-value322
                                                 %%b1933))
                                             (if (memv %%t1934 '(lexical))
                                                 '#f
                                                 (if (memv %%t1934
                                                           '(global
                                                              meta-variable))
                                                     (symbol?
                                                       (%%binding-value322
                                                         %%b1933))
                                                     (if (memv %%t1934
                                                               '(syntax))
                                                         ((lambda (%%x1935)
                                                            (if (pair?
                                                                  %%x1935)
                                                                (if '#f
                                                                    ((lambda (%%n1936)
                                                                       (if (integer?
                                                                             %%n1936)
                                                                           (if (exact?
                                                                                 %%n1936)
                                                                               (>= %%n1936
                                                                                   '0)
                                                                               '#f)
                                                                           '#f))
                                                                     (cdr %%x1935))
                                                                    '#f)
                                                                '#f))
                                                          (%%binding-value322
                                                            %%b1933))
                                                         (if (memv %%t1934
                                                                   '(begin define
                                                                           define-syntax
                                                                           set!
                                                                           $module-key
                                                                           $import
                                                                           eval-when
                                                                           meta))
                                                             (null?
                                                               (%%binding-value322
                                                                 %%b1933))
                                                             (if (memv %%t1934
                                                                       '(local-syntax))
                                                                 (boolean?
                                                                   (%%binding-value322
                                                                     %%b1933))
                                                                 (if (memv %%t1934
                                                                           '(displaced-lexical))
                                                                     (eq? (%%binding-value322
                                                                            %%b1933)
                                                                          '#f)
                                                                     '#t)))))))))
                                   (%%binding-type321 %%b1933))
                                  %%b1933
                                  '#f)
                              '#f))))
                   (%%binding-type321 car)
                   (%%binding-value322 cdr)
                   (%%set-binding-type!323 set-car!)
                   (%%set-binding-value!324 set-cdr!)
                   (%%binding?325
                    (lambda (%%x1932)
                      (if (pair? %%x1932) (symbol? (car %%x1932)) '#f)))
                   (%%extend-env335
                    (lambda (%%label1931 %%binding1930 %%r1929)
                      (cons (cons %%label1931 %%binding1930) %%r1929)))
                   (%%extend-env*336
                    (lambda (%%labels1928 %%bindings1927 %%r1926)
                      (if (null? %%labels1928)
                          %%r1926
                          (%%extend-env*336
                            (cdr %%labels1928)
                            (cdr %%bindings1927)
                            (%%extend-env335
                              (car %%labels1928)
                              (car %%bindings1927)
                              %%r1926)))))
                   (%%extend-var-env*337
                    (lambda (%%labels1925 %%vars1924 %%r1923)
                      (if (null? %%labels1925)
                          %%r1923
                          (%%extend-var-env*337
                            (cdr %%labels1925)
                            (cdr %%vars1924)
                            (%%extend-env335
                              (car %%labels1925)
                              (cons 'lexical (car %%vars1924))
                              %%r1923)))))
                   (%%displaced-lexical?338
                    (lambda (%%id1920 %%r1919)
                      ((lambda (%%n1921)
                         (if %%n1921
                             ((lambda (%%b1922)
                                (eq? (%%binding-type321 %%b1922)
                                     'displaced-lexical))
                              (%%lookup341 %%n1921 %%r1919))
                             '#f))
                       (%%id-var-name472 %%id1920 '(())))))
                   (%%displaced-lexical-error339
                    (lambda (%%id1918)
                      (syntax-error
                        %%id1918
                        (if (%%id-var-name472 %%id1918 '(()))
                            '"identifier out of context"
                            '"identifier not visible"))))
                   (%%lookup*340
                    (lambda (%%x1915 %%r1914)
                      ((lambda (%%t1916)
                         (if %%t1916
                             (cdr %%t1916)
                             (if (symbol? %%x1915)
                                 ((lambda (%%t1917)
                                    (if %%t1917
                                        %%t1917
                                        (cons 'global %%x1915)))
                                  (%%get-global-definition-hook177
                                    %%x1915))
                                 '(displaced-lexical . #f))))
                       (assq %%x1915 %%r1914))))
                   (%%lookup341
                    (lambda (%%x1909 %%r1908)
                      (letrec ((%%whack-binding!1910
                                (lambda (%%b1912 %%*b1911)
                                  (begin (%%set-binding-type!323
                                           %%b1912
                                           (%%binding-type321 %%*b1911))
                                         (%%set-binding-value!324
                                           %%b1912
                                           (%%binding-value322
                                             %%*b1911))))))
                        ((lambda (%%b1913)
                           (begin (if (eq? (%%binding-type321 %%b1913)
                                           'deferred)
                                      (%%whack-binding!1910
                                        %%b1913
                                        (%%make-transformer-binding342
                                          ((%%binding-value322 %%b1913))))
                                      (void))
                                  %%b1913))
                         (%%lookup*340 %%x1909 %%r1908)))))
                   (%%make-transformer-binding342
                    (lambda (%%b1906)
                      ((lambda (%%t1907)
                         (if %%t1907
                             %%t1907
                             (syntax-error
                               %%b1906
                               '"invalid transformer")))
                       (%%sanitize-binding311 %%b1906))))
                   (%%defer-or-eval-transformer343
                    (lambda (%%eval1905 %%x1904)
                      (if (%%built-lambda?257 %%x1904)
                          (cons 'deferred (lambda () (%%eval1905 %%x1904)))
                          (%%make-transformer-binding342
                            (%%eval1905 %%x1904)))))
                   (%%global-extend344
                    (lambda (%%type1903 %%sym1902 %%val1901)
                      (%%put-cte-hook176
                        %%sym1902
                        (cons %%type1903 %%val1901))))
                   (%%nonsymbol-id?345
                    (lambda (%%x1899)
                      (if (%%syntax-object?101 %%x1899)
                          (symbol?
                            ((lambda (%%e1900)
                               (if (annotation? %%e1900)
                                   (annotation-expression %%e1900)
                                   %%e1900))
                             (%%syntax-object-expression102 %%x1899)))
                          '#f)))
                   (%%id?346
                    (lambda (%%x1897)
                      (if (symbol? %%x1897)
                          '#t
                          (if (%%syntax-object?101 %%x1897)
                              (symbol?
                                ((lambda (%%e1898)
                                   (if (annotation? %%e1898)
                                       (annotation-expression %%e1898)
                                       %%e1898))
                                 (%%syntax-object-expression102 %%x1897)))
                              (if (annotation? %%x1897)
                                  (symbol? (annotation-expression %%x1897))
                                  '#f)))))
                   (%%id-sym-name&marks357
                    (lambda (%%x1894 %%w1893)
                      (if (%%syntax-object?101 %%x1894)
                          (values
                            ((lambda (%%e1896)
                               (if (annotation? %%e1896)
                                   (annotation-expression %%e1896)
                                   %%e1896))
                             (%%syntax-object-expression102 %%x1894))
                            (%%join-marks462
                              (%%wrap-marks359 %%w1893)
                              (%%wrap-marks359
                                (%%syntax-object-wrap103 %%x1894))))
                          (values
                            ((lambda (%%e1895)
                               (if (annotation? %%e1895)
                                   (annotation-expression %%e1895)
                                   %%e1895))
                             %%x1894)
                            (%%wrap-marks359 %%w1893)))))
                   (%%make-wrap358 cons)
                   (%%wrap-marks359 car)
                   (%%wrap-subst360 cdr)
                   (%%make-indirect-label397
                    (lambda (%%label1892)
                      (vector 'indirect-label %%label1892)))
                   (%%indirect-label?398
                    (lambda (%%x1891)
                      (if (vector? %%x1891)
                          (if (= (vector-length %%x1891) '2)
                              (eq? (vector-ref %%x1891 '0) 'indirect-label)
                              '#f)
                          '#f)))
                   (%%indirect-label-label399
                    (lambda (%%x1890) (vector-ref %%x1890 '1)))
                   (%%set-indirect-label-label!400
                    (lambda (%%x1889 %%update1888)
                      (vector-set! %%x1889 '1 %%update1888)))
                   (%%gen-indirect-label401
                    (lambda ()
                      (%%make-indirect-label397 (%%gen-label404))))
                   (%%get-indirect-label402
                    (lambda (%%x1887) (%%indirect-label-label399 %%x1887)))
                   (%%set-indirect-label!403
                    (lambda (%%x1886 %%v1885)
                      (%%set-indirect-label-label!400 %%x1886 %%v1885)))
                   (%%gen-label404 (lambda () (string '#\i)))
                   (%%label?405
                    (lambda (%%x1882)
                      ((lambda (%%t1883)
                         (if %%t1883
                             %%t1883
                             ((lambda (%%t1884)
                                (if %%t1884
                                    %%t1884
                                    (%%indirect-label?398 %%x1882)))
                              (symbol? %%x1882))))
                       (string? %%x1882))))
                   (%%gen-labels406
                    (lambda (%%ls1881)
                      (if (null? %%ls1881)
                          '()
                          (cons (%%gen-label404)
                                (%%gen-labels406 (cdr %%ls1881))))))
                   (%%make-ribcage407
                    (lambda (%%symnames1880 %%marks1879 %%labels1878)
                      (vector
                        'ribcage
                        %%symnames1880
                        %%marks1879
                        %%labels1878)))
                   (%%ribcage?408
                    (lambda (%%x1877)
                      (if (vector? %%x1877)
                          (if (= (vector-length %%x1877) '4)
                              (eq? (vector-ref %%x1877 '0) 'ribcage)
                              '#f)
                          '#f)))
                   (%%ribcage-symnames409
                    (lambda (%%x1876) (vector-ref %%x1876 '1)))
                   (%%ribcage-marks410
                    (lambda (%%x1875) (vector-ref %%x1875 '2)))
                   (%%ribcage-labels411
                    (lambda (%%x1874) (vector-ref %%x1874 '3)))
                   (%%set-ribcage-symnames!412
                    (lambda (%%x1873 %%update1872)
                      (vector-set! %%x1873 '1 %%update1872)))
                   (%%set-ribcage-marks!413
                    (lambda (%%x1871 %%update1870)
                      (vector-set! %%x1871 '2 %%update1870)))
                   (%%set-ribcage-labels!414
                    (lambda (%%x1869 %%update1868)
                      (vector-set! %%x1869 '3 %%update1868)))
                   (%%make-top-ribcage415
                    (lambda (%%key1867 %%mutable?1866)
                      (vector 'top-ribcage %%key1867 %%mutable?1866)))
                   (%%top-ribcage?416
                    (lambda (%%x1865)
                      (if (vector? %%x1865)
                          (if (= (vector-length %%x1865) '3)
                              (eq? (vector-ref %%x1865 '0) 'top-ribcage)
                              '#f)
                          '#f)))
                   (%%top-ribcage-key417
                    (lambda (%%x1864) (vector-ref %%x1864 '1)))
                   (%%top-ribcage-mutable?418
                    (lambda (%%x1863) (vector-ref %%x1863 '2)))
                   (%%set-top-ribcage-key!419
                    (lambda (%%x1862 %%update1861)
                      (vector-set! %%x1862 '1 %%update1861)))
                   (%%set-top-ribcage-mutable?!420
                    (lambda (%%x1860 %%update1859)
                      (vector-set! %%x1860 '2 %%update1859)))
                   (%%make-import-token421
                    (lambda (%%key1858) (vector 'import-token %%key1858)))
                   (%%import-token?422
                    (lambda (%%x1857)
                      (if (vector? %%x1857)
                          (if (= (vector-length %%x1857) '2)
                              (eq? (vector-ref %%x1857 '0) 'import-token)
                              '#f)
                          '#f)))
                   (%%import-token-key423
                    (lambda (%%x1856) (vector-ref %%x1856 '1)))
                   (%%set-import-token-key!424
                    (lambda (%%x1855 %%update1854)
                      (vector-set! %%x1855 '1 %%update1854)))
                   (%%make-env425
                    (lambda (%%top-ribcage1853 %%wrap1852)
                      (vector 'env %%top-ribcage1853 %%wrap1852)))
                   (%%env?426
                    (lambda (%%x1851)
                      (if (vector? %%x1851)
                          (if (= (vector-length %%x1851) '3)
                              (eq? (vector-ref %%x1851 '0) 'env)
                              '#f)
                          '#f)))
                   (%%env-top-ribcage427
                    (lambda (%%x1850) (vector-ref %%x1850 '1)))
                   (%%env-wrap428
                    (lambda (%%x1849) (vector-ref %%x1849 '2)))
                   (%%set-env-top-ribcage!429
                    (lambda (%%x1848 %%update1847)
                      (vector-set! %%x1848 '1 %%update1847)))
                   (%%set-env-wrap!430
                    (lambda (%%x1846 %%update1845)
                      (vector-set! %%x1846 '2 %%update1845)))
                   (%%anti-mark440
                    (lambda (%%w1844)
                      (%%make-wrap358
                        (cons '#f (%%wrap-marks359 %%w1844))
                        (cons 'shift (%%wrap-subst360 %%w1844)))))
                   (%%barrier-marker445 '#f)
                   (%%extend-ribcage!450
                    (lambda (%%ribcage1842 %%id1841 %%label1840)
                      (begin (%%set-ribcage-symnames!412
                               %%ribcage1842
                               (cons ((lambda (%%e1843)
                                        (if (annotation? %%e1843)
                                            (annotation-expression %%e1843)
                                            %%e1843))
                                      (%%syntax-object-expression102
                                        %%id1841))
                                     (%%ribcage-symnames409
                                       %%ribcage1842)))
                             (%%set-ribcage-marks!413
                               %%ribcage1842
                               (cons (%%wrap-marks359
                                       (%%syntax-object-wrap103 %%id1841))
                                     (%%ribcage-marks410 %%ribcage1842)))
                             (%%set-ribcage-labels!414
                               %%ribcage1842
                               (cons %%label1840
                                     (%%ribcage-labels411
                                       %%ribcage1842))))))
                   (%%extend-ribcage-barrier!451
                    (lambda (%%ribcage1839 %%killer-id1838)
                      (%%extend-ribcage-barrier-help!452
                        %%ribcage1839
                        (%%syntax-object-wrap103 %%killer-id1838))))
                   (%%extend-ribcage-barrier-help!452
                    (lambda (%%ribcage1837 %%wrap1836)
                      (begin (%%set-ribcage-symnames!412
                               %%ribcage1837
                               (cons %%barrier-marker445
                                     (%%ribcage-symnames409
                                       %%ribcage1837)))
                             (%%set-ribcage-marks!413
                               %%ribcage1837
                               (cons (%%wrap-marks359 %%wrap1836)
                                     (%%ribcage-marks410
                                       %%ribcage1837))))))
                   (%%extend-ribcage-subst!453
                    (lambda (%%ribcage1835 %%token1834)
                      (%%set-ribcage-symnames!412
                        %%ribcage1835
                        (cons (%%make-import-token421 %%token1834)
                              (%%ribcage-symnames409 %%ribcage1835)))))
                   (%%lookup-import-binding-name454
                    (lambda (%%sym1829 %%token1828 %%marks1827)
                      ((lambda (%%new1830)
                         (if %%new1830
                             ((letrec ((%%f1831
                                        (lambda (%%new1832)
                                          (if (pair? %%new1832)
                                              ((lambda (%%t1833)
                                                 (if %%t1833
                                                     %%t1833
                                                     (%%f1831
                                                       (cdr %%new1832))))
                                               (%%f1831 (car %%new1832)))
                                              (if (symbol? %%new1832)
                                                  (if (%%same-marks?464
                                                        %%marks1827
                                                        (%%wrap-marks359
                                                          '((top))))
                                                      %%new1832
                                                      '#f)
                                                  (if (%%same-marks?464
                                                        %%marks1827
                                                        (%%wrap-marks359
                                                          (%%syntax-object-wrap103
                                                            %%new1832)))
                                                      %%new1832
                                                      '#f))))))
                                %%f1831)
                              %%new1830)
                             '#f))
                       (%%get-import-binding180 %%sym1829 %%token1828))))
                   (%%store-import-binding455
                    (lambda (%%id1813 %%token1812)
                      (letrec ((%%id-marks1814
                                (lambda (%%id1821)
                                  (if (symbol? %%id1821)
                                      (%%wrap-marks359 '((top)))
                                      (%%wrap-marks359
                                        (%%syntax-object-wrap103
                                          %%id1821)))))
                               (%%cons-id1815
                                (lambda (%%id1820 %%x1819)
                                  (if (not %%x1819)
                                      %%id1820
                                      (cons %%id1820 %%x1819))))
                               (%%weed1816
                                (lambda (%%marks1818 %%x1817)
                                  (if (pair? %%x1817)
                                      (if (%%same-marks?464
                                            (%%id-marks1814 (car %%x1817))
                                            %%marks1818)
                                          (%%weed1816
                                            %%marks1818
                                            (cdr %%x1817))
                                          (%%cons-id1815
                                            (car %%x1817)
                                            (%%weed1816
                                              %%marks1818
                                              (cdr %%x1817))))
                                      (if %%x1817
                                          (if (not (%%same-marks?464
                                                     (%%id-marks1814
                                                       %%x1817)
                                                     %%marks1818))
                                              %%x1817
                                              '#f)
                                          '#f)))))
                        ((lambda (%%sym1822)
                           (if (not (eq? %%id1813 %%sym1822))
                               ((lambda (%%marks1823)
                                  ((lambda (%%x1824)
                                     (%%put-import-binding181
                                       %%sym1822
                                       %%token1812
                                       (%%cons-id1815
                                         (if (%%same-marks?464
                                               %%marks1823
                                               (%%wrap-marks359 '((top))))
                                             (%%resolved-id-var-name459
                                               %%id1813)
                                             %%id1813)
                                         %%x1824)))
                                   (%%weed1816
                                     %%marks1823
                                     (%%get-import-binding180
                                       %%sym1822
                                       %%token1812))))
                                (%%id-marks1814 %%id1813))
                               (void)))
                         ((lambda (%%x1825)
                            ((lambda (%%e1826)
                               (if (annotation? %%e1826)
                                   (annotation-expression %%e1826)
                                   %%e1826))
                             (if (%%syntax-object?101 %%x1825)
                                 (%%syntax-object-expression102 %%x1825)
                                 %%x1825)))
                          %%id1813)))))
                   (%%make-binding-wrap456
                    (lambda (%%ids1802 %%labels1801 %%w1800)
                      (if (null? %%ids1802)
                          %%w1800
                          (%%make-wrap358
                            (%%wrap-marks359 %%w1800)
                            (cons ((lambda (%%labelvec1803)
                                     ((lambda (%%n1804)
                                        ((lambda (%%symnamevec1806
                                                  %%marksvec1805)
                                           (begin ((letrec ((%%f1807
                                                             (lambda (%%ids1809
                                                                      %%i1808)
                                                               (if (not (null?
                                                                          %%ids1809))
                                                                   (call-with-values
                                                                     (lambda ()
                                                                       (%%id-sym-name&marks357
                                                                         (car %%ids1809)
                                                                         %%w1800))
                                                                     (lambda (%%symname1811
                                                                              %%marks1810)
                                                                       (begin (vector-set!
                                                                                %%symnamevec1806
                                                                                %%i1808
                                                                                %%symname1811)
                                                                              (vector-set!
                                                                                %%marksvec1805
                                                                                %%i1808
                                                                                %%marks1810)
                                                                              (%%f1807
                                                                                (cdr %%ids1809)
                                                                                (+ %%i1808
                                                                                   '1)))))
                                                                   (void)))))
                                                     %%f1807)
                                                   %%ids1802
                                                   '0)
                                                  (%%make-ribcage407
                                                    %%symnamevec1806
                                                    %%marksvec1805
                                                    %%labelvec1803)))
                                         (make-vector %%n1804)
                                         (make-vector %%n1804)))
                                      (vector-length %%labelvec1803)))
                                   (list->vector %%labels1801))
                                  (%%wrap-subst360 %%w1800))))))
                   (%%make-resolved-id457
                    (lambda (%%fromsym1799 %%marks1798 %%tosym1797)
                      (%%make-syntax-object100
                        %%fromsym1799
                        (%%make-wrap358
                          %%marks1798
                          (list (%%make-ribcage407
                                  (vector %%fromsym1799)
                                  (vector %%marks1798)
                                  (vector %%tosym1797)))))))
                   (%%id->resolved-id458
                    (lambda (%%id1792)
                      (call-with-values
                        (lambda () (%%id-var-name&marks470 %%id1792 '(())))
                        (lambda (%%tosym1794 %%marks1793)
                          (begin (if (not %%tosym1794)
                                     (syntax-error
                                       %%id1792
                                       '"identifier not visible for export")
                                     (void))
                                 (%%make-resolved-id457
                                   ((lambda (%%x1795)
                                      ((lambda (%%e1796)
                                         (if (annotation? %%e1796)
                                             (annotation-expression
                                               %%e1796)
                                             %%e1796))
                                       (if (%%syntax-object?101 %%x1795)
                                           (%%syntax-object-expression102
                                             %%x1795)
                                           %%x1795)))
                                    %%id1792)
                                   %%marks1793
                                   %%tosym1794))))))
                   (%%resolved-id-var-name459
                    (lambda (%%id1791)
                      (vector-ref
                        (%%ribcage-labels411
                          (car (%%wrap-subst360
                                 (%%syntax-object-wrap103 %%id1791))))
                        '0)))
                   (%%smart-append460
                    (lambda (%%m11790 %%m21789)
                      (if (null? %%m21789)
                          %%m11790
                          (append %%m11790 %%m21789))))
                   (%%join-wraps461
                    (lambda (%%w11786 %%w21785)
                      ((lambda (%%m11788 %%s11787)
                         (if (null? %%m11788)
                             (if (null? %%s11787)
                                 %%w21785
                                 (%%make-wrap358
                                   (%%wrap-marks359 %%w21785)
                                   (%%join-subst463
                                     %%s11787
                                     (%%wrap-subst360 %%w21785))))
                             (%%make-wrap358
                               (%%join-marks462
                                 %%m11788
                                 (%%wrap-marks359 %%w21785))
                               (%%join-subst463
                                 %%s11787
                                 (%%wrap-subst360 %%w21785)))))
                       (%%wrap-marks359 %%w11786)
                       (%%wrap-subst360 %%w11786))))
                   (%%join-marks462
                    (lambda (%%m11784 %%m21783)
                      (%%smart-append460 %%m11784 %%m21783)))
                   (%%join-subst463
                    (lambda (%%s11782 %%s21781)
                      (%%smart-append460 %%s11782 %%s21781)))
                   (%%same-marks?464
                    (lambda (%%x1779 %%y1778)
                      ((lambda (%%t1780)
                         (if %%t1780
                             %%t1780
                             (if (not (null? %%x1779))
                                 (if (not (null? %%y1778))
                                     (if (eq? (car %%x1779) (car %%y1778))
                                         (%%same-marks?464
                                           (cdr %%x1779)
                                           (cdr %%y1778))
                                         '#f)
                                     '#f)
                                 '#f)))
                       (eq? %%x1779 %%y1778))))
                   (%%leave-implicit?465
                    (lambda (%%token1777) (eq? %%token1777 '*top*)))
                   (%%new-binding466
                    (lambda (%%sym1774 %%marks1773 %%token1772)
                      ((lambda (%%loc1775)
                         ((lambda (%%id1776)
                            (begin (%%store-import-binding455
                                     %%id1776
                                     %%token1772)
                                   (values %%loc1775 %%id1776)))
                          (%%make-resolved-id457
                            %%sym1774
                            %%marks1773
                            %%loc1775)))
                       (if (if (%%leave-implicit?465 %%token1772)
                               (%%same-marks?464
                                 %%marks1773
                                 (%%wrap-marks359 '((top))))
                               '#f)
                           %%sym1774
                           (%%generate-id182 %%sym1774)))))
                   (%%top-id-bound-var-name467
                    (lambda (%%sym1768 %%marks1767 %%top-ribcage1766)
                      ((lambda (%%token1769)
                         ((lambda (%%t1770)
                            (if %%t1770
                                ((lambda (%%id1771)
                                   (if (symbol? %%id1771)
                                       (if (%%read-only-binding?179
                                             %%id1771)
                                           (%%new-binding466
                                             %%sym1768
                                             %%marks1767
                                             %%token1769)
                                           (values
                                             %%id1771
                                             (%%make-resolved-id457
                                               %%sym1768
                                               %%marks1767
                                               %%id1771)))
                                       (values
                                         (%%resolved-id-var-name459
                                           %%id1771)
                                         %%id1771)))
                                 %%t1770)
                                (%%new-binding466
                                  %%sym1768
                                  %%marks1767
                                  %%token1769)))
                          (%%lookup-import-binding-name454
                            %%sym1768
                            %%token1769
                            %%marks1767)))
                       (%%top-ribcage-key417 %%top-ribcage1766))))
                   (%%top-id-free-var-name468
                    (lambda (%%sym1760 %%marks1759 %%top-ribcage1758)
                      ((lambda (%%token1761)
                         ((lambda (%%t1762)
                            (if %%t1762
                                ((lambda (%%id1765)
                                   (if (symbol? %%id1765)
                                       %%id1765
                                       (%%resolved-id-var-name459
                                         %%id1765)))
                                 %%t1762)
                                (if (if (%%top-ribcage-mutable?418
                                          %%top-ribcage1758)
                                        (%%same-marks?464
                                          %%marks1759
                                          (%%wrap-marks359 '((top))))
                                        '#f)
                                    (call-with-values
                                      (lambda ()
                                        (%%new-binding466
                                          %%sym1760
                                          (%%wrap-marks359 '((top)))
                                          %%token1761))
                                      (lambda (%%sym1764 %%id1763)
                                        %%sym1764))
                                    '#f)))
                          (%%lookup-import-binding-name454
                            %%sym1760
                            %%token1761
                            %%marks1759)))
                       (%%top-ribcage-key417 %%top-ribcage1758))))
                   (%%id-var-name-loc&marks469
                    (lambda (%%id1723 %%w1722)
                      (letrec ((%%search1724
                                (lambda (%%sym1747 %%subst1746 %%marks1745)
                                  (if (null? %%subst1746)
                                      (values '#f %%marks1745)
                                      ((lambda (%%fst1748)
                                         (if (eq? %%fst1748 'shift)
                                             (%%search1724
                                               %%sym1747
                                               (cdr %%subst1746)
                                               (cdr %%marks1745))
                                             (if (%%ribcage?408 %%fst1748)
                                                 ((lambda (%%symnames1751)
                                                    (if (vector?
                                                          %%symnames1751)
                                                        (%%search-vector-rib1726
                                                          %%sym1747
                                                          %%subst1746
                                                          %%marks1745
                                                          %%symnames1751
                                                          %%fst1748)
                                                        (%%search-list-rib1725
                                                          %%sym1747
                                                          %%subst1746
                                                          %%marks1745
                                                          %%symnames1751
                                                          %%fst1748)))
                                                  (%%ribcage-symnames409
                                                    %%fst1748))
                                                 (if (%%top-ribcage?416
                                                       %%fst1748)
                                                     ((lambda (%%t1749)
                                                        (if %%t1749
                                                            ((lambda (%%var-name1750)
                                                               (values
                                                                 %%var-name1750
                                                                 %%marks1745))
                                                             %%t1749)
                                                            (%%search1724
                                                              %%sym1747
                                                              (cdr %%subst1746)
                                                              %%marks1745)))
                                                      (%%top-id-free-var-name468
                                                        %%sym1747
                                                        %%marks1745
                                                        %%fst1748))
                                                     (error '"internal error in id-var-name-loc&marks: improper subst"
                                                       %%subst1746)))))
                                       (car %%subst1746)))))
                               (%%search-list-rib1725
                                (lambda (%%sym1739
                                         %%subst1738
                                         %%marks1737
                                         %%symnames1736
                                         %%ribcage1735)
                                  ((letrec ((%%f1740
                                             (lambda (%%symnames1742
                                                      %%i1741)
                                               (if (null? %%symnames1742)
                                                   (%%search1724
                                                     %%sym1739
                                                     (cdr %%subst1738)
                                                     %%marks1737)
                                                   (if (if (eq? (car %%symnames1742)
                                                                %%sym1739)
                                                           (%%same-marks?464
                                                             %%marks1737
                                                             (list-ref
                                                               (%%ribcage-marks410
                                                                 %%ribcage1735)
                                                               %%i1741))
                                                           '#f)
                                                       (values
                                                         (list-ref
                                                           (%%ribcage-labels411
                                                             %%ribcage1735)
                                                           %%i1741)
                                                         %%marks1737)
                                                       (if (%%import-token?422
                                                             (car %%symnames1742))
                                                           ((lambda (%%t1743)
                                                              (if %%t1743
                                                                  ((lambda (%%id1744)
                                                                     (values
                                                                       (if (symbol?
                                                                             %%id1744)
                                                                           %%id1744
                                                                           (%%resolved-id-var-name459
                                                                             %%id1744))
                                                                       %%marks1737))
                                                                   %%t1743)
                                                                  (%%f1740
                                                                    (cdr %%symnames1742)
                                                                    %%i1741)))
                                                            (%%lookup-import-binding-name454
                                                              %%sym1739
                                                              (%%import-token-key423
                                                                (car %%symnames1742))
                                                              %%marks1737))
                                                           (if (if (eq? (car %%symnames1742)
                                                                        %%barrier-marker445)
                                                                   (%%same-marks?464
                                                                     %%marks1737
                                                                     (list-ref
                                                                       (%%ribcage-marks410
                                                                         %%ribcage1735)
                                                                       %%i1741))
                                                                   '#f)
                                                               (values
                                                                 '#f
                                                                 %%marks1737)
                                                               (%%f1740
                                                                 (cdr %%symnames1742)
                                                                 (+ %%i1741
                                                                    '1)))))))))
                                     %%f1740)
                                   %%symnames1736
                                   '0)))
                               (%%search-vector-rib1726
                                (lambda (%%sym1731
                                         %%subst1730
                                         %%marks1729
                                         %%symnames1728
                                         %%ribcage1727)
                                  ((lambda (%%n1732)
                                     ((letrec ((%%f1733
                                                (lambda (%%i1734)
                                                  (if (= %%i1734 %%n1732)
                                                      (%%search1724
                                                        %%sym1731
                                                        (cdr %%subst1730)
                                                        %%marks1729)
                                                      (if (if (eq? (vector-ref
                                                                     %%symnames1728
                                                                     %%i1734)
                                                                   %%sym1731)
                                                              (%%same-marks?464
                                                                %%marks1729
                                                                (vector-ref
                                                                  (%%ribcage-marks410
                                                                    %%ribcage1727)
                                                                  %%i1734))
                                                              '#f)
                                                          (values
                                                            (vector-ref
                                                              (%%ribcage-labels411
                                                                %%ribcage1727)
                                                              %%i1734)
                                                            %%marks1729)
                                                          (%%f1733
                                                            (+ %%i1734
                                                               '1)))))))
                                        %%f1733)
                                      '0))
                                   (vector-length %%symnames1728)))))
                        (if (symbol? %%id1723)
                            (%%search1724
                              %%id1723
                              (%%wrap-subst360 %%w1722)
                              (%%wrap-marks359 %%w1722))
                            (if (%%syntax-object?101 %%id1723)
                                ((lambda (%%sym1754 %%w11753)
                                   (call-with-values
                                     (lambda ()
                                       (%%search1724
                                         %%sym1754
                                         (%%wrap-subst360 %%w1722)
                                         (%%join-marks462
                                           (%%wrap-marks359 %%w1722)
                                           (%%wrap-marks359 %%w11753))))
                                     (lambda (%%name1756 %%marks1755)
                                       (if %%name1756
                                           (values %%name1756 %%marks1755)
                                           (%%search1724
                                             %%sym1754
                                             (%%wrap-subst360 %%w11753)
                                             %%marks1755)))))
                                 ((lambda (%%e1757)
                                    (if (annotation? %%e1757)
                                        (annotation-expression %%e1757)
                                        %%e1757))
                                  (%%syntax-object-expression102 %%id1723))
                                 (%%syntax-object-wrap103 %%id1723))
                                (if (annotation? %%id1723)
                                    (%%search1724
                                      ((lambda (%%e1752)
                                         (if (annotation? %%e1752)
                                             (annotation-expression
                                               %%e1752)
                                             %%e1752))
                                       %%id1723)
                                      (%%wrap-subst360 %%w1722)
                                      (%%wrap-marks359 %%w1722))
                                    (error '"(in id-var-name) invalid id"
                                      %%id1723)))))))
                   (%%id-var-name&marks470
                    (lambda (%%id1719 %%w1718)
                      (call-with-values
                        (lambda ()
                          (%%id-var-name-loc&marks469 %%id1719 %%w1718))
                        (lambda (%%label1721 %%marks1720)
                          (values
                            (if (%%indirect-label?398 %%label1721)
                                (%%get-indirect-label402 %%label1721)
                                %%label1721)
                            %%marks1720)))))
                   (%%id-var-name-loc471
                    (lambda (%%id1715 %%w1714)
                      (call-with-values
                        (lambda ()
                          (%%id-var-name-loc&marks469 %%id1715 %%w1714))
                        (lambda (%%label1717 %%marks1716) %%label1717))))
                   (%%id-var-name472
                    (lambda (%%id1711 %%w1710)
                      (call-with-values
                        (lambda ()
                          (%%id-var-name-loc&marks469 %%id1711 %%w1710))
                        (lambda (%%label1713 %%marks1712)
                          (if (%%indirect-label?398 %%label1713)
                              (%%get-indirect-label402 %%label1713)
                              %%label1713)))))
                   (%%free-id=?473
                    (lambda (%%i1705 %%j1704)
                      (if (eq? ((lambda (%%x1708)
                                  ((lambda (%%e1709)
                                     (if (annotation? %%e1709)
                                         (annotation-expression %%e1709)
                                         %%e1709))
                                   (if (%%syntax-object?101 %%x1708)
                                       (%%syntax-object-expression102
                                         %%x1708)
                                       %%x1708)))
                                %%i1705)
                               ((lambda (%%x1706)
                                  ((lambda (%%e1707)
                                     (if (annotation? %%e1707)
                                         (annotation-expression %%e1707)
                                         %%e1707))
                                   (if (%%syntax-object?101 %%x1706)
                                       (%%syntax-object-expression102
                                         %%x1706)
                                       %%x1706)))
                                %%j1704))
                          (eq? (%%id-var-name472 %%i1705 '(()))
                               (%%id-var-name472 %%j1704 '(())))
                          '#f)))
                   (%%literal-id=?474
                    (lambda (%%id1694 %%literal1693)
                      (if (eq? ((lambda (%%x1702)
                                  ((lambda (%%e1703)
                                     (if (annotation? %%e1703)
                                         (annotation-expression %%e1703)
                                         %%e1703))
                                   (if (%%syntax-object?101 %%x1702)
                                       (%%syntax-object-expression102
                                         %%x1702)
                                       %%x1702)))
                                %%id1694)
                               ((lambda (%%x1700)
                                  ((lambda (%%e1701)
                                     (if (annotation? %%e1701)
                                         (annotation-expression %%e1701)
                                         %%e1701))
                                   (if (%%syntax-object?101 %%x1700)
                                       (%%syntax-object-expression102
                                         %%x1700)
                                       %%x1700)))
                                %%literal1693))
                          ((lambda (%%n-id1696 %%n-literal1695)
                             ((lambda (%%t1697)
                                (if %%t1697
                                    %%t1697
                                    (if ((lambda (%%t1699)
                                           (if %%t1699
                                               %%t1699
                                               (symbol? %%n-id1696)))
                                         (not %%n-id1696))
                                        ((lambda (%%t1698)
                                           (if %%t1698
                                               %%t1698
                                               (symbol? %%n-literal1695)))
                                         (not %%n-literal1695))
                                        '#f)))
                              (eq? %%n-id1696 %%n-literal1695)))
                           (%%id-var-name472 %%id1694 '(()))
                           (%%id-var-name472 %%literal1693 '(())))
                          '#f)))
                   (%%bound-id=?475
                    (lambda (%%i1688 %%j1687)
                      (if (if (%%syntax-object?101 %%i1688)
                              (%%syntax-object?101 %%j1687)
                              '#f)
                          (if (eq? ((lambda (%%e1692)
                                      (if (annotation? %%e1692)
                                          (annotation-expression %%e1692)
                                          %%e1692))
                                    (%%syntax-object-expression102
                                      %%i1688))
                                   ((lambda (%%e1691)
                                      (if (annotation? %%e1691)
                                          (annotation-expression %%e1691)
                                          %%e1691))
                                    (%%syntax-object-expression102
                                      %%j1687)))
                              (%%same-marks?464
                                (%%wrap-marks359
                                  (%%syntax-object-wrap103 %%i1688))
                                (%%wrap-marks359
                                  (%%syntax-object-wrap103 %%j1687)))
                              '#f)
                          (eq? ((lambda (%%e1690)
                                  (if (annotation? %%e1690)
                                      (annotation-expression %%e1690)
                                      %%e1690))
                                %%i1688)
                               ((lambda (%%e1689)
                                  (if (annotation? %%e1689)
                                      (annotation-expression %%e1689)
                                      %%e1689))
                                %%j1687)))))
                   (%%valid-bound-ids?476
                    (lambda (%%ids1683)
                      (if ((letrec ((%%all-ids?1684
                                     (lambda (%%ids1685)
                                       ((lambda (%%t1686)
                                          (if %%t1686
                                              %%t1686
                                              (if (%%id?346
                                                    (car %%ids1685))
                                                  (%%all-ids?1684
                                                    (cdr %%ids1685))
                                                  '#f)))
                                        (null? %%ids1685)))))
                             %%all-ids?1684)
                           %%ids1683)
                          (%%distinct-bound-ids?477 %%ids1683)
                          '#f)))
                   (%%distinct-bound-ids?477
                    (lambda (%%ids1679)
                      ((letrec ((%%distinct?1680
                                 (lambda (%%ids1681)
                                   ((lambda (%%t1682)
                                      (if %%t1682
                                          %%t1682
                                          (if (not (%%bound-id-member?479
                                                     (car %%ids1681)
                                                     (cdr %%ids1681)))
                                              (%%distinct?1680
                                                (cdr %%ids1681))
                                              '#f)))
                                    (null? %%ids1681)))))
                         %%distinct?1680)
                       %%ids1679)))
                   (%%invalid-ids-error478
                    (lambda (%%ids1675 %%exp1674 %%class1673)
                      ((letrec ((%%find1676
                                 (lambda (%%ids1678 %%gooduns1677)
                                   (if (null? %%ids1678)
                                       (syntax-error %%exp1674)
                                       (if (%%id?346 (car %%ids1678))
                                           (if (%%bound-id-member?479
                                                 (car %%ids1678)
                                                 %%gooduns1677)
                                               (syntax-error
                                                 (car %%ids1678)
                                                 '"duplicate "
                                                 %%class1673)
                                               (%%find1676
                                                 (cdr %%ids1678)
                                                 (cons (car %%ids1678)
                                                       %%gooduns1677)))
                                           (syntax-error
                                             (car %%ids1678)
                                             '"invalid "
                                             %%class1673))))))
                         %%find1676)
                       %%ids1675
                       '())))
                   (%%bound-id-member?479
                    (lambda (%%x1671 %%list1670)
                      (if (not (null? %%list1670))
                          ((lambda (%%t1672)
                             (if %%t1672
                                 %%t1672
                                 (%%bound-id-member?479
                                   %%x1671
                                   (cdr %%list1670))))
                           (%%bound-id=?475 %%x1671 (car %%list1670)))
                          '#f)))
                   (%%wrap480
                    (lambda (%%x1669 %%w1668)
                      (if (if (null? (%%wrap-marks359 %%w1668))
                              (null? (%%wrap-subst360 %%w1668))
                              '#f)
                          %%x1669
                          (if (%%syntax-object?101 %%x1669)
                              (%%make-syntax-object100
                                (%%syntax-object-expression102 %%x1669)
                                (%%join-wraps461
                                  %%w1668
                                  (%%syntax-object-wrap103 %%x1669)))
                              (if (null? %%x1669)
                                  %%x1669
                                  (%%make-syntax-object100
                                    %%x1669
                                    %%w1668))))))
                   (%%source-wrap481
                    (lambda (%%x1667 %%w1666 %%ae1665)
                      (%%wrap480
                        (if (annotation? %%ae1665)
                            (begin (if (not (eq? (annotation-expression
                                                   %%ae1665)
                                                 %%x1667))
                                       (error '"internal error in source-wrap: ae/x mismatch")
                                       (void))
                                   %%ae1665)
                            %%x1667)
                        %%w1666)))
                   (%%chi-when-list482
                    (lambda (%%when-list1663 %%w1662)
                      (map (lambda (%%x1664)
                             (if (%%literal-id=?474
                                   %%x1664
                                   '#(syntax-object
                                      compile
                                      ((top)
                                       #(ribcage () () ())
                                       #(ribcage #(x) #((top)) #("i"))
                                       #(ribcage () () ())
                                       #(ribcage
                                         #(when-list w)
                                         #((top) (top))
                                         #("i" "i"))
                                       #(ribcage
                                         (lambda-var-list
                                           gen-var
                                           strip
                                           strip*
                                           strip-annotation
                                           ellipsis?
                                           chi-void
                                           chi-local-syntax
                                           chi-lambda-clause
                                           parse-begin
                                           parse-alias
                                           parse-eval-when
                                           parse-meta
                                           parse-define-syntax
                                           parse-define
                                           parse-import
                                           parse-module
                                           do-import!
                                           chi-internal
                                           chi-body
                                           chi-macro
                                           chi-set!
                                           chi-application
                                           chi-expr
                                           chi
                                           chi-sequence
                                           chi-meta-frob
                                           chi-frobs
                                           ct-eval/residualize3
                                           ct-eval/residualize2
                                           rt-eval/residualize
                                           initial-mode-set
                                           update-mode-set
                                           do-top-import
                                           vfor-each
                                           vmap
                                           chi-external
                                           check-defined-ids
                                           check-module-exports
                                           id-set-diff
                                           chi-top-module
                                           set-frob-meta?!
                                           set-frob-e!
                                           frob-meta?
                                           frob-e
                                           frob?
                                           make-frob
                                           create-module-binding
                                           set-module-binding-exported!
                                           set-module-binding-val!
                                           set-module-binding-imps!
                                           set-module-binding-label!
                                           set-module-binding-id!
                                           set-module-binding-type!
                                           module-binding-exported
                                           module-binding-val
                                           module-binding-imps
                                           module-binding-label
                                           module-binding-id
                                           module-binding-type
                                           module-binding?
                                           make-module-binding
                                           make-resolved-interface2
                                           make-resolved-interface1
                                           make-unresolved-interface
                                           set-interface-token!
                                           set-interface-exports!
                                           interface-token
                                           interface-exports
                                           interface?
                                           make-interface
                                           flatten-exports
                                           chi-top
                                           chi-top-sequence
                                           chi-top*
                                           syntax-type
                                           chi-when-list
                                           source-wrap
                                           wrap
                                           bound-id-member?
                                           invalid-ids-error
                                           distinct-bound-ids?
                                           valid-bound-ids?
                                           bound-id=?
                                           literal-id=?
                                           free-id=?
                                           id-var-name
                                           id-var-name-loc
                                           id-var-name&marks
                                           id-var-name-loc&marks
                                           top-id-free-var-name
                                           top-id-bound-var-name
                                           anon
                                           same-marks?
                                           join-subst
                                           join-marks
                                           join-wraps
                                           smart-append
                                           resolved-id-var-name
                                           id->resolved-id
                                           make-resolved-id
                                           make-binding-wrap
                                           store-import-binding
                                           lookup-import-binding-name
                                           extend-ribcage-subst!
                                           extend-ribcage-barrier-help!
                                           extend-ribcage-barrier!
                                           extend-ribcage!
                                           make-empty-ribcage
                                           barrier-marker
                                           new-mark
                                           anti-mark
                                           the-anti-mark
                                           set-env-wrap!
                                           set-env-top-ribcage!
                                           env-wrap
                                           env-top-ribcage
                                           env?
                                           make-env
                                           set-import-token-key!
                                           import-token-key
                                           import-token?
                                           make-import-token
                                           set-top-ribcage-mutable?!
                                           set-top-ribcage-key!
                                           top-ribcage-mutable?
                                           top-ribcage-key
                                           top-ribcage?
                                           make-top-ribcage
                                           set-ribcage-labels!
                                           set-ribcage-marks!
                                           set-ribcage-symnames!
                                           ribcage-labels
                                           ribcage-marks
                                           ribcage-symnames
                                           ribcage?
                                           make-ribcage
                                           gen-labels
                                           label?
                                           gen-label
                                           set-indirect-label!
                                           get-indirect-label
                                           indirect-label?
                                           gen-indirect-label
                                           anon
                                           only-top-marked?
                                           top-marked?
                                           top-wrap
                                           empty-wrap
                                           wrap-subst
                                           wrap-marks
                                           make-wrap
                                           id-sym-name&marks
                                           id-sym-name
                                           id?
                                           nonsymbol-id?
                                           global-extend
                                           defer-or-eval-transformer
                                           make-transformer-binding
                                           lookup
                                           lookup*
                                           displaced-lexical-error
                                           displaced-lexical?
                                           extend-var-env*
                                           extend-env*
                                           extend-env
                                           null-env
                                           binding?
                                           set-binding-value!
                                           set-binding-type!
                                           binding-value
                                           binding-type
                                           make-binding
                                           sanitize-binding
                                           arg-check
                                           no-source
                                           unannotate
                                           self-evaluating?
                                           lexical-var?
                                           build-lexical-var
                                           build-top-module
                                           build-body
                                           build-letrec
                                           build-sequence
                                           build-data
                                           build-primref
                                           built-lambda?
                                           build-params
                                           build-lambda
                                           build-revisit-only
                                           build-visit-only
                                           build-cte-install
                                           build-global-definition
                                           build-global-assignment
                                           build-global-reference
                                           build-lexical-assignment
                                           build-lexical-reference
                                           build-conditional
                                           build-application
                                           generate-id
                                           put-import-binding
                                           get-import-binding
                                           read-only-binding?
                                           put-global-definition-hook
                                           get-global-definition-hook
                                           put-cte-hook
                                           gensym-hook
                                           define-top-level-value-hook
                                           local-eval-hook
                                           top-level-eval-hook
                                           fx>=
                                           fx<=
                                           fx>
                                           fx<
                                           fx=
                                           fx-
                                           fx+
                                           set-syntax-object-wrap!
                                           set-syntax-object-expression!
                                           syntax-object-wrap
                                           syntax-object-expression
                                           syntax-object?
                                           make-syntax-object
                                           noexpand
                                           let-values
                                           define-structure
                                           unless
                                           when)
                                         ((top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          ("m" top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          ("m" top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top)
                                          (top))
                                         ("i" "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"
                                              "i"))
                                       #(top-ribcage *top* #t))))
                                 'compile
                                 (if (%%literal-id=?474
                                       %%x1664
                                       '#(syntax-object
                                          load
                                          ((top)
                                           #(ribcage () () ())
                                           #(ribcage #(x) #((top)) #("i"))
                                           #(ribcage () () ())
                                           #(ribcage
                                             #(when-list w)
                                             #((top) (top))
                                             #("i" "i"))
                                           #(ribcage
                                             (lambda-var-list
                                               gen-var
                                               strip
                                               strip*
                                               strip-annotation
                                               ellipsis?
                                               chi-void
                                               chi-local-syntax
                                               chi-lambda-clause
                                               parse-begin
                                               parse-alias
                                               parse-eval-when
                                               parse-meta
                                               parse-define-syntax
                                               parse-define
                                               parse-import
                                               parse-module
                                               do-import!
                                               chi-internal
                                               chi-body
                                               chi-macro
                                               chi-set!
                                               chi-application
                                               chi-expr
                                               chi
                                               chi-sequence
                                               chi-meta-frob
                                               chi-frobs
                                               ct-eval/residualize3
                                               ct-eval/residualize2
                                               rt-eval/residualize
                                               initial-mode-set
                                               update-mode-set
                                               do-top-import
                                               vfor-each
                                               vmap
                                               chi-external
                                               check-defined-ids
                                               check-module-exports
                                               id-set-diff
                                               chi-top-module
                                               set-frob-meta?!
                                               set-frob-e!
                                               frob-meta?
                                               frob-e
                                               frob?
                                               make-frob
                                               create-module-binding
                                               set-module-binding-exported!
                                               set-module-binding-val!
                                               set-module-binding-imps!
                                               set-module-binding-label!
                                               set-module-binding-id!
                                               set-module-binding-type!
                                               module-binding-exported
                                               module-binding-val
                                               module-binding-imps
                                               module-binding-label
                                               module-binding-id
                                               module-binding-type
                                               module-binding?
                                               make-module-binding
                                               make-resolved-interface2
                                               make-resolved-interface1
                                               make-unresolved-interface
                                               set-interface-token!
                                               set-interface-exports!
                                               interface-token
                                               interface-exports
                                               interface?
                                               make-interface
                                               flatten-exports
                                               chi-top
                                               chi-top-sequence
                                               chi-top*
                                               syntax-type
                                               chi-when-list
                                               source-wrap
                                               wrap
                                               bound-id-member?
                                               invalid-ids-error
                                               distinct-bound-ids?
                                               valid-bound-ids?
                                               bound-id=?
                                               literal-id=?
                                               free-id=?
                                               id-var-name
                                               id-var-name-loc
                                               id-var-name&marks
                                               id-var-name-loc&marks
                                               top-id-free-var-name
                                               top-id-bound-var-name
                                               anon
                                               same-marks?
                                               join-subst
                                               join-marks
                                               join-wraps
                                               smart-append
                                               resolved-id-var-name
                                               id->resolved-id
                                               make-resolved-id
                                               make-binding-wrap
                                               store-import-binding
                                               lookup-import-binding-name
                                               extend-ribcage-subst!
                                               extend-ribcage-barrier-help!
                                               extend-ribcage-barrier!
                                               extend-ribcage!
                                               make-empty-ribcage
                                               barrier-marker
                                               new-mark
                                               anti-mark
                                               the-anti-mark
                                               set-env-wrap!
                                               set-env-top-ribcage!
                                               env-wrap
                                               env-top-ribcage
                                               env?
                                               make-env
                                               set-import-token-key!
                                               import-token-key
                                               import-token?
                                               make-import-token
                                               set-top-ribcage-mutable?!
                                               set-top-ribcage-key!
                                               top-ribcage-mutable?
                                               top-ribcage-key
                                               top-ribcage?
                                               make-top-ribcage
                                               set-ribcage-labels!
                                               set-ribcage-marks!
                                               set-ribcage-symnames!
                                               ribcage-labels
                                               ribcage-marks
                                               ribcage-symnames
                                               ribcage?
                                               make-ribcage
                                               gen-labels
                                               label?
                                               gen-label
                                               set-indirect-label!
                                               get-indirect-label
                                               indirect-label?
                                               gen-indirect-label
                                               anon
                                               only-top-marked?
                                               top-marked?
                                               top-wrap
                                               empty-wrap
                                               wrap-subst
                                               wrap-marks
                                               make-wrap
                                               id-sym-name&marks
                                               id-sym-name
                                               id?
                                               nonsymbol-id?
                                               global-extend
                                               defer-or-eval-transformer
                                               make-transformer-binding
                                               lookup
                                               lookup*
                                               displaced-lexical-error
                                               displaced-lexical?
                                               extend-var-env*
                                               extend-env*
                                               extend-env
                                               null-env
                                               binding?
                                               set-binding-value!
                                               set-binding-type!
                                               binding-value
                                               binding-type
                                               make-binding
                                               sanitize-binding
                                               arg-check
                                               no-source
                                               unannotate
                                               self-evaluating?
                                               lexical-var?
                                               build-lexical-var
                                               build-top-module
                                               build-body
                                               build-letrec
                                               build-sequence
                                               build-data
                                               build-primref
                                               built-lambda?
                                               build-params
                                               build-lambda
                                               build-revisit-only
                                               build-visit-only
                                               build-cte-install
                                               build-global-definition
                                               build-global-assignment
                                               build-global-reference
                                               build-lexical-assignment
                                               build-lexical-reference
                                               build-conditional
                                               build-application
                                               generate-id
                                               put-import-binding
                                               get-import-binding
                                               read-only-binding?
                                               put-global-definition-hook
                                               get-global-definition-hook
                                               put-cte-hook
                                               gensym-hook
                                               define-top-level-value-hook
                                               local-eval-hook
                                               top-level-eval-hook
                                               fx>=
                                               fx<=
                                               fx>
                                               fx<
                                               fx=
                                               fx-
                                               fx+
                                               set-syntax-object-wrap!
                                               set-syntax-object-expression!
                                               syntax-object-wrap
                                               syntax-object-expression
                                               syntax-object?
                                               make-syntax-object
                                               noexpand
                                               let-values
                                               define-structure
                                               unless
                                               when)
                                             ((top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              ("m" top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              ("m" top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top)
                                              (top))
                                             ("i" "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"
                                                  "i"))
                                           #(top-ribcage *top* #t))))
                                     'load
                                     (if (%%literal-id=?474
                                           %%x1664
                                           '#(syntax-object
                                              visit
                                              ((top)
                                               #(ribcage () () ())
                                               #(ribcage
                                                 #(x)
                                                 #((top))
                                                 #("i"))
                                               #(ribcage () () ())
                                               #(ribcage
                                                 #(when-list w)
                                                 #((top) (top))
                                                 #("i" "i"))
                                               #(ribcage
                                                 (lambda-var-list
                                                   gen-var
                                                   strip
                                                   strip*
                                                   strip-annotation
                                                   ellipsis?
                                                   chi-void
                                                   chi-local-syntax
                                                   chi-lambda-clause
                                                   parse-begin
                                                   parse-alias
                                                   parse-eval-when
                                                   parse-meta
                                                   parse-define-syntax
                                                   parse-define
                                                   parse-import
                                                   parse-module
                                                   do-import!
                                                   chi-internal
                                                   chi-body
                                                   chi-macro
                                                   chi-set!
                                                   chi-application
                                                   chi-expr
                                                   chi
                                                   chi-sequence
                                                   chi-meta-frob
                                                   chi-frobs
                                                   ct-eval/residualize3
                                                   ct-eval/residualize2
                                                   rt-eval/residualize
                                                   initial-mode-set
                                                   update-mode-set
                                                   do-top-import
                                                   vfor-each
                                                   vmap
                                                   chi-external
                                                   check-defined-ids
                                                   check-module-exports
                                                   id-set-diff
                                                   chi-top-module
                                                   set-frob-meta?!
                                                   set-frob-e!
                                                   frob-meta?
                                                   frob-e
                                                   frob?
                                                   make-frob
                                                   create-module-binding
                                                   set-module-binding-exported!
                                                   set-module-binding-val!
                                                   set-module-binding-imps!
                                                   set-module-binding-label!
                                                   set-module-binding-id!
                                                   set-module-binding-type!
                                                   module-binding-exported
                                                   module-binding-val
                                                   module-binding-imps
                                                   module-binding-label
                                                   module-binding-id
                                                   module-binding-type
                                                   module-binding?
                                                   make-module-binding
                                                   make-resolved-interface2
                                                   make-resolved-interface1
                                                   make-unresolved-interface
                                                   set-interface-token!
                                                   set-interface-exports!
                                                   interface-token
                                                   interface-exports
                                                   interface?
                                                   make-interface
                                                   flatten-exports
                                                   chi-top
                                                   chi-top-sequence
                                                   chi-top*
                                                   syntax-type
                                                   chi-when-list
                                                   source-wrap
                                                   wrap
                                                   bound-id-member?
                                                   invalid-ids-error
                                                   distinct-bound-ids?
                                                   valid-bound-ids?
                                                   bound-id=?
                                                   literal-id=?
                                                   free-id=?
                                                   id-var-name
                                                   id-var-name-loc
                                                   id-var-name&marks
                                                   id-var-name-loc&marks
                                                   top-id-free-var-name
                                                   top-id-bound-var-name
                                                   anon
                                                   same-marks?
                                                   join-subst
                                                   join-marks
                                                   join-wraps
                                                   smart-append
                                                   resolved-id-var-name
                                                   id->resolved-id
                                                   make-resolved-id
                                                   make-binding-wrap
                                                   store-import-binding
                                                   lookup-import-binding-name
                                                   extend-ribcage-subst!
                                                   extend-ribcage-barrier-help!
                                                   extend-ribcage-barrier!
                                                   extend-ribcage!
                                                   make-empty-ribcage
                                                   barrier-marker
                                                   new-mark
                                                   anti-mark
                                                   the-anti-mark
                                                   set-env-wrap!
                                                   set-env-top-ribcage!
                                                   env-wrap
                                                   env-top-ribcage
                                                   env?
                                                   make-env
                                                   set-import-token-key!
                                                   import-token-key
                                                   import-token?
                                                   make-import-token
                                                   set-top-ribcage-mutable?!
                                                   set-top-ribcage-key!
                                                   top-ribcage-mutable?
                                                   top-ribcage-key
                                                   top-ribcage?
                                                   make-top-ribcage
                                                   set-ribcage-labels!
                                                   set-ribcage-marks!
                                                   set-ribcage-symnames!
                                                   ribcage-labels
                                                   ribcage-marks
                                                   ribcage-symnames
                                                   ribcage?
                                                   make-ribcage
                                                   gen-labels
                                                   label?
                                                   gen-label
                                                   set-indirect-label!
                                                   get-indirect-label
                                                   indirect-label?
                                                   gen-indirect-label
                                                   anon
                                                   only-top-marked?
                                                   top-marked?
                                                   top-wrap
                                                   empty-wrap
                                                   wrap-subst
                                                   wrap-marks
                                                   make-wrap
                                                   id-sym-name&marks
                                                   id-sym-name
                                                   id?
                                                   nonsymbol-id?
                                                   global-extend
                                                   defer-or-eval-transformer
                                                   make-transformer-binding
                                                   lookup
                                                   lookup*
                                                   displaced-lexical-error
                                                   displaced-lexical?
                                                   extend-var-env*
                                                   extend-env*
                                                   extend-env
                                                   null-env
                                                   binding?
                                                   set-binding-value!
                                                   set-binding-type!
                                                   binding-value
                                                   binding-type
                                                   make-binding
                                                   sanitize-binding
                                                   arg-check
                                                   no-source
                                                   unannotate
                                                   self-evaluating?
                                                   lexical-var?
                                                   build-lexical-var
                                                   build-top-module
                                                   build-body
                                                   build-letrec
                                                   build-sequence
                                                   build-data
                                                   build-primref
                                                   built-lambda?
                                                   build-params
                                                   build-lambda
                                                   build-revisit-only
                                                   build-visit-only
                                                   build-cte-install
                                                   build-global-definition
                                                   build-global-assignment
                                                   build-global-reference
                                                   build-lexical-assignment
                                                   build-lexical-reference
                                                   build-conditional
                                                   build-application
                                                   generate-id
                                                   put-import-binding
                                                   get-import-binding
                                                   read-only-binding?
                                                   put-global-definition-hook
                                                   get-global-definition-hook
                                                   put-cte-hook
                                                   gensym-hook
                                                   define-top-level-value-hook
                                                   local-eval-hook
                                                   top-level-eval-hook
                                                   fx>=
                                                   fx<=
                                                   fx>
                                                   fx<
                                                   fx=
                                                   fx-
                                                   fx+
                                                   set-syntax-object-wrap!
                                                   set-syntax-object-expression!
                                                   syntax-object-wrap
                                                   syntax-object-expression
                                                   syntax-object?
                                                   make-syntax-object
                                                   noexpand
                                                   let-values
                                                   define-structure
                                                   unless
                                                   when)
                                                 ((top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  ("m" top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  ("m" top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top)
                                                  (top))
                                                 ("i" "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"
                                                      "i"))
                                               #(top-ribcage *top* #t))))
                                         'visit
                                         (if (%%literal-id=?474
                                               %%x1664
                                               '#(syntax-object
                                                  revisit
                                                  ((top)
                                                   #(ribcage () () ())
                                                   #(ribcage
                                                     #(x)
                                                     #((top))
                                                     #("i"))
                                                   #(ribcage () () ())
                                                   #(ribcage
                                                     #(when-list w)
                                                     #((top) (top))
                                                     #("i" "i"))
                                                   #(ribcage
                                                     (lambda-var-list
                                                       gen-var
                                                       strip
                                                       strip*
                                                       strip-annotation
                                                       ellipsis?
                                                       chi-void
                                                       chi-local-syntax
                                                       chi-lambda-clause
                                                       parse-begin
                                                       parse-alias
                                                       parse-eval-when
                                                       parse-meta
                                                       parse-define-syntax
                                                       parse-define
                                                       parse-import
                                                       parse-module
                                                       do-import!
                                                       chi-internal
                                                       chi-body
                                                       chi-macro
                                                       chi-set!
                                                       chi-application
                                                       chi-expr
                                                       chi
                                                       chi-sequence
                                                       chi-meta-frob
                                                       chi-frobs
                                                       ct-eval/residualize3
                                                       ct-eval/residualize2
                                                       rt-eval/residualize
                                                       initial-mode-set
                                                       update-mode-set
                                                       do-top-import
                                                       vfor-each
                                                       vmap
                                                       chi-external
                                                       check-defined-ids
                                                       check-module-exports
                                                       id-set-diff
                                                       chi-top-module
                                                       set-frob-meta?!
                                                       set-frob-e!
                                                       frob-meta?
                                                       frob-e
                                                       frob?
                                                       make-frob
                                                       create-module-binding
                                                       set-module-binding-exported!
                                                       set-module-binding-val!
                                                       set-module-binding-imps!
                                                       set-module-binding-label!
                                                       set-module-binding-id!
                                                       set-module-binding-type!
                                                       module-binding-exported
                                                       module-binding-val
                                                       module-binding-imps
                                                       module-binding-label
                                                       module-binding-id
                                                       module-binding-type
                                                       module-binding?
                                                       make-module-binding
                                                       make-resolved-interface2
                                                       make-resolved-interface1
                                                       make-unresolved-interface
                                                       set-interface-token!
                                                       set-interface-exports!
                                                       interface-token
                                                       interface-exports
                                                       interface?
                                                       make-interface
                                                       flatten-exports
                                                       chi-top
                                                       chi-top-sequence
                                                       chi-top*
                                                       syntax-type
                                                       chi-when-list
                                                       source-wrap
                                                       wrap
                                                       bound-id-member?
                                                       invalid-ids-error
                                                       distinct-bound-ids?
                                                       valid-bound-ids?
                                                       bound-id=?
                                                       literal-id=?
                                                       free-id=?
                                                       id-var-name
                                                       id-var-name-loc
                                                       id-var-name&marks
                                                       id-var-name-loc&marks
                                                       top-id-free-var-name
                                                       top-id-bound-var-name
                                                       anon
                                                       same-marks?
                                                       join-subst
                                                       join-marks
                                                       join-wraps
                                                       smart-append
                                                       resolved-id-var-name
                                                       id->resolved-id
                                                       make-resolved-id
                                                       make-binding-wrap
                                                       store-import-binding
                                                       lookup-import-binding-name
                                                       extend-ribcage-subst!
                                                       extend-ribcage-barrier-help!
                                                       extend-ribcage-barrier!
                                                       extend-ribcage!
                                                       make-empty-ribcage
                                                       barrier-marker
                                                       new-mark
                                                       anti-mark
                                                       the-anti-mark
                                                       set-env-wrap!
                                                       set-env-top-ribcage!
                                                       env-wrap
                                                       env-top-ribcage
                                                       env?
                                                       make-env
                                                       set-import-token-key!
                                                       import-token-key
                                                       import-token?
                                                       make-import-token
                                                       set-top-ribcage-mutable?!
                                                       set-top-ribcage-key!
                                                       top-ribcage-mutable?
                                                       top-ribcage-key
                                                       top-ribcage?
                                                       make-top-ribcage
                                                       set-ribcage-labels!
                                                       set-ribcage-marks!
                                                       set-ribcage-symnames!
                                                       ribcage-labels
                                                       ribcage-marks
                                                       ribcage-symnames
                                                       ribcage?
                                                       make-ribcage
                                                       gen-labels
                                                       label?
                                                       gen-label
                                                       set-indirect-label!
                                                       get-indirect-label
                                                       indirect-label?
                                                       gen-indirect-label
                                                       anon
                                                       only-top-marked?
                                                       top-marked?
                                                       top-wrap
                                                       empty-wrap
                                                       wrap-subst
                                                       wrap-marks
                                                       make-wrap
                                                       id-sym-name&marks
                                                       id-sym-name
                                                       id?
                                                       nonsymbol-id?
                                                       global-extend
                                                       defer-or-eval-transformer
                                                       make-transformer-binding
                                                       lookup
                                                       lookup*
                                                       displaced-lexical-error
                                                       displaced-lexical?
                                                       extend-var-env*
                                                       extend-env*
                                                       extend-env
                                                       null-env
                                                       binding?
                                                       set-binding-value!
                                                       set-binding-type!
                                                       binding-value
                                                       binding-type
                                                       make-binding
                                                       sanitize-binding
                                                       arg-check
                                                       no-source
                                                       unannotate
                                                       self-evaluating?
                                                       lexical-var?
                                                       build-lexical-var
                                                       build-top-module
                                                       build-body
                                                       build-letrec
                                                       build-sequence
                                                       build-data
                                                       build-primref
                                                       built-lambda?
                                                       build-params
                                                       build-lambda
                                                       build-revisit-only
                                                       build-visit-only
                                                       build-cte-install
                                                       build-global-definition
                                                       build-global-assignment
                                                       build-global-reference
                                                       build-lexical-assignment
                                                       build-lexical-reference
                                                       build-conditional
                                                       build-application
                                                       generate-id
                                                       put-import-binding
                                                       get-import-binding
                                                       read-only-binding?
                                                       put-global-definition-hook
                                                       get-global-definition-hook
                                                       put-cte-hook
                                                       gensym-hook
                                                       define-top-level-value-hook
                                                       local-eval-hook
                                                       top-level-eval-hook
                                                       fx>=
                                                       fx<=
                                                       fx>
                                                       fx<
                                                       fx=
                                                       fx-
                                                       fx+
                                                       set-syntax-object-wrap!
                                                       set-syntax-object-expression!
                                                       syntax-object-wrap
                                                       syntax-object-expression
                                                       syntax-object?
                                                       make-syntax-object
                                                       noexpand
                                                       let-values
                                                       define-structure
                                                       unless
                                                       when)
                                                     ((top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      ("m" top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      ("m" top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top)
                                                      (top))
                                                     ("i" "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"
                                                          "i"))
                                                   #(top-ribcage
                                                     *top*
                                                     #t))))
                                             'revisit
                                             (if (%%literal-id=?474
                                                   %%x1664
                                                   '#(syntax-object
                                                      eval
                                                      ((top)
                                                       #(ribcage () () ())
                                                       #(ribcage
                                                         #(x)
                                                         #((top))
                                                         #("i"))
                                                       #(ribcage () () ())
                                                       #(ribcage
                                                         #(when-list w)
                                                         #((top) (top))
                                                         #("i" "i"))
                                                       #(ribcage
                                                         (lambda-var-list
                                                           gen-var
                                                           strip
                                                           strip*
                                                           strip-annotation
                                                           ellipsis?
                                                           chi-void
                                                           chi-local-syntax
                                                           chi-lambda-clause
                                                           parse-begin
                                                           parse-alias
                                                           parse-eval-when
                                                           parse-meta
                                                           parse-define-syntax
                                                           parse-define
                                                           parse-import
                                                           parse-module
                                                           do-import!
                                                           chi-internal
                                                           chi-body
                                                           chi-macro
                                                           chi-set!
                                                           chi-application
                                                           chi-expr
                                                           chi
                                                           chi-sequence
                                                           chi-meta-frob
                                                           chi-frobs
                                                           ct-eval/residualize3
                                                           ct-eval/residualize2
                                                           rt-eval/residualize
                                                           initial-mode-set
                                                           update-mode-set
                                                           do-top-import
                                                           vfor-each
                                                           vmap
                                                           chi-external
                                                           check-defined-ids
                                                           check-module-exports
                                                           id-set-diff
                                                           chi-top-module
                                                           set-frob-meta?!
                                                           set-frob-e!
                                                           frob-meta?
                                                           frob-e
                                                           frob?
                                                           make-frob
                                                           create-module-binding
                                                           set-module-binding-exported!
                                                           set-module-binding-val!
                                                           set-module-binding-imps!
                                                           set-module-binding-label!
                                                           set-module-binding-id!
                                                           set-module-binding-type!
                                                           module-binding-exported
                                                           module-binding-val
                                                           module-binding-imps
                                                           module-binding-label
                                                           module-binding-id
                                                           module-binding-type
                                                           module-binding?
                                                           make-module-binding
                                                           make-resolved-interface2
                                                           make-resolved-interface1
                                                           make-unresolved-interface
                                                           set-interface-token!
                                                           set-interface-exports!
                                                           interface-token
                                                           interface-exports
                                                           interface?
                                                           make-interface
                                                           flatten-exports
                                                           chi-top
                                                           chi-top-sequence
                                                           chi-top*
                                                           syntax-type
                                                           chi-when-list
                                                           source-wrap
                                                           wrap
                                                           bound-id-member?
                                                           invalid-ids-error
                                                           distinct-bound-ids?
                                                           valid-bound-ids?
                                                           bound-id=?
                                                           literal-id=?
                                                           free-id=?
                                                           id-var-name
                                                           id-var-name-loc
                                                           id-var-name&marks
                                                           id-var-name-loc&marks
                                                           top-id-free-var-name
                                                           top-id-bound-var-name
                                                           anon
                                                           same-marks?
                                                           join-subst
                                                           join-marks
                                                           join-wraps
                                                           smart-append
                                                           resolved-id-var-name
                                                           id->resolved-id
                                                           make-resolved-id
                                                           make-binding-wrap
                                                           store-import-binding
                                                           lookup-import-binding-name
                                                           extend-ribcage-subst!
                                                           extend-ribcage-barrier-help!
                                                           extend-ribcage-barrier!
                                                           extend-ribcage!
                                                           make-empty-ribcage
                                                           barrier-marker
                                                           new-mark
                                                           anti-mark
                                                           the-anti-mark
                                                           set-env-wrap!
                                                           set-env-top-ribcage!
                                                           env-wrap
                                                           env-top-ribcage
                                                           env?
                                                           make-env
                                                           set-import-token-key!
                                                           import-token-key
                                                           import-token?
                                                           make-import-token
                                                           set-top-ribcage-mutable?!
                                                           set-top-ribcage-key!
                                                           top-ribcage-mutable?
                                                           top-ribcage-key
                                                           top-ribcage?
                                                           make-top-ribcage
                                                           set-ribcage-labels!
                                                           set-ribcage-marks!
                                                           set-ribcage-symnames!
                                                           ribcage-labels
                                                           ribcage-marks
                                                           ribcage-symnames
                                                           ribcage?
                                                           make-ribcage
                                                           gen-labels
                                                           label?
                                                           gen-label
                                                           set-indirect-label!
                                                           get-indirect-label
                                                           indirect-label?
                                                           gen-indirect-label
                                                           anon
                                                           only-top-marked?
                                                           top-marked?
                                                           top-wrap
                                                           empty-wrap
                                                           wrap-subst
                                                           wrap-marks
                                                           make-wrap
                                                           id-sym-name&marks
                                                           id-sym-name
                                                           id?
                                                           nonsymbol-id?
                                                           global-extend
                                                           defer-or-eval-transformer
                                                           make-transformer-binding
                                                           lookup
                                                           lookup*
                                                           displaced-lexical-error
                                                           displaced-lexical?
                                                           extend-var-env*
                                                           extend-env*
                                                           extend-env
                                                           null-env
                                                           binding?
                                                           set-binding-value!
                                                           set-binding-type!
                                                           binding-value
                                                           binding-type
                                                           make-binding
                                                           sanitize-binding
                                                           arg-check
                                                           no-source
                                                           unannotate
                                                           self-evaluating?
                                                           lexical-var?
                                                           build-lexical-var
                                                           build-top-module
                                                           build-body
                                                           build-letrec
                                                           build-sequence
                                                           build-data
                                                           build-primref
                                                           built-lambda?
                                                           build-params
                                                           build-lambda
                                                           build-revisit-only
                                                           build-visit-only
                                                           build-cte-install
                                                           build-global-definition
                                                           build-global-assignment
                                                           build-global-reference
                                                           build-lexical-assignment
                                                           build-lexical-reference
                                                           build-conditional
                                                           build-application
                                                           generate-id
                                                           put-import-binding
                                                           get-import-binding
                                                           read-only-binding?
                                                           put-global-definition-hook
                                                           get-global-definition-hook
                                                           put-cte-hook
                                                           gensym-hook
                                                           define-top-level-value-hook
                                                           local-eval-hook
                                                           top-level-eval-hook
                                                           fx>=
                                                           fx<=
                                                           fx>
                                                           fx<
                                                           fx=
                                                           fx-
                                                           fx+
                                                           set-syntax-object-wrap!
                                                           set-syntax-object-expression!
                                                           syntax-object-wrap
                                                           syntax-object-expression
                                                           syntax-object?
                                                           make-syntax-object
                                                           noexpand
                                                           let-values
                                                           define-structure
                                                           unless
                                                           when)
                                                         ((top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          ("m" top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          ("m" top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top))
                                                         ("i" "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"))
                                                       #(top-ribcage
                                                         *top*
                                                         #t))))
                                                 'eval
                                                 (syntax-error
                                                   (%%wrap480
                                                     %%x1664
                                                     %%w1662)
                                                   '"invalid eval-when situation")))))))
                           %%when-list1663)))
                   (%%syntax-type483
                    (lambda (%%e1646 %%r1645 %%w1644 %%ae1643 %%rib1642)
                      (if (symbol? %%e1646)
                          ((lambda (%%n1658)
                             ((lambda (%%b1659)
                                ((lambda (%%type1660)
                                   ((lambda ()
                                      ((lambda (%%t1661)
                                         (if (memv %%t1661 '(macro macro!))
                                             (%%syntax-type483
                                               (%%chi-macro538
                                                 (%%binding-value322
                                                   %%b1659)
                                                 %%e1646
                                                 %%r1645
                                                 %%w1644
                                                 %%ae1643
                                                 %%rib1642)
                                               %%r1645
                                               '(())
                                               '#f
                                               %%rib1642)
                                             (values
                                               %%type1660
                                               (%%binding-value322 %%b1659)
                                               %%e1646
                                               %%w1644
                                               %%ae1643)))
                                       %%type1660))))
                                 (%%binding-type321 %%b1659)))
                              (%%lookup341 %%n1658 %%r1645)))
                           (%%id-var-name472 %%e1646 %%w1644))
                          (if (pair? %%e1646)
                              ((lambda (%%first1653)
                                 (if (%%id?346 %%first1653)
                                     ((lambda (%%n1654)
                                        ((lambda (%%b1655)
                                           ((lambda (%%type1656)
                                              ((lambda ()
                                                 ((lambda (%%t1657)
                                                    (if (memv %%t1657
                                                              '(lexical))
                                                        (values
                                                          'lexical-call
                                                          (%%binding-value322
                                                            %%b1655)
                                                          %%e1646
                                                          %%w1644
                                                          %%ae1643)
                                                        (if (memv %%t1657
                                                                  '(macro
                                                                     macro!))
                                                            (%%syntax-type483
                                                              (%%chi-macro538
                                                                (%%binding-value322
                                                                  %%b1655)
                                                                %%e1646
                                                                %%r1645
                                                                %%w1644
                                                                %%ae1643
                                                                %%rib1642)
                                                              %%r1645
                                                              '(())
                                                              '#f
                                                              %%rib1642)
                                                            (if (memv %%t1657
                                                                      '(core))
                                                                (values
                                                                  %%type1656
                                                                  (%%binding-value322
                                                                    %%b1655)
                                                                  %%e1646
                                                                  %%w1644
                                                                  %%ae1643)
                                                                (if (memv %%t1657
                                                                          '(begin))
                                                                    (values
                                                                      'begin-form
                                                                      '#f
                                                                      %%e1646
                                                                      %%w1644
                                                                      %%ae1643)
                                                                    (if (memv %%t1657
                                                                              '(alias))
                                                                        (values
                                                                          'alias-form
                                                                          '#f
                                                                          %%e1646
                                                                          %%w1644
                                                                          %%ae1643)
                                                                        (if (memv %%t1657
                                                                                  '(define))
                                                                            (values
                                                                              'define-form
                                                                              '#f
                                                                              %%e1646
                                                                              %%w1644
                                                                              %%ae1643)
                                                                            (if (memv %%t1657
                                                                                      '(define-syntax))
                                                                                (values
                                                                                  'define-syntax-form
                                                                                  '#f
                                                                                  %%e1646
                                                                                  %%w1644
                                                                                  %%ae1643)
                                                                                (if (memv %%t1657
                                                                                          '(set!))
                                                                                    (%%chi-set!537
                                                                                      %%e1646
                                                                                      %%r1645
                                                                                      %%w1644
                                                                                      %%ae1643
                                                                                      %%rib1642)
                                                                                    (if (memv %%t1657
                                                                                              '($module-key))
                                                                                        (values
                                                                                          '$module-form
                                                                                          '#f
                                                                                          %%e1646
                                                                                          %%w1644
                                                                                          %%ae1643)
                                                                                        (if (memv %%t1657
                                                                                                  '($import))
                                                                                            (values
                                                                                              '$import-form
                                                                                              '#f
                                                                                              %%e1646
                                                                                              %%w1644
                                                                                              %%ae1643)
                                                                                            (if (memv %%t1657
                                                                                                      '(eval-when))
                                                                                                (values
                                                                                                  'eval-when-form
                                                                                                  '#f
                                                                                                  %%e1646
                                                                                                  %%w1644
                                                                                                  %%ae1643)
                                                                                                (if (memv %%t1657
                                                                                                          '(meta))
                                                                                                    (values
                                                                                                      'meta-form
                                                                                                      '#f
                                                                                                      %%e1646
                                                                                                      %%w1644
                                                                                                      %%ae1643)
                                                                                                    (if (memv %%t1657
                                                                                                              '(local-syntax))
                                                                                                        (values
                                                                                                          'local-syntax-form
                                                                                                          (%%binding-value322
                                                                                                            %%b1655)
                                                                                                          %%e1646
                                                                                                          %%w1644
                                                                                                          %%ae1643)
                                                                                                        (values
                                                                                                          'call
                                                                                                          '#f
                                                                                                          %%e1646
                                                                                                          %%w1644
                                                                                                          %%ae1643)))))))))))))))
                                                  %%type1656))))
                                            (%%binding-type321 %%b1655)))
                                         (%%lookup341 %%n1654 %%r1645)))
                                      (%%id-var-name472
                                        %%first1653
                                        %%w1644))
                                     (values
                                       'call
                                       '#f
                                       %%e1646
                                       %%w1644
                                       %%ae1643)))
                               (car %%e1646))
                              (if (%%syntax-object?101 %%e1646)
                                  (%%syntax-type483
                                    (%%syntax-object-expression102 %%e1646)
                                    %%r1645
                                    (%%join-wraps461
                                      %%w1644
                                      (%%syntax-object-wrap103 %%e1646))
                                    '#f
                                    %%rib1642)
                                  (if (annotation? %%e1646)
                                      (%%syntax-type483
                                        (annotation-expression %%e1646)
                                        %%r1645
                                        %%w1644
                                        %%e1646
                                        %%rib1642)
                                      (if ((lambda (%%x1652)
                                             (self-eval? %%x1652))
                                           %%e1646)
                                          (values
                                            'constant
                                            '#f
                                            %%e1646
                                            %%w1644
                                            %%ae1643)
                                          (values
                                            'other
                                            '#f
                                            %%e1646
                                            %%w1644
                                            %%ae1643))))))))
                   (%%chi-top*484
                    (lambda (%%e1637
                             %%r1636
                             %%w1635
                             %%ctem1634
                             %%rtem1633
                             %%meta?1632
                             %%top-ribcage1631)
                      ((lambda (%%meta-residuals1638)
                         (letrec ((%%meta-residualize!1639
                                   (lambda (%%x1640)
                                     (set! %%meta-residuals1638
                                       (cons %%x1640
                                             %%meta-residuals1638)))))
                           ((lambda (%%e1641)
                              (%%build-sequence275
                                '#f
                                (reverse
                                  (cons %%e1641 %%meta-residuals1638))))
                            (%%chi-top486
                              %%e1637
                              %%r1636
                              %%w1635
                              %%ctem1634
                              %%rtem1633
                              %%meta?1632
                              %%top-ribcage1631
                              %%meta-residualize!1639
                              '#f))))
                       '())))
                   (%%chi-top-sequence485
                    (lambda (%%body1627
                             %%r1626
                             %%w1625
                             %%ae1624
                             %%ctem1623
                             %%rtem1622
                             %%meta?1621
                             %%ribcage1620
                             %%meta-residualize!1619)
                      (%%build-sequence275
                        %%ae1624
                        ((letrec ((%%dobody1628
                                   (lambda (%%body1629)
                                     (if (null? %%body1629)
                                         '()
                                         ((lambda (%%first1630)
                                            (cons %%first1630
                                                  (%%dobody1628
                                                    (cdr %%body1629))))
                                          (%%chi-top486
                                            (car %%body1629)
                                            %%r1626
                                            %%w1625
                                            %%ctem1623
                                            %%rtem1622
                                            %%meta?1621
                                            %%ribcage1620
                                            %%meta-residualize!1619
                                            '#f))))))
                           %%dobody1628)
                         %%body1627))))
                   (%%chi-top486
                    (lambda (%%e1557
                             %%r1556
                             %%w1555
                             %%ctem1554
                             %%rtem1553
                             %%meta?1552
                             %%top-ribcage1551
                             %%meta-residualize!1550
                             %%meta-seen?1549)
                      (call-with-values
                        (lambda ()
                          (%%syntax-type483
                            %%e1557
                            %%r1556
                            %%w1555
                            '#f
                            %%top-ribcage1551))
                        (lambda (%%type1562
                                 %%value1561
                                 %%e1560
                                 %%w1559
                                 %%ae1558)
                          ((lambda (%%t1563)
                             (if (memv %%t1563 '(begin-form))
                                 ((lambda (%%forms1618)
                                    (if (null? %%forms1618)
                                        (%%chi-void552)
                                        (%%chi-top-sequence485
                                          %%forms1618
                                          %%r1556
                                          %%w1559
                                          %%ae1558
                                          %%ctem1554
                                          %%rtem1553
                                          %%meta?1552
                                          %%top-ribcage1551
                                          %%meta-residualize!1550)))
                                  (%%parse-begin549
                                    %%e1560
                                    %%w1559
                                    %%ae1558
                                    '#t))
                                 (if (memv %%t1563 '(local-syntax-form))
                                     (call-with-values
                                       (lambda ()
                                         (%%chi-local-syntax551
                                           %%value1561
                                           %%e1560
                                           %%r1556
                                           %%r1556
                                           %%w1559
                                           %%ae1558))
                                       (lambda (%%forms1617
                                                %%r1616
                                                %%mr1615
                                                %%w1614
                                                %%ae1613)
                                         (%%chi-top-sequence485
                                           %%forms1617
                                           %%r1616
                                           %%w1614
                                           %%ae1613
                                           %%ctem1554
                                           %%rtem1553
                                           %%meta?1552
                                           %%top-ribcage1551
                                           %%meta-residualize!1550)))
                                     (if (memv %%t1563 '(eval-when-form))
                                         (call-with-values
                                           (lambda ()
                                             (%%parse-eval-when547
                                               %%e1560
                                               %%w1559
                                               %%ae1558))
                                           (lambda (%%when-list1610
                                                    %%forms1609)
                                             ((lambda (%%ctem1612
                                                       %%rtem1611)
                                                (if (if (null? %%ctem1612)
                                                        (null? %%rtem1611)
                                                        '#f)
                                                    (%%chi-void552)
                                                    (%%chi-top-sequence485
                                                      %%forms1609
                                                      %%r1556
                                                      %%w1559
                                                      %%ae1558
                                                      %%ctem1612
                                                      %%rtem1611
                                                      %%meta?1552
                                                      %%top-ribcage1551
                                                      %%meta-residualize!1550)))
                                              (%%update-mode-set526
                                                %%when-list1610
                                                %%ctem1554)
                                              (%%update-mode-set526
                                                %%when-list1610
                                                %%rtem1553))))
                                         (if (memv %%t1563 '(meta-form))
                                             (%%chi-top486
                                               (%%parse-meta546
                                                 %%e1560
                                                 %%w1559
                                                 %%ae1558)
                                               %%r1556
                                               %%w1559
                                               %%ctem1554
                                               %%rtem1553
                                               '#t
                                               %%top-ribcage1551
                                               %%meta-residualize!1550
                                               '#t)
                                             (if (memv %%t1563
                                                       '(define-syntax-form))
                                                 (call-with-values
                                                   (lambda ()
                                                     (%%parse-define-syntax545
                                                       %%e1560
                                                       %%w1559
                                                       %%ae1558))
                                                   (lambda (%%id1602
                                                            %%rhs1601
                                                            %%w1600)
                                                     ((lambda (%%id1603)
                                                        (begin (if (%%displaced-lexical?338
                                                                     %%id1603
                                                                     %%r1556)
                                                                   (%%displaced-lexical-error339
                                                                     %%id1603)
                                                                   (void))
                                                               (if (not (%%top-ribcage-mutable?418
                                                                          %%top-ribcage1551))
                                                                   (syntax-error
                                                                     (%%source-wrap481
                                                                       %%e1560
                                                                       %%w1600
                                                                       %%ae1558)
                                                                     '"invalid definition in read-only environment")
                                                                   (void))
                                                               ((lambda (%%sym1604)
                                                                  (call-with-values
                                                                    (lambda ()
                                                                      (%%top-id-bound-var-name467
                                                                        %%sym1604
                                                                        (%%wrap-marks359
                                                                          (%%syntax-object-wrap103
                                                                            %%id1603))
                                                                        %%top-ribcage1551))
                                                                    (lambda (%%valsym1606
                                                                             %%bound-id1605)
                                                                      (begin (if (not (eq? (%%id-var-name472
                                                                                             %%id1603
                                                                                             '(()))
                                                                                           %%valsym1606))
                                                                                 (syntax-error
                                                                                   (%%source-wrap481
                                                                                     %%e1560
                                                                                     %%w1600
                                                                                     %%ae1558)
                                                                                   '"definition not permitted")
                                                                                 (void))
                                                                             (if (%%read-only-binding?179
                                                                                   %%valsym1606)
                                                                                 (syntax-error
                                                                                   (%%source-wrap481
                                                                                     %%e1560
                                                                                     %%w1600
                                                                                     %%ae1558)
                                                                                   '"invalid definition of read-only identifier")
                                                                                 (void))
                                                                             (%%ct-eval/residualize2529
                                                                               %%ctem1554
                                                                               (lambda ()
                                                                                 (list (build-source
                                                                                         '#f
                                                                                         '$sc-put-cte)
                                                                                       (list 'quote
                                                                                             %%bound-id1605)
                                                                                       (%%chi534
                                                                                         %%rhs1601
                                                                                         %%r1556
                                                                                         %%r1556
                                                                                         %%w1600
                                                                                         '#t)
                                                                                       (build-source
                                                                                         '#f
                                                                                         (list (build-source
                                                                                                 '#f
                                                                                                 'quote)
                                                                                               (%%top-ribcage-key417
                                                                                                 %%top-ribcage1551))))))))))
                                                                ((lambda (%%x1607)
                                                                   ((lambda (%%e1608)
                                                                      (if (annotation?
                                                                            %%e1608)
                                                                          (annotation-expression
                                                                            %%e1608)
                                                                          %%e1608))
                                                                    (if (%%syntax-object?101
                                                                          %%x1607)
                                                                        (%%syntax-object-expression102
                                                                          %%x1607)
                                                                        %%x1607)))
                                                                 %%id1603))))
                                                      (%%wrap480
                                                        %%id1602
                                                        %%w1600))))
                                                 (if (memv %%t1563
                                                           '(define-form))
                                                     (call-with-values
                                                       (lambda ()
                                                         (%%parse-define544
                                                           %%e1560
                                                           %%w1559
                                                           %%ae1558))
                                                       (lambda (%%id1593
                                                                %%rhs1592
                                                                %%w1591)
                                                         ((lambda (%%id1594)
                                                            (begin (if (%%displaced-lexical?338
                                                                         %%id1594
                                                                         %%r1556)
                                                                       (%%displaced-lexical-error339
                                                                         %%id1594)
                                                                       (void))
                                                                   (if (not (%%top-ribcage-mutable?418
                                                                              %%top-ribcage1551))
                                                                       (syntax-error
                                                                         (%%source-wrap481
                                                                           %%e1560
                                                                           %%w1591
                                                                           %%ae1558)
                                                                         '"invalid definition in read-only environment")
                                                                       (void))
                                                                   ((lambda (%%sym1595)
                                                                      (call-with-values
                                                                        (lambda ()
                                                                          (%%top-id-bound-var-name467
                                                                            %%sym1595
                                                                            (%%wrap-marks359
                                                                              (%%syntax-object-wrap103
                                                                                %%id1594))
                                                                            %%top-ribcage1551))
                                                                        (lambda (%%valsym1597
                                                                                 %%bound-id1596)
                                                                          (begin (if (not (eq? (%%id-var-name472
                                                                                                 %%id1594
                                                                                                 '(()))
                                                                                               %%valsym1597))
                                                                                     (syntax-error
                                                                                       (%%source-wrap481
                                                                                         %%e1560
                                                                                         %%w1591
                                                                                         %%ae1558)
                                                                                       '"definition not permitted")
                                                                                     (void))
                                                                                 (if (%%read-only-binding?179
                                                                                       %%valsym1597)
                                                                                     (syntax-error
                                                                                       (%%source-wrap481
                                                                                         %%e1560
                                                                                         %%w1591
                                                                                         %%ae1558)
                                                                                       '"invalid definition of read-only identifier")
                                                                                     (void))
                                                                                 (if %%meta?1552
                                                                                     (%%ct-eval/residualize2529
                                                                                       %%ctem1554
                                                                                       (lambda ()
                                                                                         (%%build-sequence275
                                                                                           '#f
                                                                                           (list (list (build-source
                                                                                                         '#f
                                                                                                         '$sc-put-cte)
                                                                                                       (list 'quote
                                                                                                             %%bound-id1596)
                                                                                                       (build-source
                                                                                                         '#f
                                                                                                         (list (build-source
                                                                                                                 '#f
                                                                                                                 'quote)
                                                                                                               (attach-source
                                                                                                                 '#f
                                                                                                                 (cons 'meta-variable
                                                                                                                       %%valsym1597))))
                                                                                                       (build-source
                                                                                                         '#f
                                                                                                         (list (build-source
                                                                                                                 '#f
                                                                                                                 'quote)
                                                                                                               (%%top-ribcage-key417
                                                                                                                 %%top-ribcage1551))))
                                                                                                 (build-source
                                                                                                   %%ae1558
                                                                                                   (list (build-source
                                                                                                           %%ae1558
                                                                                                           'define)
                                                                                                         (build-source
                                                                                                           %%ae1558
                                                                                                           %%valsym1597)
                                                                                                         (%%chi534
                                                                                                           %%rhs1592
                                                                                                           %%r1556
                                                                                                           %%r1556
                                                                                                           %%w1591
                                                                                                           '#t)))))))
                                                                                     (%%build-sequence275
                                                                                       '#f
                                                                                       (list (%%ct-eval/residualize2529
                                                                                               %%ctem1554
                                                                                               (lambda ()
                                                                                                 (list (build-source
                                                                                                         '#f
                                                                                                         '$sc-put-cte)
                                                                                                       (list 'quote
                                                                                                             %%bound-id1596)
                                                                                                       (build-source
                                                                                                         '#f
                                                                                                         (list (build-source
                                                                                                                 '#f
                                                                                                                 'quote)
                                                                                                               (attach-source
                                                                                                                 '#f
                                                                                                                 (cons 'global
                                                                                                                       %%valsym1597))))
                                                                                                       (build-source
                                                                                                         '#f
                                                                                                         (list (build-source
                                                                                                                 '#f
                                                                                                                 'quote)
                                                                                                               (%%top-ribcage-key417
                                                                                                                 %%top-ribcage1551))))))
                                                                                             (%%rt-eval/residualize528
                                                                                               %%rtem1553
                                                                                               (lambda ()
                                                                                                 (build-source
                                                                                                   %%ae1558
                                                                                                   (list (build-source
                                                                                                           %%ae1558
                                                                                                           'define)
                                                                                                         (build-source
                                                                                                           %%ae1558
                                                                                                           %%valsym1597)
                                                                                                         (%%chi534
                                                                                                           %%rhs1592
                                                                                                           %%r1556
                                                                                                           %%r1556
                                                                                                           %%w1591
                                                                                                           '#f))))))))))))
                                                                    ((lambda (%%x1598)
                                                                       ((lambda (%%e1599)
                                                                          (if (annotation?
                                                                                %%e1599)
                                                                              (annotation-expression
                                                                                %%e1599)
                                                                              %%e1599))
                                                                        (if (%%syntax-object?101
                                                                              %%x1598)
                                                                            (%%syntax-object-expression102
                                                                              %%x1598)
                                                                            %%x1598)))
                                                                     %%id1594))))
                                                          (%%wrap480
                                                            %%id1593
                                                            %%w1591))))
                                                     (if (memv %%t1563
                                                               '($module-form))
                                                         ((lambda (%%ribcage1586)
                                                            (call-with-values
                                                              (lambda ()
                                                                (%%parse-module542
                                                                  %%e1560
                                                                  %%w1559
                                                                  %%ae1558
                                                                  (%%make-wrap358
                                                                    (%%wrap-marks359
                                                                      %%w1559)
                                                                    (cons %%ribcage1586
                                                                          (%%wrap-subst360
                                                                            %%w1559)))))
                                                              (lambda (%%orig1590
                                                                       %%id1589
                                                                       %%exports1588
                                                                       %%forms1587)
                                                                (begin (if (%%displaced-lexical?338
                                                                             %%id1589
                                                                             %%r1556)
                                                                           (%%displaced-lexical-error339
                                                                             (%%wrap480
                                                                               %%id1589
                                                                               %%w1559))
                                                                           (void))
                                                                       (if (not (%%top-ribcage-mutable?418
                                                                                  %%top-ribcage1551))
                                                                           (syntax-error
                                                                             %%orig1590
                                                                             '"invalid definition in read-only environment")
                                                                           (void))
                                                                       (%%chi-top-module518
                                                                         %%orig1590
                                                                         %%r1556
                                                                         %%r1556
                                                                         %%top-ribcage1551
                                                                         %%ribcage1586
                                                                         %%ctem1554
                                                                         %%rtem1553
                                                                         %%meta?1552
                                                                         %%id1589
                                                                         %%exports1588
                                                                         %%forms1587
                                                                         %%meta-residualize!1550)))))
                                                          (%%make-ribcage407
                                                            '()
                                                            '()
                                                            '()))
                                                         (if (memv %%t1563
                                                                   '($import-form))
                                                             (call-with-values
                                                               (lambda ()
                                                                 (%%parse-import543
                                                                   %%e1560
                                                                   %%w1559
                                                                   %%ae1558))
                                                               (lambda (%%orig1575
                                                                        %%only?1574
                                                                        %%mid1573)
                                                                 (begin (if (not (%%top-ribcage-mutable?418
                                                                                   %%top-ribcage1551))
                                                                            (syntax-error
                                                                              %%orig1575
                                                                              '"invalid definition in read-only environment")
                                                                            (void))
                                                                        (%%ct-eval/residualize2529
                                                                          %%ctem1554
                                                                          (lambda ()
                                                                            ((lambda (%%binding1576)
                                                                               ((lambda (%%t1577)
                                                                                  (if (memv %%t1577
                                                                                            '($module))
                                                                                      (%%do-top-import525
                                                                                        %%only?1574
                                                                                        %%top-ribcage1551
                                                                                        %%mid1573
                                                                                        (%%interface-token491
                                                                                          (%%binding-value322
                                                                                            %%binding1576)))
                                                                                      (if (memv %%t1577
                                                                                                '(displaced-lexical))
                                                                                          (%%displaced-lexical-error339
                                                                                            %%mid1573)
                                                                                          (syntax-error
                                                                                            %%mid1573
                                                                                            '"unknown module"))))
                                                                                (%%binding-type321
                                                                                  %%binding1576)))
                                                                             (%%lookup341
                                                                               (%%id-var-name472
                                                                                 %%mid1573
                                                                                 '(()))
                                                                               '())))))))
                                                             (if (memv %%t1563
                                                                       '(alias-form))
                                                                 (call-with-values
                                                                   (lambda ()
                                                                     (%%parse-alias548
                                                                       %%e1560
                                                                       %%w1559
                                                                       %%ae1558))
                                                                   (lambda (%%new-id1566
                                                                            %%old-id1565)
                                                                     ((lambda (%%new-id1567)
                                                                        (begin (if (%%displaced-lexical?338
                                                                                     %%new-id1567
                                                                                     %%r1556)
                                                                                   (%%displaced-lexical-error339
                                                                                     %%new-id1567)
                                                                                   (void))
                                                                               (if (not (%%top-ribcage-mutable?418
                                                                                          %%top-ribcage1551))
                                                                                   (syntax-error
                                                                                     (%%source-wrap481
                                                                                       %%e1560
                                                                                       %%w1559
                                                                                       %%ae1558)
                                                                                     '"invalid definition in read-only environment")
                                                                                   (void))
                                                                               ((lambda (%%sym1568)
                                                                                  (call-with-values
                                                                                    (lambda ()
                                                                                      (%%top-id-bound-var-name467
                                                                                        %%sym1568
                                                                                        (%%wrap-marks359
                                                                                          (%%syntax-object-wrap103
                                                                                            %%new-id1567))
                                                                                        %%top-ribcage1551))
                                                                                    (lambda (%%valsym1570
                                                                                             %%bound-id1569)
                                                                                      (begin (if (not (eq? (%%id-var-name472
                                                                                                             %%new-id1567
                                                                                                             '(()))
                                                                                                           %%valsym1570))
                                                                                                 (syntax-error
                                                                                                   (%%source-wrap481
                                                                                                     %%e1560
                                                                                                     %%w1559
                                                                                                     %%ae1558)
                                                                                                   '"definition not permitted")
                                                                                                 (void))
                                                                                             (if (%%read-only-binding?179
                                                                                                   %%valsym1570)
                                                                                                 (syntax-error
                                                                                                   (%%source-wrap481
                                                                                                     %%e1560
                                                                                                     %%w1559
                                                                                                     %%ae1558)
                                                                                                   '"invalid definition of read-only identifier")
                                                                                                 (void))
                                                                                             (%%ct-eval/residualize2529
                                                                                               %%ctem1554
                                                                                               (lambda ()
                                                                                                 (list (build-source
                                                                                                         '#f
                                                                                                         '$sc-put-cte)
                                                                                                       (list 'quote
                                                                                                             (%%make-resolved-id457
                                                                                                               %%sym1568
                                                                                                               (%%wrap-marks359
                                                                                                                 (%%syntax-object-wrap103
                                                                                                                   %%new-id1567))
                                                                                                               (%%id-var-name472
                                                                                                                 %%old-id1565
                                                                                                                 %%w1559)))
                                                                                                       (build-source
                                                                                                         '#f
                                                                                                         (list (build-source
                                                                                                                 '#f
                                                                                                                 'quote)
                                                                                                               (attach-source
                                                                                                                 '#f
                                                                                                                 '(do-alias
                                                                                                                    .
                                                                                                                    #f))))
                                                                                                       (build-source
                                                                                                         '#f
                                                                                                         (list (build-source
                                                                                                                 '#f
                                                                                                                 'quote)
                                                                                                               (%%top-ribcage-key417
                                                                                                                 %%top-ribcage1551))))))))))
                                                                                ((lambda (%%x1571)
                                                                                   ((lambda (%%e1572)
                                                                                      (if (annotation?
                                                                                            %%e1572)
                                                                                          (annotation-expression
                                                                                            %%e1572)
                                                                                          %%e1572))
                                                                                    (if (%%syntax-object?101
                                                                                          %%x1571)
                                                                                        (%%syntax-object-expression102
                                                                                          %%x1571)
                                                                                        %%x1571)))
                                                                                 %%new-id1567))))
                                                                      (%%wrap480
                                                                        %%new-id1566
                                                                        %%w1559))))
                                                                 (begin (if %%meta-seen?1549
                                                                            (syntax-error
                                                                              (%%source-wrap481
                                                                                %%e1560
                                                                                %%w1559
                                                                                %%ae1558)
                                                                              '"invalid meta definition")
                                                                            (void))
                                                                        (if %%meta?1552
                                                                            ((lambda (%%x1564)
                                                                               (begin (%%top-level-eval-hook169
                                                                                        %%x1564)
                                                                                      (%%ct-eval/residualize3530
                                                                                        %%ctem1554
                                                                                        void
                                                                                        (lambda ()
                                                                                          %%x1564))))
                                                                             (%%chi-expr535
                                                                               %%type1562
                                                                               %%value1561
                                                                               %%e1560
                                                                               %%r1556
                                                                               %%r1556
                                                                               %%w1559
                                                                               %%ae1558
                                                                               '#t))
                                                                            (%%rt-eval/residualize528
                                                                              %%rtem1553
                                                                              (lambda ()
                                                                                (%%chi-expr535
                                                                                  %%type1562
                                                                                  %%value1561
                                                                                  %%e1560
                                                                                  %%r1556
                                                                                  %%r1556
                                                                                  %%w1559
                                                                                  %%ae1558
                                                                                  '#f)))))))))))))))
                           %%type1562)))))
                   (%%flatten-exports487
                    (lambda (%%exports1545)
                      ((letrec ((%%loop1546
                                 (lambda (%%exports1548 %%ls1547)
                                   (if (null? %%exports1548)
                                       %%ls1547
                                       (%%loop1546
                                         (cdr %%exports1548)
                                         (if (pair? (car %%exports1548))
                                             (%%loop1546
                                               (car %%exports1548)
                                               %%ls1547)
                                             (cons (car %%exports1548)
                                                   %%ls1547)))))))
                         %%loop1546)
                       %%exports1545
                       '())))
                   (%%make-interface488
                    (lambda (%%exports1544 %%token1543)
                      (vector 'interface %%exports1544 %%token1543)))
                   (%%interface?489
                    (lambda (%%x1542)
                      (if (vector? %%x1542)
                          (if (= (vector-length %%x1542) '3)
                              (eq? (vector-ref %%x1542 '0) 'interface)
                              '#f)
                          '#f)))
                   (%%interface-exports490
                    (lambda (%%x1541) (vector-ref %%x1541 '1)))
                   (%%interface-token491
                    (lambda (%%x1540) (vector-ref %%x1540 '2)))
                   (%%set-interface-exports!492
                    (lambda (%%x1539 %%update1538)
                      (vector-set! %%x1539 '1 %%update1538)))
                   (%%set-interface-token!493
                    (lambda (%%x1537 %%update1536)
                      (vector-set! %%x1537 '2 %%update1536)))
                   (%%make-unresolved-interface494
                    (lambda (%%exports1534)
                      (%%make-interface488
                        (list->vector
                          (map (lambda (%%x1535)
                                 (if (pair? %%x1535)
                                     (car %%x1535)
                                     %%x1535))
                               %%exports1534))
                        '#f)))
                   (%%make-resolved-interface1495
                    (lambda (%%exports1533)
                      (%%make-resolved-interface2496 %%exports1533 '#f)))
                   (%%make-resolved-interface2496
                    (lambda (%%exports1531 %%import-token1530)
                      (%%make-interface488
                        (list->vector
                          (map (lambda (%%x1532)
                                 (%%id->resolved-id458
                                   (if (pair? %%x1532)
                                       (car %%x1532)
                                       %%x1532)))
                               %%exports1531))
                        %%import-token1530)))
                   (%%make-module-binding497
                    (lambda (%%type1529
                             %%id1528
                             %%label1527
                             %%imps1526
                             %%val1525
                             %%exported1524)
                      (vector
                        'module-binding
                        %%type1529
                        %%id1528
                        %%label1527
                        %%imps1526
                        %%val1525
                        %%exported1524)))
                   (%%module-binding?498
                    (lambda (%%x1523)
                      (if (vector? %%x1523)
                          (if (= (vector-length %%x1523) '7)
                              (eq? (vector-ref %%x1523 '0) 'module-binding)
                              '#f)
                          '#f)))
                   (%%module-binding-type499
                    (lambda (%%x1522) (vector-ref %%x1522 '1)))
                   (%%module-binding-id500
                    (lambda (%%x1521) (vector-ref %%x1521 '2)))
                   (%%module-binding-label501
                    (lambda (%%x1520) (vector-ref %%x1520 '3)))
                   (%%module-binding-imps502
                    (lambda (%%x1519) (vector-ref %%x1519 '4)))
                   (%%module-binding-val503
                    (lambda (%%x1518) (vector-ref %%x1518 '5)))
                   (%%module-binding-exported504
                    (lambda (%%x1517) (vector-ref %%x1517 '6)))
                   (%%set-module-binding-type!505
                    (lambda (%%x1516 %%update1515)
                      (vector-set! %%x1516 '1 %%update1515)))
                   (%%set-module-binding-id!506
                    (lambda (%%x1514 %%update1513)
                      (vector-set! %%x1514 '2 %%update1513)))
                   (%%set-module-binding-label!507
                    (lambda (%%x1512 %%update1511)
                      (vector-set! %%x1512 '3 %%update1511)))
                   (%%set-module-binding-imps!508
                    (lambda (%%x1510 %%update1509)
                      (vector-set! %%x1510 '4 %%update1509)))
                   (%%set-module-binding-val!509
                    (lambda (%%x1508 %%update1507)
                      (vector-set! %%x1508 '5 %%update1507)))
                   (%%set-module-binding-exported!510
                    (lambda (%%x1506 %%update1505)
                      (vector-set! %%x1506 '6 %%update1505)))
                   (%%create-module-binding511
                    (lambda (%%type1504
                             %%id1503
                             %%label1502
                             %%imps1501
                             %%val1500)
                      (%%make-module-binding497
                        %%type1504
                        %%id1503
                        %%label1502
                        %%imps1501
                        %%val1500
                        '#f)))
                   (%%make-frob512
                    (lambda (%%e1499 %%meta?1498)
                      (vector 'frob %%e1499 %%meta?1498)))
                   (%%frob?513
                    (lambda (%%x1497)
                      (if (vector? %%x1497)
                          (if (= (vector-length %%x1497) '3)
                              (eq? (vector-ref %%x1497 '0) 'frob)
                              '#f)
                          '#f)))
                   (%%frob-e514 (lambda (%%x1496) (vector-ref %%x1496 '1)))
                   (%%frob-meta?515
                    (lambda (%%x1495) (vector-ref %%x1495 '2)))
                   (%%set-frob-e!516
                    (lambda (%%x1494 %%update1493)
                      (vector-set! %%x1494 '1 %%update1493)))
                   (%%set-frob-meta?!517
                    (lambda (%%x1492 %%update1491)
                      (vector-set! %%x1492 '2 %%update1491)))
                   (%%chi-top-module518
                    (lambda (%%orig1432
                             %%r1431
                             %%mr1430
                             %%top-ribcage1429
                             %%ribcage1428
                             %%ctem1427
                             %%rtem1426
                             %%meta?1425
                             %%id1424
                             %%exports1423
                             %%forms1422
                             %%meta-residualize!1421)
                      ((lambda (%%fexports1433)
                         (call-with-values
                           (lambda ()
                             (%%chi-external522
                               %%ribcage1428
                               %%orig1432
                               (map (lambda (%%d1490)
                                      (%%make-frob512 %%d1490 %%meta?1425))
                                    %%forms1422)
                               %%r1431
                               %%mr1430
                               %%ctem1427
                               %%exports1423
                               %%fexports1433
                               %%meta-residualize!1421))
                           (lambda (%%r1437
                                    %%mr1436
                                    %%bindings1435
                                    %%inits1434)
                             ((letrec ((%%process-exports1438
                                        (lambda (%%fexports1440
                                                 %%ctdefs1439)
                                          (if (null? %%fexports1440)
                                              ((letrec ((%%process-locals1468
                                                         (lambda (%%bs1473
                                                                  %%r1472
                                                                  %%dts1471
                                                                  %%dvs1470
                                                                  %%des1469)
                                                           (if (null?
                                                                 %%bs1473)
                                                               ((lambda (%%des1482
                                                                         %%inits1481)
                                                                  (%%build-sequence275
                                                                    '#f
                                                                    (append
                                                                      (%%ctdefs1439)
                                                                      (list (%%ct-eval/residualize2529
                                                                              %%ctem1427
                                                                              (lambda ()
                                                                                ((lambda (%%sym1483)
                                                                                   ((lambda (%%token1484)
                                                                                      ((lambda (%%b1485)
                                                                                         ((lambda ()
                                                                                            (call-with-values
                                                                                              (lambda ()
                                                                                                (%%top-id-bound-var-name467
                                                                                                  %%sym1483
                                                                                                  (%%wrap-marks359
                                                                                                    (%%syntax-object-wrap103
                                                                                                      %%id1424))
                                                                                                  %%top-ribcage1429))
                                                                                              (lambda (%%valsym1487
                                                                                                       %%bound-id1486)
                                                                                                (begin (if (not (eq? (%%id-var-name472
                                                                                                                       %%id1424
                                                                                                                       '(()))
                                                                                                                     %%valsym1487))
                                                                                                           (syntax-error
                                                                                                             %%orig1432
                                                                                                             '"definition not permitted")
                                                                                                           (void))
                                                                                                       (if (%%read-only-binding?179
                                                                                                             %%valsym1487)
                                                                                                           (syntax-error
                                                                                                             %%orig1432
                                                                                                             '"invalid definition of read-only identifier")
                                                                                                           (void))
                                                                                                       (list (build-source
                                                                                                               '#f
                                                                                                               '$sc-put-cte)
                                                                                                             (list 'quote
                                                                                                                   %%bound-id1486)
                                                                                                             %%b1485
                                                                                                             (build-source
                                                                                                               '#f
                                                                                                               (list (build-source
                                                                                                                       '#f
                                                                                                                       'quote)
                                                                                                                     (%%top-ribcage-key417
                                                                                                                       %%top-ribcage1429))))))))))
                                                                                       (build-source
                                                                                         '#f
                                                                                         (list (build-source
                                                                                                 '#f
                                                                                                 'quote)
                                                                                               (attach-source
                                                                                                 '#f
                                                                                                 (cons '$module
                                                                                                       (%%make-resolved-interface2496
                                                                                                         %%exports1423
                                                                                                         %%token1484)))))))
                                                                                    (%%generate-id182
                                                                                      %%sym1483)))
                                                                                 ((lambda (%%x1488)
                                                                                    ((lambda (%%e1489)
                                                                                       (if (annotation?
                                                                                             %%e1489)
                                                                                           (annotation-expression
                                                                                             %%e1489)
                                                                                           %%e1489))
                                                                                     (if (%%syntax-object?101
                                                                                           %%x1488)
                                                                                         (%%syntax-object-expression102
                                                                                           %%x1488)
                                                                                         %%x1488)))
                                                                                  %%id1424))))
                                                                            (%%rt-eval/residualize528
                                                                              %%rtem1426
                                                                              (lambda ()
                                                                                (%%build-top-module278
                                                                                  '#f
                                                                                  %%dts1471
                                                                                  %%dvs1470
                                                                                  %%des1482
                                                                                  (if (null?
                                                                                        %%inits1481)
                                                                                      (%%chi-void552)
                                                                                      (%%build-sequence275
                                                                                        '#f
                                                                                        (append
                                                                                          %%inits1481
                                                                                          (list (%%chi-void552))))))))))))
                                                                (%%chi-frobs531
                                                                  %%des1469
                                                                  %%r1472
                                                                  %%mr1436
                                                                  '#f)
                                                                (%%chi-frobs531
                                                                  %%inits1434
                                                                  %%r1472
                                                                  %%mr1436
                                                                  '#f))
                                                               ((lambda (%%b1475
                                                                         %%bs1474)
                                                                  ((lambda (%%t1476)
                                                                     ((lambda (%%t1477)
                                                                        (if (memv %%t1477
                                                                                  '(define-form))
                                                                            ((lambda (%%label1478)
                                                                               (if (%%module-binding-exported504
                                                                                     %%b1475)
                                                                                   ((lambda (%%var1480)
                                                                                      (%%process-locals1468
                                                                                        %%bs1474
                                                                                        %%r1472
                                                                                        (cons 'global
                                                                                              %%dts1471)
                                                                                        (cons %%label1478
                                                                                              %%dvs1470)
                                                                                        (cons (%%module-binding-val503
                                                                                                %%b1475)
                                                                                              %%des1469)))
                                                                                    (%%module-binding-id500
                                                                                      %%b1475))
                                                                                   ((lambda (%%var1479)
                                                                                      (%%process-locals1468
                                                                                        %%bs1474
                                                                                        (%%extend-env335
                                                                                          %%label1478
                                                                                          (cons 'lexical
                                                                                                %%var1479)
                                                                                          %%r1472)
                                                                                        (cons 'local
                                                                                              %%dts1471)
                                                                                        (cons %%var1479
                                                                                              %%dvs1470)
                                                                                        (cons (%%module-binding-val503
                                                                                                %%b1475)
                                                                                              %%des1469)))
                                                                                    (%%gen-var557
                                                                                      (%%module-binding-id500
                                                                                        %%b1475)))))
                                                                             (%%get-indirect-label402
                                                                               (%%module-binding-label501
                                                                                 %%b1475)))
                                                                            (if (memv %%t1477
                                                                                      '(ctdefine-form
                                                                                         define-syntax-form
                                                                                         $module-form
                                                                                         alias-form))
                                                                                (%%process-locals1468
                                                                                  %%bs1474
                                                                                  %%r1472
                                                                                  %%dts1471
                                                                                  %%dvs1470
                                                                                  %%des1469)
                                                                                (error '"(in sc-expand-internal) unexpected module binding type"
                                                                                  %%t1476))))
                                                                      (%%module-binding-type499
                                                                        %%b1475)))
                                                                   (%%module-binding-type499
                                                                     %%b1475)))
                                                                (car %%bs1473)
                                                                (cdr %%bs1473))))))
                                                 %%process-locals1468)
                                               %%bindings1435
                                               %%r1437
                                               '()
                                               '()
                                               '())
                                              ((lambda (%%id1442
                                                        %%fexports1441)
                                                 ((letrec ((%%loop1443
                                                            (lambda (%%bs1444)
                                                              (if (null?
                                                                    %%bs1444)
                                                                  (%%process-exports1438
                                                                    %%fexports1441
                                                                    %%ctdefs1439)
                                                                  ((lambda (%%b1446
                                                                            %%bs1445)
                                                                     (if (%%free-id=?473
                                                                           (%%module-binding-id500
                                                                             %%b1446)
                                                                           %%id1442)
                                                                         (if (%%module-binding-exported504
                                                                               %%b1446)
                                                                             (%%process-exports1438
                                                                               %%fexports1441
                                                                               %%ctdefs1439)
                                                                             ((lambda (%%t1447)
                                                                                ((lambda (%%label1448)
                                                                                   ((lambda (%%imps1449)
                                                                                      ((lambda (%%fexports1450)
                                                                                         ((lambda ()
                                                                                            (begin (%%set-module-binding-exported!510
                                                                                                     %%b1446
                                                                                                     '#t)
                                                                                                   ((lambda (%%t1451)
                                                                                                      (if (memv %%t1451
                                                                                                                '(define-form))
                                                                                                          ((lambda (%%sym1465)
                                                                                                             (begin (%%set-indirect-label!403
                                                                                                                      %%label1448
                                                                                                                      %%sym1465)
                                                                                                                    (%%process-exports1438
                                                                                                                      %%fexports1450
                                                                                                                      %%ctdefs1439)))
                                                                                                           (%%generate-id182
                                                                                                             ((lambda (%%x1466)
                                                                                                                ((lambda (%%e1467)
                                                                                                                   (if (annotation?
                                                                                                                         %%e1467)
                                                                                                                       (annotation-expression
                                                                                                                         %%e1467)
                                                                                                                       %%e1467))
                                                                                                                 (if (%%syntax-object?101
                                                                                                                       %%x1466)
                                                                                                                     (%%syntax-object-expression102
                                                                                                                       %%x1466)
                                                                                                                     %%x1466)))
                                                                                                              %%id1442)))
                                                                                                          (if (memv %%t1451
                                                                                                                    '(ctdefine-form))
                                                                                                              ((lambda (%%b1463)
                                                                                                                 (%%process-exports1438
                                                                                                                   %%fexports1450
                                                                                                                   (lambda ()
                                                                                                                     ((lambda (%%sym1464)
                                                                                                                        (begin (%%set-indirect-label!403
                                                                                                                                 %%label1448
                                                                                                                                 %%sym1464)
                                                                                                                               (cons (%%ct-eval/residualize3530
                                                                                                                                       %%ctem1427
                                                                                                                                       (lambda ()
                                                                                                                                         (%%put-cte-hook176
                                                                                                                                           %%sym1464
                                                                                                                                           %%b1463))
                                                                                                                                       (lambda ()
                                                                                                                                         (list (build-source
                                                                                                                                                 '#f
                                                                                                                                                 '$sc-put-cte)
                                                                                                                                               (list 'quote
                                                                                                                                                     %%sym1464)
                                                                                                                                               (build-source
                                                                                                                                                 '#f
                                                                                                                                                 (list (build-source
                                                                                                                                                         '#f
                                                                                                                                                         'quote)
                                                                                                                                                       (attach-source
                                                                                                                                                         '#f
                                                                                                                                                         %%b1463)))
                                                                                                                                               (build-source
                                                                                                                                                 '#f
                                                                                                                                                 (list (build-source
                                                                                                                                                         '#f
                                                                                                                                                         'quote)
                                                                                                                                                       '#f)))))
                                                                                                                                     (%%ctdefs1439))))
                                                                                                                      (%%binding-value322
                                                                                                                        %%b1463)))))
                                                                                                               (%%module-binding-val503
                                                                                                                 %%b1446))
                                                                                                              (if (memv %%t1451
                                                                                                                        '(define-syntax-form))
                                                                                                                  ((lambda (%%sym1459)
                                                                                                                     (%%process-exports1438
                                                                                                                       %%fexports1450
                                                                                                                       (lambda ()
                                                                                                                         ((lambda (%%local-label1460)
                                                                                                                            (begin (%%set-indirect-label!403
                                                                                                                                     %%label1448
                                                                                                                                     %%sym1459)
                                                                                                                                   (cons (%%ct-eval/residualize3530
                                                                                                                                           %%ctem1427
                                                                                                                                           (lambda ()
                                                                                                                                             (%%put-cte-hook176
                                                                                                                                               %%sym1459
                                                                                                                                               (car (%%module-binding-val503
                                                                                                                                                      %%b1446))))
                                                                                                                                           (lambda ()
                                                                                                                                             (list (build-source
                                                                                                                                                     '#f
                                                                                                                                                     '$sc-put-cte)
                                                                                                                                                   (list 'quote
                                                                                                                                                         %%sym1459)
                                                                                                                                                   (cdr (%%module-binding-val503
                                                                                                                                                          %%b1446))
                                                                                                                                                   (build-source
                                                                                                                                                     '#f
                                                                                                                                                     (list (build-source
                                                                                                                                                             '#f
                                                                                                                                                             'quote)
                                                                                                                                                           '#f)))))
                                                                                                                                         (%%ctdefs1439))))
                                                                                                                          (%%get-indirect-label402
                                                                                                                            %%label1448)))))
                                                                                                                   (%%generate-id182
                                                                                                                     ((lambda (%%x1461)
                                                                                                                        ((lambda (%%e1462)
                                                                                                                           (if (annotation?
                                                                                                                                 %%e1462)
                                                                                                                               (annotation-expression
                                                                                                                                 %%e1462)
                                                                                                                               %%e1462))
                                                                                                                         (if (%%syntax-object?101
                                                                                                                               %%x1461)
                                                                                                                             (%%syntax-object-expression102
                                                                                                                               %%x1461)
                                                                                                                             %%x1461)))
                                                                                                                      %%id1442)))
                                                                                                                  (if (memv %%t1451
                                                                                                                            '($module-form))
                                                                                                                      ((lambda (%%sym1454
                                                                                                                                %%exports1453)
                                                                                                                         (%%process-exports1438
                                                                                                                           (append
                                                                                                                             (%%flatten-exports487
                                                                                                                               %%exports1453)
                                                                                                                             %%fexports1450)
                                                                                                                           (lambda ()
                                                                                                                             (begin (%%set-indirect-label!403
                                                                                                                                      %%label1448
                                                                                                                                      %%sym1454)
                                                                                                                                    ((lambda (%%rest1455)
                                                                                                                                       ((lambda (%%x1456)
                                                                                                                                          (cons (%%ct-eval/residualize3530
                                                                                                                                                  %%ctem1427
                                                                                                                                                  (lambda ()
                                                                                                                                                    (%%put-cte-hook176
                                                                                                                                                      %%sym1454
                                                                                                                                                      %%x1456))
                                                                                                                                                  (lambda ()
                                                                                                                                                    (list (build-source
                                                                                                                                                            '#f
                                                                                                                                                            '$sc-put-cte)
                                                                                                                                                          (list 'quote
                                                                                                                                                                %%sym1454)
                                                                                                                                                          (build-source
                                                                                                                                                            '#f
                                                                                                                                                            (list (build-source
                                                                                                                                                                    '#f
                                                                                                                                                                    'quote)
                                                                                                                                                                  (attach-source
                                                                                                                                                                    '#f
                                                                                                                                                                    %%x1456)))
                                                                                                                                                          (build-source
                                                                                                                                                            '#f
                                                                                                                                                            (list (build-source
                                                                                                                                                                    '#f
                                                                                                                                                                    'quote)
                                                                                                                                                                  '#f)))))
                                                                                                                                                %%rest1455))
                                                                                                                                        (cons '$module
                                                                                                                                              (%%make-resolved-interface2496
                                                                                                                                                %%exports1453
                                                                                                                                                %%sym1454))))
                                                                                                                                     (%%ctdefs1439))))))
                                                                                                                       (%%generate-id182
                                                                                                                         ((lambda (%%x1457)
                                                                                                                            ((lambda (%%e1458)
                                                                                                                               (if (annotation?
                                                                                                                                     %%e1458)
                                                                                                                                   (annotation-expression
                                                                                                                                     %%e1458)
                                                                                                                                   %%e1458))
                                                                                                                             (if (%%syntax-object?101
                                                                                                                                   %%x1457)
                                                                                                                                 (%%syntax-object-expression102
                                                                                                                                   %%x1457)
                                                                                                                                 %%x1457)))
                                                                                                                          %%id1442))
                                                                                                                       (%%module-binding-val503
                                                                                                                         %%b1446))
                                                                                                                      (if (memv %%t1451
                                                                                                                                '(alias-form))
                                                                                                                          (%%process-exports1438
                                                                                                                            %%fexports1450
                                                                                                                            (lambda ()
                                                                                                                              ((lambda (%%rest1452)
                                                                                                                                 (begin (if (%%indirect-label?398
                                                                                                                                              %%label1448)
                                                                                                                                            (if (not (symbol?
                                                                                                                                                       (%%get-indirect-label402
                                                                                                                                                         %%label1448)))
                                                                                                                                                (syntax-error
                                                                                                                                                  (%%module-binding-id500
                                                                                                                                                    %%b1446)
                                                                                                                                                  '"unexported target of alias")
                                                                                                                                                (void))
                                                                                                                                            (void))
                                                                                                                                        %%rest1452))
                                                                                                                               (%%ctdefs1439))))
                                                                                                                          (error '"(in sc-expand-internal) unexpected module binding type"
                                                                                                                            %%t1447)))))))
                                                                                                    %%t1447)))))
                                                                                       (append
                                                                                         %%imps1449
                                                                                         %%fexports1441)))
                                                                                    (%%module-binding-imps502
                                                                                      %%b1446)))
                                                                                 (%%module-binding-label501
                                                                                   %%b1446)))
                                                                              (%%module-binding-type499
                                                                                %%b1446)))
                                                                         (%%loop1443
                                                                           %%bs1445)))
                                                                   (car %%bs1444)
                                                                   (cdr %%bs1444))))))
                                                    %%loop1443)
                                                  %%bindings1435))
                                               (car %%fexports1440)
                                               (cdr %%fexports1440))))))
                                %%process-exports1438)
                              %%fexports1433
                              (lambda () '())))))
                       (%%flatten-exports487 %%exports1423))))
                   (%%id-set-diff519
                    (lambda (%%exports1420 %%defs1419)
                      (if (null? %%exports1420)
                          '()
                          (if (%%bound-id-member?479
                                (car %%exports1420)
                                %%defs1419)
                              (%%id-set-diff519
                                (cdr %%exports1420)
                                %%defs1419)
                              (cons (car %%exports1420)
                                    (%%id-set-diff519
                                      (cdr %%exports1420)
                                      %%defs1419))))))
                   (%%check-module-exports520
                    (lambda (%%source-exp1394 %%fexports1393 %%ids1392)
                      (letrec ((%%defined?1395
                                (lambda (%%e1397 %%ids1396)
                                  (ormap
                                    (lambda (%%x1398)
                                      (if (%%interface?489 %%x1398)
                                          ((lambda (%%token1399)
                                             (if %%token1399
                                                 (%%lookup-import-binding-name454
                                                   ((lambda (%%x1412)
                                                      ((lambda (%%e1413)
                                                         (if (annotation?
                                                               %%e1413)
                                                             (annotation-expression
                                                               %%e1413)
                                                             %%e1413))
                                                       (if (%%syntax-object?101
                                                             %%x1412)
                                                           (%%syntax-object-expression102
                                                             %%x1412)
                                                           %%x1412)))
                                                    %%e1397)
                                                   %%token1399
                                                   (%%wrap-marks359
                                                     (%%syntax-object-wrap103
                                                       %%e1397)))
                                                 ((lambda (%%v1400)
                                                    ((letrec ((%%lp1401
                                                               (lambda (%%i1402)
                                                                 (if (>= %%i1402
                                                                         '0)
                                                                     ((lambda (%%t1403)
                                                                        (if %%t1403
                                                                            %%t1403
                                                                            (%%lp1401
                                                                              (- %%i1402
                                                                                 '1))))
                                                                      (%%bound-id=?475
                                                                        %%e1397
                                                                        (vector-ref
                                                                          %%v1400
                                                                          %%i1402)))
                                                                     '#f))))
                                                       %%lp1401)
                                                     (- (vector-length
                                                          %%v1400)
                                                        '1)))
                                                  (%%interface-exports490
                                                    %%x1398))))
                                           (%%interface-token491 %%x1398))
                                          (%%bound-id=?475
                                            %%e1397
                                            %%x1398)))
                                    %%ids1396))))
                        ((letrec ((%%loop1414
                                   (lambda (%%fexports1416 %%missing1415)
                                     (if (null? %%fexports1416)
                                         (if (not (null? %%missing1415))
                                             (syntax-error
                                               %%missing1415
                                               '"missing definition for export(s)")
                                             (void))
                                         ((lambda (%%e1418 %%fexports1417)
                                            (if (%%defined?1395
                                                  %%e1418
                                                  %%ids1392)
                                                (%%loop1414
                                                  %%fexports1417
                                                  %%missing1415)
                                                (%%loop1414
                                                  %%fexports1417
                                                  (cons %%e1418
                                                        %%missing1415))))
                                          (car %%fexports1416)
                                          (cdr %%fexports1416))))))
                           %%loop1414)
                         %%fexports1393
                         '()))))
                   (%%check-defined-ids521
                    (lambda (%%source-exp1341 %%ls1340)
                      (letrec ((%%b-i=?1342
                                (lambda (%%x1379 %%y1378)
                                  (if (symbol? %%x1379)
                                      (if (symbol? %%y1378)
                                          (eq? %%x1379 %%y1378)
                                          (if (eq? %%x1379
                                                   ((lambda (%%x1382)
                                                      ((lambda (%%e1383)
                                                         (if (annotation?
                                                               %%e1383)
                                                             (annotation-expression
                                                               %%e1383)
                                                             %%e1383))
                                                       (if (%%syntax-object?101
                                                             %%x1382)
                                                           (%%syntax-object-expression102
                                                             %%x1382)
                                                           %%x1382)))
                                                    %%y1378))
                                              (%%same-marks?464
                                                (%%wrap-marks359
                                                  (%%syntax-object-wrap103
                                                    %%y1378))
                                                (%%wrap-marks359 '((top))))
                                              '#f))
                                      (if (symbol? %%y1378)
                                          (if (eq? %%y1378
                                                   ((lambda (%%x1380)
                                                      ((lambda (%%e1381)
                                                         (if (annotation?
                                                               %%e1381)
                                                             (annotation-expression
                                                               %%e1381)
                                                             %%e1381))
                                                       (if (%%syntax-object?101
                                                             %%x1380)
                                                           (%%syntax-object-expression102
                                                             %%x1380)
                                                           %%x1380)))
                                                    %%x1379))
                                              (%%same-marks?464
                                                (%%wrap-marks359
                                                  (%%syntax-object-wrap103
                                                    %%x1379))
                                                (%%wrap-marks359 '((top))))
                                              '#f)
                                          (%%bound-id=?475
                                            %%x1379
                                            %%y1378)))))
                               (%%vfold1343
                                (lambda (%%v1373 %%p1372 %%cls1371)
                                  ((lambda (%%len1374)
                                     ((letrec ((%%lp1375
                                                (lambda (%%i1377 %%cls1376)
                                                  (if (= %%i1377 %%len1374)
                                                      %%cls1376
                                                      (%%lp1375
                                                        (+ %%i1377 '1)
                                                        (%%p1372
                                                          (vector-ref
                                                            %%v1373
                                                            %%i1377)
                                                          %%cls1376))))))
                                        %%lp1375)
                                      '0
                                      %%cls1371))
                                   (vector-length %%v1373))))
                               (%%conflicts1344
                                (lambda (%%x1356 %%y1355 %%cls1354)
                                  (if (%%interface?489 %%x1356)
                                      (if (%%interface?489 %%y1355)
                                          (call-with-values
                                            (lambda ()
                                              ((lambda (%%xe1362 %%ye1361)
                                                 (if (> (vector-length
                                                          %%xe1362)
                                                        (vector-length
                                                          %%ye1361))
                                                     (values
                                                       %%x1356
                                                       %%ye1361)
                                                     (values
                                                       %%y1355
                                                       %%xe1362)))
                                               (%%interface-exports490
                                                 %%x1356)
                                               (%%interface-exports490
                                                 %%y1355)))
                                            (lambda (%%iface1358
                                                     %%exports1357)
                                              (%%vfold1343
                                                %%exports1357
                                                (lambda (%%id1360
                                                         %%cls1359)
                                                  (%%id-iface-conflicts1345
                                                    %%id1360
                                                    %%iface1358
                                                    %%cls1359))
                                                %%cls1354)))
                                          (%%id-iface-conflicts1345
                                            %%y1355
                                            %%x1356
                                            %%cls1354))
                                      (if (%%interface?489 %%y1355)
                                          (%%id-iface-conflicts1345
                                            %%x1356
                                            %%y1355
                                            %%cls1354)
                                          (if (%%b-i=?1342 %%x1356 %%y1355)
                                              (cons %%x1356 %%cls1354)
                                              %%cls1354)))))
                               (%%id-iface-conflicts1345
                                (lambda (%%id1348 %%iface1347 %%cls1346)
                                  ((lambda (%%token1349)
                                     (if %%token1349
                                         (if (%%lookup-import-binding-name454
                                               ((lambda (%%x1352)
                                                  ((lambda (%%e1353)
                                                     (if (annotation?
                                                           %%e1353)
                                                         (annotation-expression
                                                           %%e1353)
                                                         %%e1353))
                                                   (if (%%syntax-object?101
                                                         %%x1352)
                                                       (%%syntax-object-expression102
                                                         %%x1352)
                                                       %%x1352)))
                                                %%id1348)
                                               %%token1349
                                               (if (symbol? %%id1348)
                                                   (%%wrap-marks359
                                                     '((top)))
                                                   (%%wrap-marks359
                                                     (%%syntax-object-wrap103
                                                       %%id1348))))
                                             (cons %%id1348 %%cls1346)
                                             %%cls1346)
                                         (%%vfold1343
                                           (%%interface-exports490
                                             %%iface1347)
                                           (lambda (%%*id1351 %%cls1350)
                                             (if (%%b-i=?1342
                                                   %%*id1351
                                                   %%id1348)
                                                 (cons %%*id1351 %%cls1350)
                                                 %%cls1350))
                                           %%cls1346)))
                                   (%%interface-token491 %%iface1347)))))
                        (if (not (null? %%ls1340))
                            ((letrec ((%%lp1384
                                       (lambda (%%x1387 %%ls1386 %%cls1385)
                                         (if (null? %%ls1386)
                                             (if (not (null? %%cls1385))
                                                 ((lambda (%%cls1391)
                                                    (syntax-error
                                                      %%source-exp1341
                                                      '"duplicate definition for "
                                                      (symbol->string
                                                        (car %%cls1391))
                                                      '" in"))
                                                  (syntax-object->datum
                                                    %%cls1385))
                                                 (void))
                                             ((letrec ((%%lp21388
                                                        (lambda (%%ls21390
                                                                 %%cls1389)
                                                          (if (null?
                                                                %%ls21390)
                                                              (%%lp1384
                                                                (car %%ls1386)
                                                                (cdr %%ls1386)
                                                                %%cls1389)
                                                              (%%lp21388
                                                                (cdr %%ls21390)
                                                                (%%conflicts1344
                                                                  %%x1387
                                                                  (car %%ls21390)
                                                                  %%cls1389))))))
                                                %%lp21388)
                                              %%ls1386
                                              %%cls1385)))))
                               %%lp1384)
                             (car %%ls1340)
                             (cdr %%ls1340)
                             '())
                            (void)))))
                   (%%chi-external522
                    (lambda (%%ribcage1227
                             %%source-exp1226
                             %%body1225
                             %%r1224
                             %%mr1223
                             %%ctem1222
                             %%exports1221
                             %%fexports1220
                             %%meta-residualize!1219)
                      (letrec ((%%return1228
                                (lambda (%%r1244
                                         %%mr1243
                                         %%bindings1242
                                         %%ids1241
                                         %%inits1240)
                                  (begin (%%check-defined-ids521
                                           %%source-exp1226
                                           %%ids1241)
                                         (%%check-module-exports520
                                           %%source-exp1226
                                           %%fexports1220
                                           %%ids1241)
                                         (values
                                           %%r1244
                                           %%mr1243
                                           %%bindings1242
                                           %%inits1240))))
                               (%%get-implicit-exports1229
                                (lambda (%%id1237)
                                  ((letrec ((%%f1238
                                             (lambda (%%exports1239)
                                               (if (null? %%exports1239)
                                                   '()
                                                   (if (if (pair?
                                                             (car %%exports1239))
                                                           (%%bound-id=?475
                                                             %%id1237
                                                             (caar %%exports1239))
                                                           '#f)
                                                       (%%flatten-exports487
                                                         (cdar %%exports1239))
                                                       (%%f1238
                                                         (cdr %%exports1239)))))))
                                     %%f1238)
                                   %%exports1221)))
                               (%%update-imp-exports1230
                                (lambda (%%bindings1232 %%exports1231)
                                  ((lambda (%%exports1233)
                                     (map (lambda (%%b1234)
                                            ((lambda (%%id1235)
                                               (if (not (%%bound-id-member?479
                                                          %%id1235
                                                          %%exports1233))
                                                   %%b1234
                                                   (%%create-module-binding511
                                                     (%%module-binding-type499
                                                       %%b1234)
                                                     %%id1235
                                                     (%%module-binding-label501
                                                       %%b1234)
                                                     (append
                                                       (%%get-implicit-exports1229
                                                         %%id1235)
                                                       (%%module-binding-imps502
                                                         %%b1234))
                                                     (%%module-binding-val503
                                                       %%b1234))))
                                             (%%module-binding-id500
                                               %%b1234)))
                                          %%bindings1232))
                                   (map (lambda (%%x1236)
                                          (if (pair? %%x1236)
                                              (car %%x1236)
                                              %%x1236))
                                        %%exports1231)))))
                        ((letrec ((%%parse1245
                                   (lambda (%%body1252
                                            %%r1251
                                            %%mr1250
                                            %%ids1249
                                            %%bindings1248
                                            %%inits1247
                                            %%meta-seen?1246)
                                     (if (null? %%body1252)
                                         (%%return1228
                                           %%r1251
                                           %%mr1250
                                           %%bindings1248
                                           %%ids1249
                                           %%inits1247)
                                         ((lambda (%%fr1253)
                                            ((lambda (%%e1254)
                                               ((lambda (%%meta?1255)
                                                  ((lambda ()
                                                     (call-with-values
                                                       (lambda ()
                                                         (%%syntax-type483
                                                           %%e1254
                                                           %%r1251
                                                           '(())
                                                           '#f
                                                           %%ribcage1227))
                                                       (lambda (%%type1260
                                                                %%value1259
                                                                %%e1258
                                                                %%w1257
                                                                %%ae1256)
                                                         ((lambda (%%t1261)
                                                            (if (memv %%t1261
                                                                      '(define-form))
                                                                (call-with-values
                                                                  (lambda ()
                                                                    (%%parse-define544
                                                                      %%e1258
                                                                      %%w1257
                                                                      %%ae1256))
                                                                  (lambda (%%id1320
                                                                           %%rhs1319
                                                                           %%w1318)
                                                                    ((lambda (%%id1321)
                                                                       ((lambda (%%label1322)
                                                                          ((lambda (%%sym1323)
                                                                             ((lambda (%%imps1324)
                                                                                ((lambda ()
                                                                                   (begin (%%extend-ribcage!450
                                                                                            %%ribcage1227
                                                                                            %%id1321
                                                                                            %%label1322)
                                                                                          (if %%meta?1255
                                                                                              ((lambda (%%sym1325)
                                                                                                 ((lambda (%%b1326)
                                                                                                    ((lambda ()
                                                                                                       ((lambda (%%mr1327)
                                                                                                          ((lambda (%%exp1328)
                                                                                                             (begin (%%define-top-level-value-hook171
                                                                                                                      %%sym1325
                                                                                                                      (%%top-level-eval-hook169
                                                                                                                        %%exp1328))
                                                                                                                    (%%meta-residualize!1219
                                                                                                                      (%%ct-eval/residualize3530
                                                                                                                        %%ctem1222
                                                                                                                        void
                                                                                                                        (lambda ()
                                                                                                                          (build-source
                                                                                                                            '#f
                                                                                                                            (list (build-source
                                                                                                                                    '#f
                                                                                                                                    'define)
                                                                                                                                  (build-source
                                                                                                                                    '#f
                                                                                                                                    %%sym1325)
                                                                                                                                  %%exp1328)))))
                                                                                                                    (%%parse1245
                                                                                                                      (cdr %%body1252)
                                                                                                                      %%r1251
                                                                                                                      %%mr1327
                                                                                                                      (cons %%id1321
                                                                                                                            %%ids1249)
                                                                                                                      (cons (%%create-module-binding511
                                                                                                                              'ctdefine-form
                                                                                                                              %%id1321
                                                                                                                              %%label1322
                                                                                                                              %%imps1324
                                                                                                                              %%b1326)
                                                                                                                            %%bindings1248)
                                                                                                                      %%inits1247
                                                                                                                      '#f)))
                                                                                                           (%%chi534
                                                                                                             %%rhs1319
                                                                                                             %%mr1327
                                                                                                             %%mr1327
                                                                                                             %%w1318
                                                                                                             '#t)))
                                                                                                        (%%extend-env335
                                                                                                          (%%get-indirect-label402
                                                                                                            %%label1322)
                                                                                                          %%b1326
                                                                                                          %%mr1250)))))
                                                                                                  (cons 'meta-variable
                                                                                                        %%sym1325)))
                                                                                               (%%generate-id182
                                                                                                 ((lambda (%%x1336)
                                                                                                    ((lambda (%%e1337)
                                                                                                       (if (annotation?
                                                                                                             %%e1337)
                                                                                                           (annotation-expression
                                                                                                             %%e1337)
                                                                                                           %%e1337))
                                                                                                     (if (%%syntax-object?101
                                                                                                           %%x1336)
                                                                                                         (%%syntax-object-expression102
                                                                                                           %%x1336)
                                                                                                         %%x1336)))
                                                                                                  %%id1321)))
                                                                                              (%%parse1245
                                                                                                (cdr %%body1252)
                                                                                                %%r1251
                                                                                                %%mr1250
                                                                                                (cons %%id1321
                                                                                                      %%ids1249)
                                                                                                (cons (%%create-module-binding511
                                                                                                        %%type1260
                                                                                                        %%id1321
                                                                                                        %%label1322
                                                                                                        %%imps1324
                                                                                                        (%%make-frob512
                                                                                                          (%%wrap480
                                                                                                            %%rhs1319
                                                                                                            %%w1318)
                                                                                                          %%meta?1255))
                                                                                                      %%bindings1248)
                                                                                                %%inits1247
                                                                                                '#f))))))
                                                                              (%%get-implicit-exports1229
                                                                                %%id1321)))
                                                                           (%%generate-id182
                                                                             ((lambda (%%x1338)
                                                                                ((lambda (%%e1339)
                                                                                   (if (annotation?
                                                                                         %%e1339)
                                                                                       (annotation-expression
                                                                                         %%e1339)
                                                                                       %%e1339))
                                                                                 (if (%%syntax-object?101
                                                                                       %%x1338)
                                                                                     (%%syntax-object-expression102
                                                                                       %%x1338)
                                                                                     %%x1338)))
                                                                              %%id1321))))
                                                                        (%%gen-indirect-label401)))
                                                                     (%%wrap480
                                                                       %%id1320
                                                                       %%w1318))))
                                                                (if (memv %%t1261
                                                                          '(define-syntax-form))
                                                                    (call-with-values
                                                                      (lambda ()
                                                                        (%%parse-define-syntax545
                                                                          %%e1258
                                                                          %%w1257
                                                                          %%ae1256))
                                                                      (lambda (%%id1311
                                                                               %%rhs1310
                                                                               %%w1309)
                                                                        ((lambda (%%id1312)
                                                                           ((lambda (%%label1313)
                                                                              ((lambda (%%imps1314)
                                                                                 ((lambda (%%exp1315)
                                                                                    ((lambda ()
                                                                                       (begin (%%extend-ribcage!450
                                                                                                %%ribcage1227
                                                                                                %%id1312
                                                                                                %%label1313)
                                                                                              ((lambda (%%l1317
                                                                                                        %%b1316)
                                                                                                 (%%parse1245
                                                                                                   (cdr %%body1252)
                                                                                                   (%%extend-env335
                                                                                                     %%l1317
                                                                                                     %%b1316
                                                                                                     %%r1251)
                                                                                                   (%%extend-env335
                                                                                                     %%l1317
                                                                                                     %%b1316
                                                                                                     %%mr1250)
                                                                                                   (cons %%id1312
                                                                                                         %%ids1249)
                                                                                                   (cons (%%create-module-binding511
                                                                                                           %%type1260
                                                                                                           %%id1312
                                                                                                           %%label1313
                                                                                                           %%imps1314
                                                                                                           (cons %%b1316
                                                                                                                 %%exp1315))
                                                                                                         %%bindings1248)
                                                                                                   %%inits1247
                                                                                                   '#f))
                                                                                               (%%get-indirect-label402
                                                                                                 %%label1313)
                                                                                               (%%defer-or-eval-transformer343
                                                                                                 %%top-level-eval-hook169
                                                                                                 %%exp1315))))))
                                                                                  (%%chi534
                                                                                    %%rhs1310
                                                                                    %%mr1250
                                                                                    %%mr1250
                                                                                    %%w1309
                                                                                    '#t)))
                                                                               (%%get-implicit-exports1229
                                                                                 %%id1312)))
                                                                            (%%gen-indirect-label401)))
                                                                         (%%wrap480
                                                                           %%id1311
                                                                           %%w1309))))
                                                                    (if (memv %%t1261
                                                                              '($module-form))
                                                                        ((lambda (%%*ribcage1291)
                                                                           ((lambda (%%*w1292)
                                                                              ((lambda ()
                                                                                 (call-with-values
                                                                                   (lambda ()
                                                                                     (%%parse-module542
                                                                                       %%e1258
                                                                                       %%w1257
                                                                                       %%ae1256
                                                                                       %%*w1292))
                                                                                   (lambda (%%orig1296
                                                                                            %%id1295
                                                                                            %%*exports1294
                                                                                            %%forms1293)
                                                                                     (call-with-values
                                                                                       (lambda ()
                                                                                         (%%chi-external522
                                                                                           %%*ribcage1291
                                                                                           %%orig1296
                                                                                           (map (lambda (%%d1308)
                                                                                                  (%%make-frob512
                                                                                                    %%d1308
                                                                                                    %%meta?1255))
                                                                                                %%forms1293)
                                                                                           %%r1251
                                                                                           %%mr1250
                                                                                           %%ctem1222
                                                                                           %%*exports1294
                                                                                           (%%flatten-exports487
                                                                                             %%*exports1294)
                                                                                           %%meta-residualize!1219))
                                                                                       (lambda (%%r1300
                                                                                                %%mr1299
                                                                                                %%*bindings1298
                                                                                                %%*inits1297)
                                                                                         ((lambda (%%iface1301)
                                                                                            ((lambda (%%bindings1302)
                                                                                               ((lambda (%%inits1303)
                                                                                                  ((lambda ()
                                                                                                     ((lambda (%%label1305
                                                                                                               %%imps1304)
                                                                                                        (begin (%%extend-ribcage!450
                                                                                                                 %%ribcage1227
                                                                                                                 %%id1295
                                                                                                                 %%label1305)
                                                                                                               ((lambda (%%l1307
                                                                                                                         %%b1306)
                                                                                                                  (%%parse1245
                                                                                                                    (cdr %%body1252)
                                                                                                                    (%%extend-env335
                                                                                                                      %%l1307
                                                                                                                      %%b1306
                                                                                                                      %%r1300)
                                                                                                                    (%%extend-env335
                                                                                                                      %%l1307
                                                                                                                      %%b1306
                                                                                                                      %%mr1299)
                                                                                                                    (cons %%id1295
                                                                                                                          %%ids1249)
                                                                                                                    (cons (%%create-module-binding511
                                                                                                                            %%type1260
                                                                                                                            %%id1295
                                                                                                                            %%label1305
                                                                                                                            %%imps1304
                                                                                                                            %%*exports1294)
                                                                                                                          %%bindings1302)
                                                                                                                    %%inits1303
                                                                                                                    '#f))
                                                                                                                (%%get-indirect-label402
                                                                                                                  %%label1305)
                                                                                                                (cons '$module
                                                                                                                      %%iface1301))))
                                                                                                      (%%gen-indirect-label401)
                                                                                                      (%%get-implicit-exports1229
                                                                                                        %%id1295)))))
                                                                                                (append
                                                                                                  %%inits1247
                                                                                                  %%*inits1297)))
                                                                                             (append
                                                                                               %%*bindings1298
                                                                                               %%bindings1248)))
                                                                                          (%%make-unresolved-interface494
                                                                                            %%*exports1294)))))))))
                                                                            (%%make-wrap358
                                                                              (%%wrap-marks359
                                                                                %%w1257)
                                                                              (cons %%*ribcage1291
                                                                                    (%%wrap-subst360
                                                                                      %%w1257)))))
                                                                         (%%make-ribcage407
                                                                           '()
                                                                           '()
                                                                           '()))
                                                                        (if (memv %%t1261
                                                                                  '($import-form))
                                                                            (call-with-values
                                                                              (lambda ()
                                                                                (%%parse-import543
                                                                                  %%e1258
                                                                                  %%w1257
                                                                                  %%ae1256))
                                                                              (lambda (%%orig1286
                                                                                       %%only?1285
                                                                                       %%mid1284)
                                                                                ((lambda (%%mlabel1287)
                                                                                   ((lambda (%%binding1288)
                                                                                      ((lambda (%%t1289)
                                                                                         (if (memv %%t1289
                                                                                                   '($module))
                                                                                             ((lambda (%%iface1290)
                                                                                                (begin (if %%only?1285
                                                                                                           (%%extend-ribcage-barrier!451
                                                                                                             %%ribcage1227
                                                                                                             %%mid1284)
                                                                                                           (void))
                                                                                                       (%%do-import!541
                                                                                                         %%iface1290
                                                                                                         %%ribcage1227)
                                                                                                       (%%parse1245
                                                                                                         (cdr %%body1252)
                                                                                                         %%r1251
                                                                                                         %%mr1250
                                                                                                         (cons %%iface1290
                                                                                                               %%ids1249)
                                                                                                         (%%update-imp-exports1230
                                                                                                           %%bindings1248
                                                                                                           (vector->list
                                                                                                             (%%interface-exports490
                                                                                                               %%iface1290)))
                                                                                                         %%inits1247
                                                                                                         '#f)))
                                                                                              (%%binding-value322
                                                                                                %%binding1288))
                                                                                             (if (memv %%t1289
                                                                                                       '(displaced-lexical))
                                                                                                 (%%displaced-lexical-error339
                                                                                                   %%mid1284)
                                                                                                 (syntax-error
                                                                                                   %%mid1284
                                                                                                   '"unknown module"))))
                                                                                       (%%binding-type321
                                                                                         %%binding1288)))
                                                                                    (%%lookup341
                                                                                      %%mlabel1287
                                                                                      %%r1251)))
                                                                                 (%%id-var-name472
                                                                                   %%mid1284
                                                                                   '(())))))
                                                                            (if (memv %%t1261
                                                                                      '(alias-form))
                                                                                (call-with-values
                                                                                  (lambda ()
                                                                                    (%%parse-alias548
                                                                                      %%e1258
                                                                                      %%w1257
                                                                                      %%ae1256))
                                                                                  (lambda (%%new-id1280
                                                                                           %%old-id1279)
                                                                                    ((lambda (%%new-id1281)
                                                                                       ((lambda (%%label1282)
                                                                                          ((lambda (%%imps1283)
                                                                                             ((lambda ()
                                                                                                (begin (%%extend-ribcage!450
                                                                                                         %%ribcage1227
                                                                                                         %%new-id1281
                                                                                                         %%label1282)
                                                                                                       (%%parse1245
                                                                                                         (cdr %%body1252)
                                                                                                         %%r1251
                                                                                                         %%mr1250
                                                                                                         (cons %%new-id1281
                                                                                                               %%ids1249)
                                                                                                         (cons (%%create-module-binding511
                                                                                                                 %%type1260
                                                                                                                 %%new-id1281
                                                                                                                 %%label1282
                                                                                                                 %%imps1283
                                                                                                                 '#f)
                                                                                                               %%bindings1248)
                                                                                                         %%inits1247
                                                                                                         '#f)))))
                                                                                           (%%get-implicit-exports1229
                                                                                             %%new-id1281)))
                                                                                        (%%id-var-name-loc471
                                                                                          %%old-id1279
                                                                                          %%w1257)))
                                                                                     (%%wrap480
                                                                                       %%new-id1280
                                                                                       %%w1257))))
                                                                                (if (memv %%t1261
                                                                                          '(begin-form))
                                                                                    (%%parse1245
                                                                                      ((letrec ((%%f1277
                                                                                                 (lambda (%%forms1278)
                                                                                                   (if (null?
                                                                                                         %%forms1278)
                                                                                                       (cdr %%body1252)
                                                                                                       (cons (%%make-frob512
                                                                                                               (%%wrap480
                                                                                                                 (car %%forms1278)
                                                                                                                 %%w1257)
                                                                                                               %%meta?1255)
                                                                                                             (%%f1277
                                                                                                               (cdr %%forms1278)))))))
                                                                                         %%f1277)
                                                                                       (%%parse-begin549
                                                                                         %%e1258
                                                                                         %%w1257
                                                                                         %%ae1256
                                                                                         '#t))
                                                                                      %%r1251
                                                                                      %%mr1250
                                                                                      %%ids1249
                                                                                      %%bindings1248
                                                                                      %%inits1247
                                                                                      '#f)
                                                                                    (if (memv %%t1261
                                                                                              '(eval-when-form))
                                                                                        (call-with-values
                                                                                          (lambda ()
                                                                                            (%%parse-eval-when547
                                                                                              %%e1258
                                                                                              %%w1257
                                                                                              %%ae1256))
                                                                                          (lambda (%%when-list1274
                                                                                                   %%forms1273)
                                                                                            (%%parse1245
                                                                                              (if (memq 'eval
                                                                                                        %%when-list1274)
                                                                                                  ((letrec ((%%f1275
                                                                                                             (lambda (%%forms1276)
                                                                                                               (if (null?
                                                                                                                     %%forms1276)
                                                                                                                   (cdr %%body1252)
                                                                                                                   (cons (%%make-frob512
                                                                                                                           (%%wrap480
                                                                                                                             (car %%forms1276)
                                                                                                                             %%w1257)
                                                                                                                           %%meta?1255)
                                                                                                                         (%%f1275
                                                                                                                           (cdr %%forms1276)))))))
                                                                                                     %%f1275)
                                                                                                   %%forms1273)
                                                                                                  (cdr %%body1252))
                                                                                              %%r1251
                                                                                              %%mr1250
                                                                                              %%ids1249
                                                                                              %%bindings1248
                                                                                              %%inits1247
                                                                                              '#f)))
                                                                                        (if (memv %%t1261
                                                                                                  '(meta-form))
                                                                                            (%%parse1245
                                                                                              (cons (%%make-frob512
                                                                                                      (%%wrap480
                                                                                                        (%%parse-meta546
                                                                                                          %%e1258
                                                                                                          %%w1257
                                                                                                          %%ae1256)
                                                                                                        %%w1257)
                                                                                                      '#t)
                                                                                                    (cdr %%body1252))
                                                                                              %%r1251
                                                                                              %%mr1250
                                                                                              %%ids1249
                                                                                              %%bindings1248
                                                                                              %%inits1247
                                                                                              '#t)
                                                                                            (if (memv %%t1261
                                                                                                      '(local-syntax-form))
                                                                                                (call-with-values
                                                                                                  (lambda ()
                                                                                                    (%%chi-local-syntax551
                                                                                                      %%value1259
                                                                                                      %%e1258
                                                                                                      %%r1251
                                                                                                      %%mr1250
                                                                                                      %%w1257
                                                                                                      %%ae1256))
                                                                                                  (lambda (%%forms1270
                                                                                                           %%r1269
                                                                                                           %%mr1268
                                                                                                           %%w1267
                                                                                                           %%ae1266)
                                                                                                    (%%parse1245
                                                                                                      ((letrec ((%%f1271
                                                                                                                 (lambda (%%forms1272)
                                                                                                                   (if (null?
                                                                                                                         %%forms1272)
                                                                                                                       (cdr %%body1252)
                                                                                                                       (cons (%%make-frob512
                                                                                                                               (%%wrap480
                                                                                                                                 (car %%forms1272)
                                                                                                                                 %%w1267)
                                                                                                                               %%meta?1255)
                                                                                                                             (%%f1271
                                                                                                                               (cdr %%forms1272)))))))
                                                                                                         %%f1271)
                                                                                                       %%forms1270)
                                                                                                      %%r1269
                                                                                                      %%mr1268
                                                                                                      %%ids1249
                                                                                                      %%bindings1248
                                                                                                      %%inits1247
                                                                                                      '#f)))
                                                                                                (begin (if %%meta-seen?1246
                                                                                                           (syntax-error
                                                                                                             (%%source-wrap481
                                                                                                               %%e1258
                                                                                                               %%w1257
                                                                                                               %%ae1256)
                                                                                                             '"invalid meta definition")
                                                                                                           (void))
                                                                                                       ((letrec ((%%f1262
                                                                                                                  (lambda (%%body1263)
                                                                                                                    (if ((lambda (%%t1265)
                                                                                                                           (if %%t1265
                                                                                                                               %%t1265
                                                                                                                               (not (%%frob-meta?515
                                                                                                                                      (car %%body1263)))))
                                                                                                                         (null?
                                                                                                                           %%body1263))
                                                                                                                        (%%return1228
                                                                                                                          %%r1251
                                                                                                                          %%mr1250
                                                                                                                          %%bindings1248
                                                                                                                          %%ids1249
                                                                                                                          (append
                                                                                                                            %%inits1247
                                                                                                                            %%body1263))
                                                                                                                        (begin ((lambda (%%x1264)
                                                                                                                                  (begin (%%top-level-eval-hook169
                                                                                                                                           %%x1264)
                                                                                                                                         (%%meta-residualize!1219
                                                                                                                                           (%%ct-eval/residualize3530
                                                                                                                                             %%ctem1222
                                                                                                                                             void
                                                                                                                                             (lambda ()
                                                                                                                                               %%x1264)))))
                                                                                                                                (%%chi-meta-frob532
                                                                                                                                  (car %%body1263)
                                                                                                                                  %%mr1250))
                                                                                                                               (%%f1262
                                                                                                                                 (cdr %%body1263)))))))
                                                                                                          %%f1262)
                                                                                                        (cons (%%make-frob512
                                                                                                                (%%source-wrap481
                                                                                                                  %%e1258
                                                                                                                  %%w1257
                                                                                                                  %%ae1256)
                                                                                                                %%meta?1255)
                                                                                                              (cdr %%body1252))))))))))))))
                                                          %%type1260))))))
                                                (%%frob-meta?515
                                                  %%fr1253)))
                                             (%%frob-e514 %%fr1253)))
                                          (car %%body1252))))))
                           %%parse1245)
                         %%body1225
                         %%r1224
                         %%mr1223
                         '()
                         '()
                         '()
                         '#f))))
                   (%%vmap523
                    (lambda (%%fn1199 %%v1198)
                      ((letrec ((%%do1200
                                 (lambda (%%i1202 %%ls1201)
                                   (if (< %%i1202 '0)
                                       %%ls1201
                                       (%%do1200
                                         (- %%i1202 '1)
                                         (cons (%%fn1199
                                                 (vector-ref
                                                   %%v1198
                                                   %%i1202))
                                               %%ls1201))))))
                         %%do1200)
                       (- (vector-length %%v1198) '1)
                       '())))
                   (%%vfor-each524
                    (lambda (%%fn1194 %%v1193)
                      ((lambda (%%len1195)
                         ((letrec ((%%do1196
                                    (lambda (%%i1197)
                                      (if (not (= %%i1197 %%len1195))
                                          (begin (%%fn1194
                                                   (vector-ref
                                                     %%v1193
                                                     %%i1197))
                                                 (%%do1196 (+ %%i1197 '1)))
                                          (void)))))
                            %%do1196)
                          '0))
                       (vector-length %%v1193))))
                   (%%do-top-import525
                    (lambda (%%import-only?1185
                             %%top-ribcage1184
                             %%mid1183
                             %%token1182)
                      (list (build-source '#f '$sc-put-cte)
                            (list 'quote %%mid1183)
                            (build-source
                              '#f
                              (list (build-source '#f 'quote)
                                    (attach-source
                                      '#f
                                      (cons 'do-import
                                            (cons %%import-only?1185
                                                  %%token1182)))))
                            (build-source
                              '#f
                              (list (build-source '#f 'quote)
                                    (%%top-ribcage-key417
                                      %%top-ribcage1184))))))
                   (%%update-mode-set526
                    ((lambda (%%table1176)
                       (lambda (%%when-list1178 %%mode-set1177)
                         (remq '-
                               (apply
                                 append
                                 (map (lambda (%%m1179)
                                        ((lambda (%%row1180)
                                           (map (lambda (%%s1181)
                                                  (cdr (assq %%s1181
                                                             %%row1180)))
                                                %%when-list1178))
                                         (cdr (assq %%m1179 %%table1176))))
                                      %%mode-set1177)))))
                     '((l (load . l)
                          (compile . c)
                          (visit . v)
                          (revisit . r)
                          (eval . -))
                       (c (load . -)
                          (compile . -)
                          (visit . -)
                          (revisit . -)
                          (eval . c))
                       (v (load . v)
                          (compile . c)
                          (visit . v)
                          (revisit . -)
                          (eval . -))
                       (r (load . r)
                          (compile . c)
                          (visit . -)
                          (revisit . r)
                          (eval . -))
                       (e (load . -)
                          (compile . -)
                          (visit . -)
                          (revisit . -)
                          (eval . e)))))
                   (%%initial-mode-set527
                    (lambda (%%when-list1172 %%compiling-a-file1171)
                      (apply
                        append
                        (map (lambda (%%s1173)
                               (if %%compiling-a-file1171
                                   ((lambda (%%t1175)
                                      (if (memv %%t1175 '(compile))
                                          '(c)
                                          (if (memv %%t1175 '(load))
                                              '(l)
                                              (if (memv %%t1175 '(visit))
                                                  '(v)
                                                  (if (memv %%t1175
                                                            '(revisit))
                                                      '(r)
                                                      '())))))
                                    %%s1173)
                                   ((lambda (%%t1174)
                                      (if (memv %%t1174 '(eval)) '(e) '()))
                                    %%s1173)))
                             %%when-list1172))))
                   (%%rt-eval/residualize528
                    (lambda (%%rtem1166 %%thunk1165)
                      (if (memq 'e %%rtem1166)
                          (%%thunk1165)
                          ((lambda (%%thunk1167)
                             (if (memq 'v %%rtem1166)
                                 (if ((lambda (%%t1169)
                                        (if %%t1169
                                            %%t1169
                                            (memq 'r %%rtem1166)))
                                      (memq 'l %%rtem1166))
                                     (%%thunk1167)
                                     (%%thunk1167))
                                 (if ((lambda (%%t1168)
                                        (if %%t1168
                                            %%t1168
                                            (memq 'r %%rtem1166)))
                                      (memq 'l %%rtem1166))
                                     (%%thunk1167)
                                     (%%chi-void552))))
                           (if (memq 'c %%rtem1166)
                               ((lambda (%%x1170)
                                  (begin (%%top-level-eval-hook169 %%x1170)
                                         (lambda () %%x1170)))
                                (%%thunk1165))
                               %%thunk1165)))))
                   (%%ct-eval/residualize2529
                    (lambda (%%ctem1162 %%thunk1161)
                      ((lambda (%%t1163)
                         (%%ct-eval/residualize3530
                           %%ctem1162
                           (lambda ()
                             (begin (if (not %%t1163)
                                        (set! %%t1163 (%%thunk1161))
                                        (void))
                                    (%%top-level-eval-hook169 %%t1163)))
                           (lambda ()
                             ((lambda (%%t1164)
                                (if %%t1164 %%t1164 (%%thunk1161)))
                              %%t1163))))
                       '#f)))
                   (%%ct-eval/residualize3530
                    (lambda (%%ctem1148
                             %%eval-thunk1147
                             %%residualize-thunk1146)
                      (if (memq 'e %%ctem1148)
                          (begin (%%eval-thunk1147) (%%chi-void552))
                          (begin (if (memq 'c %%ctem1148)
                                     (%%eval-thunk1147)
                                     (void))
                                 (if (memq 'r %%ctem1148)
                                     (if ((lambda (%%t1160)
                                            (if %%t1160
                                                %%t1160
                                                (memq 'v %%ctem1148)))
                                          (memq 'l %%ctem1148))
                                         (%%residualize-thunk1146)
                                         (%%residualize-thunk1146))
                                     (if ((lambda (%%t1154)
                                            (if %%t1154
                                                %%t1154
                                                (memq 'v %%ctem1148)))
                                          (memq 'l %%ctem1148))
                                         (%%residualize-thunk1146)
                                         (%%chi-void552)))))))
                   (%%chi-frobs531
                    (lambda (%%frob*1144 %%r1143 %%mr1142 %%m?1141)
                      (map (lambda (%%x1145)
                             (%%chi534
                               (%%frob-e514 %%x1145)
                               %%r1143
                               %%mr1142
                               '(())
                               %%m?1141))
                           %%frob*1144)))
                   (%%chi-meta-frob532
                    (lambda (%%x1140 %%mr1139)
                      (%%chi534
                        (%%frob-e514 %%x1140)
                        %%mr1139
                        %%mr1139
                        '(())
                        '#t)))
                   (%%chi-sequence533
                    (lambda (%%body1135
                             %%r1134
                             %%mr1133
                             %%w1132
                             %%ae1131
                             %%m?1130)
                      (%%build-sequence275
                        %%ae1131
                        ((letrec ((%%dobody1136
                                   (lambda (%%body1137)
                                     (if (null? %%body1137)
                                         '()
                                         ((lambda (%%first1138)
                                            (cons %%first1138
                                                  (%%dobody1136
                                                    (cdr %%body1137))))
                                          (%%chi534
                                            (car %%body1137)
                                            %%r1134
                                            %%mr1133
                                            %%w1132
                                            %%m?1130))))))
                           %%dobody1136)
                         %%body1135))))
                   (%%chi534
                    (lambda (%%e1124 %%r1123 %%mr1122 %%w1121 %%m?1120)
                      (call-with-values
                        (lambda ()
                          (%%syntax-type483
                            %%e1124
                            %%r1123
                            %%w1121
                            '#f
                            '#f))
                        (lambda (%%type1129
                                 %%value1128
                                 %%e1127
                                 %%w1126
                                 %%ae1125)
                          (%%chi-expr535
                            %%type1129
                            %%value1128
                            %%e1127
                            %%r1123
                            %%mr1122
                            %%w1126
                            %%ae1125
                            %%m?1120)))))
                   (%%chi-expr535
                    (lambda (%%type1084
                             %%value1083
                             %%e1082
                             %%r1081
                             %%mr1080
                             %%w1079
                             %%ae1078
                             %%m?1077)
                      ((lambda (%%t1085)
                         (if (memv %%t1085 '(lexical))
                             (build-source %%ae1078 %%value1083)
                             (if (memv %%t1085 '(core))
                                 (%%value1083
                                   %%e1082
                                   %%r1081
                                   %%mr1080
                                   %%w1079
                                   %%ae1078
                                   %%m?1077)
                                 (if (memv %%t1085 '(lexical-call))
                                     (%%chi-application536
                                       (build-source
                                         ((lambda (%%x1119)
                                            (if (%%syntax-object?101
                                                  %%x1119)
                                                (%%syntax-object-expression102
                                                  %%x1119)
                                                %%x1119))
                                          (car %%e1082))
                                         %%value1083)
                                       %%e1082
                                       %%r1081
                                       %%mr1080
                                       %%w1079
                                       %%ae1078
                                       %%m?1077)
                                     (if (memv %%t1085 '(constant))
                                         (build-source
                                           %%ae1078
                                           (list (build-source
                                                   %%ae1078
                                                   'quote)
                                                 (attach-source
                                                   %%ae1078
                                                   (%%strip556
                                                     (%%source-wrap481
                                                       %%e1082
                                                       %%w1079
                                                       %%ae1078)
                                                     '(())))))
                                         (if (memv %%t1085 '(global))
                                             (build-source
                                               %%ae1078
                                               %%value1083)
                                             (if (memv %%t1085
                                                       '(meta-variable))
                                                 (if %%m?1077
                                                     (build-source
                                                       %%ae1078
                                                       %%value1083)
                                                     (%%displaced-lexical-error339
                                                       (%%source-wrap481
                                                         %%e1082
                                                         %%w1079
                                                         %%ae1078)))
                                                 (if (memv %%t1085 '(call))
                                                     (%%chi-application536
                                                       (%%chi534
                                                         (car %%e1082)
                                                         %%r1081
                                                         %%mr1080
                                                         %%w1079
                                                         %%m?1077)
                                                       %%e1082
                                                       %%r1081
                                                       %%mr1080
                                                       %%w1079
                                                       %%ae1078
                                                       %%m?1077)
                                                     (if (memv %%t1085
                                                               '(begin-form))
                                                         (%%chi-sequence533
                                                           (%%parse-begin549
                                                             %%e1082
                                                             %%w1079
                                                             %%ae1078
                                                             '#f)
                                                           %%r1081
                                                           %%mr1080
                                                           %%w1079
                                                           %%ae1078
                                                           %%m?1077)
                                                         (if (memv %%t1085
                                                                   '(local-syntax-form))
                                                             (call-with-values
                                                               (lambda ()
                                                                 (%%chi-local-syntax551
                                                                   %%value1083
                                                                   %%e1082
                                                                   %%r1081
                                                                   %%mr1080
                                                                   %%w1079
                                                                   %%ae1078))
                                                               (lambda (%%forms1099
                                                                        %%r1098
                                                                        %%mr1097
                                                                        %%w1096
                                                                        %%ae1095)
                                                                 (%%chi-sequence533
                                                                   %%forms1099
                                                                   %%r1098
                                                                   %%mr1097
                                                                   %%w1096
                                                                   %%ae1095
                                                                   %%m?1077)))
                                                             (if (memv %%t1085
                                                                       '(eval-when-form))
                                                                 (call-with-values
                                                                   (lambda ()
                                                                     (%%parse-eval-when547
                                                                       %%e1082
                                                                       %%w1079
                                                                       %%ae1078))
                                                                   (lambda (%%when-list1094
                                                                            %%forms1093)
                                                                     (if (memq 'eval
                                                                               %%when-list1094)
                                                                         (%%chi-sequence533
                                                                           %%forms1093
                                                                           %%r1081
                                                                           %%mr1080
                                                                           %%w1079
                                                                           %%ae1078
                                                                           %%m?1077)
                                                                         (%%chi-void552))))
                                                                 (if (memv %%t1085
                                                                           '(meta-form))
                                                                     (syntax-error
                                                                       (%%source-wrap481
                                                                         %%e1082
                                                                         %%w1079
                                                                         %%ae1078)
                                                                       '"invalid context for meta definition")
                                                                     (if (memv %%t1085
                                                                               '(define-form))
                                                                         (begin (%%parse-define544
                                                                                  %%e1082
                                                                                  %%w1079
                                                                                  %%ae1078)
                                                                                (syntax-error
                                                                                  (%%source-wrap481
                                                                                    %%e1082
                                                                                    %%w1079
                                                                                    %%ae1078)
                                                                                  '"invalid context for definition"))
                                                                         (if (memv %%t1085
                                                                                   '(define-syntax-form))
                                                                             (begin (%%parse-define-syntax545
                                                                                      %%e1082
                                                                                      %%w1079
                                                                                      %%ae1078)
                                                                                    (syntax-error
                                                                                      (%%source-wrap481
                                                                                        %%e1082
                                                                                        %%w1079
                                                                                        %%ae1078)
                                                                                      '"invalid context for definition"))
                                                                             (if (memv %%t1085
                                                                                       '($module-form))
                                                                                 (call-with-values
                                                                                   (lambda ()
                                                                                     (%%parse-module542
                                                                                       %%e1082
                                                                                       %%w1079
                                                                                       %%ae1078
                                                                                       %%w1079))
                                                                                   (lambda (%%orig1092
                                                                                            %%id1091
                                                                                            %%exports1090
                                                                                            %%forms1089)
                                                                                     (syntax-error
                                                                                       %%orig1092
                                                                                       '"invalid context for definition")))
                                                                                 (if (memv %%t1085
                                                                                           '($import-form))
                                                                                     (call-with-values
                                                                                       (lambda ()
                                                                                         (%%parse-import543
                                                                                           %%e1082
                                                                                           %%w1079
                                                                                           %%ae1078))
                                                                                       (lambda (%%orig1088
                                                                                                %%only?1087
                                                                                                %%mid1086)
                                                                                         (syntax-error
                                                                                           %%orig1088
                                                                                           '"invalid context for definition")))
                                                                                     (if (memv %%t1085
                                                                                               '(alias-form))
                                                                                         (begin (%%parse-alias548
                                                                                                  %%e1082
                                                                                                  %%w1079
                                                                                                  %%ae1078)
                                                                                                (syntax-error
                                                                                                  (%%source-wrap481
                                                                                                    %%e1082
                                                                                                    %%w1079
                                                                                                    %%ae1078)
                                                                                                  '"invalid context for definition"))
                                                                                         (if (memv %%t1085
                                                                                                   '(syntax))
                                                                                             (syntax-error
                                                                                               (%%source-wrap481
                                                                                                 %%e1082
                                                                                                 %%w1079
                                                                                                 %%ae1078)
                                                                                               '"reference to pattern variable outside syntax form")
                                                                                             (if (memv %%t1085
                                                                                                       '(displaced-lexical))
                                                                                                 (%%displaced-lexical-error339
                                                                                                   (%%source-wrap481
                                                                                                     %%e1082
                                                                                                     %%w1079
                                                                                                     %%ae1078))
                                                                                                 (syntax-error
                                                                                                   (%%source-wrap481
                                                                                                     %%e1082
                                                                                                     %%w1079
                                                                                                     %%ae1078)))))))))))))))))))))
                       %%type1084)))
                   (%%chi-application536
                    (lambda (%%x1069
                             %%e1068
                             %%r1067
                             %%mr1066
                             %%w1065
                             %%ae1064
                             %%m?1063)
                      ((lambda (%%tmp1070)
                         ((lambda (%%tmp1071)
                            (if %%tmp1071
                                (apply
                                  (lambda (%%e01074 %%e11073)
                                    (build-source
                                      %%ae1064
                                      (cons %%x1069
                                            (map (lambda (%%e1076)
                                                   (%%chi534
                                                     %%e1076
                                                     %%r1067
                                                     %%mr1066
                                                     %%w1065
                                                     %%m?1063))
                                                 %%e11073))))
                                  %%tmp1071)
                                ((lambda (%%_1072)
                                   (syntax-error
                                     (%%source-wrap481
                                       %%e1068
                                       %%w1065
                                       %%ae1064)))
                                 %%tmp1070)))
                          ($syntax-dispatch %%tmp1070 '(any . each-any))))
                       %%e1068)))
                   (%%chi-set!537
                    (lambda (%%e1023 %%r1022 %%w1021 %%ae1020 %%rib1019)
                      ((lambda (%%tmp1024)
                         ((lambda (%%tmp1025)
                            (if (if %%tmp1025
                                    (apply
                                      (lambda (%%_1062 %%id1061 %%val1060)
                                        (%%id?346 %%id1061))
                                      %%tmp1025)
                                    '#f)
                                (apply
                                  (lambda (%%_1029 %%id1028 %%val1027)
                                    ((lambda (%%n1030)
                                       ((lambda (%%b1031)
                                          ((lambda (%%t1032)
                                             (if (memv %%t1032 '(macro!))
                                                 ((lambda (%%id1059
                                                           %%val1058)
                                                    (%%syntax-type483
                                                      (%%chi-macro538
                                                        (%%binding-value322
                                                          %%b1031)
                                                        (list '#(syntax-object
                                                                 set!
                                                                 ((top)
                                                                  #(ribcage
                                                                    ()
                                                                    ()
                                                                    ())
                                                                  #(ribcage
                                                                    #(id
                                                                      val)
                                                                    #((top)
                                                                      (top))
                                                                    #("i"
                                                                      "i"))
                                                                  #(ribcage
                                                                    ()
                                                                    ()
                                                                    ())
                                                                  #(ribcage
                                                                    #(t)
                                                                    #(("m" top))
                                                                    #("i"))
                                                                  #(ribcage
                                                                    ()
                                                                    ()
                                                                    ())
                                                                  #(ribcage
                                                                    #(b)
                                                                    #((top))
                                                                    #("i"))
                                                                  #(ribcage
                                                                    ()
                                                                    ()
                                                                    ())
                                                                  #(ribcage
                                                                    #(n)
                                                                    #((top))
                                                                    #("i"))
                                                                  #(ribcage
                                                                    #(_
                                                                      id
                                                                      val)
                                                                    #((top)
                                                                      (top)
                                                                      (top))
                                                                    #("i"
                                                                      "i"
                                                                      "i"))
                                                                  #(ribcage
                                                                    ()
                                                                    ()
                                                                    ())
                                                                  #(ribcage
                                                                    #(e
                                                                      r
                                                                      w
                                                                      ae
                                                                      rib)
                                                                    #((top)
                                                                      (top)
                                                                      (top)
                                                                      (top)
                                                                      (top))
                                                                    #("i"
                                                                      "i"
                                                                      "i"
                                                                      "i"
                                                                      "i"))
                                                                  #(ribcage
                                                                    (lambda-var-list
                                                                      gen-var
                                                                      strip
                                                                      strip*
                                                                      strip-annotation
                                                                      ellipsis?
                                                                      chi-void
                                                                      chi-local-syntax
                                                                      chi-lambda-clause
                                                                      parse-begin
                                                                      parse-alias
                                                                      parse-eval-when
                                                                      parse-meta
                                                                      parse-define-syntax
                                                                      parse-define
                                                                      parse-import
                                                                      parse-module
                                                                      do-import!
                                                                      chi-internal
                                                                      chi-body
                                                                      chi-macro
                                                                      chi-set!
                                                                      chi-application
                                                                      chi-expr
                                                                      chi
                                                                      chi-sequence
                                                                      chi-meta-frob
                                                                      chi-frobs
                                                                      ct-eval/residualize3
                                                                      ct-eval/residualize2
                                                                      rt-eval/residualize
                                                                      initial-mode-set
                                                                      update-mode-set
                                                                      do-top-import
                                                                      vfor-each
                                                                      vmap
                                                                      chi-external
                                                                      check-defined-ids
                                                                      check-module-exports
                                                                      id-set-diff
                                                                      chi-top-module
                                                                      set-frob-meta?!
                                                                      set-frob-e!
                                                                      frob-meta?
                                                                      frob-e
                                                                      frob?
                                                                      make-frob
                                                                      create-module-binding
                                                                      set-module-binding-exported!
                                                                      set-module-binding-val!
                                                                      set-module-binding-imps!
                                                                      set-module-binding-label!
                                                                      set-module-binding-id!
                                                                      set-module-binding-type!
                                                                      module-binding-exported
                                                                      module-binding-val
                                                                      module-binding-imps
                                                                      module-binding-label
                                                                      module-binding-id
                                                                      module-binding-type
                                                                      module-binding?
                                                                      make-module-binding
                                                                      make-resolved-interface2
                                                                      make-resolved-interface1
                                                                      make-unresolved-interface
                                                                      set-interface-token!
                                                                      set-interface-exports!
                                                                      interface-token
                                                                      interface-exports
                                                                      interface?
                                                                      make-interface
                                                                      flatten-exports
                                                                      chi-top
                                                                      chi-top-sequence
                                                                      chi-top*
                                                                      syntax-type
                                                                      chi-when-list
                                                                      source-wrap
                                                                      wrap
                                                                      bound-id-member?
                                                                      invalid-ids-error
                                                                      distinct-bound-ids?
                                                                      valid-bound-ids?
                                                                      bound-id=?
                                                                      literal-id=?
                                                                      free-id=?
                                                                      id-var-name
                                                                      id-var-name-loc
                                                                      id-var-name&marks
                                                                      id-var-name-loc&marks
                                                                      top-id-free-var-name
                                                                      top-id-bound-var-name
                                                                      anon
                                                                      same-marks?
                                                                      join-subst
                                                                      join-marks
                                                                      join-wraps
                                                                      smart-append
                                                                      resolved-id-var-name
                                                                      id->resolved-id
                                                                      make-resolved-id
                                                                      make-binding-wrap
                                                                      store-import-binding
                                                                      lookup-import-binding-name
                                                                      extend-ribcage-subst!
                                                                      extend-ribcage-barrier-help!
                                                                      extend-ribcage-barrier!
                                                                      extend-ribcage!
                                                                      make-empty-ribcage
                                                                      barrier-marker
                                                                      new-mark
                                                                      anti-mark
                                                                      the-anti-mark
                                                                      set-env-wrap!
                                                                      set-env-top-ribcage!
                                                                      env-wrap
                                                                      env-top-ribcage
                                                                      env?
                                                                      make-env
                                                                      set-import-token-key!
                                                                      import-token-key
                                                                      import-token?
                                                                      make-import-token
                                                                      set-top-ribcage-mutable?!
                                                                      set-top-ribcage-key!
                                                                      top-ribcage-mutable?
                                                                      top-ribcage-key
                                                                      top-ribcage?
                                                                      make-top-ribcage
                                                                      set-ribcage-labels!
                                                                      set-ribcage-marks!
                                                                      set-ribcage-symnames!
                                                                      ribcage-labels
                                                                      ribcage-marks
                                                                      ribcage-symnames
                                                                      ribcage?
                                                                      make-ribcage
                                                                      gen-labels
                                                                      label?
                                                                      gen-label
                                                                      set-indirect-label!
                                                                      get-indirect-label
                                                                      indirect-label?
                                                                      gen-indirect-label
                                                                      anon
                                                                      only-top-marked?
                                                                      top-marked?
                                                                      top-wrap
                                                                      empty-wrap
                                                                      wrap-subst
                                                                      wrap-marks
                                                                      make-wrap
                                                                      id-sym-name&marks
                                                                      id-sym-name
                                                                      id?
                                                                      nonsymbol-id?
                                                                      global-extend
                                                                      defer-or-eval-transformer
                                                                      make-transformer-binding
                                                                      lookup
                                                                      lookup*
                                                                      displaced-lexical-error
                                                                      displaced-lexical?
                                                                      extend-var-env*
                                                                      extend-env*
                                                                      extend-env
                                                                      null-env
                                                                      binding?
                                                                      set-binding-value!
                                                                      set-binding-type!
                                                                      binding-value
                                                                      binding-type
                                                                      make-binding
                                                                      sanitize-binding
                                                                      arg-check
                                                                      no-source
                                                                      unannotate
                                                                      self-evaluating?
                                                                      lexical-var?
                                                                      build-lexical-var
                                                                      build-top-module
                                                                      build-body
                                                                      build-letrec
                                                                      build-sequence
                                                                      build-data
                                                                      build-primref
                                                                      built-lambda?
                                                                      build-params
                                                                      build-lambda
                                                                      build-revisit-only
                                                                      build-visit-only
                                                                      build-cte-install
                                                                      build-global-definition
                                                                      build-global-assignment
                                                                      build-global-reference
                                                                      build-lexical-assignment
                                                                      build-lexical-reference
                                                                      build-conditional
                                                                      build-application
                                                                      generate-id
                                                                      put-import-binding
                                                                      get-import-binding
                                                                      read-only-binding?
                                                                      put-global-definition-hook
                                                                      get-global-definition-hook
                                                                      put-cte-hook
                                                                      gensym-hook
                                                                      define-top-level-value-hook
                                                                      local-eval-hook
                                                                      top-level-eval-hook
                                                                      fx>=
                                                                      fx<=
                                                                      fx>
                                                                      fx<
                                                                      fx=
                                                                      fx-
                                                                      fx+
                                                                      set-syntax-object-wrap!
                                                                      set-syntax-object-expression!
                                                                      syntax-object-wrap
                                                                      syntax-object-expression
                                                                      syntax-object?
                                                                      make-syntax-object
                                                                      noexpand
                                                                      let-values
                                                                      define-structure
                                                                      unless
                                                                      when)
                                                                    ((top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     ("m" top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     ("m" top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top)
                                                                     (top))
                                                                    ("i" "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"
                                                                         "i"))
                                                                  #(top-ribcage
                                                                    *top*
                                                                    #t)))
                                                              %%id1059
                                                              %%val1058)
                                                        %%r1022
                                                        '(())
                                                        '#f
                                                        %%rib1019)
                                                      %%r1022
                                                      '(())
                                                      '#f
                                                      %%rib1019))
                                                  (%%wrap480
                                                    %%id1028
                                                    %%w1021)
                                                  (%%wrap480
                                                    %%val1027
                                                    %%w1021))
                                                 (values
                                                   'core
                                                   (lambda (%%e1038
                                                            %%r1037
                                                            %%mr1036
                                                            %%w1035
                                                            %%ae1034
                                                            %%m?1033)
                                                     ((lambda (%%val1040
                                                               %%n1039)
                                                        ((lambda (%%b1041)
                                                           ((lambda (%%t1042)
                                                              (if (memv %%t1042
                                                                        '(lexical))
                                                                  (build-source
                                                                    %%ae1034
                                                                    (list (build-source
                                                                            %%ae1034
                                                                            'set!)
                                                                          (build-source
                                                                            %%ae1034
                                                                            (%%binding-value322
                                                                              %%b1041))
                                                                          %%val1040))
                                                                  (if (memv %%t1042
                                                                            '(global))
                                                                      ((lambda (%%sym1050)
                                                                         (begin (if (%%read-only-binding?179
                                                                                      %%n1039)
                                                                                    (syntax-error
                                                                                      (%%source-wrap481
                                                                                        %%e1038
                                                                                        %%w1035
                                                                                        %%ae1034)
                                                                                      '"invalid assignment to read-only variable")
                                                                                    (void))
                                                                                (build-source
                                                                                  %%ae1034
                                                                                  (list (build-source
                                                                                          %%ae1034
                                                                                          'set!)
                                                                                        (build-source
                                                                                          %%ae1034
                                                                                          %%sym1050)
                                                                                        %%val1040))))
                                                                       (%%binding-value322
                                                                         %%b1041))
                                                                      (if (memv %%t1042
                                                                                '(meta-variable))
                                                                          (if %%m?1033
                                                                              (build-source
                                                                                %%ae1034
                                                                                (list (build-source
                                                                                        %%ae1034
                                                                                        'set!)
                                                                                      (build-source
                                                                                        %%ae1034
                                                                                        (%%binding-value322
                                                                                          %%b1041))
                                                                                      %%val1040))
                                                                              (%%displaced-lexical-error339
                                                                                (%%wrap480
                                                                                  %%id1028
                                                                                  %%w1035)))
                                                                          (if (memv %%t1042
                                                                                    '(displaced-lexical))
                                                                              (%%displaced-lexical-error339
                                                                                (%%wrap480
                                                                                  %%id1028
                                                                                  %%w1035))
                                                                              (syntax-error
                                                                                (%%source-wrap481
                                                                                  %%e1038
                                                                                  %%w1035
                                                                                  %%ae1034)))))))
                                                            (%%binding-type321
                                                              %%b1041)))
                                                         (%%lookup341
                                                           %%n1039
                                                           %%r1037)))
                                                      (%%chi534
                                                        %%val1027
                                                        %%r1037
                                                        %%mr1036
                                                        %%w1035
                                                        %%m?1033)
                                                      (%%id-var-name472
                                                        %%id1028
                                                        %%w1035)))
                                                   %%e1023
                                                   %%w1021
                                                   %%ae1020)))
                                           (%%binding-type321 %%b1031)))
                                        (%%lookup341 %%n1030 %%r1022)))
                                     (%%id-var-name472 %%id1028 %%w1021)))
                                  %%tmp1025)
                                ((lambda (%%_1026)
                                   (syntax-error
                                     (%%source-wrap481
                                       %%e1023
                                       %%w1021
                                       %%ae1020)))
                                 %%tmp1024)))
                          ($syntax-dispatch %%tmp1024 '(any any any))))
                       %%e1023)))
                   (%%chi-macro538
                    (lambda (%%p978 %%e977 %%r976 %%w975 %%ae974 %%rib973)
                      (letrec ((%%rebuild-macro-output979
                                (lambda (%%x981 %%m980)
                                  (if (pair? %%x981)
                                      (cons (%%rebuild-macro-output979
                                              (car %%x981)
                                              %%m980)
                                            (%%rebuild-macro-output979
                                              (cdr %%x981)
                                              %%m980))
                                      (if (%%syntax-object?101 %%x981)
                                          ((lambda (%%w1002)
                                             ((lambda (%%ms1004 %%s1003)
                                                (%%make-syntax-object100
                                                  (%%syntax-object-expression102
                                                    %%x981)
                                                  (if (if (pair? %%ms1004)
                                                          (eq? (car %%ms1004)
                                                               '#f)
                                                          '#f)
                                                      (%%make-wrap358
                                                        (cdr %%ms1004)
                                                        (cdr %%s1003))
                                                      (%%make-wrap358
                                                        (cons %%m980
                                                              %%ms1004)
                                                        (if %%rib973
                                                            (cons %%rib973
                                                                  (cons 'shift
                                                                        %%s1003))
                                                            (cons 'shift
                                                                  %%s1003))))))
                                              (%%wrap-marks359 %%w1002)
                                              (%%wrap-subst360 %%w1002)))
                                           (%%syntax-object-wrap103
                                             %%x981))
                                          (if (vector? %%x981)
                                              ((lambda (%%n982)
                                                 ((lambda (%%v983)
                                                    ((lambda ()
                                                       ((letrec ((%%do984
                                                                  (lambda (%%i985)
                                                                    (if (= %%i985
                                                                           %%n982)
                                                                        %%v983
                                                                        (begin (vector-set!
                                                                                 %%v983
                                                                                 %%i985
                                                                                 (%%rebuild-macro-output979
                                                                                   (vector-ref
                                                                                     %%x981
                                                                                     %%i985)
                                                                                   %%m980))
                                                                               (%%do984
                                                                                 (+ %%i985
                                                                                    '1)))))))
                                                          %%do984)
                                                        '0))))
                                                  (make-vector %%n982)))
                                               (vector-length %%x981))
                                              (if (symbol? %%x981)
                                                  (syntax-error
                                                    (%%source-wrap481
                                                      %%e977
                                                      %%w975
                                                      %%ae974)
                                                    '"encountered raw symbol "
                                                    (format '"~s" %%x981)
                                                    '" in output of macro")
                                                  %%x981)))))))
                        (%%rebuild-macro-output979
                          ((lambda (%%out1017)
                             (if (procedure? %%out1017)
                                 (%%out1017
                                   (lambda (%%id1018)
                                     (begin (if (not (identifier?
                                                       %%id1018))
                                                (syntax-error
                                                  %%id1018
                                                  '"environment argument is not an identifier")
                                                (void))
                                            (%%lookup341
                                              (%%id-var-name472
                                                %%id1018
                                                '(()))
                                              %%r976))))
                                 %%out1017))
                           (%%p978
                             (%%source-wrap481
                               %%e977
                               (%%anti-mark440 %%w975)
                               %%ae974)))
                          (string '#\m)))))
                   (%%chi-body539
                    (lambda (%%body961
                             %%outer-form960
                             %%r959
                             %%mr958
                             %%w957
                             %%m?956)
                      ((lambda (%%ribcage962)
                         ((lambda (%%w963)
                            ((lambda (%%body964)
                               ((lambda ()
                                  (call-with-values
                                    (lambda ()
                                      (%%chi-internal540
                                        %%ribcage962
                                        %%outer-form960
                                        %%body964
                                        %%r959
                                        %%mr958
                                        %%m?956))
                                    (lambda (%%r971
                                             %%mr970
                                             %%exprs969
                                             %%ids968
                                             %%vars967
                                             %%vals966
                                             %%inits965)
                                      (begin (if (null? %%exprs969)
                                                 (syntax-error
                                                   %%outer-form960
                                                   '"no expressions in body")
                                                 (void))
                                             (%%build-body277
                                               '#f
                                               (reverse %%vars967)
                                               (%%chi-frobs531
                                                 (reverse %%vals966)
                                                 %%r971
                                                 %%mr970
                                                 %%m?956)
                                               (%%build-sequence275
                                                 '#f
                                                 (%%chi-frobs531
                                                   (append
                                                     %%inits965
                                                     %%exprs969)
                                                   %%r971
                                                   %%mr970
                                                   %%m?956)))))))))
                             (map (lambda (%%x972)
                                    (%%make-frob512
                                      (%%wrap480 %%x972 %%w963)
                                      '#f))
                                  %%body961)))
                          (%%make-wrap358
                            (%%wrap-marks359 %%w957)
                            (cons %%ribcage962 (%%wrap-subst360 %%w957)))))
                       (%%make-ribcage407 '() '() '()))))
                   (%%chi-internal540
                    (lambda (%%ribcage840
                             %%source-exp839
                             %%body838
                             %%r837
                             %%mr836
                             %%m?835)
                      (letrec ((%%return841
                                (lambda (%%r848
                                         %%mr847
                                         %%exprs846
                                         %%ids845
                                         %%vars844
                                         %%vals843
                                         %%inits842)
                                  (begin (%%check-defined-ids521
                                           %%source-exp839
                                           %%ids845)
                                         (values
                                           %%r848
                                           %%mr847
                                           %%exprs846
                                           %%ids845
                                           %%vars844
                                           %%vals843
                                           %%inits842)))))
                        ((letrec ((%%parse849
                                   (lambda (%%body857
                                            %%r856
                                            %%mr855
                                            %%ids854
                                            %%vars853
                                            %%vals852
                                            %%inits851
                                            %%meta-seen?850)
                                     (if (null? %%body857)
                                         (%%return841
                                           %%r856
                                           %%mr855
                                           %%body857
                                           %%ids854
                                           %%vars853
                                           %%vals852
                                           %%inits851)
                                         ((lambda (%%fr858)
                                            ((lambda (%%e859)
                                               ((lambda (%%meta?860)
                                                  ((lambda ()
                                                     (call-with-values
                                                       (lambda ()
                                                         (%%syntax-type483
                                                           %%e859
                                                           %%r856
                                                           '(())
                                                           '#f
                                                           %%ribcage840))
                                                       (lambda (%%type873
                                                                %%value872
                                                                %%e871
                                                                %%w870
                                                                %%ae869)
                                                         ((lambda (%%t874)
                                                            (if (memv %%t874
                                                                      '(define-form))
                                                                (call-with-values
                                                                  (lambda ()
                                                                    (%%parse-define544
                                                                      %%e871
                                                                      %%w870
                                                                      %%ae869))
                                                                  (lambda (%%id943
                                                                           %%rhs942
                                                                           %%w941)
                                                                    ((lambda (%%id945
                                                                              %%label944)
                                                                       (if %%meta?860
                                                                           ((lambda (%%sym947)
                                                                              (begin (%%extend-ribcage!450
                                                                                       %%ribcage840
                                                                                       %%id945
                                                                                       %%label944)
                                                                                     ((lambda (%%mr948)
                                                                                        (begin (%%define-top-level-value-hook171
                                                                                                 %%sym947
                                                                                                 (%%top-level-eval-hook169
                                                                                                   (%%chi534
                                                                                                     %%rhs942
                                                                                                     %%mr948
                                                                                                     %%mr948
                                                                                                     %%w941
                                                                                                     '#t)))
                                                                                               (%%parse849
                                                                                                 (cdr %%body857)
                                                                                                 %%r856
                                                                                                 %%mr948
                                                                                                 (cons %%id945
                                                                                                       %%ids854)
                                                                                                 %%vars853
                                                                                                 %%vals852
                                                                                                 %%inits851
                                                                                                 '#f)))
                                                                                      (%%extend-env335
                                                                                        %%label944
                                                                                        (cons 'meta-variable
                                                                                              %%sym947)
                                                                                        %%mr855))))
                                                                            (%%generate-id182
                                                                              ((lambda (%%x954)
                                                                                 ((lambda (%%e955)
                                                                                    (if (annotation?
                                                                                          %%e955)
                                                                                        (annotation-expression
                                                                                          %%e955)
                                                                                        %%e955))
                                                                                  (if (%%syntax-object?101
                                                                                        %%x954)
                                                                                      (%%syntax-object-expression102
                                                                                        %%x954)
                                                                                      %%x954)))
                                                                               %%id945)))
                                                                           ((lambda (%%var946)
                                                                              (begin (%%extend-ribcage!450
                                                                                       %%ribcage840
                                                                                       %%id945
                                                                                       %%label944)
                                                                                     (%%parse849
                                                                                       (cdr %%body857)
                                                                                       (%%extend-env335
                                                                                         %%label944
                                                                                         (cons 'lexical
                                                                                               %%var946)
                                                                                         %%r856)
                                                                                       %%mr855
                                                                                       (cons %%id945
                                                                                             %%ids854)
                                                                                       (cons %%var946
                                                                                             %%vars853)
                                                                                       (cons (%%make-frob512
                                                                                               (%%wrap480
                                                                                                 %%rhs942
                                                                                                 %%w941)
                                                                                               %%meta?860)
                                                                                             %%vals852)
                                                                                       %%inits851
                                                                                       '#f)))
                                                                            (%%gen-var557
                                                                              %%id945))))
                                                                     (%%wrap480
                                                                       %%id943
                                                                       %%w941)
                                                                     (%%gen-label404))))
                                                                (if (memv %%t874
                                                                          '(define-syntax-form))
                                                                    (call-with-values
                                                                      (lambda ()
                                                                        (%%parse-define-syntax545
                                                                          %%e871
                                                                          %%w870
                                                                          %%ae869))
                                                                      (lambda (%%id936
                                                                               %%rhs935
                                                                               %%w934)
                                                                        ((lambda (%%id939
                                                                                  %%label938
                                                                                  %%exp937)
                                                                           (begin (%%extend-ribcage!450
                                                                                    %%ribcage840
                                                                                    %%id939
                                                                                    %%label938)
                                                                                  ((lambda (%%b940)
                                                                                     (%%parse849
                                                                                       (cdr %%body857)
                                                                                       (%%extend-env335
                                                                                         %%label938
                                                                                         %%b940
                                                                                         %%r856)
                                                                                       (%%extend-env335
                                                                                         %%label938
                                                                                         %%b940
                                                                                         %%mr855)
                                                                                       (cons %%id939
                                                                                             %%ids854)
                                                                                       %%vars853
                                                                                       %%vals852
                                                                                       %%inits851
                                                                                       '#f))
                                                                                   (%%defer-or-eval-transformer343
                                                                                     %%local-eval-hook170
                                                                                     %%exp937))))
                                                                         (%%wrap480
                                                                           %%id936
                                                                           %%w934)
                                                                         (%%gen-label404)
                                                                         (%%chi534
                                                                           %%rhs935
                                                                           %%mr855
                                                                           %%mr855
                                                                           %%w934
                                                                           '#t))))
                                                                    (if (memv %%t874
                                                                              '($module-form))
                                                                        ((lambda (%%*ribcage901)
                                                                           ((lambda (%%*w902)
                                                                              ((lambda ()
                                                                                 (call-with-values
                                                                                   (lambda ()
                                                                                     (%%parse-module542
                                                                                       %%e871
                                                                                       %%w870
                                                                                       %%ae869
                                                                                       %%*w902))
                                                                                   (lambda (%%orig906
                                                                                            %%id905
                                                                                            %%exports904
                                                                                            %%forms903)
                                                                                     (call-with-values
                                                                                       (lambda ()
                                                                                         (%%chi-internal540
                                                                                           %%*ribcage901
                                                                                           %%orig906
                                                                                           (map (lambda (%%d929)
                                                                                                  (%%make-frob512
                                                                                                    %%d929
                                                                                                    %%meta?860))
                                                                                                %%forms903)
                                                                                           %%r856
                                                                                           %%mr855
                                                                                           %%m?835))
                                                                                       (lambda (%%r913
                                                                                                %%mr912
                                                                                                %%*body911
                                                                                                %%*ids910
                                                                                                %%*vars909
                                                                                                %%*vals908
                                                                                                %%*inits907)
                                                                                         (begin (%%check-module-exports520
                                                                                                  %%source-exp839
                                                                                                  (%%flatten-exports487
                                                                                                    %%exports904)
                                                                                                  %%*ids910)
                                                                                                ((lambda (%%iface917
                                                                                                          %%vars916
                                                                                                          %%vals915
                                                                                                          %%inits914)
                                                                                                   ((lambda (%%label918)
                                                                                                      (begin (%%extend-ribcage!450
                                                                                                               %%ribcage840
                                                                                                               %%id905
                                                                                                               %%label918)
                                                                                                             ((lambda (%%b919)
                                                                                                                (%%parse849
                                                                                                                  (cdr %%body857)
                                                                                                                  (%%extend-env335
                                                                                                                    %%label918
                                                                                                                    %%b919
                                                                                                                    %%r913)
                                                                                                                  (%%extend-env335
                                                                                                                    %%label918
                                                                                                                    %%b919
                                                                                                                    %%mr912)
                                                                                                                  (cons %%id905
                                                                                                                        %%ids854)
                                                                                                                  %%vars916
                                                                                                                  %%vals915
                                                                                                                  %%inits914
                                                                                                                  '#f))
                                                                                                              (cons '$module
                                                                                                                    %%iface917))))
                                                                                                    (%%gen-label404)))
                                                                                                 (%%make-resolved-interface1495
                                                                                                   %%exports904)
                                                                                                 (append
                                                                                                   %%*vars909
                                                                                                   %%vars853)
                                                                                                 (append
                                                                                                   %%*vals908
                                                                                                   %%vals852)
                                                                                                 (append
                                                                                                   %%inits851
                                                                                                   %%*inits907
                                                                                                   %%*body911))))))))))
                                                                            (%%make-wrap358
                                                                              (%%wrap-marks359
                                                                                %%w870)
                                                                              (cons %%*ribcage901
                                                                                    (%%wrap-subst360
                                                                                      %%w870)))))
                                                                         (%%make-ribcage407
                                                                           '()
                                                                           '()
                                                                           '()))
                                                                        (if (memv %%t874
                                                                                  '($import-form))
                                                                            (call-with-values
                                                                              (lambda ()
                                                                                (%%parse-import543
                                                                                  %%e871
                                                                                  %%w870
                                                                                  %%ae869))
                                                                              (lambda (%%orig896
                                                                                       %%only?895
                                                                                       %%mid894)
                                                                                ((lambda (%%mlabel897)
                                                                                   ((lambda (%%binding898)
                                                                                      ((lambda (%%t899)
                                                                                         (if (memv %%t899
                                                                                                   '($module))
                                                                                             ((lambda (%%iface900)
                                                                                                (begin (if %%only?895
                                                                                                           (%%extend-ribcage-barrier!451
                                                                                                             %%ribcage840
                                                                                                             %%mid894)
                                                                                                           (void))
                                                                                                       (%%do-import!541
                                                                                                         %%iface900
                                                                                                         %%ribcage840)
                                                                                                       (%%parse849
                                                                                                         (cdr %%body857)
                                                                                                         %%r856
                                                                                                         %%mr855
                                                                                                         (cons %%iface900
                                                                                                               %%ids854)
                                                                                                         %%vars853
                                                                                                         %%vals852
                                                                                                         %%inits851
                                                                                                         '#f)))
                                                                                              (cdr %%binding898))
                                                                                             (if (memv %%t899
                                                                                                       '(displaced-lexical))
                                                                                                 (%%displaced-lexical-error339
                                                                                                   %%mid894)
                                                                                                 (syntax-error
                                                                                                   %%mid894
                                                                                                   '"unknown module"))))
                                                                                       (car %%binding898)))
                                                                                    (%%lookup341
                                                                                      %%mlabel897
                                                                                      %%r856)))
                                                                                 (%%id-var-name472
                                                                                   %%mid894
                                                                                   '(())))))
                                                                            (if (memv %%t874
                                                                                      '(alias-form))
                                                                                (call-with-values
                                                                                  (lambda ()
                                                                                    (%%parse-alias548
                                                                                      %%e871
                                                                                      %%w870
                                                                                      %%ae869))
                                                                                  (lambda (%%new-id892
                                                                                           %%old-id891)
                                                                                    ((lambda (%%new-id893)
                                                                                       (begin (%%extend-ribcage!450
                                                                                                %%ribcage840
                                                                                                %%new-id893
                                                                                                (%%id-var-name-loc471
                                                                                                  %%old-id891
                                                                                                  %%w870))
                                                                                              (%%parse849
                                                                                                (cdr %%body857)
                                                                                                %%r856
                                                                                                %%mr855
                                                                                                (cons %%new-id893
                                                                                                      %%ids854)
                                                                                                %%vars853
                                                                                                %%vals852
                                                                                                %%inits851
                                                                                                '#f)))
                                                                                     (%%wrap480
                                                                                       %%new-id892
                                                                                       %%w870))))
                                                                                (if (memv %%t874
                                                                                          '(begin-form))
                                                                                    (%%parse849
                                                                                      ((letrec ((%%f889
                                                                                                 (lambda (%%forms890)
                                                                                                   (if (null?
                                                                                                         %%forms890)
                                                                                                       (cdr %%body857)
                                                                                                       (cons (%%make-frob512
                                                                                                               (%%wrap480
                                                                                                                 (car %%forms890)
                                                                                                                 %%w870)
                                                                                                               %%meta?860)
                                                                                                             (%%f889
                                                                                                               (cdr %%forms890)))))))
                                                                                         %%f889)
                                                                                       (%%parse-begin549
                                                                                         %%e871
                                                                                         %%w870
                                                                                         %%ae869
                                                                                         '#t))
                                                                                      %%r856
                                                                                      %%mr855
                                                                                      %%ids854
                                                                                      %%vars853
                                                                                      %%vals852
                                                                                      %%inits851
                                                                                      '#f)
                                                                                    (if (memv %%t874
                                                                                              '(eval-when-form))
                                                                                        (call-with-values
                                                                                          (lambda ()
                                                                                            (%%parse-eval-when547
                                                                                              %%e871
                                                                                              %%w870
                                                                                              %%ae869))
                                                                                          (lambda (%%when-list886
                                                                                                   %%forms885)
                                                                                            (%%parse849
                                                                                              (if (memq 'eval
                                                                                                        %%when-list886)
                                                                                                  ((letrec ((%%f887
                                                                                                             (lambda (%%forms888)
                                                                                                               (if (null?
                                                                                                                     %%forms888)
                                                                                                                   (cdr %%body857)
                                                                                                                   (cons (%%make-frob512
                                                                                                                           (%%wrap480
                                                                                                                             (car %%forms888)
                                                                                                                             %%w870)
                                                                                                                           %%meta?860)
                                                                                                                         (%%f887
                                                                                                                           (cdr %%forms888)))))))
                                                                                                     %%f887)
                                                                                                   %%forms885)
                                                                                                  (cdr %%body857))
                                                                                              %%r856
                                                                                              %%mr855
                                                                                              %%ids854
                                                                                              %%vars853
                                                                                              %%vals852
                                                                                              %%inits851
                                                                                              '#f)))
                                                                                        (if (memv %%t874
                                                                                                  '(meta-form))
                                                                                            (%%parse849
                                                                                              (cons (%%make-frob512
                                                                                                      (%%wrap480
                                                                                                        (%%parse-meta546
                                                                                                          %%e871
                                                                                                          %%w870
                                                                                                          %%ae869)
                                                                                                        %%w870)
                                                                                                      '#t)
                                                                                                    (cdr %%body857))
                                                                                              %%r856
                                                                                              %%mr855
                                                                                              %%ids854
                                                                                              %%vars853
                                                                                              %%vals852
                                                                                              %%inits851
                                                                                              '#t)
                                                                                            (if (memv %%t874
                                                                                                      '(local-syntax-form))
                                                                                                (call-with-values
                                                                                                  (lambda ()
                                                                                                    (%%chi-local-syntax551
                                                                                                      %%value872
                                                                                                      %%e871
                                                                                                      %%r856
                                                                                                      %%mr855
                                                                                                      %%w870
                                                                                                      %%ae869))
                                                                                                  (lambda (%%forms882
                                                                                                           %%r881
                                                                                                           %%mr880
                                                                                                           %%w879
                                                                                                           %%ae878)
                                                                                                    (%%parse849
                                                                                                      ((letrec ((%%f883
                                                                                                                 (lambda (%%forms884)
                                                                                                                   (if (null?
                                                                                                                         %%forms884)
                                                                                                                       (cdr %%body857)
                                                                                                                       (cons (%%make-frob512
                                                                                                                               (%%wrap480
                                                                                                                                 (car %%forms884)
                                                                                                                                 %%w879)
                                                                                                                               %%meta?860)
                                                                                                                             (%%f883
                                                                                                                               (cdr %%forms884)))))))
                                                                                                         %%f883)
                                                                                                       %%forms882)
                                                                                                      %%r881
                                                                                                      %%mr880
                                                                                                      %%ids854
                                                                                                      %%vars853
                                                                                                      %%vals852
                                                                                                      %%inits851
                                                                                                      '#f)))
                                                                                                (begin (if %%meta-seen?850
                                                                                                           (syntax-error
                                                                                                             (%%source-wrap481
                                                                                                               %%e871
                                                                                                               %%w870
                                                                                                               %%ae869)
                                                                                                             '"invalid meta definition")
                                                                                                           (void))
                                                                                                       ((letrec ((%%f875
                                                                                                                  (lambda (%%body876)
                                                                                                                    (if ((lambda (%%t877)
                                                                                                                           (if %%t877
                                                                                                                               %%t877
                                                                                                                               (not (%%frob-meta?515
                                                                                                                                      (car %%body876)))))
                                                                                                                         (null?
                                                                                                                           %%body876))
                                                                                                                        (%%return841
                                                                                                                          %%r856
                                                                                                                          %%mr855
                                                                                                                          %%body876
                                                                                                                          %%ids854
                                                                                                                          %%vars853
                                                                                                                          %%vals852
                                                                                                                          %%inits851)
                                                                                                                        (begin (%%top-level-eval-hook169
                                                                                                                                 (%%chi-meta-frob532
                                                                                                                                   (car %%body876)
                                                                                                                                   %%mr855))
                                                                                                                               (%%f875
                                                                                                                                 (cdr %%body876)))))))
                                                                                                          %%f875)
                                                                                                        (cons (%%make-frob512
                                                                                                                (%%source-wrap481
                                                                                                                  %%e871
                                                                                                                  %%w870
                                                                                                                  %%ae869)
                                                                                                                %%meta?860)
                                                                                                              (cdr %%body857))))))))))))))
                                                          %%type873))))))
                                                (%%frob-meta?515 %%fr858)))
                                             (%%frob-e514 %%fr858)))
                                          (car %%body857))))))
                           %%parse849)
                         %%body838
                         %%r837
                         %%mr836
                         '()
                         '()
                         '()
                         '()
                         '#f))))
                   (%%do-import!541
                    (lambda (%%interface824 %%ribcage823)
                      ((lambda (%%token825)
                         (if %%token825
                             (%%extend-ribcage-subst!453
                               %%ribcage823
                               %%token825)
                             (%%vfor-each524
                               (lambda (%%id826)
                                 ((lambda (%%label1827)
                                    (begin (if (not %%label1827)
                                               (syntax-error
                                                 %%id826
                                                 '"exported identifier not visible")
                                               (void))
                                           (%%extend-ribcage!450
                                             %%ribcage823
                                             %%id826
                                             %%label1827)))
                                  (%%id-var-name-loc471 %%id826 '(()))))
                               (%%interface-exports490 %%interface824))))
                       (%%interface-token491 %%interface824))))
                   (%%parse-module542
                    (lambda (%%e799 %%w798 %%ae797 %%*w796)
                      (letrec ((%%listify800
                                (lambda (%%exports801)
                                  (if (null? %%exports801)
                                      '()
                                      (cons ((lambda (%%tmp802)
                                               ((lambda (%%tmp803)
                                                  (if %%tmp803
                                                      (apply
                                                        (lambda (%%ex805)
                                                          (%%listify800
                                                            %%ex805))
                                                        %%tmp803)
                                                      ((lambda (%%x804)
                                                         (if (%%id?346
                                                               %%x804)
                                                             (%%wrap480
                                                               %%x804
                                                               %%*w796)
                                                             (syntax-error
                                                               (%%source-wrap481
                                                                 %%e799
                                                                 %%w798
                                                                 %%ae797)
                                                               '"invalid exports list in")))
                                                       %%tmp802)))
                                                ($syntax-dispatch
                                                  %%tmp802
                                                  'each-any)))
                                             (car %%exports801))
                                            (%%listify800
                                              (cdr %%exports801)))))))
                        ((lambda (%%tmp807)
                           ((lambda (%%tmp808)
                              (if (if %%tmp808
                                      (apply
                                        (lambda (%%_822
                                                 %%orig821
                                                 %%mid820
                                                 %%ex819
                                                 %%form818)
                                          (%%id?346 %%mid820))
                                        %%tmp808)
                                      '#f)
                                  (apply
                                    (lambda (%%_814
                                             %%orig813
                                             %%mid812
                                             %%ex811
                                             %%form810)
                                      (values
                                        %%orig813
                                        (%%wrap480 %%mid812 %%w798)
                                        (%%listify800 %%ex811)
                                        (map (lambda (%%x816)
                                               (%%wrap480 %%x816 %%*w796))
                                             %%form810)))
                                    %%tmp808)
                                  ((lambda (%%_809)
                                     (syntax-error
                                       (%%source-wrap481
                                         %%e799
                                         %%w798
                                         %%ae797)))
                                   %%tmp807)))
                            ($syntax-dispatch
                              %%tmp807
                              '(any any any each-any . each-any))))
                         %%e799))))
                   (%%parse-import543
                    (lambda (%%e779 %%w778 %%ae777)
                      ((lambda (%%tmp780)
                         ((lambda (%%tmp781)
                            (if (if %%tmp781
                                    (apply
                                      (lambda (%%_795 %%orig794 %%mid793)
                                        (%%id?346 %%mid793))
                                      %%tmp781)
                                    '#f)
                                (apply
                                  (lambda (%%_792 %%orig791 %%mid790)
                                    (values
                                      %%orig791
                                      '#t
                                      (%%wrap480 %%mid790 %%w778)))
                                  %%tmp781)
                                ((lambda (%%tmp782)
                                   (if (if %%tmp782
                                           (apply
                                             (lambda (%%_789
                                                      %%orig788
                                                      %%mid787)
                                               (%%id?346 %%mid787))
                                             %%tmp782)
                                           '#f)
                                       (apply
                                         (lambda (%%_786
                                                  %%orig785
                                                  %%mid784)
                                           (values
                                             %%orig785
                                             '#f
                                             (%%wrap480 %%mid784 %%w778)))
                                         %%tmp782)
                                       ((lambda (%%_783)
                                          (syntax-error
                                            (%%source-wrap481
                                              %%e779
                                              %%w778
                                              %%ae777)))
                                        %%tmp780)))
                                 ($syntax-dispatch
                                   %%tmp780
                                   '(any any #(atom #f) any)))))
                          ($syntax-dispatch
                            %%tmp780
                            '(any any #(atom #t) any))))
                       %%e779)))
                   (%%parse-define544
                    (lambda (%%e750 %%w749 %%ae748)
                      ((lambda (%%tmp751)
                         ((lambda (%%tmp752)
                            (if (if %%tmp752
                                    (apply
                                      (lambda (%%_776 %%name775 %%val774)
                                        (%%id?346 %%name775))
                                      %%tmp752)
                                    '#f)
                                (apply
                                  (lambda (%%_773 %%name772 %%val771)
                                    (values %%name772 %%val771 %%w749))
                                  %%tmp752)
                                ((lambda (%%tmp753)
                                   (if (if %%tmp753
                                           (apply
                                             (lambda (%%_770
                                                      %%name769
                                                      %%args768
                                                      %%e1767
                                                      %%e2766)
                                               (if (%%id?346 %%name769)
                                                   (%%valid-bound-ids?476
                                                     (%%lambda-var-list558
                                                       %%args768))
                                                   '#f))
                                             %%tmp753)
                                           '#f)
                                       (apply
                                         (lambda (%%_764
                                                  %%name763
                                                  %%args762
                                                  %%e1761
                                                  %%e2760)
                                           (values
                                             (%%wrap480 %%name763 %%w749)
                                             (cons '#(syntax-object
                                                      lambda
                                                      ((top)
                                                       #(ribcage
                                                         #(_
                                                           name
                                                           args
                                                           e1
                                                           e2)
                                                         #((top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top))
                                                         #("i"
                                                           "i"
                                                           "i"
                                                           "i"
                                                           "i"))
                                                       #(ribcage () () ())
                                                       #(ribcage
                                                         #(e w ae)
                                                         #((top)
                                                           (top)
                                                           (top))
                                                         #("i" "i" "i"))
                                                       #(ribcage
                                                         (lambda-var-list
                                                           gen-var
                                                           strip
                                                           strip*
                                                           strip-annotation
                                                           ellipsis?
                                                           chi-void
                                                           chi-local-syntax
                                                           chi-lambda-clause
                                                           parse-begin
                                                           parse-alias
                                                           parse-eval-when
                                                           parse-meta
                                                           parse-define-syntax
                                                           parse-define
                                                           parse-import
                                                           parse-module
                                                           do-import!
                                                           chi-internal
                                                           chi-body
                                                           chi-macro
                                                           chi-set!
                                                           chi-application
                                                           chi-expr
                                                           chi
                                                           chi-sequence
                                                           chi-meta-frob
                                                           chi-frobs
                                                           ct-eval/residualize3
                                                           ct-eval/residualize2
                                                           rt-eval/residualize
                                                           initial-mode-set
                                                           update-mode-set
                                                           do-top-import
                                                           vfor-each
                                                           vmap
                                                           chi-external
                                                           check-defined-ids
                                                           check-module-exports
                                                           id-set-diff
                                                           chi-top-module
                                                           set-frob-meta?!
                                                           set-frob-e!
                                                           frob-meta?
                                                           frob-e
                                                           frob?
                                                           make-frob
                                                           create-module-binding
                                                           set-module-binding-exported!
                                                           set-module-binding-val!
                                                           set-module-binding-imps!
                                                           set-module-binding-label!
                                                           set-module-binding-id!
                                                           set-module-binding-type!
                                                           module-binding-exported
                                                           module-binding-val
                                                           module-binding-imps
                                                           module-binding-label
                                                           module-binding-id
                                                           module-binding-type
                                                           module-binding?
                                                           make-module-binding
                                                           make-resolved-interface2
                                                           make-resolved-interface1
                                                           make-unresolved-interface
                                                           set-interface-token!
                                                           set-interface-exports!
                                                           interface-token
                                                           interface-exports
                                                           interface?
                                                           make-interface
                                                           flatten-exports
                                                           chi-top
                                                           chi-top-sequence
                                                           chi-top*
                                                           syntax-type
                                                           chi-when-list
                                                           source-wrap
                                                           wrap
                                                           bound-id-member?
                                                           invalid-ids-error
                                                           distinct-bound-ids?
                                                           valid-bound-ids?
                                                           bound-id=?
                                                           literal-id=?
                                                           free-id=?
                                                           id-var-name
                                                           id-var-name-loc
                                                           id-var-name&marks
                                                           id-var-name-loc&marks
                                                           top-id-free-var-name
                                                           top-id-bound-var-name
                                                           anon
                                                           same-marks?
                                                           join-subst
                                                           join-marks
                                                           join-wraps
                                                           smart-append
                                                           resolved-id-var-name
                                                           id->resolved-id
                                                           make-resolved-id
                                                           make-binding-wrap
                                                           store-import-binding
                                                           lookup-import-binding-name
                                                           extend-ribcage-subst!
                                                           extend-ribcage-barrier-help!
                                                           extend-ribcage-barrier!
                                                           extend-ribcage!
                                                           make-empty-ribcage
                                                           barrier-marker
                                                           new-mark
                                                           anti-mark
                                                           the-anti-mark
                                                           set-env-wrap!
                                                           set-env-top-ribcage!
                                                           env-wrap
                                                           env-top-ribcage
                                                           env?
                                                           make-env
                                                           set-import-token-key!
                                                           import-token-key
                                                           import-token?
                                                           make-import-token
                                                           set-top-ribcage-mutable?!
                                                           set-top-ribcage-key!
                                                           top-ribcage-mutable?
                                                           top-ribcage-key
                                                           top-ribcage?
                                                           make-top-ribcage
                                                           set-ribcage-labels!
                                                           set-ribcage-marks!
                                                           set-ribcage-symnames!
                                                           ribcage-labels
                                                           ribcage-marks
                                                           ribcage-symnames
                                                           ribcage?
                                                           make-ribcage
                                                           gen-labels
                                                           label?
                                                           gen-label
                                                           set-indirect-label!
                                                           get-indirect-label
                                                           indirect-label?
                                                           gen-indirect-label
                                                           anon
                                                           only-top-marked?
                                                           top-marked?
                                                           top-wrap
                                                           empty-wrap
                                                           wrap-subst
                                                           wrap-marks
                                                           make-wrap
                                                           id-sym-name&marks
                                                           id-sym-name
                                                           id?
                                                           nonsymbol-id?
                                                           global-extend
                                                           defer-or-eval-transformer
                                                           make-transformer-binding
                                                           lookup
                                                           lookup*
                                                           displaced-lexical-error
                                                           displaced-lexical?
                                                           extend-var-env*
                                                           extend-env*
                                                           extend-env
                                                           null-env
                                                           binding?
                                                           set-binding-value!
                                                           set-binding-type!
                                                           binding-value
                                                           binding-type
                                                           make-binding
                                                           sanitize-binding
                                                           arg-check
                                                           no-source
                                                           unannotate
                                                           self-evaluating?
                                                           lexical-var?
                                                           build-lexical-var
                                                           build-top-module
                                                           build-body
                                                           build-letrec
                                                           build-sequence
                                                           build-data
                                                           build-primref
                                                           built-lambda?
                                                           build-params
                                                           build-lambda
                                                           build-revisit-only
                                                           build-visit-only
                                                           build-cte-install
                                                           build-global-definition
                                                           build-global-assignment
                                                           build-global-reference
                                                           build-lexical-assignment
                                                           build-lexical-reference
                                                           build-conditional
                                                           build-application
                                                           generate-id
                                                           put-import-binding
                                                           get-import-binding
                                                           read-only-binding?
                                                           put-global-definition-hook
                                                           get-global-definition-hook
                                                           put-cte-hook
                                                           gensym-hook
                                                           define-top-level-value-hook
                                                           local-eval-hook
                                                           top-level-eval-hook
                                                           fx>=
                                                           fx<=
                                                           fx>
                                                           fx<
                                                           fx=
                                                           fx-
                                                           fx+
                                                           set-syntax-object-wrap!
                                                           set-syntax-object-expression!
                                                           syntax-object-wrap
                                                           syntax-object-expression
                                                           syntax-object?
                                                           make-syntax-object
                                                           noexpand
                                                           let-values
                                                           define-structure
                                                           unless
                                                           when)
                                                         ((top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          ("m" top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          ("m" top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top)
                                                          (top))
                                                         ("i" "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"
                                                              "i"))
                                                       #(top-ribcage
                                                         *top*
                                                         #t)))
                                                   (%%wrap480
                                                     (cons %%args762
                                                           (cons %%e1761
                                                                 %%e2760))
                                                     %%w749))
                                             '(())))
                                         %%tmp753)
                                       ((lambda (%%tmp754)
                                          (if (if %%tmp754
                                                  (apply
                                                    (lambda (%%_759
                                                             %%name758)
                                                      (%%id?346 %%name758))
                                                    %%tmp754)
                                                  '#f)
                                              (apply
                                                (lambda (%%_757 %%name756)
                                                  (values
                                                    (%%wrap480
                                                      %%name756
                                                      %%w749)
                                                    '#(syntax-object
                                                       (void)
                                                       ((top)
                                                        #(ribcage
                                                          #(_ name)
                                                          #((top) (top))
                                                          #("i" "i"))
                                                        #(ribcage () () ())
                                                        #(ribcage
                                                          #(e w ae)
                                                          #((top)
                                                            (top)
                                                            (top))
                                                          #("i" "i" "i"))
                                                        #(ribcage
                                                          (lambda-var-list
                                                            gen-var
                                                            strip
                                                            strip*
                                                            strip-annotation
                                                            ellipsis?
                                                            chi-void
                                                            chi-local-syntax
                                                            chi-lambda-clause
                                                            parse-begin
                                                            parse-alias
                                                            parse-eval-when
                                                            parse-meta
                                                            parse-define-syntax
                                                            parse-define
                                                            parse-import
                                                            parse-module
                                                            do-import!
                                                            chi-internal
                                                            chi-body
                                                            chi-macro
                                                            chi-set!
                                                            chi-application
                                                            chi-expr
                                                            chi
                                                            chi-sequence
                                                            chi-meta-frob
                                                            chi-frobs
                                                            ct-eval/residualize3
                                                            ct-eval/residualize2
                                                            rt-eval/residualize
                                                            initial-mode-set
                                                            update-mode-set
                                                            do-top-import
                                                            vfor-each
                                                            vmap
                                                            chi-external
                                                            check-defined-ids
                                                            check-module-exports
                                                            id-set-diff
                                                            chi-top-module
                                                            set-frob-meta?!
                                                            set-frob-e!
                                                            frob-meta?
                                                            frob-e
                                                            frob?
                                                            make-frob
                                                            create-module-binding
                                                            set-module-binding-exported!
                                                            set-module-binding-val!
                                                            set-module-binding-imps!
                                                            set-module-binding-label!
                                                            set-module-binding-id!
                                                            set-module-binding-type!
                                                            module-binding-exported
                                                            module-binding-val
                                                            module-binding-imps
                                                            module-binding-label
                                                            module-binding-id
                                                            module-binding-type
                                                            module-binding?
                                                            make-module-binding
                                                            make-resolved-interface2
                                                            make-resolved-interface1
                                                            make-unresolved-interface
                                                            set-interface-token!
                                                            set-interface-exports!
                                                            interface-token
                                                            interface-exports
                                                            interface?
                                                            make-interface
                                                            flatten-exports
                                                            chi-top
                                                            chi-top-sequence
                                                            chi-top*
                                                            syntax-type
                                                            chi-when-list
                                                            source-wrap
                                                            wrap
                                                            bound-id-member?
                                                            invalid-ids-error
                                                            distinct-bound-ids?
                                                            valid-bound-ids?
                                                            bound-id=?
                                                            literal-id=?
                                                            free-id=?
                                                            id-var-name
                                                            id-var-name-loc
                                                            id-var-name&marks
                                                            id-var-name-loc&marks
                                                            top-id-free-var-name
                                                            top-id-bound-var-name
                                                            anon
                                                            same-marks?
                                                            join-subst
                                                            join-marks
                                                            join-wraps
                                                            smart-append
                                                            resolved-id-var-name
                                                            id->resolved-id
                                                            make-resolved-id
                                                            make-binding-wrap
                                                            store-import-binding
                                                            lookup-import-binding-name
                                                            extend-ribcage-subst!
                                                            extend-ribcage-barrier-help!
                                                            extend-ribcage-barrier!
                                                            extend-ribcage!
                                                            make-empty-ribcage
                                                            barrier-marker
                                                            new-mark
                                                            anti-mark
                                                            the-anti-mark
                                                            set-env-wrap!
                                                            set-env-top-ribcage!
                                                            env-wrap
                                                            env-top-ribcage
                                                            env?
                                                            make-env
                                                            set-import-token-key!
                                                            import-token-key
                                                            import-token?
                                                            make-import-token
                                                            set-top-ribcage-mutable?!
                                                            set-top-ribcage-key!
                                                            top-ribcage-mutable?
                                                            top-ribcage-key
                                                            top-ribcage?
                                                            make-top-ribcage
                                                            set-ribcage-labels!
                                                            set-ribcage-marks!
                                                            set-ribcage-symnames!
                                                            ribcage-labels
                                                            ribcage-marks
                                                            ribcage-symnames
                                                            ribcage?
                                                            make-ribcage
                                                            gen-labels
                                                            label?
                                                            gen-label
                                                            set-indirect-label!
                                                            get-indirect-label
                                                            indirect-label?
                                                            gen-indirect-label
                                                            anon
                                                            only-top-marked?
                                                            top-marked?
                                                            top-wrap
                                                            empty-wrap
                                                            wrap-subst
                                                            wrap-marks
                                                            make-wrap
                                                            id-sym-name&marks
                                                            id-sym-name
                                                            id?
                                                            nonsymbol-id?
                                                            global-extend
                                                            defer-or-eval-transformer
                                                            make-transformer-binding
                                                            lookup
                                                            lookup*
                                                            displaced-lexical-error
                                                            displaced-lexical?
                                                            extend-var-env*
                                                            extend-env*
                                                            extend-env
                                                            null-env
                                                            binding?
                                                            set-binding-value!
                                                            set-binding-type!
                                                            binding-value
                                                            binding-type
                                                            make-binding
                                                            sanitize-binding
                                                            arg-check
                                                            no-source
                                                            unannotate
                                                            self-evaluating?
                                                            lexical-var?
                                                            build-lexical-var
                                                            build-top-module
                                                            build-body
                                                            build-letrec
                                                            build-sequence
                                                            build-data
                                                            build-primref
                                                            built-lambda?
                                                            build-params
                                                            build-lambda
                                                            build-revisit-only
                                                            build-visit-only
                                                            build-cte-install
                                                            build-global-definition
                                                            build-global-assignment
                                                            build-global-reference
                                                            build-lexical-assignment
                                                            build-lexical-reference
                                                            build-conditional
                                                            build-application
                                                            generate-id
                                                            put-import-binding
                                                            get-import-binding
                                                            read-only-binding?
                                                            put-global-definition-hook
                                                            get-global-definition-hook
                                                            put-cte-hook
                                                            gensym-hook
                                                            define-top-level-value-hook
                                                            local-eval-hook
                                                            top-level-eval-hook
                                                            fx>=
                                                            fx<=
                                                            fx>
                                                            fx<
                                                            fx=
                                                            fx-
                                                            fx+
                                                            set-syntax-object-wrap!
                                                            set-syntax-object-expression!
                                                            syntax-object-wrap
                                                            syntax-object-expression
                                                            syntax-object?
                                                            make-syntax-object
                                                            noexpand
                                                            let-values
                                                            define-structure
                                                            unless
                                                            when)
                                                          ((top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           ("m" top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           ("m" top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top)
                                                           (top))
                                                          ("i" "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"
                                                               "i"))
                                                        #(top-ribcage
                                                          *top*
                                                          #t)))
                                                    '(())))
                                                %%tmp754)
                                              ((lambda (%%_755)
                                                 (syntax-error
                                                   (%%source-wrap481
                                                     %%e750
                                                     %%w749
                                                     %%ae748)))
                                               %%tmp751)))
                                        ($syntax-dispatch
                                          %%tmp751
                                          '(any any)))))
                                 ($syntax-dispatch
                                   %%tmp751
                                   '(any (any . any) any . each-any)))))
                          ($syntax-dispatch %%tmp751 '(any any any))))
                       %%e750)))
                   (%%parse-define-syntax545
                    (lambda (%%e726 %%w725 %%ae724)
                      ((lambda (%%tmp727)
                         ((lambda (%%tmp728)
                            (if (if %%tmp728
                                    (apply
                                      (lambda (%%_747
                                               %%name746
                                               %%id745
                                               %%e1744
                                               %%e2743)
                                        (if (%%id?346 %%name746)
                                            (%%id?346 %%id745)
                                            '#f))
                                      %%tmp728)
                                    '#f)
                                (apply
                                  (lambda (%%_741
                                           %%name740
                                           %%id739
                                           %%e1738
                                           %%e2737)
                                    (values
                                      (%%wrap480 %%name740 %%w725)
                                      (list*
                                        '#(syntax-object
                                           lambda
                                           ((top)
                                            #(ribcage
                                              #(_ name id e1 e2)
                                              #((top)
                                                (top)
                                                (top)
                                                (top)
                                                (top))
                                              #("i" "i" "i" "i" "i"))
                                            #(ribcage () () ())
                                            #(ribcage
                                              #(e w ae)
                                              #((top) (top) (top))
                                              #("i" "i" "i"))
                                            #(ribcage
                                              (lambda-var-list
                                                gen-var
                                                strip
                                                strip*
                                                strip-annotation
                                                ellipsis?
                                                chi-void
                                                chi-local-syntax
                                                chi-lambda-clause
                                                parse-begin
                                                parse-alias
                                                parse-eval-when
                                                parse-meta
                                                parse-define-syntax
                                                parse-define
                                                parse-import
                                                parse-module
                                                do-import!
                                                chi-internal
                                                chi-body
                                                chi-macro
                                                chi-set!
                                                chi-application
                                                chi-expr
                                                chi
                                                chi-sequence
                                                chi-meta-frob
                                                chi-frobs
                                                ct-eval/residualize3
                                                ct-eval/residualize2
                                                rt-eval/residualize
                                                initial-mode-set
                                                update-mode-set
                                                do-top-import
                                                vfor-each
                                                vmap
                                                chi-external
                                                check-defined-ids
                                                check-module-exports
                                                id-set-diff
                                                chi-top-module
                                                set-frob-meta?!
                                                set-frob-e!
                                                frob-meta?
                                                frob-e
                                                frob?
                                                make-frob
                                                create-module-binding
                                                set-module-binding-exported!
                                                set-module-binding-val!
                                                set-module-binding-imps!
                                                set-module-binding-label!
                                                set-module-binding-id!
                                                set-module-binding-type!
                                                module-binding-exported
                                                module-binding-val
                                                module-binding-imps
                                                module-binding-label
                                                module-binding-id
                                                module-binding-type
                                                module-binding?
                                                make-module-binding
                                                make-resolved-interface2
                                                make-resolved-interface1
                                                make-unresolved-interface
                                                set-interface-token!
                                                set-interface-exports!
                                                interface-token
                                                interface-exports
                                                interface?
                                                make-interface
                                                flatten-exports
                                                chi-top
                                                chi-top-sequence
                                                chi-top*
                                                syntax-type
                                                chi-when-list
                                                source-wrap
                                                wrap
                                                bound-id-member?
                                                invalid-ids-error
                                                distinct-bound-ids?
                                                valid-bound-ids?
                                                bound-id=?
                                                literal-id=?
                                                free-id=?
                                                id-var-name
                                                id-var-name-loc
                                                id-var-name&marks
                                                id-var-name-loc&marks
                                                top-id-free-var-name
                                                top-id-bound-var-name
                                                anon
                                                same-marks?
                                                join-subst
                                                join-marks
                                                join-wraps
                                                smart-append
                                                resolved-id-var-name
                                                id->resolved-id
                                                make-resolved-id
                                                make-binding-wrap
                                                store-import-binding
                                                lookup-import-binding-name
                                                extend-ribcage-subst!
                                                extend-ribcage-barrier-help!
                                                extend-ribcage-barrier!
                                                extend-ribcage!
                                                make-empty-ribcage
                                                barrier-marker
                                                new-mark
                                                anti-mark
                                                the-anti-mark
                                                set-env-wrap!
                                                set-env-top-ribcage!
                                                env-wrap
                                                env-top-ribcage
                                                env?
                                                make-env
                                                set-import-token-key!
                                                import-token-key
                                                import-token?
                                                make-import-token
                                                set-top-ribcage-mutable?!
                                                set-top-ribcage-key!
                                                top-ribcage-mutable?
                                                top-ribcage-key
                                                top-ribcage?
                                                make-top-ribcage
                                                set-ribcage-labels!
                                                set-ribcage-marks!
                                                set-ribcage-symnames!
                                                ribcage-labels
                                                ribcage-marks
                                                ribcage-symnames
                                                ribcage?
                                                make-ribcage
                                                gen-labels
                                                label?
                                                gen-label
                                                set-indirect-label!
                                                get-indirect-label
                                                indirect-label?
                                                gen-indirect-label
                                                anon
                                                only-top-marked?
                                                top-marked?
                                                top-wrap
                                                empty-wrap
                                                wrap-subst
                                                wrap-marks
                                                make-wrap
                                                id-sym-name&marks
                                                id-sym-name
                                                id?
                                                nonsymbol-id?
                                                global-extend
                                                defer-or-eval-transformer
                                                make-transformer-binding
                                                lookup
                                                lookup*
                                                displaced-lexical-error
                                                displaced-lexical?
                                                extend-var-env*
                                                extend-env*
                                                extend-env
                                                null-env
                                                binding?
                                                set-binding-value!
                                                set-binding-type!
                                                binding-value
                                                binding-type
                                                make-binding
                                                sanitize-binding
                                                arg-check
                                                no-source
                                                unannotate
                                                self-evaluating?
                                                lexical-var?
                                                build-lexical-var
                                                build-top-module
                                                build-body
                                                build-letrec
                                                build-sequence
                                                build-data
                                                build-primref
                                                built-lambda?
                                                build-params
                                                build-lambda
                                                build-revisit-only
                                                build-visit-only
                                                build-cte-install
                                                build-global-definition
                                                build-global-assignment
                                                build-global-reference
                                                build-lexical-assignment
                                                build-lexical-reference
                                                build-conditional
                                                build-application
                                                generate-id
                                                put-import-binding
                                                get-import-binding
                                                read-only-binding?
                                                put-global-definition-hook
                                                get-global-definition-hook
                                                put-cte-hook
                                                gensym-hook
                                                define-top-level-value-hook
                                                local-eval-hook
                                                top-level-eval-hook
                                                fx>=
                                                fx<=
                                                fx>
                                                fx<
                                                fx=
                                                fx-
                                                fx+
                                                set-syntax-object-wrap!
                                                set-syntax-object-expression!
                                                syntax-object-wrap
                                                syntax-object-expression
                                                syntax-object?
                                                make-syntax-object
                                                noexpand
                                                let-values
                                                define-structure
                                                unless
                                                when)
                                              ((top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               ("m" top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               ("m" top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top)
                                               (top))
                                              ("i" "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"
                                                   "i"))
                                            #(top-ribcage *top* #t)))
                                        (%%wrap480 (list %%id739) %%w725)
                                        (%%wrap480
                                          (cons %%e1738 %%e2737)
                                          %%w725))
                                      '(())))
                                  %%tmp728)
                                ((lambda (%%tmp729)
                                   (if (if %%tmp729
                                           (apply
                                             (lambda (%%_736
                                                      %%name735
                                                      %%val734)
                                               (%%id?346 %%name735))
                                             %%tmp729)
                                           '#f)
                                       (apply
                                         (lambda (%%_733
                                                  %%name732
                                                  %%val731)
                                           (values
                                             %%name732
                                             %%val731
                                             %%w725))
                                         %%tmp729)
                                       ((lambda (%%_730)
                                          (syntax-error
                                            (%%source-wrap481
                                              %%e726
                                              %%w725
                                              %%ae724)))
                                        %%tmp727)))
                                 ($syntax-dispatch
                                   %%tmp727
                                   '(any any any)))))
                          ($syntax-dispatch
                            %%tmp727
                            '(any (any any) any . each-any))))
                       %%e726)))
                   (%%parse-meta546
                    (lambda (%%e718 %%w717 %%ae716)
                      ((lambda (%%tmp719)
                         ((lambda (%%tmp720)
                            (if %%tmp720
                                (apply
                                  (lambda (%%_723 %%form722) %%form722)
                                  %%tmp720)
                                ((lambda (%%_721)
                                   (syntax-error
                                     (%%source-wrap481
                                       %%e718
                                       %%w717
                                       %%ae716)))
                                 %%tmp719)))
                          ($syntax-dispatch %%tmp719 '(any . any))))
                       %%e718)))
                   (%%parse-eval-when547
                    (lambda (%%e706 %%w705 %%ae704)
                      ((lambda (%%tmp707)
                         ((lambda (%%tmp708)
                            (if %%tmp708
                                (apply
                                  (lambda (%%_713 %%x712 %%e1711 %%e2710)
                                    (values
                                      (%%chi-when-list482 %%x712 %%w705)
                                      (cons %%e1711 %%e2710)))
                                  %%tmp708)
                                ((lambda (%%_709)
                                   (syntax-error
                                     (%%source-wrap481
                                       %%e706
                                       %%w705
                                       %%ae704)))
                                 %%tmp707)))
                          ($syntax-dispatch
                            %%tmp707
                            '(any each-any any . each-any))))
                       %%e706)))
                   (%%parse-alias548
                    (lambda (%%e694 %%w693 %%ae692)
                      ((lambda (%%tmp695)
                         ((lambda (%%tmp696)
                            (if (if %%tmp696
                                    (apply
                                      (lambda (%%_703
                                               %%new-id702
                                               %%old-id701)
                                        (if (%%id?346 %%new-id702)
                                            (%%id?346 %%old-id701)
                                            '#f))
                                      %%tmp696)
                                    '#f)
                                (apply
                                  (lambda (%%_700 %%new-id699 %%old-id698)
                                    (values %%new-id699 %%old-id698))
                                  %%tmp696)
                                ((lambda (%%_697)
                                   (syntax-error
                                     (%%source-wrap481
                                       %%e694
                                       %%w693
                                       %%ae692)))
                                 %%tmp695)))
                          ($syntax-dispatch %%tmp695 '(any any any))))
                       %%e694)))
                   (%%parse-begin549
                    (lambda (%%e681 %%w680 %%ae679 %%empty-okay?678)
                      ((lambda (%%tmp682)
                         ((lambda (%%tmp683)
                            (if (if %%tmp683
                                    (apply
                                      (lambda (%%_691) %%empty-okay?678)
                                      %%tmp683)
                                    '#f)
                                (apply (lambda (%%_690) '()) %%tmp683)
                                ((lambda (%%tmp684)
                                   (if %%tmp684
                                       (apply
                                         (lambda (%%_688 %%e1687 %%e2686)
                                           (cons %%e1687 %%e2686))
                                         %%tmp684)
                                       ((lambda (%%_685)
                                          (syntax-error
                                            (%%source-wrap481
                                              %%e681
                                              %%w680
                                              %%ae679)))
                                        %%tmp682)))
                                 ($syntax-dispatch
                                   %%tmp682
                                   '(any any . each-any)))))
                          ($syntax-dispatch %%tmp682 '(any))))
                       %%e681)))
                   (%%chi-lambda-clause550
                    (lambda (%%e655 %%c654 %%r653 %%mr652 %%w651 %%m?650)
                      ((lambda (%%tmp656)
                         ((lambda (%%tmp657)
                            (if %%tmp657
                                (apply
                                  (lambda (%%id672 %%e1671 %%e2670)
                                    ((lambda (%%ids673)
                                       (if (not (%%valid-bound-ids?476
                                                  %%ids673))
                                           (syntax-error
                                             %%e655
                                             '"invalid parameter list in")
                                           ((lambda (%%labels675
                                                     %%new-vars674)
                                              (values
                                                %%new-vars674
                                                (%%chi-body539
                                                  (cons %%e1671 %%e2670)
                                                  %%e655
                                                  (%%extend-var-env*337
                                                    %%labels675
                                                    %%new-vars674
                                                    %%r653)
                                                  %%mr652
                                                  (%%make-binding-wrap456
                                                    %%ids673
                                                    %%labels675
                                                    %%w651)
                                                  %%m?650)))
                                            (%%gen-labels406 %%ids673)
                                            (map %%gen-var557 %%ids673))))
                                     %%id672))
                                  %%tmp657)
                                ((lambda (%%tmp658)
                                   (if %%tmp658
                                       (apply
                                         (lambda (%%ids662 %%e1661 %%e2660)
                                           ((lambda (%%old-ids663)
                                              (if (not (%%valid-bound-ids?476
                                                         %%old-ids663))
                                                  (syntax-error
                                                    %%e655
                                                    '"invalid parameter list in")
                                                  ((lambda (%%labels665
                                                            %%new-vars664)
                                                     (values
                                                       ((letrec ((%%f667
                                                                  (lambda (%%ls1669
                                                                           %%ls2668)
                                                                    (if (null?
                                                                          %%ls1669)
                                                                        %%ls2668
                                                                        (%%f667
                                                                          (cdr %%ls1669)
                                                                          (cons (car %%ls1669)
                                                                                %%ls2668))))))
                                                          %%f667)
                                                        (cdr %%new-vars664)
                                                        (car %%new-vars664))
                                                       (%%chi-body539
                                                         (cons %%e1661
                                                               %%e2660)
                                                         %%e655
                                                         (%%extend-var-env*337
                                                           %%labels665
                                                           %%new-vars664
                                                           %%r653)
                                                         %%mr652
                                                         (%%make-binding-wrap456
                                                           %%old-ids663
                                                           %%labels665
                                                           %%w651)
                                                         %%m?650)))
                                                   (%%gen-labels406
                                                     %%old-ids663)
                                                   (map %%gen-var557
                                                        %%old-ids663))))
                                            (%%lambda-var-list558
                                              %%ids662)))
                                         %%tmp658)
                                       ((lambda (%%_659)
                                          (syntax-error %%e655))
                                        %%tmp656)))
                                 ($syntax-dispatch
                                   %%tmp656
                                   '(any any . each-any)))))
                          ($syntax-dispatch
                            %%tmp656
                            '(each-any any . each-any))))
                       %%c654)))
                   (%%chi-local-syntax551
                    (lambda (%%rec?631
                             %%e630
                             %%r629
                             %%mr628
                             %%w627
                             %%ae626)
                      ((lambda (%%tmp632)
                         ((lambda (%%tmp633)
                            (if %%tmp633
                                (apply
                                  (lambda (%%_639
                                           %%id638
                                           %%val637
                                           %%e1636
                                           %%e2635)
                                    ((lambda (%%ids640)
                                       (if (not (%%valid-bound-ids?476
                                                  %%ids640))
                                           (%%invalid-ids-error478
                                             (map (lambda (%%x648)
                                                    (%%wrap480
                                                      %%x648
                                                      %%w627))
                                                  %%ids640)
                                             (%%source-wrap481
                                               %%e630
                                               %%w627
                                               %%ae626)
                                             '"keyword")
                                           ((lambda (%%labels641)
                                              ((lambda (%%new-w642)
                                                 ((lambda (%%b*643)
                                                    (values
                                                      (cons %%e1636
                                                            %%e2635)
                                                      (%%extend-env*336
                                                        %%labels641
                                                        %%b*643
                                                        %%r629)
                                                      (%%extend-env*336
                                                        %%labels641
                                                        %%b*643
                                                        %%mr628)
                                                      %%new-w642
                                                      %%ae626))
                                                  ((lambda (%%w645)
                                                     (map (lambda (%%x647)
                                                            (%%defer-or-eval-transformer343
                                                              %%local-eval-hook170
                                                              (%%chi534
                                                                %%x647
                                                                %%mr628
                                                                %%mr628
                                                                %%w645
                                                                '#t)))
                                                          %%val637))
                                                   (if %%rec?631
                                                       %%new-w642
                                                       %%w627))))
                                               (%%make-binding-wrap456
                                                 %%ids640
                                                 %%labels641
                                                 %%w627)))
                                            (%%gen-labels406 %%ids640))))
                                     %%id638))
                                  %%tmp633)
                                ((lambda (%%_634)
                                   (syntax-error
                                     (%%source-wrap481
                                       %%e630
                                       %%w627
                                       %%ae626)))
                                 %%tmp632)))
                          ($syntax-dispatch
                            %%tmp632
                            '(any #(each (any any)) any . each-any))))
                       %%e630)))
                   (%%chi-void552
                    (lambda ()
                      (build-source '#f (list (build-source '#f 'void)))))
                   (%%ellipsis?553
                    (lambda (%%x599)
                      (if (%%nonsymbol-id?345 %%x599)
                          (%%literal-id=?474
                            %%x599
                            '#(syntax-object
                               ...
                               ((top)
                                #(ribcage () () ())
                                #(ribcage #(x) #((top)) #("i"))
                                #(ribcage
                                  (lambda-var-list
                                    gen-var
                                    strip
                                    strip*
                                    strip-annotation
                                    ellipsis?
                                    chi-void
                                    chi-local-syntax
                                    chi-lambda-clause
                                    parse-begin
                                    parse-alias
                                    parse-eval-when
                                    parse-meta
                                    parse-define-syntax
                                    parse-define
                                    parse-import
                                    parse-module
                                    do-import!
                                    chi-internal
                                    chi-body
                                    chi-macro
                                    chi-set!
                                    chi-application
                                    chi-expr
                                    chi
                                    chi-sequence
                                    chi-meta-frob
                                    chi-frobs
                                    ct-eval/residualize3
                                    ct-eval/residualize2
                                    rt-eval/residualize
                                    initial-mode-set
                                    update-mode-set
                                    do-top-import
                                    vfor-each
                                    vmap
                                    chi-external
                                    check-defined-ids
                                    check-module-exports
                                    id-set-diff
                                    chi-top-module
                                    set-frob-meta?!
                                    set-frob-e!
                                    frob-meta?
                                    frob-e
                                    frob?
                                    make-frob
                                    create-module-binding
                                    set-module-binding-exported!
                                    set-module-binding-val!
                                    set-module-binding-imps!
                                    set-module-binding-label!
                                    set-module-binding-id!
                                    set-module-binding-type!
                                    module-binding-exported
                                    module-binding-val
                                    module-binding-imps
                                    module-binding-label
                                    module-binding-id
                                    module-binding-type
                                    module-binding?
                                    make-module-binding
                                    make-resolved-interface2
                                    make-resolved-interface1
                                    make-unresolved-interface
                                    set-interface-token!
                                    set-interface-exports!
                                    interface-token
                                    interface-exports
                                    interface?
                                    make-interface
                                    flatten-exports
                                    chi-top
                                    chi-top-sequence
                                    chi-top*
                                    syntax-type
                                    chi-when-list
                                    source-wrap
                                    wrap
                                    bound-id-member?
                                    invalid-ids-error
                                    distinct-bound-ids?
                                    valid-bound-ids?
                                    bound-id=?
                                    literal-id=?
                                    free-id=?
                                    id-var-name
                                    id-var-name-loc
                                    id-var-name&marks
                                    id-var-name-loc&marks
                                    top-id-free-var-name
                                    top-id-bound-var-name
                                    anon
                                    same-marks?
                                    join-subst
                                    join-marks
                                    join-wraps
                                    smart-append
                                    resolved-id-var-name
                                    id->resolved-id
                                    make-resolved-id
                                    make-binding-wrap
                                    store-import-binding
                                    lookup-import-binding-name
                                    extend-ribcage-subst!
                                    extend-ribcage-barrier-help!
                                    extend-ribcage-barrier!
                                    extend-ribcage!
                                    make-empty-ribcage
                                    barrier-marker
                                    new-mark
                                    anti-mark
                                    the-anti-mark
                                    set-env-wrap!
                                    set-env-top-ribcage!
                                    env-wrap
                                    env-top-ribcage
                                    env?
                                    make-env
                                    set-import-token-key!
                                    import-token-key
                                    import-token?
                                    make-import-token
                                    set-top-ribcage-mutable?!
                                    set-top-ribcage-key!
                                    top-ribcage-mutable?
                                    top-ribcage-key
                                    top-ribcage?
                                    make-top-ribcage
                                    set-ribcage-labels!
                                    set-ribcage-marks!
                                    set-ribcage-symnames!
                                    ribcage-labels
                                    ribcage-marks
                                    ribcage-symnames
                                    ribcage?
                                    make-ribcage
                                    gen-labels
                                    label?
                                    gen-label
                                    set-indirect-label!
                                    get-indirect-label
                                    indirect-label?
                                    gen-indirect-label
                                    anon
                                    only-top-marked?
                                    top-marked?
                                    top-wrap
                                    empty-wrap
                                    wrap-subst
                                    wrap-marks
                                    make-wrap
                                    id-sym-name&marks
                                    id-sym-name
                                    id?
                                    nonsymbol-id?
                                    global-extend
                                    defer-or-eval-transformer
                                    make-transformer-binding
                                    lookup
                                    lookup*
                                    displaced-lexical-error
                                    displaced-lexical?
                                    extend-var-env*
                                    extend-env*
                                    extend-env
                                    null-env
                                    binding?
                                    set-binding-value!
                                    set-binding-type!
                                    binding-value
                                    binding-type
                                    make-binding
                                    sanitize-binding
                                    arg-check
                                    no-source
                                    unannotate
                                    self-evaluating?
                                    lexical-var?
                                    build-lexical-var
                                    build-top-module
                                    build-body
                                    build-letrec
                                    build-sequence
                                    build-data
                                    build-primref
                                    built-lambda?
                                    build-params
                                    build-lambda
                                    build-revisit-only
                                    build-visit-only
                                    build-cte-install
                                    build-global-definition
                                    build-global-assignment
                                    build-global-reference
                                    build-lexical-assignment
                                    build-lexical-reference
                                    build-conditional
                                    build-application
                                    generate-id
                                    put-import-binding
                                    get-import-binding
                                    read-only-binding?
                                    put-global-definition-hook
                                    get-global-definition-hook
                                    put-cte-hook
                                    gensym-hook
                                    define-top-level-value-hook
                                    local-eval-hook
                                    top-level-eval-hook
                                    fx>=
                                    fx<=
                                    fx>
                                    fx<
                                    fx=
                                    fx-
                                    fx+
                                    set-syntax-object-wrap!
                                    set-syntax-object-expression!
                                    syntax-object-wrap
                                    syntax-object-expression
                                    syntax-object?
                                    make-syntax-object
                                    noexpand
                                    let-values
                                    define-structure
                                    unless
                                    when)
                                  ((top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   ("m" top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   ("m" top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top)
                                   (top))
                                  ("i" "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"
                                       "i"))
                                #(top-ribcage *top* #t))))
                          '#f)))
                   (%%strip-annotation554
                    (lambda (%%x598)
                      (if (pair? %%x598)
                          (cons (%%strip-annotation554 (car %%x598))
                                (%%strip-annotation554 (cdr %%x598)))
                          (if (annotation? %%x598)
                              (annotation-stripped %%x598)
                              %%x598))))
                   (%%strip*555
                    (lambda (%%x586 %%w585 %%fn584)
                      (if (memq 'top (%%wrap-marks359 %%w585))
                          (%%fn584 %%x586)
                          ((letrec ((%%f587
                                     (lambda (%%x588)
                                       (if (%%syntax-object?101 %%x588)
                                           (%%strip*555
                                             (%%syntax-object-expression102
                                               %%x588)
                                             (%%syntax-object-wrap103
                                               %%x588)
                                             %%fn584)
                                           (if (pair? %%x588)
                                               ((lambda (%%a592 %%d591)
                                                  (if (if (eq? %%a592
                                                               (car %%x588))
                                                          (eq? %%d591
                                                               (cdr %%x588))
                                                          '#f)
                                                      %%x588
                                                      (cons %%a592
                                                            %%d591)))
                                                (%%f587 (car %%x588))
                                                (%%f587 (cdr %%x588)))
                                               (if (vector? %%x588)
                                                   ((lambda (%%old589)
                                                      ((lambda (%%new590)
                                                         (if (andmap
                                                               eq?
                                                               %%old589
                                                               %%new590)
                                                             %%x588
                                                             (list->vector
                                                               %%new590)))
                                                       (map %%f587
                                                            %%old589)))
                                                    (vector->list %%x588))
                                                   %%x588))))))
                             %%f587)
                           %%x586))))
                   (%%strip556
                    (lambda (%%x581 %%w580)
                      (%%strip*555
                        %%x581
                        %%w580
                        (lambda (%%x582)
                          (if ((lambda (%%t583)
                                 (if %%t583
                                     %%t583
                                     (if (pair? %%x582)
                                         (annotation? (car %%x582))
                                         '#f)))
                               (annotation? %%x582))
                              (%%strip-annotation554 %%x582)
                              %%x582)))))
                   (%%gen-var557
                    (lambda (%%id572)
                      ((lambda (%%id573)
                         (if (annotation? %%id573)
                             (gensym (annotation-expression %%id573))
                             (gensym %%id573)))
                       (if (%%syntax-object?101 %%id572)
                           (%%syntax-object-expression102 %%id572)
                           %%id572))))
                   (%%lambda-var-list558
                    (lambda (%%vars559)
                      ((letrec ((%%lvl560
                                 (lambda (%%vars563 %%ls562 %%w561)
                                   (if (pair? %%vars563)
                                       (%%lvl560
                                         (cdr %%vars563)
                                         (cons (%%wrap480
                                                 (car %%vars563)
                                                 %%w561)
                                               %%ls562)
                                         %%w561)
                                       (if (%%id?346 %%vars563)
                                           (cons (%%wrap480
                                                   %%vars563
                                                   %%w561)
                                                 %%ls562)
                                           (if (null? %%vars563)
                                               %%ls562
                                               (if (%%syntax-object?101
                                                     %%vars563)
                                                   (%%lvl560
                                                     (%%syntax-object-expression102
                                                       %%vars563)
                                                     %%ls562
                                                     (%%join-wraps461
                                                       %%w561
                                                       (%%syntax-object-wrap103
                                                         %%vars563)))
                                                   (if (annotation?
                                                         %%vars563)
                                                       (%%lvl560
                                                         (annotation-expression
                                                           %%vars563)
                                                         %%ls562
                                                         %%w561)
                                                       (cons %%vars563
                                                             %%ls562)))))))))
                         %%lvl560)
                       %%vars559
                       '()
                       '(())))))
            (begin (set! $sc-put-cte
                     (lambda (%%id2698 %%b2697 %%top-token2696)
                       (letrec ((%%sc-put-module2699
                                 (lambda (%%exports2706 %%token2705)
                                   (%%vfor-each524
                                     (lambda (%%id2707)
                                       (%%store-import-binding455
                                         %%id2707
                                         %%token2705))
                                     %%exports2706)))
                                (%%put-cte2700
                                 (lambda (%%id2703
                                          %%binding2702
                                          %%token2701)
                                   ((lambda (%%sym2704)
                                      (begin (%%store-import-binding455
                                               %%id2703
                                               %%token2701)
                                             (%%put-global-definition-hook178
                                               %%sym2704
                                               (if (if (eq? (%%binding-type321
                                                              %%binding2702)
                                                            'global)
                                                       (eq? (%%binding-value322
                                                              %%binding2702)
                                                            %%sym2704)
                                                       '#f)
                                                   '#f
                                                   %%binding2702))))
                                    (if (symbol? %%id2703)
                                        %%id2703
                                        (%%id-var-name472
                                          %%id2703
                                          '(())))))))
                         ((lambda (%%binding2708)
                            ((lambda (%%t2709)
                               (if (memv %%t2709 '($module))
                                   (begin ((lambda (%%iface2716)
                                             (%%sc-put-module2699
                                               (%%interface-exports490
                                                 %%iface2716)
                                               (%%interface-token491
                                                 %%iface2716)))
                                           (%%binding-value322
                                             %%binding2708))
                                          (%%put-cte2700
                                            %%id2698
                                            %%binding2708
                                            %%top-token2696))
                                   (if (memv %%t2709 '(do-alias))
                                       (%%store-import-binding455
                                         %%id2698
                                         %%top-token2696)
                                       (if (memv %%t2709 '(do-import))
                                           ((lambda (%%import-only?2711
                                                     %%token2710)
                                              ((lambda (%%b2712)
                                                 ((lambda (%%t2713)
                                                    (if (memv %%t2713
                                                              '($module))
                                                        ((lambda (%%iface2714)
                                                           ((lambda (%%exports2715)
                                                              ((lambda ()
                                                                 (begin (if (not (eq? (%%interface-token491
                                                                                        %%iface2714)
                                                                                      %%token2710))
                                                                            (syntax-error
                                                                              %%id2698
                                                                              '"import mismatch for module")
                                                                            (void))
                                                                        (%%sc-put-module2699
                                                                          %%exports2715
                                                                          %%top-token2696)))))
                                                            (%%interface-exports490
                                                              %%iface2714)))
                                                         (%%binding-value322
                                                           %%b2712))
                                                        (syntax-error
                                                          %%id2698
                                                          '"unknown module")))
                                                  (%%binding-type321
                                                    %%b2712)))
                                               (%%lookup341
                                                 (%%id-var-name472
                                                   %%id2698
                                                   '(()))
                                                 '())))
                                            (car (%%binding-value322
                                                   %%b2697))
                                            (cdr (%%binding-value322
                                                   %%b2697)))
                                           (%%put-cte2700
                                             %%id2698
                                             %%binding2708
                                             %%top-token2696)))))
                             (%%binding-type321 %%binding2708)))
                          (%%make-transformer-binding342 %%b2697)))))
                   (%%global-extend344 'local-syntax 'letrec-syntax '#t)
                   (%%global-extend344 'local-syntax 'let-syntax '#f)
                   (%%global-extend344
                     'core
                     'fluid-let-syntax
                     (lambda (%%e2670
                              %%r2669
                              %%mr2668
                              %%w2667
                              %%ae2666
                              %%m?2665)
                       ((lambda (%%tmp2671)
                          ((lambda (%%tmp2672)
                             (if (if %%tmp2672
                                     (apply
                                       (lambda (%%_2694
                                                %%var2693
                                                %%val2692
                                                %%e12691
                                                %%e22690)
                                         (%%valid-bound-ids?476 %%var2693))
                                       %%tmp2672)
                                     '#f)
                                 (apply
                                   (lambda (%%_2678
                                            %%var2677
                                            %%val2676
                                            %%e12675
                                            %%e22674)
                                     ((lambda (%%names2679)
                                        (begin (for-each
                                                 (lambda (%%id2686 %%n2685)
                                                   ((lambda (%%t2687)
                                                      (if (memv %%t2687
                                                                '(displaced-lexical))
                                                          (%%displaced-lexical-error339
                                                            (%%wrap480
                                                              %%id2686
                                                              %%w2667))
                                                          (void)))
                                                    (%%binding-type321
                                                      (%%lookup341
                                                        %%n2685
                                                        %%r2669))))
                                                 %%var2677
                                                 %%names2679)
                                               ((lambda (%%b*2680)
                                                  (%%chi-body539
                                                    (cons %%e12675
                                                          %%e22674)
                                                    (%%source-wrap481
                                                      %%e2670
                                                      %%w2667
                                                      %%ae2666)
                                                    (%%extend-env*336
                                                      %%names2679
                                                      %%b*2680
                                                      %%r2669)
                                                    (%%extend-env*336
                                                      %%names2679
                                                      %%b*2680
                                                      %%mr2668)
                                                    %%w2667
                                                    %%m?2665))
                                                (map (lambda (%%x2683)
                                                       (%%defer-or-eval-transformer343
                                                         %%local-eval-hook170
                                                         (%%chi534
                                                           %%x2683
                                                           %%mr2668
                                                           %%mr2668
                                                           %%w2667
                                                           '#t)))
                                                     %%val2676))))
                                      (map (lambda (%%x2689)
                                             (%%id-var-name472
                                               %%x2689
                                               %%w2667))
                                           %%var2677)))
                                   %%tmp2672)
                                 ((lambda (%%_2673)
                                    (syntax-error
                                      (%%source-wrap481
                                        %%e2670
                                        %%w2667
                                        %%ae2666)))
                                  %%tmp2671)))
                           ($syntax-dispatch
                             %%tmp2671
                             '(any #(each (any any)) any . each-any))))
                        %%e2670)))
                   (%%global-extend344
                     'core
                     'quote
                     (lambda (%%e2659
                              %%r2658
                              %%mr2657
                              %%w2656
                              %%ae2655
                              %%m?2654)
                       ((lambda (%%tmp2660)
                          ((lambda (%%tmp2661)
                             (if %%tmp2661
                                 (apply
                                   (lambda (%%_2664 %%e2663)
                                     (build-source
                                       %%ae2655
                                       (list (build-source %%ae2655 'quote)
                                             (attach-source
                                               %%ae2655
                                               (%%strip556
                                                 %%e2663
                                                 %%w2656)))))
                                   %%tmp2661)
                                 ((lambda (%%_2662)
                                    (syntax-error
                                      (%%source-wrap481
                                        %%e2659
                                        %%w2656
                                        %%ae2655)))
                                  %%tmp2660)))
                           ($syntax-dispatch %%tmp2660 '(any any))))
                        %%e2659)))
                   (%%global-extend344
                     'core
                     'syntax
                     ((lambda ()
                        (letrec ((%%gen-syntax2539
                                  (lambda (%%src2585
                                           %%e2584
                                           %%r2583
                                           %%maps2582
                                           %%ellipsis?2581)
                                    (if (%%id?346 %%e2584)
                                        ((lambda (%%label2635)
                                           ((lambda (%%b2636)
                                              (if (eq? (%%binding-type321
                                                         %%b2636)
                                                       'syntax)
                                                  (call-with-values
                                                    (lambda ()
                                                      ((lambda (%%var.lev2639)
                                                         (%%gen-ref2540
                                                           %%src2585
                                                           (car %%var.lev2639)
                                                           (cdr %%var.lev2639)
                                                           %%maps2582))
                                                       (%%binding-value322
                                                         %%b2636)))
                                                    (lambda (%%var2638
                                                             %%maps2637)
                                                      (values
                                                        (list 'ref
                                                              %%var2638)
                                                        %%maps2637)))
                                                  (if (%%ellipsis?2581
                                                        %%e2584)
                                                      (syntax-error
                                                        %%src2585
                                                        '"misplaced ellipsis in syntax form")
                                                      (values
                                                        (list 'quote
                                                              %%e2584)
                                                        %%maps2582))))
                                            (%%lookup341
                                              %%label2635
                                              %%r2583)))
                                         (%%id-var-name472 %%e2584 '(())))
                                        ((lambda (%%tmp2586)
                                           ((lambda (%%tmp2587)
                                              (if (if %%tmp2587
                                                      (apply
                                                        (lambda (%%dots2634
                                                                 %%e2633)
                                                          (%%ellipsis?2581
                                                            %%dots2634))
                                                        %%tmp2587)
                                                      '#f)
                                                  (apply
                                                    (lambda (%%dots2631
                                                             %%e2630)
                                                      (%%gen-syntax2539
                                                        %%src2585
                                                        %%e2630
                                                        %%r2583
                                                        %%maps2582
                                                        (lambda (%%x2632)
                                                          '#f)))
                                                    %%tmp2587)
                                                  ((lambda (%%tmp2588)
                                                     (if (if %%tmp2588
                                                             (apply
                                                               (lambda (%%x2629
                                                                        %%dots2628
                                                                        %%y2627)
                                                                 (%%ellipsis?2581
                                                                   %%dots2628))
                                                               %%tmp2588)
                                                             '#f)
                                                         (apply
                                                           (lambda (%%x2606
                                                                    %%dots2605
                                                                    %%y2604)
                                                             ((letrec ((%%f2607
                                                                        (lambda (%%y2609
                                                                                 %%k2608)
                                                                          ((lambda (%%tmp2610)
                                                                             ((lambda (%%tmp2611)
                                                                                (if (if %%tmp2611
                                                                                        (apply
                                                                                          (lambda (%%dots2623
                                                                                                   %%y2622)
                                                                                            (%%ellipsis?2581
                                                                                              %%dots2623))
                                                                                          %%tmp2611)
                                                                                        '#f)
                                                                                    (apply
                                                                                      (lambda (%%dots2618
                                                                                               %%y2617)
                                                                                        (%%f2607
                                                                                          %%y2617
                                                                                          (lambda (%%maps2619)
                                                                                            (call-with-values
                                                                                              (lambda ()
                                                                                                (%%k2608
                                                                                                  (cons '()
                                                                                                        %%maps2619)))
                                                                                              (lambda (%%x2621
                                                                                                       %%maps2620)
                                                                                                (if (null?
                                                                                                      (car %%maps2620))
                                                                                                    (syntax-error
                                                                                                      %%src2585
                                                                                                      '"extra ellipsis in syntax form")
                                                                                                    (values
                                                                                                      (%%gen-mappend2542
                                                                                                        %%x2621
                                                                                                        (car %%maps2620))
                                                                                                      (cdr %%maps2620))))))))
                                                                                      %%tmp2611)
                                                                                    ((lambda (%%_2612)
                                                                                       (call-with-values
                                                                                         (lambda ()
                                                                                           (%%gen-syntax2539
                                                                                             %%src2585
                                                                                             %%y2609
                                                                                             %%r2583
                                                                                             %%maps2582
                                                                                             %%ellipsis?2581))
                                                                                         (lambda (%%y2614
                                                                                                  %%maps2613)
                                                                                           (call-with-values
                                                                                             (lambda ()
                                                                                               (%%k2608
                                                                                                 %%maps2613))
                                                                                             (lambda (%%x2616
                                                                                                      %%maps2615)
                                                                                               (values
                                                                                                 (%%gen-append2541
                                                                                                   %%x2616
                                                                                                   %%y2614)
                                                                                                 %%maps2615))))))
                                                                                     %%tmp2610)))
                                                                              ($syntax-dispatch
                                                                                %%tmp2610
                                                                                '(any .
                                                                                      any))))
                                                                           %%y2609))))
                                                                %%f2607)
                                                              %%y2604
                                                              (lambda (%%maps2624)
                                                                (call-with-values
                                                                  (lambda ()
                                                                    (%%gen-syntax2539
                                                                      %%src2585
                                                                      %%x2606
                                                                      %%r2583
                                                                      (cons '()
                                                                            %%maps2624)
                                                                      %%ellipsis?2581))
                                                                  (lambda (%%x2626
                                                                           %%maps2625)
                                                                    (if (null?
                                                                          (car %%maps2625))
                                                                        (syntax-error
                                                                          %%src2585
                                                                          '"extra ellipsis in syntax form")
                                                                        (values
                                                                          (%%gen-map2543
                                                                            %%x2626
                                                                            (car %%maps2625))
                                                                          (cdr %%maps2625))))))))
                                                           %%tmp2588)
                                                         ((lambda (%%tmp2589)
                                                            (if %%tmp2589
                                                                (apply
                                                                  (lambda (%%x2599
                                                                           %%y2598)
                                                                    (call-with-values
                                                                      (lambda ()
                                                                        (%%gen-syntax2539
                                                                          %%src2585
                                                                          %%x2599
                                                                          %%r2583
                                                                          %%maps2582
                                                                          %%ellipsis?2581))
                                                                      (lambda (%%xnew2601
                                                                               %%maps2600)
                                                                        (call-with-values
                                                                          (lambda ()
                                                                            (%%gen-syntax2539
                                                                              %%src2585
                                                                              %%y2598
                                                                              %%r2583
                                                                              %%maps2600
                                                                              %%ellipsis?2581))
                                                                          (lambda (%%ynew2603
                                                                                   %%maps2602)
                                                                            (values
                                                                              (%%gen-cons2544
                                                                                %%e2584
                                                                                %%x2599
                                                                                %%y2598
                                                                                %%xnew2601
                                                                                %%ynew2603)
                                                                              %%maps2602))))))
                                                                  %%tmp2589)
                                                                ((lambda (%%tmp2590)
                                                                   (if %%tmp2590
                                                                       (apply
                                                                         (lambda (%%x12593
                                                                                  %%x22592)
                                                                           ((lambda (%%ls2594)
                                                                              (call-with-values
                                                                                (lambda ()
                                                                                  (%%gen-syntax2539
                                                                                    %%src2585
                                                                                    %%ls2594
                                                                                    %%r2583
                                                                                    %%maps2582
                                                                                    %%ellipsis?2581))
                                                                                (lambda (%%lsnew2596
                                                                                         %%maps2595)
                                                                                  (values
                                                                                    (%%gen-vector2545
                                                                                      %%e2584
                                                                                      %%ls2594
                                                                                      %%lsnew2596)
                                                                                    %%maps2595))))
                                                                            (cons %%x12593
                                                                                  %%x22592)))
                                                                         %%tmp2590)
                                                                       ((lambda (%%_2591)
                                                                          (values
                                                                            (list 'quote
                                                                                  %%e2584)
                                                                            %%maps2582))
                                                                        %%tmp2586)))
                                                                 ($syntax-dispatch
                                                                   %%tmp2586
                                                                   '#(vector
                                                                      (any .
                                                                           each-any))))))
                                                          ($syntax-dispatch
                                                            %%tmp2586
                                                            '(any .
                                                                  any)))))
                                                   ($syntax-dispatch
                                                     %%tmp2586
                                                     '(any any . any)))))
                                            ($syntax-dispatch
                                              %%tmp2586
                                              '(any any))))
                                         %%e2584))))
                                 (%%gen-ref2540
                                  (lambda (%%src2576
                                           %%var2575
                                           %%level2574
                                           %%maps2573)
                                    (if (= %%level2574 '0)
                                        (values %%var2575 %%maps2573)
                                        (if (null? %%maps2573)
                                            (syntax-error
                                              %%src2576
                                              '"missing ellipsis in syntax form")
                                            (call-with-values
                                              (lambda ()
                                                (%%gen-ref2540
                                                  %%src2576
                                                  %%var2575
                                                  (- %%level2574 '1)
                                                  (cdr %%maps2573)))
                                              (lambda (%%outer-var2578
                                                       %%outer-maps2577)
                                                ((lambda (%%b2579)
                                                   (if %%b2579
                                                       (values
                                                         (cdr %%b2579)
                                                         %%maps2573)
                                                       ((lambda (%%inner-var2580)
                                                          (values
                                                            %%inner-var2580
                                                            (cons (cons (cons %%outer-var2578
                                                                              %%inner-var2580)
                                                                        (car %%maps2573))
                                                                  %%outer-maps2577)))
                                                        (%%gen-var557
                                                          'tmp))))
                                                 (assq %%outer-var2578
                                                       (car %%maps2573)))))))))
                                 (%%gen-append2541
                                  (lambda (%%x2572 %%y2571)
                                    (if (equal? %%y2571 ''())
                                        %%x2572
                                        (list 'append %%x2572 %%y2571))))
                                 (%%gen-mappend2542
                                  (lambda (%%e2570 %%map-env2569)
                                    (list 'apply
                                          '(primitive append)
                                          (%%gen-map2543
                                            %%e2570
                                            %%map-env2569))))
                                 (%%gen-map2543
                                  (lambda (%%e2562 %%map-env2561)
                                    ((lambda (%%formals2564 %%actuals2563)
                                       (if (eq? (car %%e2562) 'ref)
                                           (car %%actuals2563)
                                           (if (andmap
                                                 (lambda (%%x2567)
                                                   (if (eq? (car %%x2567)
                                                            'ref)
                                                       (memq (cadr %%x2567)
                                                             %%formals2564)
                                                       '#f))
                                                 (cdr %%e2562))
                                               (cons 'map
                                                     (cons (list 'primitive
                                                                 (car %%e2562))
                                                           (map ((lambda (%%r2565)
                                                                   (lambda (%%x2566)
                                                                     (cdr (assq (cadr %%x2566)
                                                                                %%r2565))))
                                                                 (map cons
                                                                      %%formals2564
                                                                      %%actuals2563))
                                                                (cdr %%e2562))))
                                               (cons 'map
                                                     (cons (list 'lambda
                                                                 %%formals2564
                                                                 %%e2562)
                                                           %%actuals2563)))))
                                     (map cdr %%map-env2561)
                                     (map (lambda (%%x2568)
                                            (list 'ref (car %%x2568)))
                                          %%map-env2561))))
                                 (%%gen-cons2544
                                  (lambda (%%e2557
                                           %%x2556
                                           %%y2555
                                           %%xnew2554
                                           %%ynew2553)
                                    ((lambda (%%t2558)
                                       (if (memv %%t2558 '(quote))
                                           (if (eq? (car %%xnew2554)
                                                    'quote)
                                               ((lambda (%%xnew2560
                                                         %%ynew2559)
                                                  (if (if (eq? %%xnew2560
                                                               %%x2556)
                                                          (eq? %%ynew2559
                                                               %%y2555)
                                                          '#f)
                                                      (list 'quote %%e2557)
                                                      (list 'quote
                                                            (cons %%xnew2560
                                                                  %%ynew2559))))
                                                (cadr %%xnew2554)
                                                (cadr %%ynew2553))
                                               (if (eq? (cadr %%ynew2553)
                                                        '())
                                                   (list 'list %%xnew2554)
                                                   (list 'cons
                                                         %%xnew2554
                                                         %%ynew2553)))
                                           (if (memv %%t2558 '(list))
                                               (cons 'list
                                                     (cons %%xnew2554
                                                           (cdr %%ynew2553)))
                                               (list 'cons
                                                     %%xnew2554
                                                     %%ynew2553))))
                                     (car %%ynew2553))))
                                 (%%gen-vector2545
                                  (lambda (%%e2552 %%ls2551 %%lsnew2550)
                                    (if (eq? (car %%lsnew2550) 'quote)
                                        (if (eq? (cadr %%lsnew2550)
                                                 %%ls2551)
                                            (list 'quote %%e2552)
                                            (list 'quote
                                                  (list->vector
                                                    (cadr %%lsnew2550))))
                                        (if (eq? (car %%lsnew2550) 'list)
                                            (cons 'vector
                                                  (cdr %%lsnew2550))
                                            (list 'list->vector
                                                  %%lsnew2550)))))
                                 (%%regen2546
                                  (lambda (%%x2547)
                                    ((lambda (%%t2548)
                                       (if (memv %%t2548 '(ref))
                                           (build-source
                                             '#f
                                             (cadr %%x2547))
                                           (if (memv %%t2548 '(primitive))
                                               (build-source
                                                 '#f
                                                 (cadr %%x2547))
                                               (if (memv %%t2548 '(quote))
                                                   (build-source
                                                     '#f
                                                     (list (build-source
                                                             '#f
                                                             'quote)
                                                           (attach-source
                                                             '#f
                                                             (cadr %%x2547))))
                                                   (if (memv %%t2548
                                                             '(lambda))
                                                       (build-source
                                                         '#f
                                                         (list (build-source
                                                                 '#f
                                                                 'lambda)
                                                               (%%build-params256
                                                                 '#f
                                                                 (cadr %%x2547))
                                                               (%%regen2546
                                                                 (caddr
                                                                   %%x2547))))
                                                       (if (memv %%t2548
                                                                 '(map))
                                                           ((lambda (%%ls2549)
                                                              (build-source
                                                                '#f
                                                                (cons (if (= (length
                                                                               %%ls2549)
                                                                             '2)
                                                                          (build-source
                                                                            '#f
                                                                            'map)
                                                                          (build-source
                                                                            '#f
                                                                            'map))
                                                                      %%ls2549)))
                                                            (map %%regen2546
                                                                 (cdr %%x2547)))
                                                           (build-source
                                                             '#f
                                                             (cons (build-source
                                                                     '#f
                                                                     (car %%x2547))
                                                                   (map %%regen2546
                                                                        (cdr %%x2547))))))))))
                                     (car %%x2547)))))
                          (lambda (%%e2645
                                   %%r2644
                                   %%mr2643
                                   %%w2642
                                   %%ae2641
                                   %%m?2640)
                            ((lambda (%%e2646)
                               ((lambda (%%tmp2647)
                                  ((lambda (%%tmp2648)
                                     (if %%tmp2648
                                         (apply
                                           (lambda (%%_2651 %%x2650)
                                             (call-with-values
                                               (lambda ()
                                                 (%%gen-syntax2539
                                                   %%e2646
                                                   %%x2650
                                                   %%r2644
                                                   '()
                                                   %%ellipsis?553))
                                               (lambda (%%e2653 %%maps2652)
                                                 (%%regen2546 %%e2653))))
                                           %%tmp2648)
                                         ((lambda (%%_2649)
                                            (syntax-error %%e2646))
                                          %%tmp2647)))
                                   ($syntax-dispatch
                                     %%tmp2647
                                     '(any any))))
                                %%e2646))
                             (%%source-wrap481
                               %%e2645
                               %%w2642
                               %%ae2641)))))))
                   (%%global-extend344
                     'core
                     'lambda
                     (lambda (%%e2532
                              %%r2531
                              %%mr2530
                              %%w2529
                              %%ae2528
                              %%m?2527)
                       ((lambda (%%tmp2533)
                          ((lambda (%%tmp2534)
                             (if %%tmp2534
                                 (apply
                                   (lambda (%%_2536 %%c2535)
                                     (call-with-values
                                       (lambda ()
                                         (%%chi-lambda-clause550
                                           (%%source-wrap481
                                             %%e2532
                                             %%w2529
                                             %%ae2528)
                                           %%c2535
                                           %%r2531
                                           %%mr2530
                                           %%w2529
                                           %%m?2527))
                                       (lambda (%%vars2538 %%body2537)
                                         (build-source
                                           %%ae2528
                                           (list (build-source
                                                   %%ae2528
                                                   'lambda)
                                                 (%%build-params256
                                                   %%ae2528
                                                   %%vars2538)
                                                 %%body2537)))))
                                   %%tmp2534)
                                 (syntax-error %%tmp2533)))
                           ($syntax-dispatch %%tmp2533 '(any . any))))
                        %%e2532)))
                   (%%global-extend344
                     'core
                     'letrec
                     (lambda (%%e2508
                              %%r2507
                              %%mr2506
                              %%w2505
                              %%ae2504
                              %%m?2503)
                       ((lambda (%%tmp2509)
                          ((lambda (%%tmp2510)
                             (if %%tmp2510
                                 (apply
                                   (lambda (%%_2516
                                            %%id2515
                                            %%val2514
                                            %%e12513
                                            %%e22512)
                                     ((lambda (%%ids2517)
                                        (if (not (%%valid-bound-ids?476
                                                   %%ids2517))
                                            (%%invalid-ids-error478
                                              (map (lambda (%%x2525)
                                                     (%%wrap480
                                                       %%x2525
                                                       %%w2505))
                                                   %%ids2517)
                                              (%%source-wrap481
                                                %%e2508
                                                %%w2505
                                                %%ae2504)
                                              '"bound variable")
                                            ((lambda (%%labels2519
                                                      %%new-vars2518)
                                               ((lambda (%%w2521 %%r2520)
                                                  (%%build-letrec276
                                                    %%ae2504
                                                    %%new-vars2518
                                                    (map (lambda (%%x2524)
                                                           (%%chi534
                                                             %%x2524
                                                             %%r2520
                                                             %%mr2506
                                                             %%w2521
                                                             %%m?2503))
                                                         %%val2514)
                                                    (%%chi-body539
                                                      (cons %%e12513
                                                            %%e22512)
                                                      (%%source-wrap481
                                                        %%e2508
                                                        %%w2521
                                                        %%ae2504)
                                                      %%r2520
                                                      %%mr2506
                                                      %%w2521
                                                      %%m?2503)))
                                                (%%make-binding-wrap456
                                                  %%ids2517
                                                  %%labels2519
                                                  %%w2505)
                                                (%%extend-var-env*337
                                                  %%labels2519
                                                  %%new-vars2518
                                                  %%r2507)))
                                             (%%gen-labels406 %%ids2517)
                                             (map %%gen-var557
                                                  %%ids2517))))
                                      %%id2515))
                                   %%tmp2510)
                                 ((lambda (%%_2511)
                                    (syntax-error
                                      (%%source-wrap481
                                        %%e2508
                                        %%w2505
                                        %%ae2504)))
                                  %%tmp2509)))
                           ($syntax-dispatch
                             %%tmp2509
                             '(any #(each (any any)) any . each-any))))
                        %%e2508)))
                   (%%global-extend344
                     'core
                     'if
                     (lambda (%%e2491
                              %%r2490
                              %%mr2489
                              %%w2488
                              %%ae2487
                              %%m?2486)
                       ((lambda (%%tmp2492)
                          ((lambda (%%tmp2493)
                             (if %%tmp2493
                                 (apply
                                   (lambda (%%_2502 %%test2501 %%then2500)
                                     (build-source
                                       %%ae2487
                                       (list (build-source %%ae2487 'if)
                                             (%%chi534
                                               %%test2501
                                               %%r2490
                                               %%mr2489
                                               %%w2488
                                               %%m?2486)
                                             (%%chi534
                                               %%then2500
                                               %%r2490
                                               %%mr2489
                                               %%w2488
                                               %%m?2486)
                                             (%%chi-void552))))
                                   %%tmp2493)
                                 ((lambda (%%tmp2494)
                                    (if %%tmp2494
                                        (apply
                                          (lambda (%%_2499
                                                   %%test2498
                                                   %%then2497
                                                   %%else2496)
                                            (build-source
                                              %%ae2487
                                              (list (build-source
                                                      %%ae2487
                                                      'if)
                                                    (%%chi534
                                                      %%test2498
                                                      %%r2490
                                                      %%mr2489
                                                      %%w2488
                                                      %%m?2486)
                                                    (%%chi534
                                                      %%then2497
                                                      %%r2490
                                                      %%mr2489
                                                      %%w2488
                                                      %%m?2486)
                                                    (%%chi534
                                                      %%else2496
                                                      %%r2490
                                                      %%mr2489
                                                      %%w2488
                                                      %%m?2486))))
                                          %%tmp2494)
                                        ((lambda (%%_2495)
                                           (syntax-error
                                             (%%source-wrap481
                                               %%e2491
                                               %%w2488
                                               %%ae2487)))
                                         %%tmp2492)))
                                  ($syntax-dispatch
                                    %%tmp2492
                                    '(any any any any)))))
                           ($syntax-dispatch %%tmp2492 '(any any any))))
                        %%e2491)))
                   (%%global-extend344 'set! 'set! '())
                   (%%global-extend344 'alias 'alias '())
                   (%%global-extend344 'begin 'begin '())
                   (%%global-extend344 '$module-key '$module '())
                   (%%global-extend344 '$import '$import '())
                   (%%global-extend344 'define 'define '())
                   (%%global-extend344 'define-syntax 'define-syntax '())
                   (%%global-extend344 'eval-when 'eval-when '())
                   (%%global-extend344 'meta 'meta '())
                   (%%global-extend344
                     'core
                     'syntax-case
                     ((lambda ()
                        (letrec ((%%convert-pattern2335
                                  (lambda (%%pattern2417 %%keys2416)
                                    (letrec ((%%cvt*2418
                                              (lambda (%%p*2463
                                                       %%n2462
                                                       %%ids2461)
                                                (if (null? %%p*2463)
                                                    (values '() %%ids2461)
                                                    (call-with-values
                                                      (lambda ()
                                                        (%%cvt*2418
                                                          (cdr %%p*2463)
                                                          %%n2462
                                                          %%ids2461))
                                                      (lambda (%%y2465
                                                               %%ids2464)
                                                        (call-with-values
                                                          (lambda ()
                                                            (%%cvt2419
                                                              (car %%p*2463)
                                                              %%n2462
                                                              %%ids2464))
                                                          (lambda (%%x2467
                                                                   %%ids2466)
                                                            (values
                                                              (cons %%x2467
                                                                    %%y2465)
                                                              %%ids2466))))))))
                                             (%%cvt2419
                                              (lambda (%%p2422
                                                       %%n2421
                                                       %%ids2420)
                                                (if (%%id?346 %%p2422)
                                                    (if (%%bound-id-member?479
                                                          %%p2422
                                                          %%keys2416)
                                                        (values
                                                          (vector
                                                            'free-id
                                                            %%p2422)
                                                          %%ids2420)
                                                        (values
                                                          'any
                                                          (cons (cons %%p2422
                                                                      %%n2421)
                                                                %%ids2420)))
                                                    ((lambda (%%tmp2423)
                                                       ((lambda (%%tmp2424)
                                                          (if (if %%tmp2424
                                                                  (apply
                                                                    (lambda (%%x2460
                                                                             %%dots2459)
                                                                      (%%ellipsis?553
                                                                        %%dots2459))
                                                                    %%tmp2424)
                                                                  '#f)
                                                              (apply
                                                                (lambda (%%x2456
                                                                         %%dots2455)
                                                                  (call-with-values
                                                                    (lambda ()
                                                                      (%%cvt2419
                                                                        %%x2456
                                                                        (+ %%n2421
                                                                           '1)
                                                                        %%ids2420))
                                                                    (lambda (%%p2458
                                                                             %%ids2457)
                                                                      (values
                                                                        (if (eq? %%p2458
                                                                                 'any)
                                                                            'each-any
                                                                            (vector
                                                                              'each
                                                                              %%p2458))
                                                                        %%ids2457))))
                                                                %%tmp2424)
                                                              ((lambda (%%tmp2425)
                                                                 (if (if %%tmp2425
                                                                         (apply
                                                                           (lambda (%%x2454
                                                                                    %%dots2453
                                                                                    %%y2452
                                                                                    %%z2451)
                                                                             (%%ellipsis?553
                                                                               %%dots2453))
                                                                           %%tmp2425)
                                                                         '#f)
                                                                     (apply
                                                                       (lambda (%%x2443
                                                                                %%dots2442
                                                                                %%y2441
                                                                                %%z2440)
                                                                         (call-with-values
                                                                           (lambda ()
                                                                             (%%cvt2419
                                                                               %%z2440
                                                                               %%n2421
                                                                               %%ids2420))
                                                                           (lambda (%%z2445
                                                                                    %%ids2444)
                                                                             (call-with-values
                                                                               (lambda ()
                                                                                 (%%cvt*2418
                                                                                   %%y2441
                                                                                   %%n2421
                                                                                   %%ids2444))
                                                                               (lambda (%%y2447
                                                                                        %%ids2446)
                                                                                 (call-with-values
                                                                                   (lambda ()
                                                                                     (%%cvt2419
                                                                                       %%x2443
                                                                                       (+ %%n2421
                                                                                          '1)
                                                                                       %%ids2446))
                                                                                   (lambda (%%x2449
                                                                                            %%ids2448)
                                                                                     (values
                                                                                       (vector
                                                                                         'each+
                                                                                         %%x2449
                                                                                         (reverse
                                                                                           %%y2447)
                                                                                         %%z2445)
                                                                                       %%ids2448))))))))
                                                                       %%tmp2425)
                                                                     ((lambda (%%tmp2426)
                                                                        (if %%tmp2426
                                                                            (apply
                                                                              (lambda (%%x2435
                                                                                       %%y2434)
                                                                                (call-with-values
                                                                                  (lambda ()
                                                                                    (%%cvt2419
                                                                                      %%y2434
                                                                                      %%n2421
                                                                                      %%ids2420))
                                                                                  (lambda (%%y2437
                                                                                           %%ids2436)
                                                                                    (call-with-values
                                                                                      (lambda ()
                                                                                        (%%cvt2419
                                                                                          %%x2435
                                                                                          %%n2421
                                                                                          %%ids2436))
                                                                                      (lambda (%%x2439
                                                                                               %%ids2438)
                                                                                        (values
                                                                                          (cons %%x2439
                                                                                                %%y2437)
                                                                                          %%ids2438))))))
                                                                              %%tmp2426)
                                                                            ((lambda (%%tmp2427)
                                                                               (if %%tmp2427
                                                                                   (apply
                                                                                     (lambda ()
                                                                                       (values
                                                                                         '()
                                                                                         %%ids2420))
                                                                                     %%tmp2427)
                                                                                   ((lambda (%%tmp2428)
                                                                                      (if %%tmp2428
                                                                                          (apply
                                                                                            (lambda (%%x2430)
                                                                                              (call-with-values
                                                                                                (lambda ()
                                                                                                  (%%cvt2419
                                                                                                    %%x2430
                                                                                                    %%n2421
                                                                                                    %%ids2420))
                                                                                                (lambda (%%p2432
                                                                                                         %%ids2431)
                                                                                                  (values
                                                                                                    (vector
                                                                                                      'vector
                                                                                                      %%p2432)
                                                                                                    %%ids2431))))
                                                                                            %%tmp2428)
                                                                                          ((lambda (%%x2429)
                                                                                             (values
                                                                                               (vector
                                                                                                 'atom
                                                                                                 (%%strip556
                                                                                                   %%p2422
                                                                                                   '(())))
                                                                                               %%ids2420))
                                                                                           %%tmp2423)))
                                                                                    ($syntax-dispatch
                                                                                      %%tmp2423
                                                                                      '#(vector
                                                                                         each-any)))))
                                                                             ($syntax-dispatch
                                                                               %%tmp2423
                                                                               '()))))
                                                                      ($syntax-dispatch
                                                                        %%tmp2423
                                                                        '(any .
                                                                              any)))))
                                                               ($syntax-dispatch
                                                                 %%tmp2423
                                                                 '(any any
                                                                       .
                                                                       #(each+
                                                                         any
                                                                         ()
                                                                         any))))))
                                                        ($syntax-dispatch
                                                          %%tmp2423
                                                          '(any any))))
                                                     %%p2422)))))
                                      (%%cvt2419 %%pattern2417 '0 '()))))
                                 (%%build-dispatch-call2336
                                  (lambda (%%pvars2409
                                           %%exp2408
                                           %%y2407
                                           %%r2406
                                           %%mr2405
                                           %%m?2404)
                                    ((lambda (%%ids2411 %%levels2410)
                                       ((lambda (%%labels2413
                                                 %%new-vars2412)
                                          (build-source
                                            '#f
                                            (list (build-source '#f 'apply)
                                                  (build-source
                                                    '#f
                                                    (list (build-source
                                                            '#f
                                                            'lambda)
                                                          (%%build-params256
                                                            '#f
                                                            %%new-vars2412)
                                                          (%%chi534
                                                            %%exp2408
                                                            (%%extend-env*336
                                                              %%labels2413
                                                              (map (lambda (%%var2415
                                                                            %%level2414)
                                                                     (cons 'syntax
                                                                           (cons %%var2415
                                                                                 %%level2414)))
                                                                   %%new-vars2412
                                                                   (map cdr
                                                                        %%pvars2409))
                                                              %%r2406)
                                                            %%mr2405
                                                            (%%make-binding-wrap456
                                                              %%ids2411
                                                              %%labels2413
                                                              '(()))
                                                            %%m?2404)))
                                                  %%y2407)))
                                        (%%gen-labels406 %%ids2411)
                                        (map %%gen-var557 %%ids2411)))
                                     (map car %%pvars2409)
                                     (map cdr %%pvars2409))))
                                 (%%gen-clause2337
                                  (lambda (%%x2371
                                           %%keys2370
                                           %%clauses2369
                                           %%r2368
                                           %%mr2367
                                           %%m?2366
                                           %%pat2365
                                           %%fender2364
                                           %%exp2363)
                                    (call-with-values
                                      (lambda ()
                                        (%%convert-pattern2335
                                          %%pat2365
                                          %%keys2370))
                                      (lambda (%%p2373 %%pvars2372)
                                        (if (not (%%distinct-bound-ids?477
                                                   (map car %%pvars2372)))
                                            (%%invalid-ids-error478
                                              (map car %%pvars2372)
                                              %%pat2365
                                              '"pattern variable")
                                            (if (not (andmap
                                                       (lambda (%%x2403)
                                                         (not (%%ellipsis?553
                                                                (car %%x2403))))
                                                       %%pvars2372))
                                                (syntax-error
                                                  %%pat2365
                                                  '"misplaced ellipsis in syntax-case pattern")
                                                ((lambda (%%y2374)
                                                   (build-source
                                                     '#f
                                                     (list (build-source
                                                             '#f
                                                             (list (build-source
                                                                     '#f
                                                                     'lambda)
                                                                   (%%build-params256
                                                                     '#f
                                                                     (list %%y2374))
                                                                   (build-source
                                                                     '#f
                                                                     (list (build-source
                                                                             '#f
                                                                             'if)
                                                                           ((lambda (%%tmp2400)
                                                                              ((lambda (%%tmp2401)
                                                                               