/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2008 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "allocate.h"
#include "widgets.h"
#include "gettext.h"
#include "show_info.h"
#include "list_scopes.h"
#include "reread_conf.h"

extern char DHCPD_CONF_BUF[1024];



void add_scope(struct w *widgets)
{
    FILE *fp;
    char *line;
    long conf_size = 0;
    int scope_found = 0;
    G_CONST_RETURN gchar *nic, *subnet, *netmask;
    gchar *scope, *scope_line, *info;

    nic = gtk_entry_get_text(GTK_ENTRY(widgets->scope_add_nic_entry));
    subnet = gtk_entry_get_text(GTK_ENTRY(widgets->scope_add_subnet_entry));
    netmask = gtk_entry_get_text(GTK_ENTRY(widgets->scope_add_netmask_entry));

    if( strlen(nic) == 0 )
    {
	info = g_strdup_printf(_("The name of the network card is too short, the scope was not added.\n"));
	show_info(info);
	g_free(info);
	return;
    }
    if( strlen(subnet) < 7 )
    {
	info = g_strdup_printf(_("The network address is too short, the scope was not added.\n"));
	show_info(info);
	g_free(info);
	return;
    }
    if( strlen(netmask) < 7 )
    {
	info = g_strdup_printf(_("The subnet mask is too short, the scope was not added.\n"));
	show_info(info);
	g_free(info);
	return;
    }


    /* Dont add the scope if it already exists */
    if((fp=fopen(DHCPD_CONF_BUF, "r"))==NULL)
    {
        printf("Could not read dhcpd.conf here: %s\n", DHCPD_CONF_BUF);
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);
    line = allocate(conf_size+1);
				    
    scope_line = g_strdup_printf("subnet %s netmask %s {\n", subnet, netmask);

    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
        if( !strcmp(line, scope_line) && ! strstr(line, "#") )
        {
            scope_found = 1;
            break;
        }
    }
    fclose(fp);
    free(line);
    g_free(scope_line);

    if( scope_found )
    {
	info = g_strdup_printf(_("The scope already exists, the scope was not added.\n"));
        show_info(info);
        g_free(info);
        return;
    }


    /* Add the scope, FIXME: add it before other scopes */
    if((fp=fopen(DHCPD_CONF_BUF, "a"))==NULL)
    {
        printf("Couldnt write dhcpd.conf here: %s\n", DHCPD_CONF_BUF);
        return;
    }

    /* Also adds some standard values such as time etc */
    scope = g_strconcat("\nsubnet ", subnet, " netmask ", netmask," {\n",
    "   interface ", nic,";\n",
    
    "	option subnet-mask ", netmask, ";\n",

    "	default-lease-time 6000;\n",
    "	max-lease-time 7200;\n",
    "	option time-offset -3600;\n",
    
    "}\n",
    NULL);

    fputs(scope, fp);    
    fclose(fp);    

    g_free(scope);

    /* FIXME set this as the selected scope (now we have the first scope as selected) */
    list_scopes(widgets);

    reread_conf();
}
