/* 

                          Firewall Builder

                 Copyright (C) 2004 NetCitadel, LLC

  Author:  Vadim Kurland vadim@fwbuilder.org

  $Id: RCSFilePreview.cpp,v 1.18 2006/10/21 15:12:11 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "global.h"

#include <RCS.h>
#include <RCSFilePreview.h>
#include <RCSFileDialog.h>

#include "fwbuilder/libfwbuilder-config.h"
#include "fwbuilder/FWException.h"

#include <qlistview.h>
#include <qregexp.h>
#include <qpushbutton.h>
#include <qtextbrowser.h>

#include <string>
#include <iostream>

using namespace std;
using namespace libfwbuilder;

int RCSViewItem::compare(QListViewItem *itm, int col, bool ascending) const
{
    QString rev1 = text(col);
    QString rev2 = itm->text(col);

    for(int i=1; ; i++)
    {
        QString v1 = rev1.section(".",i,i);
        QString v2 = rev2.section(".",i,i);
        if (v1=="" && v2=="") return 0;
        if (v1==v2) continue;
        if (v1=="" && v2!="") return -1;
        if (v1!="" && v2=="") return 1;
        if (v1.toInt()>v2.toInt()) return 1;
        if (v1.toInt()<v2.toInt()) return -1;
        i++;
    }
    return 0;
}


RCSFilePreview::RCSFilePreview( RCSFileDialog *parent )
    : RCSFilePreview_q(parent), QFilePreview()
{
    if (fwbdebug) qDebug("RCSFilePreview: constructor");

    dialog=parent;

//    setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)7, false ) );

//    RCSTreeView->setResizePolicy( QListView::AutoOneFit );
    RCSTreeView->setResizeMode( QListView::LastColumn );
    RCSTreeView->setColumnWidthMode(0, QListView::Maximum );
    RCSTreeView->setColumnWidth(0, 60 );
    RCSTreeView->setColumnWidthMode(1, QListView::Maximum );
    RCSTreeView->setColumnWidth(1, 60 );
    RCSTreeView->setColumnWidthMode(2, QListView::Maximum );
    RCSTreeView->setColumnWidth(2, 60 );
    RCSTreeView->setColumnWidthMode(3, QListView::Maximum );
    RCSTreeView->setAllColumnsShowFocus( true );
    RCSTreeView->setSelectionMode( QListView::Single );
    RCSTreeView->setShowSortIndicator( FALSE );
    RCSTreeView->setTreeStepSize( 20 );
    RCSTreeView->setItemMargin( 2 );
    RCSTreeView->setRootIsDecorated( FALSE );
    RCSTreeView->setSorting( 0 );

    RCSTreeView->setResizePolicy( QScrollView::AutoOneFit );
    RCSTreeView->setResizeMode( QListView::LastColumn );
//    RCSTreeView->setHScrollBarMode( QScrollView::AlwaysOff );

    if (fwbdebug) qDebug("RCSFilePreview: constructor done");

    rcs=NULL;
}

RCSFilePreview::~RCSFilePreview()
{
    if (fwbdebug) qDebug("~RCSFilePreview()  rcs=%p",rcs);
//    if (rcs!=NULL) delete rcs;
}

void RCSFilePreview::openReadOnly()
{
    if (rcs!=NULL) rcs->setRO(true);
    dialog->openFileRO();
}

void RCSFilePreview::selectedRevision(QListViewItem *itm)
{
    QString rev=itm->text(0);
    assert(rcs!=NULL);
    rcs->setSelectedRev(rev);
    comment->setText( rcsComments[rev] );
    if (fwbdebug) qDebug("RCSFilePreview::selectedRevision : %s",rev.ascii());
}

void RCSFilePreview::showFileRLog( const QString &filename )
{
    if (fwbdebug) qDebug("RCSFilePreview::showFileRLog filename=%s rcs=%p",
                         filename.ascii(),rcs);

    RCSTreeView->clear();

    if (rcs!=NULL) delete rcs;
    rcs = new RCS(filename);

    if (rcs->revisions.size()==0)
    {
        QListViewItem *itm=new QListViewItem(RCSTreeView);
        itm->setText( 0, tr("File is not in RCS") );
//        addToRCS->setEnabled(true);
        comment->setText("");

        return;
    }
//    addToRCS->setEnabled(false);

    QListViewItem *rootItm=new QListViewItem( RCSTreeView );
    rootItm->setText(0, filename.right( filename.length()-filename.findRev("/")-1 ) );
    rootItm->setOpen(true);

    rcsComments.clear();

    QValueList<Revision>::iterator i;
    for (i=rcs->revisions.begin(); i!=rcs->revisions.end(); ++i)
    {
        rcsComments[(*i).rev]=(*i).log;

        if ((*i).rev.find(QRegExp("^[0-9]+\\.[0-9]+$"))!=-1)
        {
            RCSViewItem *itm=new RCSViewItem( rootItm );
            itm->setText( 0, (*i).rev       );
            itm->setText( 1, (*i).date      );
            itm->setText( 2, (*i).author    );
            itm->setText( 3, QString("    ")+(*i).locked_by );
        }

        if ((*i).rev.find(QRegExp("^[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+"))!=-1)
        {
            QString branch_root = (*i).rev.section(".",0,1);
            QListViewItem   *br = RCSTreeView->findItem(branch_root, 0);
            if (br!=NULL)
            {
                RCSViewItem *itm=new RCSViewItem(br);
                itm->setText( 0, (*i).rev       );
                itm->setText( 1, (*i).date      );
                itm->setText( 2, (*i).author    );
                itm->setText( 3, QString("    ")+(*i).locked_by );
            }
        }
    }

    RCSTreeView->setSelected( RCSTreeView->lastItem() , true );
    RCSTreeView->ensureItemVisible( RCSTreeView->lastItem() );
}

void RCSFilePreview::previewUrl( const QUrl &u )
{
    if (fwbdebug) qDebug("RCSFilePreview::previewUrl u=%s",
                         u.toString().ascii());

    QString f=u.path(true);

/* if file name ends with '/', it is a directory - no need to check
 * for RCS.
 *
 * The file name we get here is a part of an URL, therefore it always
 * uses '/', even on windows
 */
    
    if (f.findRev('/')!=(int)(f.length())-1 )
    {
        current_file=f;
        showFileRLog( current_file );
    }
}

RCS* RCSFilePreview::getSelectedRev()
{
    if (fwbdebug) qDebug("RCSFilePreview::getSelectedRev rcs=%p",rcs);

    return rcs;

//    if (rcs!=NULL) return rcs;
//    return new RCS(current_file);
}




