#!/bin/sh

if [ -x /bin/bash ];           then BASH="/bin/bash";           fi
if [ -x /usr/bin/bash ];       then BASH="/usr/bin/bash";       fi
if [ -x /usr/local/bin/bash ]; then BASH="/usr/local/bin/bash"; fi
if [ -z "$BASH" ]; then
  echo "Could not find bash."
  exit 1
fi

PACKAGE_NAME="fwbuilder"

. VERSION

RPMROOT=/var/tmp/${PACKAGE_NAME}
EXPORTDIR=`pwd`/export
TAR_FILE=${PACKAGE_NAME}-${VERSION}.tar.gz
SNAPSHOT_DIR=${PACKAGE_NAME}-${VERSION}

TMP_FILE=${EXPORTDIR}/.maketar.tmp.sh

SPECFILE=`ls *.spec 2>/dev/null`

RPMFILES=""

#
# files regenerated by autogen.sh
GENFILES="aclocal.m4"

for f in ${GENFILES}; do
    test -f $f && RPMFILES="${RPMFILES} $f"
done


mkdir -p ${EXPORTDIR}

#cat > ${TMP_FILE} << EOF

function die {
   echo $1
   exit 1
}

if test -z ${PACKAGE_NAME} -o -z ${VERSION}; then
  echo Usage: maketar.sh package_name version
  exit 1
fi

# make distclean

RPMFILES="autogen.sh               \
	  build_num                \
          config.h.in              \
          configure                \
          configure.in             \
          config.sub               \
          config.guess             \
          acinclude.m4             \
          fwbuilder2.pro           \
          install.sh               \
          maketar.sh               \
          missing                  \
          mkinstalldirs            \
          printversion.sh          \
          qmake.inc                \
          qmake.inc.in             \
          runqmake.sh              \
          VERSION                  \
          VERSION.h                \
          definitions.h            \

          m4/*.m4                  \
          po/*.pot                 \
          po/POmakefile*           \
          po/LINGUAS               \
          po/*.pro                 \
          po/*.sin                 \
          po/*.po                  \
          po/*.ts                  \
          po/*.qm                  \

	  doc                      \

	  src/*.pro                \

          src/gui/*.pro            \
          src/gui/*.cw             \
          src/gui/*.cpp            \
          src/gui/*.h              \
          src/gui/*.ui             \
          src/gui/icons            \
          src/gui/images           \

          src/ipt/*.pro            \
          src/ipt/*.cpp            \
          src/ipt/*.h              \

          src/pflib/*.pro          \
          src/pflib/*.cpp          \
          src/pflib/*.h            \

          src/pf/*.pro             \
          src/pf/*.cpp             \

          src/ipf/*.pro            \
          src/ipf/*.cpp            \

          src/ipfw/*.pro           \
          src/ipfw/*.cpp           \

          src/cisco_lib/*.pro      \
          src/cisco_lib/*.cpp      \
          src/cisco_lib/*.h        \

          src/iosacl/*.pro         \
          src/iosacl/*.cpp         \
          src/iosacl/*.h           \

          src/pix/*.pro            \
          src/pix/*.cpp            \
          src/pix/*.h              \

          src/fwblookup/*.pro      \
          src/fwblookup/*.cpp      \

          src/fwbedit/*.pro        \
          src/fwbedit/*.cpp        \

          src/common/*.cpp         \

          src/res/*                \

          src/antlr/*.pro          \
          src/antlr/*.hpp          \
          src/antlr/*.cpp          \

          src/parsers/*.g          \
          src/parsers/*.hpp        \
          src/parsers/*.cpp        \
          src/parsers/*.pro        \

          src/tools/*.pro          \
          src/tools/fwb_install    \
          src/tools/fwb_compile_all
"

RPMFILES="${RPMFILES} ${SPECFILE}"


cd ${EXPORTDIR}
rm -rf ${SNAPSHOT_DIR}
ln -s .. ${SNAPSHOT_DIR}

FILELIST=`for f in ${RPMFILES}; do echo ${SNAPSHOT_DIR}/$f; done`

tar -ch  --exclude CVS --exclude api --exclude Tutorial --exclude *.bak -f - ${FILELIST}  | gzip > ${TAR_FILE} 
cd ..

#EOF
#
#$BASH $TMP_FILE

#rm -f $TMP_FILE

