/* 

                          Firewall Builder

                 Copyright (C) 2004 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: StartWizard.cpp,v 1.12 2005/01/03 01:43:50 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "../../config.h"
#include "global.h"

#include "StartWizard.h"
#include "RCSFileDialog.h"
#include "FWWindow.h"
#include "FWBSettings.h"

#include <qfileinfo.h>
#include <qmessagebox.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qfile.h>

#include <errno.h>
#include <iostream>

using namespace std;
using namespace libfwbuilder;


StartWizard::StartWizard()
{
    wantRCS=false;
    oldfile=false;
    newfile=false;

    cancelButton()->hide();

    programName->setText( QObject::tr(QString("<b>Firewall Builder %1</b>")).arg(VERSION) );

    setNextEnabled(   QWizard::page(0), false );
    setHelpEnabled(   QWizard::page(0), false );
    setHelpEnabled(   QWizard::page(1), false );
}

void StartWizard::openFile()
{
    RCSFileDialog   fd(this, 0, true);

    if ( fd.exec()== QDialog::Accepted )
    {
        RCS *rcs = fd.getSelectedRev();

        if (rcs==NULL) return;

        try
        {
            rcs->co();

        } catch (FWException &ex)
        {
/* if there was an exception, abort operation. */
            return;
        }
/***********************************************************************/

        mw->load( this, rcs );
        mw->showFirewalls();

        if (rcs->isTemp()) QFile(rcs->getFileName()).remove();

        setFinishEnabled( QWizard::page(0), true );
        oldfile=true;

        accept();
    }
}

void StartWizard::newFile()
{
    fname=mw->chooseNewFileName(st->getWDir(),true,
                                tr("Choose name and location for the new file"));
    if (fname.isEmpty()) return;

    if (QFileInfo(fname).exists() && ! QFileInfo(fname).isWritable() )
    {
        QMessageBox::warning(
            this,"Firewall Builder", 
            tr("File %1 is read-only, you can not save changes to it.")
            .arg(fname),
            "&Continue", QString::null, QString::null,
            0, 1 );
        return;
    }

    mw->load(this);

    mw->setFileName(fname);

// save blank data into the new file ("initialize" it)
    mw->save();
    mw->fileClose();

    setNextEnabled( QWizard::page(0), true );
    newfile=true;
}

void StartWizard::selected(const QString &title)
{
    int p = indexOf( currentPage() );

    if (p==1 && newfile && !fname.isEmpty())
    {
        fileLbl->setText( fileLbl->text().arg(fname) );
        setFinishEnabled( QWizard::page(1), true );
    }
}

void StartWizard::accept()
{
    if (newfile && !fname.isEmpty())
    {
        if (autoopenBtn->isChecked())
        {
            st->setStartupAction(1);
            st->setLastEdited(fname);
        }

        RCS *rcs=new RCS(fname);
        if (rcsBtn->isChecked())
        {
            try
            {
                rcs->add();
            }
            catch (FWException &ex)
            {
                QMessageBox::warning(
                    this,"Firewall Builder", 
                    tr("Error adding file to RCS:\n%1").arg(ex.toString().c_str()),
                    "&Continue", QString::null,QString::null,
                    0, 1 );
            }
        } 
        try
        {
            rcs->co();
            mw->load( this, rcs );
        }
        catch (FWException &ex)
        {
            QMessageBox::warning(
                this,"Firewall Builder", 
                tr("Error opening file:\n%1").arg(ex.toString().c_str()),
                "&Continue", QString::null,QString::null,
                0, 1 );
        }
    }
    QWizard::accept();
}



