/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: MessageDialog.cc,v 1.25 2001/12/29 10:06:35 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#include <gtk--/main.h>

#include "MessageDialog.hh"
#include "helpers.hh"
#include "PixmapButton.hh"




using namespace libfwbuilder;


MessageDialog::MessageDialog(const string& msg,DlgType t)
{
    string     icn;


    hide();

    running=false;

    result=CANCEL;

    dialog_message->set_text(msg);
    dialog_message->set_justify(GTK_JUSTIFY_LEFT);


/*
 *  button1 : Yes
 *  button2 : No
 *  button3 : OK
 *  button4 : Cancel
 */

    button1->hide();
    button2->hide();
    button3->hide();
    button4->hide();

    PixmapButton::addPixmapAndText( *button1 , "Yes"    , "Yes"    );
    PixmapButton::addPixmapAndText( *button2 , "No"     , "No"     );
    PixmapButton::addPixmapAndText( *button3 , "Ok"     , "OK"     );
    PixmapButton::addPixmapAndText( *button4 , "Cancel" , "Cancel" );

    switch (t) {
    case QuestionDlg:
	icn = Resources::global_res->getIconPath("Question");
	button1->show();
	button2->show();
	button4->show();
	break;

    case YesNoDlg:
	icn = Resources::global_res->getIconPath("Question");
	button1->show();
	button2->show();
	break;

    case ErrorDlg:
	icn = Resources::global_res->getIconPath("Error");
	button3->show();
	break;

    case LongTextErrorDlg:
    case LongTextInfoDlg:
    {
	packer3->remove(*dialog_message);

	Gtk::ScrolledWindow *sw   = manage(new class Gtk::ScrolledWindow());
	Gtk::Text           *text = manage(new class Gtk::Text());

	text->set_editable(false);
	text->set_word_wrap(false);
	text->set_line_wrap(true);

	text->set_point(0);
	text->insert(msg);

	sw->set_policy(GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	sw->add(*text);
	sw->set_usize(650,300);

	packer3->add(*sw, GTK_SIDE_RIGHT, GTK_ANCHOR_CENTER, GTK_EXPAND|GTK_FILL_X|GTK_FILL_Y, 0, 0, 0, 0, 0);

	text->show();
	sw->show();
	
	if (t==LongTextErrorDlg)
	    icn = Resources::global_res->getIconPath("Error");
	if (t==LongTextInfoDlg)
	    icn = Resources::global_res->getIconPath("Info");
	
	button3->show();

	break;
    }
    case WarningDlg:
	icn = Resources::global_res->getIconPath("Warning");
	button3->show();
	break;
    }

    pixmap->set(icn);


    delete_event.connect( SigC::slot(this, &MessageDialog::on_delete) );

    show();
}

MessageDialog::DlgReturnValue MessageDialog::run()
{
    Gtk::Main::grab_add(*this);
    running=true;

    Gtk::Main::run();
    running=false;

    Gtk::Main::grab_remove(*this);
    hide();
    return result;
}

gint MessageDialog::on_delete(GdkEventAny* ev)
{
    if (running) {
	Gtk::Main::quit();
	running=false;
    }
    return(true);
}


/*
 *  button1 : Yes
 *  button2 : No
 *  button3 : OK
 *  button4 : Cancel
 */
void MessageDialog::on_button1_clicked()
{   
    result=OK_YES;
    Gtk::Main::quit();
    running=false;
}

void MessageDialog::on_button2_clicked()
{   
    result=NO;
    Gtk::Main::quit();
    running=false;
}

void MessageDialog::on_button3_clicked()
{   
    result=OK_YES;
    Gtk::Main::quit();
    running=false;
}

void MessageDialog::on_button4_clicked()
{   
    result=CANCEL;
    Gtk::Main::quit();
    running=false;
}

void MessageDialog::Error(const string& msg)
{
    MessageDialog *md = new MessageDialog(msg,ErrorDlg);
    md->run();
    delete md;
}

void MessageDialog::Error(const string& msg, const string& errcode)
{
    string m;
    m=msg + "\n" + errcode;
    MessageDialog *md = new MessageDialog(m,ErrorDlg);
    md->run();
    delete md;
}

void MessageDialog::LongTextError(const string& msg)
{
    MessageDialog *md = new MessageDialog(msg,LongTextErrorDlg);
    md->run();
    delete md;
}

void MessageDialog::LongTextError(const string& msg, const string& errcode)
{
    string m;
    m=msg + "\n" + errcode;
    MessageDialog *md = new MessageDialog(m,LongTextErrorDlg);
    md->run();
    delete md;
}

void MessageDialog::LongTextInfo(const string& msg)
{
    MessageDialog *md = new MessageDialog(msg,LongTextInfoDlg);
    md->run();
    delete md;
}

void MessageDialog::Warning(const string& msg)
{
    MessageDialog *md = new MessageDialog(msg,WarningDlg);
    md->run();
    delete md;
}

MessageDialog::DlgReturnValue  MessageDialog::Question(const string& msg)
{
    DlgReturnValue r;
    MessageDialog *md = new MessageDialog(msg,QuestionDlg);
    r=md->run();
    delete md;
    return r;
}


MessageDialog::DlgReturnValue  MessageDialog::YesNo(const string& msg)
{
    DlgReturnValue r;
    MessageDialog *md = new MessageDialog(msg,YesNoDlg);
    r=md->run();
    delete md;
    return r;
}












