/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: ICMPServiceDialog.cc,v 1.10 2001/12/27 06:48:47 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#include "ICMPServiceDialog.hh"
#include "fwbuilder/FWObject.hh"
#include "MessageDialog.hh"
#include "helpers.hh"


using namespace libfwbuilder;



struct icmp_type_and_code {
    int    type_val;
    int    code_val;
    char*  type_desc;
    char*  code_desc;;
};

static const struct icmp_type_and_code icmp_types[] = {
    { 0,0, "0: Echo reply","0" },

    { 3,-1, "3: Destination unreachable","" },
    { 3,0, "3: Destination unreachable","0: Network unreachable" },
    { 3,1, "3: Destination unreachable","1: Host unreachable" },
    { 3,2, "3: Destination unreachable","2: Protocol unreachable" },
    { 3,3, "3: Destination unreachable","3: Port unreachable" },
    { 3,4, "3: Destination unreachable","4: Fragmentation needed" },
    { 3,5, "3: Destination unreachable","5: Source route failed" },
    { 3,6, "3: Destination unreachable","6: Destination network unknown" },
    { 3,7, "3: Destination unreachable","7: Destination host unknown" },
    { 3,8, "3: Destination unreachable","8: Source host isolated" },
    { 3,9, "3: Destination unreachable","9: Dest. net adm. prohibited" },
    { 3,10,"3: Destination unreachable","10: Dest. host adm. prohibited" },
    { 3,11,"3: Destination unreachable","11: Network unreachable for TOS" },
    { 3,12,"3: Destination unreachable","12: Host unreachable for TOS" },
    { 3,13,"3: Destination unreachable","13: Admin. prohibited by filtering" },
    { 3,14,"3: Destination unreachable","14: Host precedence violation" },
    { 3,15,"3: Destination unreachable","14: Precedence cutoff" },

    { 4,0, "4: Source quench","0" },

    { 5,-1, "5: Redirect","" },
    { 5,0, "5: Redirect","0: Redirect for network" },
    { 5,1, "5: Redirect","1: Redirect for host" },
    { 5,2, "5: Redirect","2: Redirect for TOS and network" },
    { 5,3, "5: Redirect","3: Redirect for TOS and host" },

    { 8,0, "8: Echo request","0" },

    { 9,0, "9: Router advertisiment","0" },
    {10,0, "10: Router solicitation","0" },

    {11,-1, "11: Time exceeded","" },
    {11,0, "11: Time exceeded","0: TTL equals 0 in transit" },
    {11,1, "11: Time exceeded","1: TTL equals 0 in reassembly" },

    {12,-1, "12: Parameter problem","" },
    {12,0, "12: Parameter problem","0: IP header bad" },
    {12,1, "12: Parameter problem","1: Option missing" },

    {13,0, "13: Timestamp request","0" },
    {14,0, "14: Timestamp reply",  "0" },

    {15,0, "15: Information request","0" },
    {16,0, "16: Information reply","0" },

    {17,0, "17: Address mask request","0" },
    {18,0, "18: Address mask reply","0" },

    { -1,-1,"","" }
};


ICMPServiceDialog::ICMPServiceDialog(FWObject *obj)
{
    object=obj;
//    type->set_digits(0);
//    code->set_digits(0);

}

void ICMPServiceDialog::wrk2dlg()
{
    int t,c;

    t=object->getInt("type");
    c=object->getInt("code");

    name->set_text(object->getName());

//    type->set_value( object->getInt("type"));
//    code->set_value( object->getInt("code"));

    if (t==-1) {
	_fill_type( true );
	any_type->set_active(true);
	type->set_sensitive( false );
	code->set_sensitive( false );
    } else {
	_fill_type( false );
	_set_type( t );
	_fill_code( t );
	_set_code( t,c );
	any_type->set_active(false);
	type->set_sensitive( true );
	code->set_sensitive( true );
    }
    comment->set_point(0);
    comment->forward_delete( comment->get_length() );
    comment->insert(object->getComment());

    name->grab_focus();
}

bool ICMPServiceDialog::dlg2wrk()
{
    Gtk::Entry      *entry;
    int             t,c;

/*
 *  check if name is valid
 */
    if ( ! checkObjectName(name->get_text()) ) return(false);

    object->setName( name->get_text() );
    object->setComment( comment->get_chars(0,comment->get_length()) );

    if ( any_type->get_active() ) {
	object->setInt( "type" , -1 );
	object->setInt( "code" , -1 );
    } else {

	entry=type->get_entry();
	t=_get_type_by_desc( entry->get_text() );

	entry=code->get_entry();
	c=_get_code_by_desc( entry->get_text() );

//	object->setInt( "type" , type->get_value_as_int() );
//	object->setInt( "code" , code->get_value_as_int() );

	object->setInt( "type" , t );
	object->setInt( "code" , c );
    }

    return(true);
}

void ICMPServiceDialog::on_any_type_toggled()
{   
    type->set_sensitive( ! any_type->get_active() );
    code->set_sensitive( ! any_type->get_active() );
    _fill_type( any_type->get_active() );
//    if ( ! any_type->get_active() )
//	_set_type( object->getInt("type"));
}

void ICMPServiceDialog::on_type_changed()
{   
    Gtk::Entry     *entry;
    int             t, c;

    entry=type->get_entry();
    t=_get_type_by_desc( entry->get_text() );
    c=object->getInt("code");
//    if (c==-1) c=0;

    if (t!=-1) {
	_fill_code( t );
	_set_code( t , c );
    }
    data_changed_flag(true);
}

void ICMPServiceDialog::on_code_changed()
{   
    data_changed_flag(true);
}

void ICMPServiceDialog::_fill_type(bool empty_type)
{
    list<string>  strings;
    string        desc;

    int i, j;
    j=-1;

    if (empty_type) {
	type->get_entry()->set_text( "" );
    } else {
	for (i=0; icmp_types[i].type_val!=-1; i++) {
	    if (icmp_types[i].type_val==j) continue;

	    strings.push_back( icmp_types[i].type_desc );
	    j=icmp_types[i].type_val;
	}
    } 
    type->set_popdown_strings( strings );
}

void ICMPServiceDialog::_fill_code(int t)
{
    list<string>  strings;
    string        desc;

    int i,j;

    i=_get_table_entry_for_type(t);

    if ( icmp_types[i].type_val!=-1 ) {
	for (j=i; icmp_types[j].type_val==t && icmp_types[j].type_val!=-1;
	     j++) {
	    strings.push_back( icmp_types[j].code_desc );
	}
    }
    code->set_popdown_strings( strings );
}

void ICMPServiceDialog::_set_type(int t)
{
    string        desc;
    desc=_get_type_desc(t);
    type->get_entry()->set_text( desc );
}

void ICMPServiceDialog::_set_code(int t,int c)
{
    string        desc;
    desc=_get_code_desc(t,c);
    code->get_entry()->set_text( desc );
}

char* ICMPServiceDialog::_get_type_desc(int t)
{
    int i;

    i=_get_table_entry_for_type(t);
    if ( icmp_types[i].type_val!=-1 )
	return icmp_types[i].type_desc;
    return NULL;
}

char* ICMPServiceDialog::_get_code_desc(int t,int c)
{
    int i,j;

//    if (c==-1) return "";

    i=_get_table_entry_for_type(t);
    if ( icmp_types[i].type_val!=-1 ) {
	for (j=i; icmp_types[j].code_val!=c && icmp_types[j].type_val!=-1; 
	 j++);
	return icmp_types[j].code_desc;
    }
    return NULL;
}


int ICMPServiceDialog::_get_table_entry_for_type(int t)
{
    int i;

    for (i=0; icmp_types[i].type_val!=t && icmp_types[i].type_val!=-1; 
	 i++);

    return i;
}

int ICMPServiceDialog::_get_type_by_desc(string desc)
{
    int i;

    for (i=0; icmp_types[i].type_val!=-1; i++) {
	if ( desc==icmp_types[i].type_desc ) break;
    }
    return icmp_types[i].type_val;
}


int ICMPServiceDialog::_get_code_by_desc(string desc)
{
    int i;

    for (i=0; icmp_types[i].type_val!=-1; i++) {
	if ( desc==icmp_types[i].code_desc ) break;
    }
    return icmp_types[i].code_val;
}

void ICMPServiceDialog::on_changed()
{
  data_changed_flag(true);
}

