#! /bin/sh

# Shell script to convert an Analog language file to a fwAnalog one.
# Language/Sprache: German/Deutsch
# Usage: mklangfile.de.sh {infile} [> outfile]
# 	infile should be de.lng, not dea.lng
# $Id: mklangfile.de.sh,v 1.3 2002/02/05 16:24:32 bb Exp $

cat $1 \
	| sed 's/Anzahl unterschiedlicher anfragender Hosts/Verschiedene Hosts, deren Pakete blockiert wurden/g' \
	| sed 's/Anzahl unterschiedlicher verlangter Dateien/Verschiedene blockierte Pakete/g' \
	| sed 's/Verzeichnis-Bericht/Bericht ber blockierte Pakete/g' \
	| sed 's/Anfragen/blockierten Pakete/g' \
	| sed 's/Anfrage/blockiertem Paket/g' \
	| sed 's/erster Zugriff/erstes bl. Paket/g' \
	| sed 's/letzter Zugriff/letztes bl. Paket/g' \
	| sed 's/Virtueller Host/Netzwerkschnittstelle/g' \
	| sed 's/Virtuellen* Hosts/Netzwerkschnittstellen/g' \
	| sed 's/Virtueller-Host-Bericht/Netzwerkschnittstellen-Bericht/g' \
	| sed 's/Verzeichnisses/blockierten Pakets/g' \
	| sed 's/Verzeichnisse/blockierten Pakete/g' \
	| sed 's/Verzeichnis/blockiertes Paket/g' \
	| sed 's/URL/Quellport/g' \
	| sed 's/Browser/MAC-Adresse(n)/g' \
	| sed 's/Server-Statistiken f..?r/Firewall-Statistiken, generiert von/g' \
	| sed 's/Monat mit der strksten Nutzung:/Monat mit den meisten blockierten Paketen:/g' \
	| sed 's/Woche mit der strksten Nutzung:/Woche mit den meisten blockierten Paketen:/g' \
	| sed 's/Tag mit der strksten Nutzung:/Tag mit den meisten blockierten Paketen:/g' \
	| sed 's/Uhrzeit mit der strksten Nutzung:/Uhrzeit mit den meisten blockierten Paketen:/g' \
	| sed 's/Stunde mit der strksten Nutzung:/Stunde mit den meisten blockierten Paketen:/g' \
	| sed 's/Viertelstunde mit der strksten Nutzung:/Viertelstunde mit den meisten blockierten Paketen:/g' \
	| sed 's/5 Minuten mit der strksten Nutzung:/5 Minuten mit den meisten blockierten Paketen:/g' \
	| sed 's/Host-Bericht/Paket-Quell-Host-Bericht/g' \
	| sed 's/Verzeichnis-Bericht/Bericht ber blockierte Pakete/g' \
	| sed 's/Verweis-Bericht/Quellport-Bericht/g' \
	| sed 's/verweisenden URL/Quellport/g' \
	| sed 's/Dateien/Pakete/g' \
	| sed 's/Datei/Paket/g' \
	| sed 's/Erfolgreich/Blockiert/g' \
	| sed 's/Nichtverwendete.*Logdatei/Nicht verwendete Eintrge in der Logdatei (wegen Datum, EXCLUDE usw.)/g' \
	| sed 's/Menge verschickter Daten/Gre aller blockierten Pakete zusammen/g' \
	| sed 's/Durchschnittliche Menge verschickter Daten pro Tag/Durchschnittliche tgliche Grer blockierter Pakete/g' \
	| sed 's/#Anf./#Blocks/g' \
	| sed 's/%Anf./%Blocks/g' \
	| sed 's/verweisenden //g' \
	| sed 's/Blockiert bearbeitete blockierten/Blockierte/g' \
	| sed 's/bearbeitete blockierten/blockierte/g' \
	| sed 's/^Blockierte Pakete(n)/Blockierte Pakete/g' \
	| sed 's/ch blockierte Pakete(n)/ch blockierte Pakete/g' \
	| sed 's/aller blockierten Pakete(n)/aller blockierten Pakete/g' \
	| sed 's/der blockierten Pakete(n)/der blockierten Pakete/g' \
	| sed 's/Benutzers/Log-Prfixes/g' \
	| sed '/WWW-Server/,/Benutzer/s/Benutzer/Log-Prfix/' \
	| sed '/Benutzer/,/Status-Code/s/Benutzer/Log-Prfixe/' \
	| sed 's/Benutzer/Log-Prfix/g' \
	| sed 's/Log-Prfixe Bericht/Log-Prfix-Bericht/g' \
	| sed 's/blockiertes Paketbericht/Bericht ber blockierte Pakete/g' \
	| sed 's/entspricht \([0-9]*\) blockierten Pakete/entspricht \1 blockierten Paketen/g' \
	| sed 's/mindestens \([0-9]*\) blockiertem Paket/mindestens \1 blockierten Paket/g' \
	| perl -pwe "s!^## This is a language file for analog!## Converted from $1 on `date` \\n## by mklangfile.de.sh (from the fwanalog distribution)\\n## More info: http://tud.at/programm/fwanalog/\\n##\\n## This is a language file for analog!" 
