"""
ImageMagick picture toolkit

Use "identify -verbose" command line.

Supported file formats: BMP, GIF, JPG, ICO, ...
"""
from fusil.process.create import CreateProcess
from fusil.process.watch import WatchProcess
from fusil.process.stdout import WatchStdout
from fusil.auto_mangle import AutoMangle

class IdentifyProcess(CreateProcess):
    def on_mangle_filenames(self, image_filenames):
        self.cmdline.arguments[-1] = image_filenames[0]
        self.createProcess()

def setupProject(project):
    orig_filename = project.application().getInputFilename("Image")
    mangle = AutoMangle(project, orig_filename)
    mangle.fixed_size_factor = 0.5

    process = IdentifyProcess(project,
        ['identify', '-verbose', None],
        timeout=2.0)
    WatchProcess(process, exitcode_score=-0.25)

    stdout = WatchStdout(process)
    stdout.max_nb_line = (3000, 0.20)
    stdout.patterns['memory allocation failed'] = 1.0
    stdout.patterns['no decode delegate for this image format'] = -1.0
    stdout.addRegex('Corrupt', 0.05)
    stdout.addRegex('Unsupported', 0.05)
    stdout.addRegex('Not a JPEG file', -0.50)
    stdout.addRegex('JPEG datastream contains no image', -0.50)
    stdout.show_not_matching = False

