#!/bin/sh
#
# Copyright (c) 1996, Ikuo Nakagawa.
# All rights reserved.
#
# $Id: mirror.sh,v 1.3 1997/05/22 08:39:10 ikuo Exp $
#
libdir=/usr/local/lib/ftpmirror
name=${1-daily}

# check existence of list file
if [ ! -f "$libdir/list.$name" ]; then
	echo "$libdir/list.$name not found" 1>&2
	exit 1
fi

# set position parameters
set - `sed '/^#/d' "$libdir/list.$name"`

# rotate log files, see:
# ftp://ftp.intec.co.jp/pub/utils/rotate-1.1.tar.gz
log=/var/log/mirror.$name
/usr/local/bin/rotate -o root -g wheel -m 0640 $log 3 2 1 0

# redirect all to /dev/null
exec >$log 2>&1

# do real work
for i
do
	$libdir/ftpmirror $i
done
