/* sms.c generated by valac 0.14.2, the Vala compiler
 * generated from sms.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *                         Simon Busch <morphis@gravedo.de>
 *                         Lukas Märdian <lukasmaerdian@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <fsobasics.h>
#include <fsogsm.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <conversions.h>
#include <util.h>
#include <smsutil.h>
#include <fsotransport.h>
#include <msmcomm-specs.h>
#include <freesmartphone.h>


#define TYPE_MSM_SMS_HANDLER (msm_sms_handler_get_type ())
#define MSM_SMS_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MSM_SMS_HANDLER, MsmSmsHandler))
#define MSM_SMS_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MSM_SMS_HANDLER, MsmSmsHandlerClass))
#define IS_MSM_SMS_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MSM_SMS_HANDLER))
#define IS_MSM_SMS_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MSM_SMS_HANDLER))
#define MSM_SMS_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MSM_SMS_HANDLER, MsmSmsHandlerClass))

typedef struct _MsmSmsHandler MsmSmsHandler;
typedef struct _MsmSmsHandlerClass MsmSmsHandlerClass;
typedef struct _MsmSmsHandlerPrivate MsmSmsHandlerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block6Data Block6Data;
#define _wrap_hex_pdu_unref0(var) ((var == NULL) ? NULL : (var = (wrap_hex_pdu_unref (var), NULL)))
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))
typedef struct _msm_sms_handler_simIsReadyData msm_sms_handler_simIsReadyData;

#define TYPE_MSM_CHANNEL (msm_channel_get_type ())
#define MSM_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MSM_CHANNEL, MsmChannel))
#define MSM_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MSM_CHANNEL, MsmChannelClass))
#define IS_MSM_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MSM_CHANNEL))
#define IS_MSM_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MSM_CHANNEL))
#define MSM_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MSM_CHANNEL, MsmChannelClass))

typedef struct _MsmChannel MsmChannel;
typedef struct _MsmChannelClass MsmChannelClass;
typedef struct _MsmChannelPrivate MsmChannelPrivate;

#define TYPE_MSM_UNSOLICITED_RESPONSE_HANDLER (msm_unsolicited_response_handler_get_type ())
#define MSM_UNSOLICITED_RESPONSE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MSM_UNSOLICITED_RESPONSE_HANDLER, MsmUnsolicitedResponseHandler))
#define MSM_UNSOLICITED_RESPONSE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MSM_UNSOLICITED_RESPONSE_HANDLER, MsmUnsolicitedResponseHandlerClass))
#define IS_MSM_UNSOLICITED_RESPONSE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MSM_UNSOLICITED_RESPONSE_HANDLER))
#define IS_MSM_UNSOLICITED_RESPONSE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MSM_UNSOLICITED_RESPONSE_HANDLER))
#define MSM_UNSOLICITED_RESPONSE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MSM_UNSOLICITED_RESPONSE_HANDLER, MsmUnsolicitedResponseHandlerClass))

typedef struct _MsmUnsolicitedResponseHandler MsmUnsolicitedResponseHandler;
typedef struct _MsmUnsolicitedResponseHandlerClass MsmUnsolicitedResponseHandlerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _msm_sms_handler_syncWithSimData msm_sms_handler_syncWithSimData;
typedef struct _msm_sms_handler_handleIncomingSmsOnSimData msm_sms_handler_handleIncomingSmsOnSimData;
typedef struct _msm_sms_handler_handleIncomingSmsData msm_sms_handler_handleIncomingSmsData;
#define _sms_free0(var) ((var == NULL) ? NULL : (var = (sms_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct __msm_sms_handler_handleIncomingSmsData _msm_sms_handler_handleIncomingSmsData;
typedef struct _msm_sms_handler_handleIncomingSmsReportData msm_sms_handler_handleIncomingSmsReportData;

struct _MsmSmsHandler {
	FsoFrameworkAbstractObject parent_instance;
	MsmSmsHandlerPrivate * priv;
};

struct _MsmSmsHandlerClass {
	FsoFrameworkAbstractObjectClass parent_class;
};

struct _MsmSmsHandlerPrivate {
	FsoGsmISmsStorage* _storage;
};

struct _Block6Data {
	int _ref_count_;
	MsmSmsHandler * self;
	GeeArrayList* hexpdus;
	gchar* number;
	gboolean requestReport;
};

struct _msm_sms_handler_simIsReadyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmSmsHandler* self;
};

struct _MsmChannel {
	FsoFrameworkAbstractObject parent_instance;
	MsmChannelPrivate * priv;
	gchar* name;
	MsmUnsolicitedResponseHandler* urc_handler;
	MsmcommManagement* management_service;
	MsmcommState* state_service;
	MsmcommMisc* misc_service;
	MsmcommCall* call_service;
	MsmcommSim* sim_service;
	MsmcommPhonebook* phonebook_service;
	MsmcommNetwork* network_service;
	MsmcommSound* sound_service;
	MsmcommSms* sms_service;
};

struct _MsmChannelClass {
	FsoFrameworkAbstractObjectClass parent_class;
};

struct _msm_sms_handler_syncWithSimData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmSmsHandler* self;
	FsoGsmModem* _tmp0_;
	FsoGsmChannel* _tmp1_;
	MsmChannel* channel;
	gchar* _tmp2_;
	gchar* imsi;
	MsmChannel* _tmp3_;
	MsmcommSim* _tmp4_;
	MsmcommSimFieldInfo _tmp5_;
	MsmcommSimFieldInfo sim_field_info;
	MsmcommSimFieldInfo _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GError* err;
	GError* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* msg;
	const gchar* _tmp13_;
	GError* _tmp14_;
	const gchar* _tmp15_;
	FsoGsmISmsStorage* _tmp16_;
	FsoGsmISmsStorage* _tmp17_;
	GError * _inner_error_;
};

struct _msm_sms_handler_handleIncomingSmsOnSimData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmSmsHandler* self;
	guint index;
};

struct _msm_sms_handler_handleIncomingSmsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmSmsHandler* self;
	gchar* hexpdu;
	gint tpdulen;
	FsoGsmModem* _tmp0_;
	FsoGsmChannel* _tmp1_;
	MsmChannel* channel;
	MsmChannel* _tmp2_;
	MsmcommSms* _tmp3_;
	FsoFrameworkLogger* _tmp4_;
	GError* err;
	GError* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* msg;
	const gchar* _tmp9_;
	GError* _tmp10_;
	const gchar* _tmp11_;
	gint _tmp12_;
	GError * _inner_error_;
};

struct __msm_sms_handler_handleIncomingSmsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmSmsHandler* self;
	gchar* hexpdu;
	gint tpdulen;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	struct sms* _tmp4_;
	struct sms* _tmp5_;
	struct sms* sms;
	struct sms* _tmp6_;
	FsoFrameworkLogger* _tmp7_;
	FsoGsmISmsStorage* _tmp8_;
	FsoGsmISmsStorage* _tmp9_;
	struct sms* _tmp10_;
	gint _tmp11_;
	gint _result_;
	gint _tmp12_;
	FsoFrameworkLogger* _tmp13_;
	gint _tmp14_;
	FsoFrameworkLogger* _tmp15_;
	FsoFrameworkLogger* _tmp16_;
	struct sms* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	FsoGsmISmsStorage* _tmp23_;
	FsoGsmISmsStorage* _tmp24_;
	struct sms* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	FreeSmartphoneGSMSIMMessage _tmp28_;
	FreeSmartphoneGSMSIMMessage _tmp29_;
	FreeSmartphoneGSMSIMMessage msg;
	FsoGsmModem* _tmp30_;
	gpointer _tmp31_;
	FreeSmartphoneGSMSMS* obj;
	FreeSmartphoneGSMSMS* _tmp32_;
	FreeSmartphoneGSMSIMMessage _tmp33_;
	const gchar* _tmp34_;
	FreeSmartphoneGSMSIMMessage _tmp35_;
	const gchar* _tmp36_;
	FreeSmartphoneGSMSIMMessage _tmp37_;
	const gchar* _tmp38_;
};

struct _msm_sms_handler_handleIncomingSmsReportData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmSmsHandler* self;
	gchar* hexpdu;
	gint tpdulen;
};


static gpointer msm_sms_handler_parent_class = NULL;
static FsoGsmSmsHandlerIface* msm_sms_handler_fso_gsm_sms_handler_parent_iface = NULL;
static GType msm_sms_handler_type_id = 0;

GType msm_sms_handler_get_type (void) G_GNUC_CONST;
GType msm_sms_handler_register_type (GTypeModule * module);
#define MSM_SMS_HANDLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MSM_SMS_HANDLER, MsmSmsHandlerPrivate))
enum  {
	MSM_SMS_HANDLER_DUMMY_PROPERTY,
	MSM_SMS_HANDLER_STORAGE
};
MsmSmsHandler* msm_sms_handler_new (void);
MsmSmsHandler* msm_sms_handler_construct (GType object_type);
void msm_sms_handler_onModemStatusChanged (MsmSmsHandler* self, FsoGsmModem* modem, FsoGsmModemStatus status);
static void _msm_sms_handler_onModemStatusChanged_fso_gsm_modem_signal_status_changed (FsoGsmModem* _sender, FsoGsmModemStatus status, gpointer self);
static gchar* msm_sms_handler_real_repr (FsoFrameworkAbstractObject* base);
void msm_sms_handler_simIsReady (MsmSmsHandler* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void msm_sms_handler_simIsReady_finish (MsmSmsHandler* self, GAsyncResult* _res_);
static guint16 msm_sms_handler_real_lastReferenceNumber (FsoGsmSmsHandler* base);
static guint16 msm_sms_handler_real_nextReferenceNumber (FsoGsmSmsHandler* base);
static GeeArrayList* msm_sms_handler_real_formatTextMessage (FsoGsmSmsHandler* base, const gchar* number, const gchar* contents, gboolean requestReport);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
static void __lambda6_ (Block6Data* _data6_, struct sms* element);
static void ___lambda6__gfunc (gconstpointer data, gpointer self);
static void msm_sms_handler_simIsReady_data_free (gpointer _data);
static gboolean msm_sms_handler_simIsReady_co (msm_sms_handler_simIsReadyData* _data_);
void msm_sms_handler_syncWithSim (MsmSmsHandler* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void msm_sms_handler_syncWithSim_finish (MsmSmsHandler* self, GAsyncResult* _res_);
static void msm_sms_handler_simIsReady_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void msm_sms_handler_syncWithSim_data_free (gpointer _data);
static gboolean msm_sms_handler_syncWithSim_co (msm_sms_handler_syncWithSimData* _data_);
GType msm_channel_get_type (void) G_GNUC_CONST;
GType msm_channel_register_type (GTypeModule * module);
GType msm_unsolicited_response_handler_get_type (void) G_GNUC_CONST;
GType msm_unsolicited_response_handler_register_type (GTypeModule * module);
static void msm_sms_handler_syncWithSim_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void msm_sms_handler_real_handleIncomingSmsOnSim_data_free (gpointer _data);
static void msm_sms_handler_real_handleIncomingSmsOnSim (FsoGsmSmsHandler* base, guint index, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean msm_sms_handler_real_handleIncomingSmsOnSim_co (msm_sms_handler_handleIncomingSmsOnSimData* _data_);
static void msm_sms_handler_real_handleIncomingSms_data_free (gpointer _data);
static void msm_sms_handler_real_handleIncomingSms (FsoGsmSmsHandler* base, const gchar* hexpdu, gint tpdulen, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean msm_sms_handler_real_handleIncomingSms_co (msm_sms_handler_handleIncomingSmsData* _data_);
static void msm_sms_handler_handleIncomingSms_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void _msm_sms_handler_handleIncomingSms (MsmSmsHandler* self, const gchar* hexpdu, gint tpdulen, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _msm_sms_handler_handleIncomingSms_finish (MsmSmsHandler* self, GAsyncResult* _res_);
static void _msm_sms_handler_handleIncomingSms_data_free (gpointer _data);
static gboolean _msm_sms_handler_handleIncomingSms_co (_msm_sms_handler_handleIncomingSmsData* _data_);
void _msm_sms_handler_handleIncomingSmsReport (MsmSmsHandler* self, struct sms* sms);
static void msm_sms_handler_real_handleIncomingSmsReport_data_free (gpointer _data);
static void msm_sms_handler_real_handleIncomingSmsReport (FsoGsmSmsHandler* base, const gchar* hexpdu, gint tpdulen, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean msm_sms_handler_real_handleIncomingSmsReport_co (msm_sms_handler_handleIncomingSmsReportData* _data_);
static void msm_sms_handler_real_storeTransactionIndizesForSentMessage (FsoGsmSmsHandler* base, GeeArrayList* hexpdus);
static void msm_sms_handler_finalize (GObject* obj);
static void _vala_msm_sms_handler_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_msm_sms_handler_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _msm_sms_handler_onModemStatusChanged_fso_gsm_modem_signal_status_changed (FsoGsmModem* _sender, FsoGsmModemStatus status, gpointer self) {
	msm_sms_handler_onModemStatusChanged (self, _sender, status);
}


MsmSmsHandler* msm_sms_handler_construct (GType object_type) {
	MsmSmsHandler * self = NULL;
	FsoGsmModem* _tmp0_;
	self = (MsmSmsHandler*) fso_framework_abstract_object_construct (object_type);
	_tmp0_ = fso_gsm_theModem;
	if (_tmp0_ == NULL) {
		FsoFrameworkLogger* _tmp1_;
		_tmp1_ = ((FsoFrameworkAbstractObject*) self)->logger;
		fso_framework_logger_warning (_tmp1_, "SMS Handler created before modem");
	} else {
		FsoGsmModem* _tmp2_;
		_tmp2_ = fso_gsm_theModem;
		g_signal_connect_object (_tmp2_, "signal-status-changed", (GCallback) _msm_sms_handler_onModemStatusChanged_fso_gsm_modem_signal_status_changed, self, 0);
	}
	return self;
}


MsmSmsHandler* msm_sms_handler_new (void) {
	return msm_sms_handler_construct (TYPE_MSM_SMS_HANDLER);
}


static gchar* msm_sms_handler_real_repr (FsoFrameworkAbstractObject* base) {
	MsmSmsHandler * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	FsoGsmISmsStorage* _tmp1_;
	FsoGsmISmsStorage* _tmp2_;
	self = (MsmSmsHandler*) base;
	_tmp1_ = fso_gsm_sms_handler_get_storage ((FsoGsmSmsHandler*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		FsoGsmISmsStorage* _tmp3_;
		FsoGsmISmsStorage* _tmp4_;
		gchar* _tmp5_ = NULL;
		_tmp3_ = fso_gsm_sms_handler_get_storage ((FsoGsmSmsHandler*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = fso_framework_abstract_object_repr ((FsoFrameworkAbstractObject*) _tmp4_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	} else {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("<None>");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp6_;
	}
	result = _tmp0_;
	return result;
}


void msm_sms_handler_onModemStatusChanged (MsmSmsHandler* self, FsoGsmModem* modem, FsoGsmModemStatus status) {
	FsoGsmModemStatus _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (modem != NULL);
	_tmp0_ = status;
	switch (_tmp0_) {
		case FSO_GSM_MODEM_STATUS_ALIVE_SIM_READY:
		{
			msm_sms_handler_simIsReady (self, NULL, NULL);
			break;
		}
		default:
		{
			break;
		}
	}
}


static guint16 msm_sms_handler_real_lastReferenceNumber (FsoGsmSmsHandler* base) {
	MsmSmsHandler * self;
	guint16 result = 0U;
	FsoGsmISmsStorage* _tmp0_;
	FsoGsmISmsStorage* _tmp1_;
	guint16 _tmp2_ = 0U;
	self = (MsmSmsHandler*) base;
	_tmp0_ = fso_gsm_sms_handler_get_storage ((FsoGsmSmsHandler*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = fso_gsm_isms_storage_lastReferenceNumber (_tmp1_);
	result = _tmp2_;
	return result;
}


static guint16 msm_sms_handler_real_nextReferenceNumber (FsoGsmSmsHandler* base) {
	MsmSmsHandler * self;
	guint16 result = 0U;
	FsoGsmISmsStorage* _tmp0_;
	FsoGsmISmsStorage* _tmp1_;
	guint16 _tmp2_ = 0U;
	self = (MsmSmsHandler*) base;
	_tmp0_ = fso_gsm_sms_handler_get_storage ((FsoGsmSmsHandler*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = fso_gsm_isms_storage_increasingReferenceNumber (_tmp1_);
	result = _tmp2_;
	return result;
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		_g_object_unref0 (_data6_->self);
		_g_object_unref0 (_data6_->hexpdus);
		_g_free0 (_data6_->number);
		g_slice_free (Block6Data, _data6_);
	}
}


static gchar* sms_toHexPdu (struct sms* self, gint* tpdulen) {
	gint _vala_tpdulen = 0;
	gchar* result = NULL;
	gint binlen = 0;
	gchar* _tmp0_ = NULL;
	gchar* binpdu;
	gint binpdu_length1;
	gint _binpdu_size_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gboolean res;
	gboolean _tmp5_;
	gchar* _tmp7_ = NULL;
	gchar* hexpdu;
	gint hexpdu_length1;
	gint _hexpdu_size_;
	gchar* _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
	gchar* _tmp10_;
	gint _tmp10__length1;
	gchar* _tmp11_;
	gint _tmp11__length1;
	gchar* _tmp12_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar, 176);
	binpdu = _tmp0_;
	binpdu_length1 = 176;
	_binpdu_size_ = binpdu_length1;
	_tmp1_ = binpdu;
	_tmp1__length1 = binpdu_length1;
	_tmp4_ = sms_encode (self, &_tmp2_, &_tmp3_, _tmp1_);
	binlen = _tmp2_;
	_vala_tpdulen = _tmp3_;
	res = _tmp4_;
	_tmp5_ = res;
	if (!_tmp5_) {
		gchar* _tmp6_;
		g_warning ("fsogsm3rdparty.vapi:619: %s", "Sms.Message::toHexPdu: could not encode message");
		_vala_tpdulen = -1;
		_tmp6_ = g_strdup ("");
		result = _tmp6_;
		binpdu = (g_free (binpdu), NULL);
		if (tpdulen) {
			*tpdulen = _vala_tpdulen;
		}
		return result;
	}
	_tmp7_ = g_new0 (gchar, 1024);
	hexpdu = _tmp7_;
	hexpdu_length1 = 1024;
	_hexpdu_size_ = hexpdu_length1;
	_tmp8_ = binpdu;
	_tmp8__length1 = binpdu_length1;
	_tmp9_ = binlen;
	_tmp10_ = hexpdu;
	_tmp10__length1 = hexpdu_length1;
	encode_hex_own_buf (_tmp8_, (glong) _tmp9_, (gchar) 0, _tmp10_);
	_tmp11_ = hexpdu;
	_tmp11__length1 = hexpdu_length1;
	_tmp12_ = g_strdup_printf ("%s", (const gchar*) _tmp11_);
	result = _tmp12_;
	hexpdu = (g_free (hexpdu), NULL);
	binpdu = (g_free (binpdu), NULL);
	if (tpdulen) {
		*tpdulen = _vala_tpdulen;
	}
	return result;
}


static void __lambda6_ (Block6Data* _data6_, struct sms* element) {
	MsmSmsHandler * self;
	struct sms* _tmp0_;
	struct sms* msgelement;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	gint tpdulen;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* hexpdu;
	gint _tmp5_;
	gint _tmp6_;
	WrapHexPdu* _tmp7_;
	WrapHexPdu* _tmp8_;
	self = _data6_->self;
	g_return_if_fail (element != NULL);
	_tmp0_ = element;
	msgelement = (struct sms*) _tmp0_;
	_tmp1_ = _data6_->number;
	sms_address_from_string (&msgelement->submit.daddr, _tmp1_);
	_tmp2_ = _data6_->requestReport;
	msgelement->submit.srr = _tmp2_;
	tpdulen = 0;
	_tmp4_ = sms_toHexPdu (msgelement, &_tmp3_);
	tpdulen = _tmp3_;
	hexpdu = _tmp4_;
	_tmp5_ = tpdulen;
	g_assert (_tmp5_ > 0);
	_tmp6_ = tpdulen;
	_tmp7_ = wrap_hex_pdu_new (hexpdu, (guint) _tmp6_);
	_tmp8_ = _tmp7_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _data6_->hexpdus, _tmp8_);
	_wrap_hex_pdu_unref0 (_tmp8_);
	_g_free0 (hexpdu);
}


static void ___lambda6__gfunc (gconstpointer data, gpointer self) {
	__lambda6_ (self, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GeeArrayList* msm_sms_handler_real_formatTextMessage (FsoGsmSmsHandler* base, const gchar* number, const gchar* contents, gboolean requestReport) {
	MsmSmsHandler * self;
	GeeArrayList* result = NULL;
	Block6Data* _data6_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	guint16 _tmp3_ = 0U;
	guint16 inref;
	gint byteOffsetForRefnum = 0;
	GeeArrayList* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_ = 0;
	GSList* _tmp7_ = NULL;
	GSList* smslist;
	GeeArrayList* _tmp8_;
	self = (MsmSmsHandler*) base;
	g_return_val_if_fail (number != NULL, NULL);
	g_return_val_if_fail (contents != NULL, NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = number;
	_tmp1_ = g_strdup (_tmp0_);
	_data6_->number = _tmp1_;
	_tmp2_ = requestReport;
	_data6_->requestReport = _tmp2_;
	_tmp3_ = fso_gsm_sms_handler_nextReferenceNumber ((FsoGsmSmsHandler*) self);
	inref = _tmp3_;
	_tmp4_ = gee_array_list_new (TYPE_WRAP_HEX_PDU, (GBoxedCopyFunc) wrap_hex_pdu_ref, wrap_hex_pdu_unref, NULL);
	_data6_->hexpdus = _tmp4_;
	_tmp5_ = contents;
	_tmp7_ = sms_text_prepare (_tmp5_, inref, TRUE, &_tmp6_);
	byteOffsetForRefnum = _tmp6_;
	smslist = _tmp7_;
	g_slist_foreach (smslist, ___lambda6__gfunc, _data6_);
	_tmp8_ = _g_object_ref0 (_data6_->hexpdus);
	result = _tmp8_;
	_g_slist_free0 (smslist);
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return result;
}


static void msm_sms_handler_simIsReady_data_free (gpointer _data) {
	msm_sms_handler_simIsReadyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (msm_sms_handler_simIsReadyData, _data_);
}


void msm_sms_handler_simIsReady (MsmSmsHandler* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	msm_sms_handler_simIsReadyData* _data_;
	MsmSmsHandler* _tmp0_;
	_data_ = g_slice_new0 (msm_sms_handler_simIsReadyData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_sms_handler_simIsReady);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_sms_handler_simIsReady_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	msm_sms_handler_simIsReady_co (_data_);
}


void msm_sms_handler_simIsReady_finish (MsmSmsHandler* self, GAsyncResult* _res_) {
	msm_sms_handler_simIsReadyData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void msm_sms_handler_simIsReady_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	msm_sms_handler_simIsReadyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	msm_sms_handler_simIsReady_co (_data_);
}


static gboolean msm_sms_handler_simIsReady_co (msm_sms_handler_simIsReadyData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	msm_sms_handler_syncWithSim (_data_->self, msm_sms_handler_simIsReady_ready, _data_);
	return FALSE;
	_state_1:
	msm_sms_handler_syncWithSim_finish (_data_->self, _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void msm_sms_handler_syncWithSim_data_free (gpointer _data) {
	msm_sms_handler_syncWithSimData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (msm_sms_handler_syncWithSimData, _data_);
}


void msm_sms_handler_syncWithSim (MsmSmsHandler* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	msm_sms_handler_syncWithSimData* _data_;
	MsmSmsHandler* _tmp0_;
	_data_ = g_slice_new0 (msm_sms_handler_syncWithSimData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_sms_handler_syncWithSim);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_sms_handler_syncWithSim_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	msm_sms_handler_syncWithSim_co (_data_);
}


void msm_sms_handler_syncWithSim_finish (MsmSmsHandler* self, GAsyncResult* _res_) {
	msm_sms_handler_syncWithSimData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void msm_sms_handler_syncWithSim_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	msm_sms_handler_syncWithSimData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	msm_sms_handler_syncWithSim_co (_data_);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gboolean msm_sms_handler_syncWithSim_co (msm_sms_handler_syncWithSimData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = fso_gsm_theModem;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = fso_gsm_modem_channel (_data_->_tmp0_, "main");
	_data_->channel = IS_MSM_CHANNEL (_data_->_tmp1_) ? ((MsmChannel*) _data_->_tmp1_) : NULL;
	_data_->_tmp2_ = g_strdup ("");
	_data_->imsi = _data_->_tmp2_;
	{
		_data_->_tmp3_ = _data_->channel;
		_data_->_tmp4_ = _data_->_tmp3_->sim_service;
		memset (&_data_->_tmp5_, 0, sizeof (MsmcommSimFieldInfo));
		_data_->_state_ = 1;
		msmcomm_sim_read_field (_data_->_tmp4_, MSMCOMM_SIM_FIELD_IMSI, msm_sms_handler_syncWithSim_ready, _data_);
		return FALSE;
		_state_1:
		msmcomm_sim_read_field_finish (_data_->_tmp4_, _data_->_res_, &_data_->_tmp5_, &_data_->_inner_error_);
		_data_->sim_field_info = _data_->_tmp5_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch17_g_error;
		}
		_data_->_tmp6_ = _data_->sim_field_info;
		_data_->_tmp7_ = _data_->_tmp6_.data;
		_data_->_tmp8_ = g_strdup (_data_->_tmp7_);
		_g_free0 (_data_->imsi);
		_data_->imsi = _data_->_tmp8_;
		msmcomm_sim_field_info_destroy (&_data_->sim_field_info);
	}
	goto __finally17;
	__catch17_g_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp9_ = _data_->err;
		_data_->_tmp10_ = _data_->_tmp9_->message;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = string_to_string (_data_->_tmp10_);
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = g_strconcat ("Could not gather IMSI number, got: ", _data_->_tmp11_, NULL);
		_data_->msg = _data_->_tmp12_;
		_data_->_tmp13_ = _data_->msg;
		_data_->_tmp14_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INTERNAL_ERROR, _data_->_tmp13_);
		_data_->_inner_error_ = _data_->_tmp14_;
		_g_free0 (_data_->msg);
		_g_error_free0 (_data_->err);
		goto __finally17;
	}
	__finally17:
	if (_data_->_inner_error_ != NULL) {
		_g_free0 (_data_->imsi);
		_g_object_unref0 (_data_->channel);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp15_ = _data_->imsi;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = fso_gsm_sms_storage_factory_create ("default", _data_->_tmp15_);
	_data_->_tmp17_ = _data_->_tmp16_;
	fso_gsm_sms_handler_set_storage ((FsoGsmSmsHandler*) _data_->self, _data_->_tmp17_);
	_g_object_unref0 (_data_->_tmp17_);
	_g_free0 (_data_->imsi);
	_g_object_unref0 (_data_->channel);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void msm_sms_handler_real_handleIncomingSmsOnSim_data_free (gpointer _data) {
	msm_sms_handler_handleIncomingSmsOnSimData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (msm_sms_handler_handleIncomingSmsOnSimData, _data_);
}


static void msm_sms_handler_real_handleIncomingSmsOnSim (FsoGsmSmsHandler* base, guint index, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MsmSmsHandler * self;
	msm_sms_handler_handleIncomingSmsOnSimData* _data_;
	MsmSmsHandler* _tmp0_;
	guint _tmp1_;
	self = (MsmSmsHandler*) base;
	_data_ = g_slice_new0 (msm_sms_handler_handleIncomingSmsOnSimData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_sms_handler_real_handleIncomingSmsOnSim);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_sms_handler_real_handleIncomingSmsOnSim_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = index;
	_data_->index = _tmp1_;
	msm_sms_handler_real_handleIncomingSmsOnSim_co (_data_);
}


static void msm_sms_handler_real_handleIncomingSmsOnSim_finish (FsoGsmSmsHandler* base, GAsyncResult* _res_) {
	msm_sms_handler_handleIncomingSmsOnSimData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean msm_sms_handler_real_handleIncomingSmsOnSim_co (msm_sms_handler_handleIncomingSmsOnSimData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void msm_sms_handler_real_handleIncomingSms_data_free (gpointer _data) {
	msm_sms_handler_handleIncomingSmsData* _data_;
	_data_ = _data;
	_g_free0 (_data_->hexpdu);
	_g_object_unref0 (_data_->self);
	g_slice_free (msm_sms_handler_handleIncomingSmsData, _data_);
}


static void msm_sms_handler_real_handleIncomingSms (FsoGsmSmsHandler* base, const gchar* hexpdu, gint tpdulen, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MsmSmsHandler * self;
	msm_sms_handler_handleIncomingSmsData* _data_;
	MsmSmsHandler* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	self = (MsmSmsHandler*) base;
	_data_ = g_slice_new0 (msm_sms_handler_handleIncomingSmsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_sms_handler_real_handleIncomingSms);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_sms_handler_real_handleIncomingSms_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = hexpdu;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->hexpdu = _tmp2_;
	_tmp3_ = tpdulen;
	_data_->tpdulen = _tmp3_;
	msm_sms_handler_real_handleIncomingSms_co (_data_);
}


static void msm_sms_handler_real_handleIncomingSms_finish (FsoGsmSmsHandler* base, GAsyncResult* _res_) {
	msm_sms_handler_handleIncomingSmsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void msm_sms_handler_handleIncomingSms_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	msm_sms_handler_handleIncomingSmsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	msm_sms_handler_real_handleIncomingSms_co (_data_);
}


static gboolean msm_sms_handler_real_handleIncomingSms_co (msm_sms_handler_handleIncomingSmsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = fso_gsm_theModem;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = fso_gsm_modem_channel (_data_->_tmp0_, "main");
	_data_->channel = IS_MSM_CHANNEL (_data_->_tmp1_) ? ((MsmChannel*) _data_->_tmp1_) : NULL;
	{
		_data_->_tmp2_ = _data_->channel;
		_data_->_tmp3_ = _data_->_tmp2_->sms_service;
		_data_->_state_ = 1;
		msmcomm_sms_acknowledge_message (_data_->_tmp3_, msm_sms_handler_handleIncomingSms_ready, _data_);
		return FALSE;
		_state_1:
		msmcomm_sms_acknowledge_message_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch18_g_error;
		}
		_data_->_tmp4_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
		fso_framework_logger_info (_data_->_tmp4_, "Acknowledged new SMS");
	}
	goto __finally18;
	__catch18_g_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp5_ = _data_->err;
		_data_->_tmp6_ = _data_->_tmp5_->message;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = string_to_string (_data_->_tmp6_);
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = g_strconcat ("Can't acknowledge new SMS, got: ", _data_->_tmp7_, NULL);
		_data_->msg = _data_->_tmp8_;
		_data_->_tmp9_ = _data_->msg;
		_data_->_tmp10_ = g_error_new_literal (FREE_SMARTPHONE_ERROR, FREE_SMARTPHONE_ERROR_INTERNAL_ERROR, _data_->_tmp9_);
		_data_->_inner_error_ = _data_->_tmp10_;
		_g_free0 (_data_->msg);
		_g_error_free0 (_data_->err);
		goto __finally18;
	}
	__finally18:
	if (_data_->_inner_error_ != NULL) {
		_g_object_unref0 (_data_->channel);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp11_ = _data_->hexpdu;
	_data_->_tmp12_ = _data_->tpdulen;
	_data_->_state_ = 2;
	_msm_sms_handler_handleIncomingSms (_data_->self, _data_->_tmp11_, _data_->_tmp12_, msm_sms_handler_handleIncomingSms_ready, _data_);
	return FALSE;
	_state_2:
	_msm_sms_handler_handleIncomingSms_finish (_data_->self, _data_->_res_);
	_g_object_unref0 (_data_->channel);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _msm_sms_handler_handleIncomingSms_data_free (gpointer _data) {
	_msm_sms_handler_handleIncomingSmsData* _data_;
	_data_ = _data;
	_g_free0 (_data_->hexpdu);
	_g_object_unref0 (_data_->self);
	g_slice_free (_msm_sms_handler_handleIncomingSmsData, _data_);
}


void _msm_sms_handler_handleIncomingSms (MsmSmsHandler* self, const gchar* hexpdu, gint tpdulen, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	_msm_sms_handler_handleIncomingSmsData* _data_;
	MsmSmsHandler* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	_data_ = g_slice_new0 (_msm_sms_handler_handleIncomingSmsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _msm_sms_handler_handleIncomingSms);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _msm_sms_handler_handleIncomingSms_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = hexpdu;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->hexpdu = _tmp2_;
	_tmp3_ = tpdulen;
	_data_->tpdulen = _tmp3_;
	_msm_sms_handler_handleIncomingSms_co (_data_);
}


void _msm_sms_handler_handleIncomingSms_finish (MsmSmsHandler* self, GAsyncResult* _res_) {
	_msm_sms_handler_handleIncomingSmsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static struct sms* sms_newFromHexPdu (const gchar* hexpdu, gint tpdulen) {
	struct sms* result = NULL;
	glong items_written;
	gchar* _tmp0_ = NULL;
	gchar* binpdu;
	gint binpdu_length1;
	gint _binpdu_size_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp2__length1;
	glong _tmp3_ = 0L;
	glong _tmp4_;
	struct sms* _tmp5_;
	struct sms* sms;
	gchar* _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_;
	struct sms* _tmp8_;
	gboolean _tmp9_ = FALSE;
	gboolean res;
	gboolean _tmp10_;
	g_return_val_if_fail (hexpdu != NULL, NULL);
	items_written = (glong) (-1);
	_tmp0_ = g_new0 (gchar, 1024);
	binpdu = _tmp0_;
	binpdu_length1 = 1024;
	_binpdu_size_ = binpdu_length1;
	_tmp1_ = hexpdu;
	_tmp2_ = binpdu;
	_tmp2__length1 = binpdu_length1;
	decode_hex_own_buf (_tmp1_, (glong) (-1), &_tmp3_, (gchar) 0, _tmp2_);
	items_written = _tmp3_;
	_tmp4_ = items_written;
	g_assert (_tmp4_ != ((glong) (-1)));
	_tmp5_ = sms_new ();
	sms = _tmp5_;
	_tmp6_ = binpdu;
	_tmp6__length1 = binpdu_length1;
	_tmp7_ = tpdulen;
	_tmp8_ = sms;
	_tmp9_ = sms_decode (_tmp6_, _tmp6__length1, FALSE, _tmp7_, _tmp8_);
	res = _tmp9_;
	_tmp10_ = res;
	if (!_tmp10_) {
		gint _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		_tmp11_ = tpdulen;
		_tmp12_ = g_strdup_printf ("%i", _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = hexpdu;
		_tmp15_ = string_to_string (_tmp14_);
		_tmp16_ = g_strconcat ("Sms.Message::newFromHexPdu: could not decode message w/ tpdulen ", _tmp13_, " and hexpdu ", _tmp15_, NULL);
		_tmp17_ = _tmp16_;
		g_warning ("fsogsm3rdparty.vapi:602: %s", _tmp17_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp13_);
		result = NULL;
		_sms_free0 (sms);
		binpdu = (g_free (binpdu), NULL);
		return result;
	} else {
		result = sms;
		binpdu = (g_free (binpdu), NULL);
		return result;
	}
	_sms_free0 (sms);
	binpdu = (g_free (binpdu), NULL);
}


static gchar* sms_number (struct sms* self) {
	gchar* result = NULL;
	enum sms_type _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->type;
	switch (_tmp0_) {
		case SMS_TYPE_DELIVER:
		{
			const gchar* _tmp1_ = NULL;
			gchar* _tmp2_;
			_tmp1_ = sms_address_to_string (&self->deliver.oaddr);
			_tmp2_ = g_strdup (_tmp1_);
			result = _tmp2_;
			return result;
		}
		case SMS_TYPE_SUBMIT:
		{
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			_tmp3_ = sms_address_to_string (&self->submit.daddr);
			_tmp4_ = g_strdup (_tmp3_);
			result = _tmp4_;
			return result;
		}
		case SMS_TYPE_COMMAND:
		{
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			_tmp5_ = sms_address_to_string (&self->command.daddr);
			_tmp6_ = g_strdup (_tmp5_);
			result = _tmp6_;
			return result;
		}
		case SMS_TYPE_STATUS_REPORT:
		{
			const gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			_tmp7_ = sms_address_to_string (&self->status_report.raddr);
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		}
		default:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("unknown");
			result = _tmp9_;
			return result;
		}
	}
}


/**
         * @returns a hashable string for the message that serves as a unique identifier
         * (considering the fragments of a concatenated message as being the same message)
         */
static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch19_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch19_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally19;
	__catch19_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally19:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* sms_hash (struct sms* self) {
	gchar* result = NULL;
	enum sms_type _tmp0_;
	guint16 ref_num = 0U;
	guint8 max_msgs = 0U;
	guint8 seq_num = 0U;
	gint tpdulen = 0;
	gchar* _tmp1_;
	gchar* hash;
	gchar* _tmp2_ = NULL;
	gchar* oaddr;
	guint16 _tmp3_ = 0U;
	guint8 _tmp4_ = 0U;
	guint8 _tmp5_ = 0U;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->type;
	g_assert (_tmp0_ == SMS_TYPE_DELIVER);
	_tmp1_ = g_strdup ("");
	hash = _tmp1_;
	_tmp2_ = sms_number (self);
	oaddr = _tmp2_;
	_tmp6_ = sms_extract_concatenation (self, &_tmp3_, &_tmp4_, &_tmp5_);
	ref_num = _tmp3_;
	max_msgs = _tmp4_;
	seq_num = _tmp5_;
	if (!_tmp6_) {
		gint _tmp7_ = 0;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		gchar* pdu_hash;
		const gchar* _tmp12_;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		_tmp8_ = sms_toHexPdu (self, &_tmp7_);
		tpdulen = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp9_, (gsize) (-1));
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		pdu_hash = _tmp11_;
		_tmp12_ = pdu_hash;
		_tmp13_ = string_to_string (_tmp12_);
		_tmp14_ = g_strconcat (_tmp13_, "_1", NULL);
		_g_free0 (hash);
		hash = _tmp14_;
		_g_free0 (pdu_hash);
	} else {
		const gchar* _tmp15_;
		const gchar* _tmp16_ = NULL;
		guint16 _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		guint8 _tmp20_;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
		gchar* _tmp25_ = NULL;
		_tmp15_ = oaddr;
		_tmp16_ = string_to_string (_tmp15_);
		_tmp17_ = ref_num;
		_tmp18_ = g_strdup_printf ("%hu", _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = max_msgs;
		_tmp21_ = g_strdup_printf ("%hhu", _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat (_tmp16_, "_", _tmp19_, "_", _tmp22_, NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = string_replace (_tmp24_, "+", "");
		_g_free0 (hash);
		hash = _tmp25_;
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp19_);
	}
	result = hash;
	_g_free0 (oaddr);
	return result;
}


static gboolean _msm_sms_handler_handleIncomingSms_co (_msm_sms_handler_handleIncomingSmsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->hexpdu;
	_data_->_tmp1_ = g_strconcat ("00", _data_->_tmp0_, NULL);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->tpdulen;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = sms_newFromHexPdu (_data_->_tmp2_, _data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_g_free0 (_data_->_tmp2_);
	_data_->sms = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->sms;
	if (_data_->_tmp6_ == NULL) {
		_data_->_tmp7_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
		fso_framework_logger_warning (_data_->_tmp7_, "Can't parse incoming SMS");
		_sms_free0 (_data_->sms);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = fso_gsm_sms_handler_get_storage ((FsoGsmSmsHandler*) _data_->self);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = _data_->sms;
	_data_->_tmp11_ = 0;
	_data_->_tmp11_ = fso_gsm_isms_storage_addSms (_data_->_tmp9_, _data_->_tmp10_);
	_data_->_result_ = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->_result_;
	if (_data_->_tmp12_ == FSO_GSM_SMS_STORAGE_SMS_ALREADY_SEEN) {
		_data_->_tmp13_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
		fso_framework_logger_warning (_data_->_tmp13_, "Ignoring already seen SMS");
		_sms_free0 (_data_->sms);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp14_ = _data_->_result_;
		if (_data_->_tmp14_ == FSO_GSM_SMS_STORAGE_SMS_MULTI_INCOMPLETE) {
			_data_->_tmp15_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
			fso_framework_logger_info (_data_->_tmp15_, "Got new fragment for still-incomplete concatenated SMS");
			_sms_free0 (_data_->sms);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_data_->_tmp16_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
			_data_->_tmp17_ = _data_->sms;
			_data_->_tmp18_ = NULL;
			_data_->_tmp18_ = sms_number (_data_->_tmp17_);
			_data_->_tmp19_ = _data_->_tmp18_;
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = string_to_string (_data_->_tmp19_);
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = g_strconcat ("Got new SMS from ", _data_->_tmp20_, NULL);
			_data_->_tmp22_ = _data_->_tmp21_;
			fso_framework_logger_info (_data_->_tmp16_, _data_->_tmp22_);
			_g_free0 (_data_->_tmp22_);
			_g_free0 (_data_->_tmp19_);
			_data_->_tmp23_ = fso_gsm_sms_handler_get_storage ((FsoGsmSmsHandler*) _data_->self);
			_data_->_tmp24_ = _data_->_tmp23_;
			_data_->_tmp25_ = _data_->sms;
			_data_->_tmp26_ = NULL;
			_data_->_tmp26_ = sms_hash (_data_->_tmp25_);
			_data_->_tmp27_ = _data_->_tmp26_;
			memset (&_data_->_tmp28_, 0, sizeof (FreeSmartphoneGSMSIMMessage));
			fso_gsm_isms_storage_message (_data_->_tmp24_, _data_->_tmp27_, 0, &_data_->_tmp28_);
			_data_->_tmp29_ = _data_->_tmp28_;
			_g_free0 (_data_->_tmp27_);
			_data_->msg = _data_->_tmp29_;
			_data_->_tmp30_ = fso_gsm_theModem;
			_data_->_tmp31_ = NULL;
			_data_->_tmp31_ = fso_gsm_modem_theDevice (_data_->_tmp30_, FREE_SMARTPHONE_GSM_TYPE_SMS, (GBoxedCopyFunc) g_object_ref, g_object_unref);
			_data_->obj = (FreeSmartphoneGSMSMS*) _data_->_tmp31_;
			_data_->_tmp32_ = _data_->obj;
			_data_->_tmp33_ = _data_->msg;
			_data_->_tmp34_ = _data_->_tmp33_.number;
			_data_->_tmp35_ = _data_->msg;
			_data_->_tmp36_ = _data_->_tmp35_.timestamp;
			_data_->_tmp37_ = _data_->msg;
			_data_->_tmp38_ = _data_->_tmp37_.contents;
			g_signal_emit_by_name (_data_->_tmp32_, "incoming-text-message", _data_->_tmp34_, _data_->_tmp36_, _data_->_tmp38_);
			_g_object_unref0 (_data_->obj);
			free_smartphone_gsm_sim_message_destroy (&_data_->msg);
		}
	}
	_sms_free0 (_data_->sms);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void _msm_sms_handler_handleIncomingSmsReport (MsmSmsHandler* self, struct sms* sms) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sms != NULL);
}


static void msm_sms_handler_real_handleIncomingSmsReport_data_free (gpointer _data) {
	msm_sms_handler_handleIncomingSmsReportData* _data_;
	_data_ = _data;
	_g_free0 (_data_->hexpdu);
	_g_object_unref0 (_data_->self);
	g_slice_free (msm_sms_handler_handleIncomingSmsReportData, _data_);
}


static void msm_sms_handler_real_handleIncomingSmsReport (FsoGsmSmsHandler* base, const gchar* hexpdu, gint tpdulen, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MsmSmsHandler * self;
	msm_sms_handler_handleIncomingSmsReportData* _data_;
	MsmSmsHandler* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	self = (MsmSmsHandler*) base;
	_data_ = g_slice_new0 (msm_sms_handler_handleIncomingSmsReportData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_sms_handler_real_handleIncomingSmsReport);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_sms_handler_real_handleIncomingSmsReport_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = hexpdu;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->hexpdu = _tmp2_;
	_tmp3_ = tpdulen;
	_data_->tpdulen = _tmp3_;
	msm_sms_handler_real_handleIncomingSmsReport_co (_data_);
}


static void msm_sms_handler_real_handleIncomingSmsReport_finish (FsoGsmSmsHandler* base, GAsyncResult* _res_) {
	msm_sms_handler_handleIncomingSmsReportData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean msm_sms_handler_real_handleIncomingSmsReport_co (msm_sms_handler_handleIncomingSmsReportData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void msm_sms_handler_real_storeTransactionIndizesForSentMessage (FsoGsmSmsHandler* base, GeeArrayList* hexpdus) {
	MsmSmsHandler * self;
	FsoGsmISmsStorage* _tmp0_;
	FsoGsmISmsStorage* _tmp1_;
	GeeArrayList* _tmp2_;
	self = (MsmSmsHandler*) base;
	g_return_if_fail (hexpdus != NULL);
	_tmp0_ = fso_gsm_sms_handler_get_storage ((FsoGsmSmsHandler*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = hexpdus;
	fso_gsm_isms_storage_storeTransactionIndizesForSentMessage (_tmp1_, _tmp2_);
}


static FsoGsmISmsStorage* msm_sms_handler_real_get_storage (FsoGsmSmsHandler* base) {
	FsoGsmISmsStorage* result;
	MsmSmsHandler* self;
	FsoGsmISmsStorage* _tmp0_;
	self = (MsmSmsHandler*) base;
	_tmp0_ = self->priv->_storage;
	result = _tmp0_;
	return result;
}


static void msm_sms_handler_real_set_storage (FsoGsmSmsHandler* base, FsoGsmISmsStorage* value) {
	MsmSmsHandler* self;
	FsoGsmISmsStorage* _tmp0_;
	FsoGsmISmsStorage* _tmp1_;
	self = (MsmSmsHandler*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_storage);
	self->priv->_storage = _tmp1_;
	g_object_notify ((GObject *) self, "storage");
}


static void msm_sms_handler_class_init (MsmSmsHandlerClass * klass) {
	msm_sms_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MsmSmsHandlerPrivate));
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = msm_sms_handler_real_repr;
	G_OBJECT_CLASS (klass)->get_property = _vala_msm_sms_handler_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_msm_sms_handler_set_property;
	G_OBJECT_CLASS (klass)->finalize = msm_sms_handler_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MSM_SMS_HANDLER_STORAGE, g_param_spec_object ("storage", "storage", "storage", FSO_GSM_TYPE_ISMS_STORAGE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void msm_sms_handler_fso_gsm_sms_handler_interface_init (FsoGsmSmsHandlerIface * iface) {
	msm_sms_handler_fso_gsm_sms_handler_parent_iface = g_type_interface_peek_parent (iface);
	iface->lastReferenceNumber = (guint16 (*)(FsoGsmSmsHandler*)) msm_sms_handler_real_lastReferenceNumber;
	iface->nextReferenceNumber = (guint16 (*)(FsoGsmSmsHandler*)) msm_sms_handler_real_nextReferenceNumber;
	iface->formatTextMessage = (GeeArrayList* (*)(FsoGsmSmsHandler*, const gchar*, const gchar*, gboolean)) msm_sms_handler_real_formatTextMessage;
	iface->handleIncomingSmsOnSim = (void (*)(FsoGsmSmsHandler*, guint)) msm_sms_handler_real_handleIncomingSmsOnSim;
	iface->handleIncomingSmsOnSim_finish = msm_sms_handler_real_handleIncomingSmsOnSim_finish;
	iface->handleIncomingSms = (void (*)(FsoGsmSmsHandler*, const gchar*, gint)) msm_sms_handler_real_handleIncomingSms;
	iface->handleIncomingSms_finish = msm_sms_handler_real_handleIncomingSms_finish;
	iface->handleIncomingSmsReport = (void (*)(FsoGsmSmsHandler*, const gchar*, gint)) msm_sms_handler_real_handleIncomingSmsReport;
	iface->handleIncomingSmsReport_finish = msm_sms_handler_real_handleIncomingSmsReport_finish;
	iface->storeTransactionIndizesForSentMessage = (void (*)(FsoGsmSmsHandler*, GeeArrayList*)) msm_sms_handler_real_storeTransactionIndizesForSentMessage;
	iface->get_storage = msm_sms_handler_real_get_storage;
	iface->set_storage = msm_sms_handler_real_set_storage;
}


static void msm_sms_handler_instance_init (MsmSmsHandler * self) {
	self->priv = MSM_SMS_HANDLER_GET_PRIVATE (self);
}


static void msm_sms_handler_finalize (GObject* obj) {
	MsmSmsHandler * self;
	self = MSM_SMS_HANDLER (obj);
	_g_object_unref0 (self->priv->_storage);
	G_OBJECT_CLASS (msm_sms_handler_parent_class)->finalize (obj);
}


/**
 * @class MsmSmsHandler
 **/
GType msm_sms_handler_get_type (void) {
	return msm_sms_handler_type_id;
}


GType msm_sms_handler_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (MsmSmsHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) msm_sms_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MsmSmsHandler), 0, (GInstanceInitFunc) msm_sms_handler_instance_init, NULL };
	static const GInterfaceInfo fso_gsm_sms_handler_info = { (GInterfaceInitFunc) msm_sms_handler_fso_gsm_sms_handler_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	msm_sms_handler_type_id = g_type_module_register_type (module, FSO_FRAMEWORK_TYPE_ABSTRACT_OBJECT, "MsmSmsHandler", &g_define_type_info, 0);
	g_type_module_add_interface (module, msm_sms_handler_type_id, FSO_GSM_TYPE_SMS_HANDLER, &fso_gsm_sms_handler_info);
	return msm_sms_handler_type_id;
}


static void _vala_msm_sms_handler_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MsmSmsHandler * self;
	self = MSM_SMS_HANDLER (object);
	switch (property_id) {
		case MSM_SMS_HANDLER_STORAGE:
		g_value_set_object (value, fso_gsm_sms_handler_get_storage ((FsoGsmSmsHandler*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_msm_sms_handler_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MsmSmsHandler * self;
	self = MSM_SMS_HANDLER (object);
	switch (property_id) {
		case MSM_SMS_HANDLER_STORAGE:
		fso_gsm_sms_handler_set_storage ((FsoGsmSmsHandler*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



