/* channel.c generated by valac 0.14.2, the Vala compiler
 * generated from channel.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *                         Simon Busch <morphis@gravedo.de>
 *                         Lukas Märdian <lukasmaerdian@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <fsobasics.h>
#include <fsotransport.h>
#include <fsogsm.h>
#include <stdlib.h>
#include <string.h>
#include <msmcomm-specs.h>
#include <freesmartphone.h>
#include <gio/gio.h>
#include <unistd.h>


#define TYPE_MSM_CHANNEL (msm_channel_get_type ())
#define MSM_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MSM_CHANNEL, MsmChannel))
#define MSM_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MSM_CHANNEL, MsmChannelClass))
#define IS_MSM_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MSM_CHANNEL))
#define IS_MSM_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MSM_CHANNEL))
#define MSM_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MSM_CHANNEL, MsmChannelClass))

typedef struct _MsmChannel MsmChannel;
typedef struct _MsmChannelClass MsmChannelClass;
typedef struct _MsmChannelPrivate MsmChannelPrivate;

#define TYPE_MSM_UNSOLICITED_RESPONSE_HANDLER (msm_unsolicited_response_handler_get_type ())
#define MSM_UNSOLICITED_RESPONSE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MSM_UNSOLICITED_RESPONSE_HANDLER, MsmUnsolicitedResponseHandler))
#define MSM_UNSOLICITED_RESPONSE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MSM_UNSOLICITED_RESPONSE_HANDLER, MsmUnsolicitedResponseHandlerClass))
#define IS_MSM_UNSOLICITED_RESPONSE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MSM_UNSOLICITED_RESPONSE_HANDLER))
#define IS_MSM_UNSOLICITED_RESPONSE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MSM_UNSOLICITED_RESPONSE_HANDLER))
#define MSM_UNSOLICITED_RESPONSE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MSM_UNSOLICITED_RESPONSE_HANDLER, MsmUnsolicitedResponseHandlerClass))

typedef struct _MsmUnsolicitedResponseHandler MsmUnsolicitedResponseHandler;
typedef struct _MsmUnsolicitedResponseHandlerClass MsmUnsolicitedResponseHandlerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _msm_channel_onModemControlStatusChangedData msm_channel_onModemControlStatusChangedData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _msm_channel_requestModemResourceData msm_channel_requestModemResourceData;
typedef struct _msm_channel_releaseModemResourceData msm_channel_releaseModemResourceData;
typedef struct _MsmChannelInitializeData MsmChannelInitializeData;
typedef struct _MsmChannelShutdownData MsmChannelShutdownData;
typedef struct _Block1Data Block1Data;
typedef struct _msm_channel_waitUntilModemIsActiveData msm_channel_waitUntilModemIsActiveData;
typedef struct _Block2Data Block2Data;

#define TYPE_MSM_URC_TYPE (msm_urc_type_get_type ())
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _MsmChannelOpenData MsmChannelOpenData;
typedef struct _Block3Data Block3Data;
typedef struct _MsmChannelSuspendData MsmChannelSuspendData;
typedef struct _MsmChannelResumeData MsmChannelResumeData;
typedef struct _MsmChannelCloseData MsmChannelCloseData;
typedef struct _MsmChannelFreezeData MsmChannelFreezeData;
typedef struct _MsmChannelThawData MsmChannelThawData;

struct _MsmChannel {
	FsoFrameworkAbstractObject parent_instance;
	MsmChannelPrivate * priv;
	gchar* name;
	MsmUnsolicitedResponseHandler* urc_handler;
	MsmcommManagement* management_service;
	MsmcommState* state_service;
	MsmcommMisc* misc_service;
	MsmcommCall* call_service;
	MsmcommSim* sim_service;
	MsmcommPhonebook* phonebook_service;
	MsmcommNetwork* network_service;
	MsmcommSound* sound_service;
	MsmcommSms* sms_service;
};

struct _MsmChannelClass {
	FsoFrameworkAbstractObjectClass parent_class;
};

struct _MsmChannelPrivate {
	FreeSmartphoneUsage* usage;
	gboolean is_initialized;
	MsmcommModemStatus currentModemStatus;
	FsoFrameworkTransport* _transport;
};

struct _msm_channel_onModemControlStatusChangedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmChannel* self;
	MsmcommModemStatus status;
	MsmcommModemStatus _tmp0_;
	gboolean _tmp1_;
	MsmcommModemStatus _tmp2_;
	FsoFrameworkLogger* _tmp3_;
	MsmcommMisc* _tmp4_;
};

struct _msm_channel_requestModemResourceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmChannel* self;
	gboolean result;
	FreeSmartphoneUsage* _tmp0_;
	FreeSmartphoneUsage* _tmp1_;
	FreeSmartphoneUsage* _tmp2_;
	GError* err;
	FsoFrameworkLogger* _tmp3_;
	GError* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GError * _inner_error_;
};

struct _msm_channel_releaseModemResourceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmChannel* self;
	FsoFrameworkLogger* _tmp0_;
	FreeSmartphoneUsage* _tmp1_;
	GError* err;
	FsoFrameworkLogger* _tmp2_;
	GError * _inner_error_;
};

struct _MsmChannelInitializeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmChannel* self;
	MsmcommDateInfo date_info;
	MsmcommMisc* _tmp0_;
	MsmcommDateInfo _tmp1_;
	MsmcommChargerStatusInfo charger_info;
	MsmcommMisc* _tmp2_;
	MsmcommChargerStatusInfo _tmp3_;
	GError* err0;
	FsoFrameworkLogger* _tmp4_;
	GError* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GError * _inner_error_;
};

struct _MsmChannelShutdownData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmChannel* self;
};

struct _Block1Data {
	int _ref_count_;
	MsmChannel * self;
	gpointer _async_data_;
};

struct _msm_channel_waitUntilModemIsActiveData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmChannel* self;
	Block1Data* _data1_;
};

struct _Block2Data {
	int _ref_count_;
	MsmChannel * self;
	gpointer _async_data_;
};

typedef enum  {
	MSM_URC_TYPE_INVALID,
	MSM_URC_TYPE_RESET_RADIO_IND,
	MSM_URC_TYPE_CALL_ORIGINATION,
	MSM_URC_TYPE_EXTENDED_FILE_INFO,
	MSM_URC_TYPE_NETWORK_STATE_INFO,
	MSM_URC_TYPE_OPERATION_MODE,
	MSM_URC_TYPE_PIN1_VERIFIED
} MsmUrcType;

struct _MsmChannelOpenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmChannel* self;
	gboolean result;
	Block2Data* _data2_;
	gboolean timeout;
	gboolean _tmp0_;
	gboolean _result_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	FsoFrameworkLogger* _tmp3_;
	MsmcommManagement* _tmp4_;
	FsoFrameworkLogger* _tmp5_;
	MsmUnsolicitedResponseHandler* _tmp6_;
	MsmcommMisc* _tmp7_;
	FsoFrameworkLogger* _tmp8_;
	MsmcommState* _tmp9_;
	MsmUnsolicitedResponseHandler* _tmp10_;
	GVariant* _tmp11_;
	GVariant* _tmp12_;
	FsoFrameworkLogger* _tmp13_;
	MsmcommMisc* _tmp14_;
	GError* err0;
	FsoFrameworkLogger* _tmp15_;
	GError* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GError * _inner_error_;
};

struct _Block3Data {
	int _ref_count_;
	MsmChannel * self;
	gpointer _async_data_;
};

struct _MsmChannelSuspendData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmChannel* self;
	gboolean result;
	Block3Data* _data3_;
	gboolean _result_;
	MsmcommNetwork* _tmp0_;
	MsmcommNetwork* _tmp1_;
	GError* _error_;
	FsoFrameworkLogger* _tmp2_;
	GError* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GError * _inner_error_;
};

struct _MsmChannelResumeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmChannel* self;
	gboolean result;
	gboolean _result_;
	MsmcommNetwork* _tmp0_;
	MsmcommNetwork* _tmp1_;
	GError* _error_;
	FsoFrameworkLogger* _tmp2_;
	GError* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GError * _inner_error_;
};

struct _MsmChannelCloseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmChannel* self;
	FsoFrameworkLogger* _tmp0_;
	MsmcommManagement* _tmp1_;
	GError* err0;
	GError * _inner_error_;
};

struct _MsmChannelFreezeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmChannel* self;
	gboolean drain;
};

struct _MsmChannelThawData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MsmChannel* self;
};


static gpointer msm_channel_parent_class = NULL;
static FsoFrameworkCommandQueueIface* msm_channel_fso_framework_command_queue_parent_iface = NULL;
static FsoGsmChannelIface* msm_channel_fso_gsm_channel_parent_iface = NULL;
static GType msm_channel_type_id = 0;

GType msm_channel_get_type (void) G_GNUC_CONST;
GType msm_channel_register_type (GTypeModule * module);
GType msm_unsolicited_response_handler_get_type (void) G_GNUC_CONST;
GType msm_unsolicited_response_handler_register_type (GTypeModule * module);
#define MSM_CHANNEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MSM_CHANNEL, MsmChannelPrivate))
enum  {
	MSM_CHANNEL_DUMMY_PROPERTY,
	MSM_CHANNEL_TRANSPORT
};
static void msm_channel_onModemControlStatusChanged_data_free (gpointer _data);
static void msm_channel_onModemControlStatusChanged (MsmChannel* self, MsmcommModemStatus status, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void msm_channel_onModemControlStatusChanged_finish (MsmChannel* self, GAsyncResult* _res_);
static gboolean msm_channel_onModemControlStatusChanged_co (msm_channel_onModemControlStatusChangedData* _data_);
static void msm_channel_onModemStatusChanged (MsmChannel* self, FsoGsmModem* modem, FsoGsmModemStatus status);
static void msm_channel_initialize (MsmChannel* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void msm_channel_initialize_finish (MsmChannel* self, GAsyncResult* _res_);
static void msm_channel_shutdown (MsmChannel* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void msm_channel_shutdown_finish (MsmChannel* self, GAsyncResult* _res_);
static void msm_channel_requestModemResource_data_free (gpointer _data);
static void msm_channel_requestModemResource (MsmChannel* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean msm_channel_requestModemResource_finish (MsmChannel* self, GAsyncResult* _res_);
static gboolean msm_channel_requestModemResource_co (msm_channel_requestModemResourceData* _data_);
static void msm_channel_requestModemResource_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean msm_channel_registerObjects (MsmChannel* self);
static void _msm_channel_onModemControlStatusChanged_msmcomm_management_modem_status (MsmcommManagement* _sender, MsmcommModemStatus status, gpointer self);
static void msm_channel_releaseModemResource_data_free (gpointer _data);
static void msm_channel_releaseModemResource (MsmChannel* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void msm_channel_releaseModemResource_finish (MsmChannel* self, GAsyncResult* _res_);
static gboolean msm_channel_releaseModemResource_co (msm_channel_releaseModemResourceData* _data_);
static void msm_channel_releaseModemResource_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void msm_channel_initialize_data_free (gpointer _data);
static gboolean msm_channel_initialize_co (MsmChannelInitializeData* _data_);
static void msm_channel_initialize_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void msm_channel_shutdown_data_free (gpointer _data);
static gboolean msm_channel_shutdown_co (MsmChannelShutdownData* _data_);
static void msm_channel_waitUntilModemIsActive_data_free (gpointer _data);
static void msm_channel_waitUntilModemIsActive (MsmChannel* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void msm_channel_waitUntilModemIsActive_finish (MsmChannel* self, GAsyncResult* _res_);
static gboolean msm_channel_waitUntilModemIsActive_co (msm_channel_waitUntilModemIsActiveData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static gboolean __lambda10_ (Block1Data* _data1_);
static gboolean ___lambda10__gsource_func (gpointer self);
MsmChannel* msm_channel_new (const gchar* name);
MsmChannel* msm_channel_construct (GType object_type, const gchar* name);
MsmUnsolicitedResponseHandler* msm_unsolicited_response_handler_new (void);
MsmUnsolicitedResponseHandler* msm_unsolicited_response_handler_construct (GType object_type);
static void _msm_channel_onModemStatusChanged_fso_gsm_modem_signal_status_changed (FsoGsmModem* _sender, FsoGsmModemStatus status, gpointer self);
gboolean msm_channel_is_ready (MsmChannel* self);
static void msm_channel_real_open_data_free (gpointer _data);
static void msm_channel_real_open (FsoFrameworkCommandQueue* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean msm_channel_real_open_co (MsmChannelOpenData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
void msm_data_reset (void);
static void msm_channel_open_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean ___lambda11_ (Block2Data* _data2_);
static gboolean ____lambda11__gsource_func (gpointer self);
void msm_unsolicited_response_handler_setup (MsmUnsolicitedResponseHandler* self);
GType msm_urc_type_get_type (void) G_GNUC_CONST;
void msm_unsolicited_response_handler_waitForUnsolicitedResponse (MsmUnsolicitedResponseHandler* self, MsmUrcType type, gint timeout, GSourceFunc timeout_func, void* timeout_func_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* msm_unsolicited_response_handler_waitForUnsolicitedResponse_finish (MsmUnsolicitedResponseHandler* self, GAsyncResult* _res_);
static void msm_channel_real_injectResponse (FsoGsmChannel* base, const gchar* response);
static void msm_channel_real_suspend_data_free (gpointer _data);
static void msm_channel_real_suspend (FsoGsmChannel* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean msm_channel_real_suspend_co (MsmChannelSuspendData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static void msm_channel_suspend_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean ___lambda12_ (Block3Data* _data3_);
static gboolean ____lambda12__gsource_func (gpointer self);
static void msm_channel_real_resume_data_free (gpointer _data);
static void msm_channel_real_resume (FsoGsmChannel* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean msm_channel_real_resume_co (MsmChannelResumeData* _data_);
static void msm_channel_resume_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void msm_channel_real_close_data_free (gpointer _data);
static void msm_channel_real_close (FsoFrameworkCommandQueue* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean msm_channel_real_close_co (MsmChannelCloseData* _data_);
static void msm_channel_close_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void msm_channel_real_registerUnsolicitedHandler (FsoFrameworkCommandQueue* base, FsoFrameworkCommandQueueUnsolicitedHandler urchandler, void* urchandler_target);
static void msm_channel_real_freeze_data_free (gpointer _data);
static void msm_channel_real_freeze (FsoFrameworkCommandQueue* base, gboolean drain, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean msm_channel_real_freeze_co (MsmChannelFreezeData* _data_);
static void msm_channel_real_thaw_data_free (gpointer _data);
static void msm_channel_real_thaw (FsoFrameworkCommandQueue* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean msm_channel_real_thaw_co (MsmChannelThawData* _data_);
static gchar* msm_channel_real_repr (FsoFrameworkAbstractObject* base);
static void msm_channel_finalize (GObject* obj);
static void _vala_msm_channel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_msm_channel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void msm_channel_onModemControlStatusChanged_data_free (gpointer _data) {
	msm_channel_onModemControlStatusChangedData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (msm_channel_onModemControlStatusChangedData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void msm_channel_onModemControlStatusChanged (MsmChannel* self, MsmcommModemStatus status, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	msm_channel_onModemControlStatusChangedData* _data_;
	MsmChannel* _tmp0_;
	MsmcommModemStatus _tmp1_;
	_data_ = g_slice_new0 (msm_channel_onModemControlStatusChangedData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_channel_onModemControlStatusChanged);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_channel_onModemControlStatusChanged_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = status;
	_data_->status = _tmp1_;
	msm_channel_onModemControlStatusChanged_co (_data_);
}


static void msm_channel_onModemControlStatusChanged_finish (MsmChannel* self, GAsyncResult* _res_) {
	msm_channel_onModemControlStatusChangedData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean msm_channel_onModemControlStatusChanged_co (msm_channel_onModemControlStatusChangedData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->status;
	_data_->self->priv->currentModemStatus = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->is_initialized;
	if (!_data_->_tmp1_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->status;
	switch (_data_->_tmp2_) {
		case MSMCOMM_MODEM_STATUS_ACTIVE:
		{
			_data_->_tmp3_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
			fso_framework_logger_error (_data_->_tmp3_, "Modem control was reseted due to internal error; synchronizing with th" \
"e modem ...");
			sleep ((guint) 2);
			_data_->_tmp4_ = _data_->self->misc_service;
			msmcomm_misc_test_alive (_data_->_tmp4_, NULL, NULL);
			break;
		}
		case MSMCOMM_MODEM_STATUS_INACTIVE:
		{
			break;
		}
		default:
		break;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void msm_channel_onModemStatusChanged (MsmChannel* self, FsoGsmModem* modem, FsoGsmModemStatus status) {
	FsoGsmModemStatus _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (modem != NULL);
	_tmp0_ = status;
	switch (_tmp0_) {
		case FSO_GSM_MODEM_STATUS_INITIALIZING:
		{
			msm_channel_initialize (self, NULL, NULL);
			break;
		}
		case FSO_GSM_MODEM_STATUS_CLOSING:
		{
			msm_channel_shutdown (self, NULL, NULL);
			break;
		}
		default:
		{
			break;
		}
	}
}


static void msm_channel_requestModemResource_data_free (gpointer _data) {
	msm_channel_requestModemResourceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (msm_channel_requestModemResourceData, _data_);
}


static void msm_channel_requestModemResource (MsmChannel* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	msm_channel_requestModemResourceData* _data_;
	MsmChannel* _tmp0_;
	_data_ = g_slice_new0 (msm_channel_requestModemResourceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_channel_requestModemResource);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_channel_requestModemResource_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	msm_channel_requestModemResource_co (_data_);
}


static gboolean msm_channel_requestModemResource_finish (MsmChannel* self, GAsyncResult* _res_) {
	gboolean result;
	msm_channel_requestModemResourceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void msm_channel_requestModemResource_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	msm_channel_requestModemResourceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	msm_channel_requestModemResource_co (_data_);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gboolean msm_channel_requestModemResource_co (msm_channel_requestModemResourceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = g_initable_new (FREE_SMARTPHONE_TYPE_USAGE_PROXY, NULL, &_data_->_inner_error_, "g-flags", 0, "g-name", "org.freesmartphone.ousaged", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freesmartphone/Usage", "g-interface-name", "org.freesmartphone.Usage", NULL);
		_data_->_tmp1_ = (FreeSmartphoneUsage*) _data_->_tmp0_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_g_object_unref0 (_data_->self->priv->usage);
		_data_->self->priv->usage = _data_->_tmp1_;
		_data_->_tmp2_ = _data_->self->priv->usage;
		_data_->_state_ = 1;
		free_smartphone_usage_request_resource (_data_->_tmp2_, "Modem", msm_channel_requestModemResource_ready, _data_);
		return FALSE;
		_state_1:
		free_smartphone_usage_request_resource_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp3_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
		_data_->_tmp4_ = _data_->err;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = string_to_string (_data_->_tmp5_);
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = g_strconcat ("Modem resource is not available: ", _data_->_tmp6_, NULL);
		_data_->_tmp8_ = _data_->_tmp7_;
		fso_framework_logger_error (_data_->_tmp3_, _data_->_tmp8_);
		_g_free0 (_data_->_tmp8_);
		_data_->result = FALSE;
		_g_error_free0 (_data_->err);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->result = TRUE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _msm_channel_onModemControlStatusChanged_msmcomm_management_modem_status (MsmcommManagement* _sender, MsmcommModemStatus status, gpointer self) {
	msm_channel_onModemControlStatusChanged (self, status, NULL, NULL);
}


static gboolean msm_channel_registerObjects (MsmChannel* self) {
	gboolean result = FALSE;
	gboolean _result_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_result_ = TRUE;
	{
		MsmcommManagement* _tmp0_ = NULL;
		MsmcommManagement* _tmp1_;
		MsmcommManagement* _tmp2_;
		MsmcommMisc* _tmp3_ = NULL;
		MsmcommMisc* _tmp4_;
		MsmcommSms* _tmp5_ = NULL;
		MsmcommSms* _tmp6_;
		MsmcommState* _tmp7_ = NULL;
		MsmcommState* _tmp8_;
		MsmcommSim* _tmp9_ = NULL;
		MsmcommSim* _tmp10_;
		MsmcommPhonebook* _tmp11_ = NULL;
		MsmcommPhonebook* _tmp12_;
		MsmcommNetwork* _tmp13_ = NULL;
		MsmcommNetwork* _tmp14_;
		MsmcommCall* _tmp15_ = NULL;
		MsmcommCall* _tmp16_;
		MsmcommSound* _tmp17_ = NULL;
		MsmcommSound* _tmp18_;
		_tmp0_ = g_initable_new (MSMCOMM_TYPE_MANAGEMENT_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "org.msmcomm", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/msmcomm", "g-interface-name", "org.msmcomm.Management", NULL);
		_tmp1_ = (MsmcommManagement*) _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch1_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (self->management_service);
		self->management_service = _tmp1_;
		_tmp2_ = self->management_service;
		g_signal_connect_object (_tmp2_, "modem-status", (GCallback) _msm_channel_onModemControlStatusChanged_msmcomm_management_modem_status, self, 0);
		_tmp3_ = g_initable_new (MSMCOMM_TYPE_MISC_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "org.msmcomm", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/msmcomm", "g-interface-name", "org.msmcomm.Misc", NULL);
		_tmp4_ = (MsmcommMisc*) _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch1_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (self->misc_service);
		self->misc_service = _tmp4_;
		_tmp5_ = g_initable_new (MSMCOMM_TYPE_SMS_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "org.msmcomm", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/msmcomm", "g-interface-name", "org.msmcomm.Sms", NULL);
		_tmp6_ = (MsmcommSms*) _tmp5_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch1_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (self->sms_service);
		self->sms_service = _tmp6_;
		_tmp7_ = g_initable_new (MSMCOMM_TYPE_STATE_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "org.msmcomm", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/msmcomm", "g-interface-name", "org.msmcomm.State", NULL);
		_tmp8_ = (MsmcommState*) _tmp7_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch1_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (self->state_service);
		self->state_service = _tmp8_;
		_tmp9_ = g_initable_new (MSMCOMM_TYPE_SIM_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "org.msmcomm", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/msmcomm", "g-interface-name", "org.msmcomm.SIM", NULL);
		_tmp10_ = (MsmcommSim*) _tmp9_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch1_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (self->sim_service);
		self->sim_service = _tmp10_;
		_tmp11_ = g_initable_new (MSMCOMM_TYPE_PHONEBOOK_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "org.msmcomm", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/msmcomm", "g-interface-name", "org.msmcomm.Phonebook", NULL);
		_tmp12_ = (MsmcommPhonebook*) _tmp11_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch1_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (self->phonebook_service);
		self->phonebook_service = _tmp12_;
		_tmp13_ = g_initable_new (MSMCOMM_TYPE_NETWORK_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "org.msmcomm", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/msmcomm", "g-interface-name", "org.msmcomm.Network", NULL);
		_tmp14_ = (MsmcommNetwork*) _tmp13_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch1_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (self->network_service);
		self->network_service = _tmp14_;
		_tmp15_ = g_initable_new (MSMCOMM_TYPE_CALL_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "org.msmcomm", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/msmcomm", "g-interface-name", "org.msmcomm.Call", NULL);
		_tmp16_ = (MsmcommCall*) _tmp15_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch1_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (self->call_service);
		self->call_service = _tmp16_;
		_tmp17_ = g_initable_new (MSMCOMM_TYPE_SOUND_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "org.msmcomm", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/msmcomm", "g-interface-name", "org.msmcomm.Sound", NULL);
		_tmp18_ = (MsmcommSound*) _tmp17_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch1_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (self->sound_service);
		self->sound_service = _tmp18_;
	}
	goto __finally1;
	__catch1_g_io_error:
	{
		GError* err = NULL;
		FsoFrameworkLogger* _tmp19_;
		GError* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp20_ = err;
		_tmp21_ = _tmp20_->message;
		_tmp22_ = string_to_string (_tmp21_);
		_tmp23_ = g_strconcat ("Can't initialize msmcommd proxy objects: ", _tmp22_, NULL);
		_tmp24_ = _tmp23_;
		fso_framework_logger_error (_tmp19_, _tmp24_);
		_g_free0 (_tmp24_);
		_result_ = FALSE;
		_g_error_free0 (err);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = _result_;
	return result;
}


static void msm_channel_releaseModemResource_data_free (gpointer _data) {
	msm_channel_releaseModemResourceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (msm_channel_releaseModemResourceData, _data_);
}


static void msm_channel_releaseModemResource (MsmChannel* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	msm_channel_releaseModemResourceData* _data_;
	MsmChannel* _tmp0_;
	_data_ = g_slice_new0 (msm_channel_releaseModemResourceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_channel_releaseModemResource);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_channel_releaseModemResource_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	msm_channel_releaseModemResource_co (_data_);
}


static void msm_channel_releaseModemResource_finish (MsmChannel* self, GAsyncResult* _res_) {
	msm_channel_releaseModemResourceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void msm_channel_releaseModemResource_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	msm_channel_releaseModemResourceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	msm_channel_releaseModemResource_co (_data_);
}


static gboolean msm_channel_releaseModemResource_co (msm_channel_releaseModemResourceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
		fso_framework_logger_debug (_data_->_tmp0_, "Releasing modem dbus resource ...");
		_data_->_tmp1_ = _data_->self->priv->usage;
		_data_->_state_ = 1;
		free_smartphone_usage_release_resource (_data_->_tmp1_, "Modem", msm_channel_releaseModemResource_ready, _data_);
		return FALSE;
		_state_1:
		free_smartphone_usage_release_resource_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp2_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
		fso_framework_logger_error (_data_->_tmp2_, "Could not release Modem resource!");
		_g_error_free0 (_data_->err);
	}
	__finally2:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void msm_channel_initialize_data_free (gpointer _data) {
	MsmChannelInitializeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MsmChannelInitializeData, _data_);
}


static void msm_channel_initialize (MsmChannel* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MsmChannelInitializeData* _data_;
	MsmChannel* _tmp0_;
	_data_ = g_slice_new0 (MsmChannelInitializeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_channel_initialize);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_channel_initialize_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	msm_channel_initialize_co (_data_);
}


static void msm_channel_initialize_finish (MsmChannel* self, GAsyncResult* _res_) {
	MsmChannelInitializeData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void msm_channel_initialize_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	MsmChannelInitializeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	msm_channel_initialize_co (_data_);
}


static gboolean msm_channel_initialize_co (MsmChannelInitializeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		memset (&_data_->date_info, 0, sizeof (MsmcommDateInfo));
		_data_->date_info.time_source = MSMCOMM_TIME_SOURCE_NETWORK;
		_data_->_tmp0_ = _data_->self->misc_service;
		_data_->_tmp1_ = _data_->date_info;
		_data_->_state_ = 1;
		msmcomm_misc_set_date (_data_->_tmp0_, &_data_->_tmp1_, msm_channel_initialize_ready, _data_);
		return FALSE;
		_state_1:
		msmcomm_misc_set_date_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		memset (&_data_->charger_info, 0, sizeof (MsmcommChargerStatusInfo));
		_data_->charger_info.mode = MSMCOMM_CHARGER_MODE_USB;
		_data_->charger_info.voltage = MSMCOMM_CHARGER_VOLTAGE_VOLTAGE_1000mA;
		_data_->_tmp2_ = _data_->self->misc_service;
		_data_->_tmp3_ = _data_->charger_info;
		_data_->_state_ = 2;
		msmcomm_misc_set_charge (_data_->_tmp2_, &_data_->_tmp3_, msm_channel_initialize_ready, _data_);
		return FALSE;
		_state_2:
		msmcomm_misc_set_charge_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		_data_->err0 = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp4_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
		_data_->_tmp5_ = _data_->err0;
		_data_->_tmp6_ = _data_->_tmp5_->message;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = string_to_string (_data_->_tmp6_);
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = g_strconcat ("Could not initialize modem with initial settings: ", _data_->_tmp7_, NULL);
		_data_->_tmp9_ = _data_->_tmp8_;
		fso_framework_logger_error (_data_->_tmp4_, _data_->_tmp9_);
		_g_free0 (_data_->_tmp9_);
		_g_error_free0 (_data_->err0);
	}
	__finally3:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void msm_channel_shutdown_data_free (gpointer _data) {
	MsmChannelShutdownData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MsmChannelShutdownData, _data_);
}


static void msm_channel_shutdown (MsmChannel* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MsmChannelShutdownData* _data_;
	MsmChannel* _tmp0_;
	_data_ = g_slice_new0 (MsmChannelShutdownData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_channel_shutdown);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_channel_shutdown_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	msm_channel_shutdown_co (_data_);
}


static void msm_channel_shutdown_finish (MsmChannel* self, GAsyncResult* _res_) {
	MsmChannelShutdownData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean msm_channel_shutdown_co (MsmChannelShutdownData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void msm_channel_waitUntilModemIsActive_data_free (gpointer _data) {
	msm_channel_waitUntilModemIsActiveData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (msm_channel_waitUntilModemIsActiveData, _data_);
}


static void msm_channel_waitUntilModemIsActive (MsmChannel* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	msm_channel_waitUntilModemIsActiveData* _data_;
	MsmChannel* _tmp0_;
	_data_ = g_slice_new0 (msm_channel_waitUntilModemIsActiveData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_channel_waitUntilModemIsActive);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_channel_waitUntilModemIsActive_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	msm_channel_waitUntilModemIsActive_co (_data_);
}


static void msm_channel_waitUntilModemIsActive_finish (MsmChannel* self, GAsyncResult* _res_) {
	msm_channel_waitUntilModemIsActiveData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
     * Little asynchronous helper method to let us wait until the modem becomes active.
     **/
static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean __lambda10_ (Block1Data* _data1_) {
	MsmChannel * self;
	gboolean result = FALSE;
	MsmcommModemStatus _tmp0_;
	self = _data1_->self;
	_tmp0_ = self->priv->currentModemStatus;
	if (_tmp0_ == MSMCOMM_MODEM_STATUS_ACTIVE) {
		msm_channel_waitUntilModemIsActive_co (_data1_->_async_data_);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean ___lambda10__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda10_ (self);
	return result;
}


static gboolean msm_channel_waitUntilModemIsActive_co (msm_channel_waitUntilModemIsActiveData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ___lambda10__gsource_func, block1_data_ref (_data_->_data1_), block1_data_unref);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _msm_channel_onModemStatusChanged_fso_gsm_modem_signal_status_changed (FsoGsmModem* _sender, FsoGsmModemStatus status, gpointer self) {
	msm_channel_onModemStatusChanged (self, _sender, status);
}


MsmChannel* msm_channel_construct (GType object_type, const gchar* name) {
	MsmChannel * self = NULL;
	MsmUnsolicitedResponseHandler* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	FsoGsmModem* _tmp3_;
	const gchar* _tmp4_;
	FsoGsmModem* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (MsmChannel*) fso_framework_abstract_object_construct (object_type);
	_tmp0_ = msm_unsolicited_response_handler_new ();
	_g_object_unref0 (self->urc_handler);
	self->urc_handler = _tmp0_;
	self->priv->is_initialized = FALSE;
	self->priv->currentModemStatus = MSMCOMM_MODEM_STATUS_UNKNOWN;
	_tmp1_ = name;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->name);
	self->name = _tmp2_;
	_tmp3_ = fso_gsm_theModem;
	_tmp4_ = name;
	fso_gsm_modem_registerChannel (_tmp3_, _tmp4_, (FsoGsmChannel*) self);
	_tmp5_ = fso_gsm_theModem;
	g_signal_connect_object (_tmp5_, "signal-status-changed", (GCallback) _msm_channel_onModemStatusChanged_fso_gsm_modem_signal_status_changed, self, 0);
	_tmp6_ = g_strdup ("Modem");
	fso_gsm_theServiceDependencies = g_list_append (fso_gsm_theServiceDependencies, _tmp6_);
	return self;
}


MsmChannel* msm_channel_new (const gchar* name) {
	return msm_channel_construct (TYPE_MSM_CHANNEL, name);
}


gboolean msm_channel_is_ready (MsmChannel* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->is_initialized;
	result = _tmp0_;
	return result;
}


static void msm_channel_real_open_data_free (gpointer _data) {
	MsmChannelOpenData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MsmChannelOpenData, _data_);
}


static void msm_channel_real_open (FsoFrameworkCommandQueue* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MsmChannel * self;
	MsmChannelOpenData* _data_;
	MsmChannel* _tmp0_;
	self = (MsmChannel*) base;
	_data_ = g_slice_new0 (MsmChannelOpenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_channel_real_open);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_channel_real_open_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	msm_channel_real_open_co (_data_);
}


static gboolean msm_channel_real_open_finish (FsoFrameworkCommandQueue* base, GAsyncResult* _res_) {
	gboolean result;
	MsmChannelOpenData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void msm_channel_open_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	MsmChannelOpenData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	msm_channel_real_open_co (_data_);
}


static gboolean ___lambda11_ (Block2Data* _data2_) {
	MsmChannel * self;
	gboolean result = FALSE;
	MsmcommModemStatus _tmp0_;
	self = _data2_->self;
	_tmp0_ = self->priv->currentModemStatus;
	if (_tmp0_ == MSMCOMM_MODEM_STATUS_ACTIVE) {
		msm_channel_real_open_co (_data2_->_async_data_);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean ____lambda11__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda11_ (self);
	return result;
}


static gboolean msm_channel_real_open_co (MsmChannelOpenData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		case 7:
		goto _state_7;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = g_object_ref (_data_->self);
	_data_->_data2_->_async_data_ = _data_;
	_data_->timeout = FALSE;
	{
		msm_data_reset ();
		_data_->_state_ = 1;
		msm_channel_requestModemResource (_data_->self, msm_channel_open_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = FALSE;
		_data_->_tmp0_ = msm_channel_requestModemResource_finish (_data_->self, _data_->_res_);
		_data_->_result_ = _data_->_tmp0_;
		_data_->_tmp1_ = _data_->_result_;
		if (!_data_->_tmp1_) {
			_data_->result = FALSE;
			block2_data_unref (_data_->_data2_);
			_data_->_data2_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp2_ = FALSE;
		_data_->_tmp2_ = msm_channel_registerObjects (_data_->self);
		if (!_data_->_tmp2_) {
			_data_->result = FALSE;
			block2_data_unref (_data_->_data2_);
			_data_->_data2_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp3_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
		fso_framework_logger_debug (_data_->_tmp3_, "Initialize modem controller ...");
		_data_->_tmp4_ = _data_->self->management_service;
		_data_->_state_ = 2;
		msmcomm_management_initialize (_data_->_tmp4_, msm_channel_open_ready, _data_);
		return FALSE;
		_state_2:
		msmcomm_management_initialize_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		_data_->_tmp5_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
		fso_framework_logger_debug (_data_->_tmp5_, "Waiting for modem controller to be fully initialized ...");
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, ____lambda11__gsource_func, block2_data_ref (_data_->_data2_), block2_data_unref);
		_data_->_state_ = 3;
		return FALSE;
		_state_3:
		;
		_data_->_tmp6_ = _data_->self->urc_handler;
		msm_unsolicited_response_handler_setup (_data_->_tmp6_);
		_data_->_tmp7_ = _data_->self->misc_service;
		_data_->_state_ = 4;
		msmcomm_misc_test_alive (_data_->_tmp7_, msm_channel_open_ready, _data_);
		return FALSE;
		_state_4:
		msmcomm_misc_test_alive_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		sleep ((guint) 2);
		_data_->_tmp8_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
		fso_framework_logger_debug (_data_->_tmp8_, "Reseting modem and waiting for it to come back ...");
		_data_->_tmp9_ = _data_->self->state_service;
		_data_->_state_ = 5;
		msmcomm_state_change_operation_mode (_data_->_tmp9_, MSMCOMM_OPERATION_MODE_RESET, msm_channel_open_ready, _data_);
		return FALSE;
		_state_5:
		msmcomm_state_change_operation_mode_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		_data_->_tmp10_ = _data_->self->urc_handler;
		_data_->_state_ = 6;
		msm_unsolicited_response_handler_waitForUnsolicitedResponse (_data_->_tmp10_, MSM_URC_TYPE_RESET_RADIO_IND, 0, NULL, NULL, msm_channel_open_ready, _data_);
		return FALSE;
		_state_6:
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = msm_unsolicited_response_handler_waitForUnsolicitedResponse_finish (_data_->_tmp10_, _data_->_res_);
		_data_->_tmp12_ = _data_->_tmp11_;
		_g_variant_unref0 (_data_->_tmp12_);
		sleep ((guint) 2);
		_data_->_tmp13_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
		fso_framework_logger_debug (_data_->_tmp13_, "Modem is back after reset now; Synchronizing ...");
		_data_->_tmp14_ = _data_->self->misc_service;
		_data_->_state_ = 7;
		msmcomm_misc_test_alive (_data_->_tmp14_, msm_channel_open_ready, _data_);
		return FALSE;
		_state_7:
		msmcomm_misc_test_alive_finish (_data_->_tmp14_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		_data_->self->priv->is_initialized = TRUE;
	}
	goto __finally4;
	__catch4_g_error:
	{
		_data_->err0 = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp15_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
		_data_->_tmp16_ = _data_->err0;
		_data_->_tmp17_ = _data_->_tmp16_->message;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = string_to_string (_data_->_tmp17_);
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = g_strconcat ("Something failed while opening the channel: ", _data_->_tmp18_, NULL);
		_data_->_tmp20_ = _data_->_tmp19_;
		fso_framework_logger_error (_data_->_tmp15_, _data_->_tmp20_);
		_g_free0 (_data_->_tmp20_);
		fso_framework_command_queue_close ((FsoFrameworkCommandQueue*) _data_->self, NULL, NULL);
		_data_->result = FALSE;
		_g_error_free0 (_data_->err0);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally4:
	if (_data_->_inner_error_ != NULL) {
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->result = TRUE;
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void msm_channel_real_injectResponse (FsoGsmChannel* base, const gchar* response) {
	MsmChannel * self;
	self = (MsmChannel*) base;
	g_return_if_fail (response != NULL);
	g_assert_not_reached ();
}


static void msm_channel_real_suspend_data_free (gpointer _data) {
	MsmChannelSuspendData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MsmChannelSuspendData, _data_);
}


static void msm_channel_real_suspend (FsoGsmChannel* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MsmChannel * self;
	MsmChannelSuspendData* _data_;
	MsmChannel* _tmp0_;
	self = (MsmChannel*) base;
	_data_ = g_slice_new0 (MsmChannelSuspendData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_channel_real_suspend);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_channel_real_suspend_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	msm_channel_real_suspend_co (_data_);
}


static gboolean msm_channel_real_suspend_finish (FsoGsmChannel* base, GAsyncResult* _res_) {
	gboolean result;
	MsmChannelSuspendData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void msm_channel_suspend_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	MsmChannelSuspendData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	msm_channel_real_suspend_co (_data_);
}


static gboolean ___lambda12_ (Block3Data* _data3_) {
	MsmChannel * self;
	gboolean result = FALSE;
	self = _data3_->self;
	msm_channel_real_suspend_co (_data3_->_async_data_);
	result = FALSE;
	return result;
}


static gboolean ____lambda12__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda12_ (self);
	return result;
}


static gboolean msm_channel_real_suspend_co (MsmChannelSuspendData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data3_ = g_slice_new0 (Block3Data);
	_data_->_data3_->_ref_count_ = 1;
	_data_->_data3_->self = g_object_ref (_data_->self);
	_data_->_data3_->_async_data_ = _data_;
	_data_->_result_ = TRUE;
	{
		_data_->_tmp0_ = _data_->self->network_service;
		_data_->_state_ = 1;
		msmcomm_network_report_health (_data_->_tmp0_, FALSE, msm_channel_suspend_ready, _data_);
		return FALSE;
		_state_1:
		msmcomm_network_report_health_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		_data_->_tmp1_ = _data_->self->network_service;
		_data_->_state_ = 2;
		msmcomm_network_report_rssi (_data_->_tmp1_, FALSE, msm_channel_suspend_ready, _data_);
		return FALSE;
		_state_2:
		msmcomm_network_report_rssi_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ____lambda12__gsource_func, block3_data_ref (_data_->_data3_), block3_data_unref);
		_data_->_state_ = 3;
		return FALSE;
		_state_3:
		;
	}
	goto __finally5;
	__catch5_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp2_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
		_data_->_tmp3_ = _data_->_error_;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = string_to_string (_data_->_tmp4_);
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = g_strconcat ("Could not disable health and rssi reports: ", _data_->_tmp5_, NULL);
		_data_->_tmp7_ = _data_->_tmp6_;
		fso_framework_logger_error (_data_->_tmp2_, _data_->_tmp7_);
		_g_free0 (_data_->_tmp7_);
		_data_->_result_ = FALSE;
		_g_error_free0 (_data_->_error_);
	}
	__finally5:
	if (_data_->_inner_error_ != NULL) {
		block3_data_unref (_data_->_data3_);
		_data_->_data3_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->result = _data_->_result_;
	block3_data_unref (_data_->_data3_);
	_data_->_data3_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	block3_data_unref (_data_->_data3_);
	_data_->_data3_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void msm_channel_real_resume_data_free (gpointer _data) {
	MsmChannelResumeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MsmChannelResumeData, _data_);
}


static void msm_channel_real_resume (FsoGsmChannel* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MsmChannel * self;
	MsmChannelResumeData* _data_;
	MsmChannel* _tmp0_;
	self = (MsmChannel*) base;
	_data_ = g_slice_new0 (MsmChannelResumeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_channel_real_resume);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_channel_real_resume_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	msm_channel_real_resume_co (_data_);
}


static gboolean msm_channel_real_resume_finish (FsoGsmChannel* base, GAsyncResult* _res_) {
	gboolean result;
	MsmChannelResumeData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void msm_channel_resume_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	MsmChannelResumeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	msm_channel_real_resume_co (_data_);
}


static gboolean msm_channel_real_resume_co (MsmChannelResumeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_result_ = TRUE;
	{
		_data_->_state_ = 1;
		msm_channel_waitUntilModemIsActive (_data_->self, msm_channel_resume_ready, _data_);
		return FALSE;
		_state_1:
		msm_channel_waitUntilModemIsActive_finish (_data_->self, _data_->_res_);
		_data_->_tmp0_ = _data_->self->network_service;
		_data_->_state_ = 2;
		msmcomm_network_report_health (_data_->_tmp0_, TRUE, msm_channel_resume_ready, _data_);
		return FALSE;
		_state_2:
		msmcomm_network_report_health_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
		_data_->_tmp1_ = _data_->self->network_service;
		_data_->_state_ = 3;
		msmcomm_network_report_rssi (_data_->_tmp1_, TRUE, msm_channel_resume_ready, _data_);
		return FALSE;
		_state_3:
		msmcomm_network_report_rssi_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp2_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
		_data_->_tmp3_ = _data_->_error_;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = string_to_string (_data_->_tmp4_);
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = g_strconcat ("Could not enable health and rssi reports: ", _data_->_tmp5_, NULL);
		_data_->_tmp7_ = _data_->_tmp6_;
		fso_framework_logger_error (_data_->_tmp2_, _data_->_tmp7_);
		_g_free0 (_data_->_tmp7_);
		_data_->_result_ = FALSE;
		_g_error_free0 (_data_->_error_);
	}
	__finally6:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->result = _data_->_result_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void msm_channel_real_close_data_free (gpointer _data) {
	MsmChannelCloseData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MsmChannelCloseData, _data_);
}


static void msm_channel_real_close (FsoFrameworkCommandQueue* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MsmChannel * self;
	MsmChannelCloseData* _data_;
	MsmChannel* _tmp0_;
	self = (MsmChannel*) base;
	_data_ = g_slice_new0 (MsmChannelCloseData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_channel_real_close);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_channel_real_close_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	msm_channel_real_close_co (_data_);
}


static void msm_channel_real_close_finish (FsoFrameworkCommandQueue* base, GAsyncResult* _res_) {
	MsmChannelCloseData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void msm_channel_close_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	MsmChannelCloseData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	msm_channel_real_close_co (_data_);
}


static gboolean msm_channel_real_close_co (MsmChannelCloseData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
		fso_framework_logger_debug (_data_->_tmp0_, "Shutdown modem controller ...");
		_data_->_tmp1_ = _data_->self->management_service;
		_data_->_state_ = 1;
		msmcomm_management_shutdown (_data_->_tmp1_, msm_channel_close_ready, _data_);
		return FALSE;
		_state_1:
		msmcomm_management_shutdown_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		_data_->_state_ = 2;
		msm_channel_releaseModemResource (_data_->self, msm_channel_close_ready, _data_);
		return FALSE;
		_state_2:
		msm_channel_releaseModemResource_finish (_data_->self, _data_->_res_);
	}
	goto __finally7;
	__catch7_g_error:
	{
		_data_->err0 = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_g_error_free0 (_data_->err0);
	}
	__finally7:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->self->priv->is_initialized = FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void msm_channel_real_registerUnsolicitedHandler (FsoFrameworkCommandQueue* base, FsoFrameworkCommandQueueUnsolicitedHandler urchandler, void* urchandler_target) {
	MsmChannel * self;
	self = (MsmChannel*) base;
}


static void msm_channel_real_freeze_data_free (gpointer _data) {
	MsmChannelFreezeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MsmChannelFreezeData, _data_);
}


static void msm_channel_real_freeze (FsoFrameworkCommandQueue* base, gboolean drain, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MsmChannel * self;
	MsmChannelFreezeData* _data_;
	MsmChannel* _tmp0_;
	gboolean _tmp1_;
	self = (MsmChannel*) base;
	_data_ = g_slice_new0 (MsmChannelFreezeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_channel_real_freeze);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_channel_real_freeze_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = drain;
	_data_->drain = _tmp1_;
	msm_channel_real_freeze_co (_data_);
}


static void msm_channel_real_freeze_finish (FsoFrameworkCommandQueue* base, GAsyncResult* _res_) {
	MsmChannelFreezeData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean msm_channel_real_freeze_co (MsmChannelFreezeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void msm_channel_real_thaw_data_free (gpointer _data) {
	MsmChannelThawData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (MsmChannelThawData, _data_);
}


static void msm_channel_real_thaw (FsoFrameworkCommandQueue* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MsmChannel * self;
	MsmChannelThawData* _data_;
	MsmChannel* _tmp0_;
	self = (MsmChannel*) base;
	_data_ = g_slice_new0 (MsmChannelThawData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, msm_channel_real_thaw);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, msm_channel_real_thaw_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	msm_channel_real_thaw_co (_data_);
}


static void msm_channel_real_thaw_finish (FsoFrameworkCommandQueue* base, GAsyncResult* _res_) {
	MsmChannelThawData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean msm_channel_real_thaw_co (MsmChannelThawData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar* msm_channel_real_repr (FsoFrameworkAbstractObject* base) {
	MsmChannel * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (MsmChannel*) base;
	_tmp0_ = g_strdup ("<>");
	result = _tmp0_;
	return result;
}


static FsoFrameworkTransport* msm_channel_real_get_transport (FsoFrameworkCommandQueue* base) {
	FsoFrameworkTransport* result;
	MsmChannel* self;
	FsoFrameworkTransport* _tmp0_;
	self = (MsmChannel*) base;
	_tmp0_ = self->priv->_transport;
	result = _tmp0_;
	return result;
}


static void msm_channel_real_set_transport (FsoFrameworkCommandQueue* base, FsoFrameworkTransport* value) {
	MsmChannel* self;
	FsoFrameworkTransport* _tmp0_;
	FsoFrameworkTransport* _tmp1_;
	self = (MsmChannel*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_transport);
	self->priv->_transport = _tmp1_;
	g_object_notify ((GObject *) self, "transport");
}


static void msm_channel_class_init (MsmChannelClass * klass) {
	msm_channel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MsmChannelPrivate));
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = msm_channel_real_repr;
	G_OBJECT_CLASS (klass)->get_property = _vala_msm_channel_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_msm_channel_set_property;
	G_OBJECT_CLASS (klass)->finalize = msm_channel_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MSM_CHANNEL_TRANSPORT, g_param_spec_object ("transport", "transport", "transport", FSO_FRAMEWORK_TYPE_TRANSPORT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void msm_channel_fso_framework_command_queue_interface_init (FsoFrameworkCommandQueueIface * iface) {
	msm_channel_fso_framework_command_queue_parent_iface = g_type_interface_peek_parent (iface);
	iface->open = (gboolean (*)(FsoFrameworkCommandQueue*)) msm_channel_real_open;
	iface->open_finish = msm_channel_real_open_finish;
	iface->close = (void (*)(FsoFrameworkCommandQueue*)) msm_channel_real_close;
	iface->close_finish = msm_channel_real_close_finish;
	iface->registerUnsolicitedHandler = (void (*)(FsoFrameworkCommandQueue*, FsoFrameworkCommandQueueUnsolicitedHandler, void*)) msm_channel_real_registerUnsolicitedHandler;
	iface->freeze = (void (*)(FsoFrameworkCommandQueue*, gboolean)) msm_channel_real_freeze;
	iface->freeze_finish = msm_channel_real_freeze_finish;
	iface->thaw = (void (*)(FsoFrameworkCommandQueue*)) msm_channel_real_thaw;
	iface->thaw_finish = msm_channel_real_thaw_finish;
	iface->get_transport = msm_channel_real_get_transport;
	iface->set_transport = msm_channel_real_set_transport;
}


static void msm_channel_fso_gsm_channel_interface_init (FsoGsmChannelIface * iface) {
	msm_channel_fso_gsm_channel_parent_iface = g_type_interface_peek_parent (iface);
	iface->injectResponse = (void (*)(FsoGsmChannel*, const gchar*)) msm_channel_real_injectResponse;
	iface->suspend = (gboolean (*)(FsoGsmChannel*)) msm_channel_real_suspend;
	iface->suspend_finish = msm_channel_real_suspend_finish;
	iface->resume = (gboolean (*)(FsoGsmChannel*)) msm_channel_real_resume;
	iface->resume_finish = msm_channel_real_resume_finish;
}


static void msm_channel_instance_init (MsmChannel * self) {
	self->priv = MSM_CHANNEL_GET_PRIVATE (self);
}


static void msm_channel_finalize (GObject* obj) {
	MsmChannel * self;
	self = MSM_CHANNEL (obj);
	_g_object_unref0 (self->priv->usage);
	_g_object_unref0 (self->priv->_transport);
	_g_free0 (self->name);
	_g_object_unref0 (self->urc_handler);
	_g_object_unref0 (self->management_service);
	_g_object_unref0 (self->state_service);
	_g_object_unref0 (self->misc_service);
	_g_object_unref0 (self->call_service);
	_g_object_unref0 (self->sim_service);
	_g_object_unref0 (self->phonebook_service);
	_g_object_unref0 (self->network_service);
	_g_object_unref0 (self->sound_service);
	_g_object_unref0 (self->sms_service);
	G_OBJECT_CLASS (msm_channel_parent_class)->finalize (obj);
}


GType msm_channel_get_type (void) {
	return msm_channel_type_id;
}


GType msm_channel_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (MsmChannelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) msm_channel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MsmChannel), 0, (GInstanceInitFunc) msm_channel_instance_init, NULL };
	static const GInterfaceInfo fso_framework_command_queue_info = { (GInterfaceInitFunc) msm_channel_fso_framework_command_queue_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo fso_gsm_channel_info = { (GInterfaceInitFunc) msm_channel_fso_gsm_channel_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	msm_channel_type_id = g_type_module_register_type (module, FSO_FRAMEWORK_TYPE_ABSTRACT_OBJECT, "MsmChannel", &g_define_type_info, 0);
	g_type_module_add_interface (module, msm_channel_type_id, FSO_FRAMEWORK_TYPE_COMMAND_QUEUE, &fso_framework_command_queue_info);
	g_type_module_add_interface (module, msm_channel_type_id, FSO_GSM_TYPE_CHANNEL, &fso_gsm_channel_info);
	return msm_channel_type_id;
}


static void _vala_msm_channel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MsmChannel * self;
	self = MSM_CHANNEL (object);
	switch (property_id) {
		case MSM_CHANNEL_TRANSPORT:
		g_value_set_object (value, fso_framework_command_queue_get_transport ((FsoFrameworkCommandQueue*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_msm_channel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MsmChannel * self;
	self = MSM_CHANNEL (object);
	switch (property_id) {
		case MSM_CHANNEL_TRANSPORT:
		fso_framework_command_queue_set_transport ((FsoFrameworkCommandQueue*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



