/* smsstorage.c generated by valac 0.14.2, the Vala compiler
 * generated from smsstorage.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <fsobasics.h>
#include <smsutil.h>
#include <conversions.h>
#include <gee.h>
#include <freesmartphone.h>
#include <util.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>


#define FSO_GSM_TYPE_ISMS_STORAGE (fso_gsm_isms_storage_get_type ())
#define FSO_GSM_ISMS_STORAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_GSM_TYPE_ISMS_STORAGE, FsoGsmISmsStorage))
#define FSO_GSM_IS_ISMS_STORAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_GSM_TYPE_ISMS_STORAGE))
#define FSO_GSM_ISMS_STORAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FSO_GSM_TYPE_ISMS_STORAGE, FsoGsmISmsStorageIface))

typedef struct _FsoGsmISmsStorage FsoGsmISmsStorage;
typedef struct _FsoGsmISmsStorageIface FsoGsmISmsStorageIface;

#define TYPE_WRAP_HEX_PDU (wrap_hex_pdu_get_type ())
#define WRAP_HEX_PDU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WRAP_HEX_PDU, WrapHexPdu))
#define WRAP_HEX_PDU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WRAP_HEX_PDU, WrapHexPduClass))
#define IS_WRAP_HEX_PDU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WRAP_HEX_PDU))
#define IS_WRAP_HEX_PDU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WRAP_HEX_PDU))
#define WRAP_HEX_PDU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WRAP_HEX_PDU, WrapHexPduClass))

typedef struct _WrapHexPdu WrapHexPdu;
typedef struct _WrapHexPduClass WrapHexPduClass;

#define FSO_GSM_TYPE_SMS_STORAGE_FACTORY (fso_gsm_sms_storage_factory_get_type ())
#define FSO_GSM_SMS_STORAGE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_GSM_TYPE_SMS_STORAGE_FACTORY, FsoGsmSmsStorageFactory))
#define FSO_GSM_SMS_STORAGE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_GSM_TYPE_SMS_STORAGE_FACTORY, FsoGsmSmsStorageFactoryClass))
#define FSO_GSM_IS_SMS_STORAGE_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_GSM_TYPE_SMS_STORAGE_FACTORY))
#define FSO_GSM_IS_SMS_STORAGE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_GSM_TYPE_SMS_STORAGE_FACTORY))
#define FSO_GSM_SMS_STORAGE_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_GSM_TYPE_SMS_STORAGE_FACTORY, FsoGsmSmsStorageFactoryClass))

typedef struct _FsoGsmSmsStorageFactory FsoGsmSmsStorageFactory;
typedef struct _FsoGsmSmsStorageFactoryClass FsoGsmSmsStorageFactoryClass;
typedef struct _FsoGsmSmsStorageFactoryPrivate FsoGsmSmsStorageFactoryPrivate;

#define FSO_GSM_TYPE_SMS_STORAGE (fso_gsm_sms_storage_get_type ())
#define FSO_GSM_SMS_STORAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_GSM_TYPE_SMS_STORAGE, FsoGsmSmsStorage))
#define FSO_GSM_SMS_STORAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_GSM_TYPE_SMS_STORAGE, FsoGsmSmsStorageClass))
#define FSO_GSM_IS_SMS_STORAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_GSM_TYPE_SMS_STORAGE))
#define FSO_GSM_IS_SMS_STORAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_GSM_TYPE_SMS_STORAGE))
#define FSO_GSM_SMS_STORAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_GSM_TYPE_SMS_STORAGE, FsoGsmSmsStorageClass))

typedef struct _FsoGsmSmsStorage FsoGsmSmsStorage;
typedef struct _FsoGsmSmsStorageClass FsoGsmSmsStorageClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FSO_GSM_TYPE_NULL_SMS_STORAGE (fso_gsm_null_sms_storage_get_type ())
#define FSO_GSM_NULL_SMS_STORAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_GSM_TYPE_NULL_SMS_STORAGE, FsoGsmNullSmsStorage))
#define FSO_GSM_NULL_SMS_STORAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_GSM_TYPE_NULL_SMS_STORAGE, FsoGsmNullSmsStorageClass))
#define FSO_GSM_IS_NULL_SMS_STORAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_GSM_TYPE_NULL_SMS_STORAGE))
#define FSO_GSM_IS_NULL_SMS_STORAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_GSM_TYPE_NULL_SMS_STORAGE))
#define FSO_GSM_NULL_SMS_STORAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_GSM_TYPE_NULL_SMS_STORAGE, FsoGsmNullSmsStorageClass))

typedef struct _FsoGsmNullSmsStorage FsoGsmNullSmsStorage;
typedef struct _FsoGsmNullSmsStorageClass FsoGsmNullSmsStorageClass;
typedef struct _FsoGsmParamSpecSmsStorageFactory FsoGsmParamSpecSmsStorageFactory;
typedef struct _FsoGsmNullSmsStoragePrivate FsoGsmNullSmsStoragePrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _FsoGsmSmsStoragePrivate FsoGsmSmsStoragePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))
#define _sms_free0(var) ((var == NULL) ? NULL : (var = (sms_free (var), NULL)))
typedef struct _WrapHexPduPrivate WrapHexPduPrivate;
#define _wrap_hex_pdu_unref0(var) ((var == NULL) ? NULL : (var = (wrap_hex_pdu_unref (var), NULL)))

struct _FsoGsmISmsStorageIface {
	GTypeInterface parent_iface;
	void (*clean) (FsoGsmISmsStorage* self);
	gint (*addSms) (FsoGsmISmsStorage* self, struct sms* message);
	GeeArrayList* (*keys) (FsoGsmISmsStorage* self);
	void (*message) (FsoGsmISmsStorage* self, const gchar* key, gint index, FreeSmartphoneGSMSIMMessage* result);
	FreeSmartphoneGSMSIMMessage* (*messagebook) (FsoGsmISmsStorage* self, int* result_length1);
	guint16 (*lastReferenceNumber) (FsoGsmISmsStorage* self);
	guint16 (*increasingReferenceNumber) (FsoGsmISmsStorage* self);
	void (*storeTransactionIndizesForSentMessage) (FsoGsmISmsStorage* self, GeeArrayList* hexpdus);
	gint (*confirmReceivedMessage) (FsoGsmISmsStorage* self, gint netreference);
};

struct _FsoGsmSmsStorageFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FsoGsmSmsStorageFactoryPrivate * priv;
};

struct _FsoGsmSmsStorageFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (FsoGsmSmsStorageFactory *self);
};

struct _FsoGsmParamSpecSmsStorageFactory {
	GParamSpec parent_instance;
};

struct _FsoGsmNullSmsStorage {
	FsoFrameworkAbstractObject parent_instance;
	FsoGsmNullSmsStoragePrivate * priv;
};

struct _FsoGsmNullSmsStorageClass {
	FsoFrameworkAbstractObjectClass parent_class;
};

struct _FsoGsmSmsStorage {
	FsoFrameworkAbstractObject parent_instance;
	FsoGsmSmsStoragePrivate * priv;
};

struct _FsoGsmSmsStorageClass {
	FsoFrameworkAbstractObjectClass parent_class;
};

struct _FsoGsmSmsStoragePrivate {
	gchar* imsi;
	gchar* storagedir;
};

struct _WrapHexPdu {
	GTypeInstance parent_instance;
	volatile int ref_count;
	WrapHexPduPrivate * priv;
	gchar* hexpdu;
	guint tpdulen;
	gint transaction_index;
};

struct _WrapHexPduClass {
	GTypeClass parent_class;
	void (*finalize) (WrapHexPdu *self);
};


static gpointer fso_gsm_sms_storage_factory_parent_class = NULL;
static gpointer fso_gsm_null_sms_storage_parent_class = NULL;
static FsoGsmISmsStorageIface* fso_gsm_null_sms_storage_fso_gsm_isms_storage_parent_iface = NULL;
static gpointer fso_gsm_sms_storage_parent_class = NULL;
static gchar* fso_gsm_sms_storage_storagedirprefix;
static gchar* fso_gsm_sms_storage_storagedirprefix = NULL;
static FsoGsmISmsStorageIface* fso_gsm_sms_storage_fso_gsm_isms_storage_parent_iface = NULL;

#define FSO_GSM_SMS_STORAGE_DEFAULT_STORAGE_DIR "/tmp/fsogsmd/sms"
#define FSO_GSM_SMS_STORAGE_SENT_UNCONFIRMED "sent-unconfirmed"
#define FSO_GSM_SMS_STORAGE_DIRECTORY_PERMISSIONS ((((((((gint) S_IRUSR) | S_IWUSR) | S_IXUSR) | S_IRGRP) | S_IXGRP) | S_IROTH) | S_IXOTH)
gpointer wrap_hex_pdu_ref (gpointer instance);
void wrap_hex_pdu_unref (gpointer instance);
GParamSpec* param_spec_wrap_hex_pdu (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_wrap_hex_pdu (GValue* value, gpointer v_object);
void value_take_wrap_hex_pdu (GValue* value, gpointer v_object);
gpointer value_get_wrap_hex_pdu (const GValue* value);
GType wrap_hex_pdu_get_type (void) G_GNUC_CONST;
GType fso_gsm_isms_storage_get_type (void) G_GNUC_CONST;
void fso_gsm_isms_storage_clean (FsoGsmISmsStorage* self);
gint fso_gsm_isms_storage_addSms (FsoGsmISmsStorage* self, struct sms* message);
GeeArrayList* fso_gsm_isms_storage_keys (FsoGsmISmsStorage* self);
void fso_gsm_isms_storage_message (FsoGsmISmsStorage* self, const gchar* key, gint index, FreeSmartphoneGSMSIMMessage* result);
FreeSmartphoneGSMSIMMessage* fso_gsm_isms_storage_messagebook (FsoGsmISmsStorage* self, int* result_length1);
guint16 fso_gsm_isms_storage_lastReferenceNumber (FsoGsmISmsStorage* self);
guint16 fso_gsm_isms_storage_increasingReferenceNumber (FsoGsmISmsStorage* self);
void fso_gsm_isms_storage_storeTransactionIndizesForSentMessage (FsoGsmISmsStorage* self, GeeArrayList* hexpdus);
gint fso_gsm_isms_storage_confirmReceivedMessage (FsoGsmISmsStorage* self, gint netreference);
gpointer fso_gsm_sms_storage_factory_ref (gpointer instance);
void fso_gsm_sms_storage_factory_unref (gpointer instance);
GParamSpec* fso_gsm_param_spec_sms_storage_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void fso_gsm_value_set_sms_storage_factory (GValue* value, gpointer v_object);
void fso_gsm_value_take_sms_storage_factory (GValue* value, gpointer v_object);
gpointer fso_gsm_value_get_sms_storage_factory (const GValue* value);
GType fso_gsm_sms_storage_factory_get_type (void) G_GNUC_CONST;
enum  {
	FSO_GSM_SMS_STORAGE_FACTORY_DUMMY_PROPERTY
};
FsoGsmISmsStorage* fso_gsm_sms_storage_factory_create (const gchar* type, const gchar* imsi);
FsoGsmSmsStorage* fso_gsm_sms_storage_new (const gchar* imsi);
FsoGsmSmsStorage* fso_gsm_sms_storage_construct (GType object_type, const gchar* imsi);
GType fso_gsm_sms_storage_get_type (void) G_GNUC_CONST;
FsoGsmNullSmsStorage* fso_gsm_null_sms_storage_new (void);
FsoGsmNullSmsStorage* fso_gsm_null_sms_storage_construct (GType object_type);
GType fso_gsm_null_sms_storage_get_type (void) G_GNUC_CONST;
FsoGsmSmsStorageFactory* fso_gsm_sms_storage_factory_new (void);
FsoGsmSmsStorageFactory* fso_gsm_sms_storage_factory_construct (GType object_type);
static void fso_gsm_sms_storage_factory_finalize (FsoGsmSmsStorageFactory* obj);
enum  {
	FSO_GSM_NULL_SMS_STORAGE_DUMMY_PROPERTY
};
static void fso_gsm_null_sms_storage_real_clean (FsoGsmISmsStorage* base);
static gint fso_gsm_null_sms_storage_real_addSms (FsoGsmISmsStorage* base, struct sms* message);
static GeeArrayList* fso_gsm_null_sms_storage_real_keys (FsoGsmISmsStorage* base);
static void fso_gsm_null_sms_storage_real_message (FsoGsmISmsStorage* base, const gchar* key, gint index, FreeSmartphoneGSMSIMMessage* result);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static FreeSmartphoneGSMSIMMessage* fso_gsm_null_sms_storage_real_messagebook (FsoGsmISmsStorage* base, int* result_length1);
static guint16 fso_gsm_null_sms_storage_real_lastReferenceNumber (FsoGsmISmsStorage* base);
static guint16 fso_gsm_null_sms_storage_real_increasingReferenceNumber (FsoGsmISmsStorage* base);
static void fso_gsm_null_sms_storage_real_storeTransactionIndizesForSentMessage (FsoGsmISmsStorage* base, GeeArrayList* hexpdus);
static gint fso_gsm_null_sms_storage_real_confirmReceivedMessage (FsoGsmISmsStorage* base, gint netreference);
static gchar* fso_gsm_null_sms_storage_real_repr (FsoFrameworkAbstractObject* base);
#define FSO_GSM_SMS_STORAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FSO_GSM_TYPE_SMS_STORAGE, FsoGsmSmsStoragePrivate))
enum  {
	FSO_GSM_SMS_STORAGE_DUMMY_PROPERTY
};
#define FSO_GSM_SMS_STORAGE_SMS_ALREADY_SEEN (-1)
#define FSO_GSM_SMS_STORAGE_SMS_MULTI_INCOMPLETE 0
#define FSO_GSM_SMS_STORAGE_SMS_SINGLE_COMPLETE 1
void fso_gsm_sms_storage_setStorageDir (const gchar* dirname);
static gchar* fso_gsm_sms_storage_real_repr (FsoFrameworkAbstractObject* base);
#define FSO_GSM_CONFIG_SECTION "fsogsm"
static void fso_gsm_sms_storage_real_clean (FsoGsmISmsStorage* base);
static gint fso_gsm_sms_storage_real_addSms (FsoGsmISmsStorage* base, struct sms* message);
static GeeArrayList* fso_gsm_sms_storage_real_keys (FsoGsmISmsStorage* base);
static void fso_gsm_sms_storage_real_message (FsoGsmISmsStorage* base, const gchar* key, gint index, FreeSmartphoneGSMSIMMessage* result);
static GVariant* _variant_new69 (gint value);
static GVariant* _variant_new70 (gint value);
static GVariant* _variant_new71 (gboolean value);
static GVariant* _variant_new72 (gboolean value);
static GVariant* _variant_new73 (gboolean value);
static GVariant* _variant_new74 (gboolean value);
static GVariant* _variant_new75 (gboolean value);
static GVariant* _variant_new76 (guint8 value);
static GVariant* _variant_new77 (guint8 value);
static GVariant* _variant_new78 (guint8 value);
static GVariant* _variant_new79 (gchar* value);
static GVariant* _variant_new80 (gchar* value);
static FreeSmartphoneGSMSIMMessage* fso_gsm_sms_storage_real_messagebook (FsoGsmISmsStorage* base, int* result_length1);
static void _vala_array_add27 (FreeSmartphoneGSMSIMMessage** array, int* length, int* size, const FreeSmartphoneGSMSIMMessage* value);
static void _vala_FreeSmartphoneGSMSIMMessage_array_free (FreeSmartphoneGSMSIMMessage* array, gint array_length);
static guint16 fso_gsm_sms_storage_real_lastReferenceNumber (FsoGsmISmsStorage* base);
static guint16 fso_gsm_sms_storage_real_increasingReferenceNumber (FsoGsmISmsStorage* base);
static void fso_gsm_sms_storage_real_storeTransactionIndizesForSentMessage (FsoGsmISmsStorage* base, GeeArrayList* hexpdus);
static gint fso_gsm_sms_storage_real_confirmReceivedMessage (FsoGsmISmsStorage* base, gint netreference);
static void fso_gsm_sms_storage_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


void fso_gsm_isms_storage_clean (FsoGsmISmsStorage* self) {
	g_return_if_fail (self != NULL);
	FSO_GSM_ISMS_STORAGE_GET_INTERFACE (self)->clean (self);
}


gint fso_gsm_isms_storage_addSms (FsoGsmISmsStorage* self, struct sms* message) {
	g_return_val_if_fail (self != NULL, 0);
	return FSO_GSM_ISMS_STORAGE_GET_INTERFACE (self)->addSms (self, message);
}


GeeArrayList* fso_gsm_isms_storage_keys (FsoGsmISmsStorage* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FSO_GSM_ISMS_STORAGE_GET_INTERFACE (self)->keys (self);
}


void fso_gsm_isms_storage_message (FsoGsmISmsStorage* self, const gchar* key, gint index, FreeSmartphoneGSMSIMMessage* result) {
	g_return_if_fail (self != NULL);
	FSO_GSM_ISMS_STORAGE_GET_INTERFACE (self)->message (self, key, index, result);
}


FreeSmartphoneGSMSIMMessage* fso_gsm_isms_storage_messagebook (FsoGsmISmsStorage* self, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return FSO_GSM_ISMS_STORAGE_GET_INTERFACE (self)->messagebook (self, result_length1);
}


guint16 fso_gsm_isms_storage_lastReferenceNumber (FsoGsmISmsStorage* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return FSO_GSM_ISMS_STORAGE_GET_INTERFACE (self)->lastReferenceNumber (self);
}


guint16 fso_gsm_isms_storage_increasingReferenceNumber (FsoGsmISmsStorage* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return FSO_GSM_ISMS_STORAGE_GET_INTERFACE (self)->increasingReferenceNumber (self);
}


void fso_gsm_isms_storage_storeTransactionIndizesForSentMessage (FsoGsmISmsStorage* self, GeeArrayList* hexpdus) {
	g_return_if_fail (self != NULL);
	FSO_GSM_ISMS_STORAGE_GET_INTERFACE (self)->storeTransactionIndizesForSentMessage (self, hexpdus);
}


gint fso_gsm_isms_storage_confirmReceivedMessage (FsoGsmISmsStorage* self, gint netreference) {
	g_return_val_if_fail (self != NULL, 0);
	return FSO_GSM_ISMS_STORAGE_GET_INTERFACE (self)->confirmReceivedMessage (self, netreference);
}


static void fso_gsm_isms_storage_base_init (FsoGsmISmsStorageIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType fso_gsm_isms_storage_get_type (void) {
	static volatile gsize fso_gsm_isms_storage_type_id__volatile = 0;
	if (g_once_init_enter (&fso_gsm_isms_storage_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoGsmISmsStorageIface), (GBaseInitFunc) fso_gsm_isms_storage_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType fso_gsm_isms_storage_type_id;
		fso_gsm_isms_storage_type_id = g_type_register_static (G_TYPE_INTERFACE, "FsoGsmISmsStorage", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (fso_gsm_isms_storage_type_id, FSO_FRAMEWORK_TYPE_ABSTRACT_OBJECT);
		g_once_init_leave (&fso_gsm_isms_storage_type_id__volatile, fso_gsm_isms_storage_type_id);
	}
	return fso_gsm_isms_storage_type_id__volatile;
}


/**
         * Create a new SMS storage for a given IMSI.
         **/
FsoGsmISmsStorage* fso_gsm_sms_storage_factory_create (const gchar* type, const gchar* imsi) {
	FsoGsmISmsStorage* result = NULL;
	FsoGsmISmsStorage* storage;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (imsi != NULL, NULL);
	storage = NULL;
	_tmp0_ = type;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("default")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp4_;
				FsoGsmSmsStorage* _tmp5_;
				_tmp4_ = imsi;
				_tmp5_ = fso_gsm_sms_storage_new (_tmp4_);
				_g_object_unref0 (storage);
				storage = (FsoGsmISmsStorage*) _tmp5_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				FsoGsmNullSmsStorage* _tmp6_;
				_tmp6_ = fso_gsm_null_sms_storage_new ();
				_g_object_unref0 (storage);
				storage = (FsoGsmISmsStorage*) _tmp6_;
				break;
			}
		}
	}
	result = storage;
	return result;
}


FsoGsmSmsStorageFactory* fso_gsm_sms_storage_factory_construct (GType object_type) {
	FsoGsmSmsStorageFactory* self = NULL;
	self = (FsoGsmSmsStorageFactory*) g_type_create_instance (object_type);
	return self;
}


FsoGsmSmsStorageFactory* fso_gsm_sms_storage_factory_new (void) {
	return fso_gsm_sms_storage_factory_construct (FSO_GSM_TYPE_SMS_STORAGE_FACTORY);
}


static void fso_gsm_value_sms_storage_factory_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void fso_gsm_value_sms_storage_factory_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		fso_gsm_sms_storage_factory_unref (value->data[0].v_pointer);
	}
}


static void fso_gsm_value_sms_storage_factory_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = fso_gsm_sms_storage_factory_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer fso_gsm_value_sms_storage_factory_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* fso_gsm_value_sms_storage_factory_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		FsoGsmSmsStorageFactory* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = fso_gsm_sms_storage_factory_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* fso_gsm_value_sms_storage_factory_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	FsoGsmSmsStorageFactory** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = fso_gsm_sms_storage_factory_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* fso_gsm_param_spec_sms_storage_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	FsoGsmParamSpecSmsStorageFactory* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FSO_GSM_TYPE_SMS_STORAGE_FACTORY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer fso_gsm_value_get_sms_storage_factory (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_GSM_TYPE_SMS_STORAGE_FACTORY), NULL);
	return value->data[0].v_pointer;
}


void fso_gsm_value_set_sms_storage_factory (GValue* value, gpointer v_object) {
	FsoGsmSmsStorageFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_GSM_TYPE_SMS_STORAGE_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FSO_GSM_TYPE_SMS_STORAGE_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		fso_gsm_sms_storage_factory_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fso_gsm_sms_storage_factory_unref (old);
	}
}


void fso_gsm_value_take_sms_storage_factory (GValue* value, gpointer v_object) {
	FsoGsmSmsStorageFactory* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_GSM_TYPE_SMS_STORAGE_FACTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FSO_GSM_TYPE_SMS_STORAGE_FACTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fso_gsm_sms_storage_factory_unref (old);
	}
}


static void fso_gsm_sms_storage_factory_class_init (FsoGsmSmsStorageFactoryClass * klass) {
	fso_gsm_sms_storage_factory_parent_class = g_type_class_peek_parent (klass);
	FSO_GSM_SMS_STORAGE_FACTORY_CLASS (klass)->finalize = fso_gsm_sms_storage_factory_finalize;
}


static void fso_gsm_sms_storage_factory_instance_init (FsoGsmSmsStorageFactory * self) {
	self->ref_count = 1;
}


static void fso_gsm_sms_storage_factory_finalize (FsoGsmSmsStorageFactory* obj) {
	FsoGsmSmsStorageFactory * self;
	self = FSO_GSM_SMS_STORAGE_FACTORY (obj);
}


GType fso_gsm_sms_storage_factory_get_type (void) {
	static volatile gsize fso_gsm_sms_storage_factory_type_id__volatile = 0;
	if (g_once_init_enter (&fso_gsm_sms_storage_factory_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { fso_gsm_value_sms_storage_factory_init, fso_gsm_value_sms_storage_factory_free_value, fso_gsm_value_sms_storage_factory_copy_value, fso_gsm_value_sms_storage_factory_peek_pointer, "p", fso_gsm_value_sms_storage_factory_collect_value, "p", fso_gsm_value_sms_storage_factory_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (FsoGsmSmsStorageFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_gsm_sms_storage_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoGsmSmsStorageFactory), 0, (GInstanceInitFunc) fso_gsm_sms_storage_factory_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType fso_gsm_sms_storage_factory_type_id;
		fso_gsm_sms_storage_factory_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FsoGsmSmsStorageFactory", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&fso_gsm_sms_storage_factory_type_id__volatile, fso_gsm_sms_storage_factory_type_id);
	}
	return fso_gsm_sms_storage_factory_type_id__volatile;
}


gpointer fso_gsm_sms_storage_factory_ref (gpointer instance) {
	FsoGsmSmsStorageFactory* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void fso_gsm_sms_storage_factory_unref (gpointer instance) {
	FsoGsmSmsStorageFactory* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FSO_GSM_SMS_STORAGE_FACTORY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void fso_gsm_null_sms_storage_real_clean (FsoGsmISmsStorage* base) {
	FsoGsmNullSmsStorage * self;
	self = (FsoGsmNullSmsStorage*) base;
}


static gint fso_gsm_null_sms_storage_real_addSms (FsoGsmISmsStorage* base, struct sms* message) {
	FsoGsmNullSmsStorage * self;
	gint result = 0;
	self = (FsoGsmNullSmsStorage*) base;
	g_return_val_if_fail (message != NULL, 0);
	result = 1;
	return result;
}


static GeeArrayList* fso_gsm_null_sms_storage_real_keys (FsoGsmISmsStorage* base) {
	FsoGsmNullSmsStorage * self;
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_;
	self = (FsoGsmNullSmsStorage*) base;
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	result = _tmp0_;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


static void fso_gsm_null_sms_storage_real_message (FsoGsmISmsStorage* base, const gchar* key, gint index, FreeSmartphoneGSMSIMMessage* result) {
	FsoGsmNullSmsStorage * self;
	gint _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	FreeSmartphoneGSMSIMMessage _tmp3_ = {0};
	FreeSmartphoneGSMSIMMessage _tmp4_;
	self = (FsoGsmNullSmsStorage*) base;
	g_return_if_fail (key != NULL);
	_tmp0_ = index;
	_tmp1_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
	_tmp2_ = _tmp1_;
	free_smartphone_gsm_sim_message_init (&_tmp3_, _tmp0_, "unknown", "1234567890", "0", "Test", _tmp2_);
	_tmp4_ = _tmp3_;
	_g_hash_table_unref0 (_tmp2_);
	*result = _tmp4_;
	return;
}


static FreeSmartphoneGSMSIMMessage* fso_gsm_null_sms_storage_real_messagebook (FsoGsmISmsStorage* base, int* result_length1) {
	FsoGsmNullSmsStorage * self;
	FreeSmartphoneGSMSIMMessage* result = NULL;
	FreeSmartphoneGSMSIMMessage* _tmp0_ = NULL;
	FreeSmartphoneGSMSIMMessage* _tmp1_;
	gint _tmp1__length1;
	self = (FsoGsmNullSmsStorage*) base;
	_tmp0_ = g_new0 (FreeSmartphoneGSMSIMMessage, 0);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static guint16 fso_gsm_null_sms_storage_real_lastReferenceNumber (FsoGsmISmsStorage* base) {
	FsoGsmNullSmsStorage * self;
	guint16 result = 0U;
	self = (FsoGsmNullSmsStorage*) base;
	result = (guint16) 0;
	return result;
}


static guint16 fso_gsm_null_sms_storage_real_increasingReferenceNumber (FsoGsmISmsStorage* base) {
	FsoGsmNullSmsStorage * self;
	guint16 result = 0U;
	self = (FsoGsmNullSmsStorage*) base;
	result = (guint16) 0;
	return result;
}


static void fso_gsm_null_sms_storage_real_storeTransactionIndizesForSentMessage (FsoGsmISmsStorage* base, GeeArrayList* hexpdus) {
	FsoGsmNullSmsStorage * self;
	self = (FsoGsmNullSmsStorage*) base;
	g_return_if_fail (hexpdus != NULL);
}


static gint fso_gsm_null_sms_storage_real_confirmReceivedMessage (FsoGsmISmsStorage* base, gint netreference) {
	FsoGsmNullSmsStorage * self;
	gint result = 0;
	self = (FsoGsmNullSmsStorage*) base;
	result = 0;
	return result;
}


static gchar* fso_gsm_null_sms_storage_real_repr (FsoFrameworkAbstractObject* base) {
	FsoGsmNullSmsStorage * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (FsoGsmNullSmsStorage*) base;
	_tmp0_ = g_strdup ("<>");
	result = _tmp0_;
	return result;
}


FsoGsmNullSmsStorage* fso_gsm_null_sms_storage_construct (GType object_type) {
	FsoGsmNullSmsStorage * self = NULL;
	self = (FsoGsmNullSmsStorage*) fso_framework_abstract_object_construct (object_type);
	return self;
}


FsoGsmNullSmsStorage* fso_gsm_null_sms_storage_new (void) {
	return fso_gsm_null_sms_storage_construct (FSO_GSM_TYPE_NULL_SMS_STORAGE);
}


static void fso_gsm_null_sms_storage_class_init (FsoGsmNullSmsStorageClass * klass) {
	fso_gsm_null_sms_storage_parent_class = g_type_class_peek_parent (klass);
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = fso_gsm_null_sms_storage_real_repr;
}


static void fso_gsm_null_sms_storage_fso_gsm_isms_storage_interface_init (FsoGsmISmsStorageIface * iface) {
	fso_gsm_null_sms_storage_fso_gsm_isms_storage_parent_iface = g_type_interface_peek_parent (iface);
	iface->clean = (void (*)(FsoGsmISmsStorage*)) fso_gsm_null_sms_storage_real_clean;
	iface->addSms = (gint (*)(FsoGsmISmsStorage*, struct sms*)) fso_gsm_null_sms_storage_real_addSms;
	iface->keys = (GeeArrayList* (*)(FsoGsmISmsStorage*)) fso_gsm_null_sms_storage_real_keys;
	iface->message = (void (*)(FsoGsmISmsStorage*, const gchar*, gint, FreeSmartphoneGSMSIMMessage*)) fso_gsm_null_sms_storage_real_message;
	iface->messagebook = (FreeSmartphoneGSMSIMMessage* (*)(FsoGsmISmsStorage*, int*)) fso_gsm_null_sms_storage_real_messagebook;
	iface->lastReferenceNumber = (guint16 (*)(FsoGsmISmsStorage*)) fso_gsm_null_sms_storage_real_lastReferenceNumber;
	iface->increasingReferenceNumber = (guint16 (*)(FsoGsmISmsStorage*)) fso_gsm_null_sms_storage_real_increasingReferenceNumber;
	iface->storeTransactionIndizesForSentMessage = (void (*)(FsoGsmISmsStorage*, GeeArrayList*)) fso_gsm_null_sms_storage_real_storeTransactionIndizesForSentMessage;
	iface->confirmReceivedMessage = (gint (*)(FsoGsmISmsStorage*, gint)) fso_gsm_null_sms_storage_real_confirmReceivedMessage;
}


static void fso_gsm_null_sms_storage_instance_init (FsoGsmNullSmsStorage * self) {
}


/**
     * @class NullSmsStorage
     *
     * A sms storage without a implement for times where no real sms storage handling is
     * needed but required by the implementation (e.g. testing, dummy implementation, ...)
     **/
GType fso_gsm_null_sms_storage_get_type (void) {
	static volatile gsize fso_gsm_null_sms_storage_type_id__volatile = 0;
	if (g_once_init_enter (&fso_gsm_null_sms_storage_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoGsmNullSmsStorageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_gsm_null_sms_storage_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoGsmNullSmsStorage), 0, (GInstanceInitFunc) fso_gsm_null_sms_storage_instance_init, NULL };
		static const GInterfaceInfo fso_gsm_isms_storage_info = { (GInterfaceInitFunc) fso_gsm_null_sms_storage_fso_gsm_isms_storage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType fso_gsm_null_sms_storage_type_id;
		fso_gsm_null_sms_storage_type_id = g_type_register_static (FSO_FRAMEWORK_TYPE_ABSTRACT_OBJECT, "FsoGsmNullSmsStorage", &g_define_type_info, 0);
		g_type_add_interface_static (fso_gsm_null_sms_storage_type_id, FSO_GSM_TYPE_ISMS_STORAGE, &fso_gsm_isms_storage_info);
		g_once_init_leave (&fso_gsm_null_sms_storage_type_id__volatile, fso_gsm_null_sms_storage_type_id);
	}
	return fso_gsm_null_sms_storage_type_id__volatile;
}


void fso_gsm_sms_storage_setStorageDir (const gchar* dirname) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (dirname != NULL);
	_tmp0_ = dirname;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (fso_gsm_sms_storage_storagedirprefix);
	fso_gsm_sms_storage_storagedirprefix = _tmp1_;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gchar* fso_gsm_sms_storage_real_repr (FsoFrameworkAbstractObject* base) {
	FsoGsmSmsStorage * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	self = (FsoGsmSmsStorage*) base;
	_tmp1_ = self->priv->imsi;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp2_ = self->priv->imsi;
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = g_strconcat ("<", _tmp3_, ">", NULL);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("<>");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	result = _tmp0_;
	return result;
}


FsoGsmSmsStorage* fso_gsm_sms_storage_construct (GType object_type, const gchar* imsi) {
	FsoGsmSmsStorage * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	FsoFrameworkSmartKeyFile* _tmp2_;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_;
	FsoFrameworkLogger* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	g_return_val_if_fail (imsi != NULL, NULL);
	self = (FsoGsmSmsStorage*) fso_framework_abstract_object_construct (object_type);
	_tmp0_ = imsi;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->imsi);
	self->priv->imsi = _tmp1_;
	_tmp2_ = ((FsoFrameworkAbstractObject*) self)->config;
	_tmp3_ = fso_framework_smart_key_file_stringValue (_tmp2_, FSO_GSM_CONFIG_SECTION, "sms_storage_dir", FSO_GSM_SMS_STORAGE_DEFAULT_STORAGE_DIR);
	_g_free0 (fso_gsm_sms_storage_storagedirprefix);
	fso_gsm_sms_storage_storagedirprefix = _tmp3_;
	_tmp4_ = fso_gsm_sms_storage_storagedirprefix;
	_tmp5_ = imsi;
	_tmp6_ = g_build_filename (_tmp4_, _tmp5_, NULL);
	_g_free0 (self->priv->storagedir);
	self->priv->storagedir = _tmp6_;
	_tmp7_ = self->priv->storagedir;
	g_mkdir_with_parents (_tmp7_, FSO_GSM_SMS_STORAGE_DIRECTORY_PERMISSIONS);
	_tmp8_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp9_ = self->priv->storagedir;
	_tmp10_ = string_to_string (_tmp9_);
	_tmp11_ = g_strconcat ("Created w/ storage dir ", _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	fso_framework_logger_info (_tmp8_, _tmp12_);
	_g_free0 (_tmp12_);
	return self;
}


FsoGsmSmsStorage* fso_gsm_sms_storage_new (const gchar* imsi) {
	return fso_gsm_sms_storage_construct (FSO_GSM_TYPE_SMS_STORAGE, imsi);
}


static void fso_gsm_sms_storage_real_clean (FsoGsmISmsStorage* base) {
	FsoGsmSmsStorage * self;
	const gchar* _tmp0_;
	self = (FsoGsmSmsStorage*) base;
	_tmp0_ = self->priv->storagedir;
	fso_framework_file_handling_removeTree (_tmp0_);
}


/**
         * Hand a new message over to the storage.
         *
         * @note The storage will now own the message.
         * @returns -1, if the message is already known.
         * @returns 0, if the message is a fragment of an incomplete concatenated sms.
         * @returns 1, if the message is not concatenated, hence complete.
         * @returns n > 1, if the message is a fragment which completes an incomplete concatenated sms composed out of n fragments.
         **/
/**
         * @returns a hashable string for the message that serves as a unique identifier
         * (considering the fragments of a concatenated message as being the same message)
         */
static gchar* sms_number (struct sms* self) {
	gchar* result = NULL;
	enum sms_type _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->type;
	switch (_tmp0_) {
		case SMS_TYPE_DELIVER:
		{
			const gchar* _tmp1_ = NULL;
			gchar* _tmp2_;
			_tmp1_ = sms_address_to_string (&self->deliver.oaddr);
			_tmp2_ = g_strdup (_tmp1_);
			result = _tmp2_;
			return result;
		}
		case SMS_TYPE_SUBMIT:
		{
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			_tmp3_ = sms_address_to_string (&self->submit.daddr);
			_tmp4_ = g_strdup (_tmp3_);
			result = _tmp4_;
			return result;
		}
		case SMS_TYPE_COMMAND:
		{
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			_tmp5_ = sms_address_to_string (&self->command.daddr);
			_tmp6_ = g_strdup (_tmp5_);
			result = _tmp6_;
			return result;
		}
		case SMS_TYPE_STATUS_REPORT:
		{
			const gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			_tmp7_ = sms_address_to_string (&self->status_report.raddr);
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		}
		default:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("unknown");
			result = _tmp9_;
			return result;
		}
	}
}


static gchar* sms_toHexPdu (struct sms* self, gint* tpdulen) {
	gint _vala_tpdulen = 0;
	gchar* result = NULL;
	gint binlen = 0;
	gchar* _tmp0_ = NULL;
	gchar* binpdu;
	gint binpdu_length1;
	gint _binpdu_size_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gboolean res;
	gboolean _tmp5_;
	gchar* _tmp7_ = NULL;
	gchar* hexpdu;
	gint hexpdu_length1;
	gint _hexpdu_size_;
	gchar* _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
	gchar* _tmp10_;
	gint _tmp10__length1;
	gchar* _tmp11_;
	gint _tmp11__length1;
	gchar* _tmp12_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar, 176);
	binpdu = _tmp0_;
	binpdu_length1 = 176;
	_binpdu_size_ = binpdu_length1;
	_tmp1_ = binpdu;
	_tmp1__length1 = binpdu_length1;
	_tmp4_ = sms_encode (self, &_tmp2_, &_tmp3_, _tmp1_);
	binlen = _tmp2_;
	_vala_tpdulen = _tmp3_;
	res = _tmp4_;
	_tmp5_ = res;
	if (!_tmp5_) {
		gchar* _tmp6_;
		g_warning ("fsogsm3rdparty.vapi:619: %s", "Sms.Message::toHexPdu: could not encode message");
		_vala_tpdulen = -1;
		_tmp6_ = g_strdup ("");
		result = _tmp6_;
		binpdu = (g_free (binpdu), NULL);
		if (tpdulen) {
			*tpdulen = _vala_tpdulen;
		}
		return result;
	}
	_tmp7_ = g_new0 (gchar, 1024);
	hexpdu = _tmp7_;
	hexpdu_length1 = 1024;
	_hexpdu_size_ = hexpdu_length1;
	_tmp8_ = binpdu;
	_tmp8__length1 = binpdu_length1;
	_tmp9_ = binlen;
	_tmp10_ = hexpdu;
	_tmp10__length1 = hexpdu_length1;
	encode_hex_own_buf (_tmp8_, (glong) _tmp9_, (gchar) 0, _tmp10_);
	_tmp11_ = hexpdu;
	_tmp11__length1 = hexpdu_length1;
	_tmp12_ = g_strdup_printf ("%s", (const gchar*) _tmp11_);
	result = _tmp12_;
	hexpdu = (g_free (hexpdu), NULL);
	binpdu = (g_free (binpdu), NULL);
	if (tpdulen) {
		*tpdulen = _vala_tpdulen;
	}
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch57_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch57_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally57;
	__catch57_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally57:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar* sms_hash (struct sms* self) {
	gchar* result = NULL;
	enum sms_type _tmp0_;
	guint16 ref_num = 0U;
	guint8 max_msgs = 0U;
	guint8 seq_num = 0U;
	gint tpdulen = 0;
	gchar* _tmp1_;
	gchar* hash;
	gchar* _tmp2_ = NULL;
	gchar* oaddr;
	guint16 _tmp3_ = 0U;
	guint8 _tmp4_ = 0U;
	guint8 _tmp5_ = 0U;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->type;
	g_assert (_tmp0_ == SMS_TYPE_DELIVER);
	_tmp1_ = g_strdup ("");
	hash = _tmp1_;
	_tmp2_ = sms_number (self);
	oaddr = _tmp2_;
	_tmp6_ = sms_extract_concatenation (self, &_tmp3_, &_tmp4_, &_tmp5_);
	ref_num = _tmp3_;
	max_msgs = _tmp4_;
	seq_num = _tmp5_;
	if (!_tmp6_) {
		gint _tmp7_ = 0;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		gchar* pdu_hash;
		const gchar* _tmp12_;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		_tmp8_ = sms_toHexPdu (self, &_tmp7_);
		tpdulen = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp9_, (gsize) (-1));
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		pdu_hash = _tmp11_;
		_tmp12_ = pdu_hash;
		_tmp13_ = string_to_string (_tmp12_);
		_tmp14_ = g_strconcat (_tmp13_, "_1", NULL);
		_g_free0 (hash);
		hash = _tmp14_;
		_g_free0 (pdu_hash);
	} else {
		const gchar* _tmp15_;
		const gchar* _tmp16_ = NULL;
		guint16 _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		guint8 _tmp20_;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
		gchar* _tmp25_ = NULL;
		_tmp15_ = oaddr;
		_tmp16_ = string_to_string (_tmp15_);
		_tmp17_ = ref_num;
		_tmp18_ = g_strdup_printf ("%hu", _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = max_msgs;
		_tmp21_ = g_strdup_printf ("%hhu", _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat (_tmp16_, "_", _tmp19_, "_", _tmp22_, NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = string_replace (_tmp24_, "+", "");
		_g_free0 (hash);
		hash = _tmp25_;
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp19_);
	}
	result = hash;
	_g_free0 (oaddr);
	return result;
}


static gint fso_gsm_sms_storage_real_addSms (FsoGsmISmsStorage* base, struct sms* message) {
	FsoGsmSmsStorage * self;
	gint result = 0;
	struct sms* _tmp0_;
	enum sms_type _tmp1_;
	struct sms* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* smshash;
	guint16 ref_num = 0U;
	guint8 max_msgs;
	guint8 seq_num;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	struct sms* _tmp13_;
	guint16 _tmp14_ = 0U;
	guint8 _tmp15_ = 0U;
	guint8 _tmp16_ = 0U;
	gboolean _tmp17_ = FALSE;
	self = (FsoGsmSmsStorage*) base;
	g_return_val_if_fail (message != NULL, 0);
	_tmp0_ = message;
	_tmp1_ = _tmp0_->type;
	if (_tmp1_ != SMS_TYPE_DELIVER) {
		FsoFrameworkLogger* _tmp2_;
		struct sms* _tmp3_;
		enum sms_type _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp2_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp3_ = message;
		_tmp4_ = _tmp3_->type;
		_tmp5_ = g_strdup_printf ("Ignoring message with type %u (!= DELIVER)", (guint) _tmp4_);
		_tmp6_ = _tmp5_;
		fso_framework_logger_info (_tmp2_, _tmp6_);
		_g_free0 (_tmp6_);
		result = FSO_GSM_SMS_STORAGE_SMS_ALREADY_SEEN;
		return result;
	}
	_tmp7_ = message;
	_tmp8_ = sms_hash (_tmp7_);
	smshash = _tmp8_;
	max_msgs = (guint8) 1;
	seq_num = (guint8) 1;
	_tmp9_ = self->priv->storagedir;
	_tmp10_ = smshash;
	_tmp11_ = g_build_filename (_tmp9_, _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	g_mkdir_with_parents (_tmp12_, FSO_GSM_SMS_STORAGE_DIRECTORY_PERMISSIONS);
	_g_free0 (_tmp12_);
	_tmp13_ = message;
	_tmp17_ = sms_extract_concatenation (_tmp13_, &_tmp14_, &_tmp15_, &_tmp16_);
	ref_num = _tmp14_;
	max_msgs = _tmp15_;
	seq_num = _tmp16_;
	if (!_tmp17_) {
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_ = NULL;
		gchar* filename;
		const gchar* _tmp21_;
		gboolean _tmp22_ = FALSE;
		struct sms* _tmp23_;
		struct sms* _tmp24_;
		glong _tmp25_ = 0L;
		const gchar* _tmp26_;
		_tmp18_ = self->priv->storagedir;
		_tmp19_ = smshash;
		_tmp20_ = g_build_filename (_tmp18_, _tmp19_, "001", NULL);
		filename = _tmp20_;
		_tmp21_ = filename;
		_tmp22_ = fso_framework_file_handling_isPresent (_tmp21_);
		if (_tmp22_) {
			result = FSO_GSM_SMS_STORAGE_SMS_ALREADY_SEEN;
			_g_free0 (filename);
			_g_free0 (smshash);
			return result;
		}
		_tmp23_ = message;
		_tmp24_ = message;
		_tmp25_ = sms_size ();
		_tmp26_ = filename;
		fso_framework_file_handling_writeBuffer (_tmp23_, (gulong) _tmp25_, _tmp26_, TRUE);
		result = FSO_GSM_SMS_STORAGE_SMS_SINGLE_COMPLETE;
		_g_free0 (filename);
		_g_free0 (smshash);
		return result;
	} else {
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		guint8 _tmp29_;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_;
		gchar* filename;
		const gchar* _tmp34_;
		gboolean _tmp35_ = FALSE;
		struct sms* _tmp36_;
		struct sms* _tmp37_;
		glong _tmp38_ = 0L;
		const gchar* _tmp39_;
		_tmp27_ = self->priv->storagedir;
		_tmp28_ = smshash;
		_tmp29_ = seq_num;
		_tmp30_ = g_strdup_printf ("%03u", (guint) _tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_build_filename (_tmp27_, _tmp28_, _tmp31_, NULL);
		_tmp33_ = _tmp32_;
		_g_free0 (_tmp31_);
		filename = _tmp33_;
		_tmp34_ = filename;
		_tmp35_ = fso_framework_file_handling_isPresent (_tmp34_);
		if (_tmp35_) {
			result = FSO_GSM_SMS_STORAGE_SMS_ALREADY_SEEN;
			_g_free0 (filename);
			_g_free0 (smshash);
			return result;
		}
		_tmp36_ = message;
		_tmp37_ = message;
		_tmp38_ = sms_size ();
		_tmp39_ = filename;
		fso_framework_file_handling_writeBuffer (_tmp36_, (gulong) _tmp38_, _tmp39_, TRUE);
		{
			gint i;
			i = 1;
			{
				gboolean _tmp40_;
				_tmp40_ = TRUE;
				while (TRUE) {
					gboolean _tmp41_;
					gint _tmp43_;
					guint8 _tmp44_;
					const gchar* _tmp45_;
					const gchar* _tmp46_;
					gint _tmp47_;
					gchar* _tmp48_ = NULL;
					gchar* _tmp49_;
					gchar* _tmp50_ = NULL;
					gchar* _tmp51_;
					gchar* fragmentfilename;
					const gchar* _tmp52_;
					gboolean _tmp53_ = FALSE;
					_tmp41_ = _tmp40_;
					if (!_tmp41_) {
						gint _tmp42_;
						_tmp42_ = i;
						i = _tmp42_ + 1;
					}
					_tmp40_ = FALSE;
					_tmp43_ = i;
					_tmp44_ = max_msgs;
					if (!(_tmp43_ <= ((gint) _tmp44_))) {
						break;
					}
					_tmp45_ = self->priv->storagedir;
					_tmp46_ = smshash;
					_tmp47_ = i;
					_tmp48_ = g_strdup_printf ("%03u", (guint) _tmp47_);
					_tmp49_ = _tmp48_;
					_tmp50_ = g_build_filename (_tmp45_, _tmp46_, _tmp49_, NULL);
					_tmp51_ = _tmp50_;
					_g_free0 (_tmp49_);
					fragmentfilename = _tmp51_;
					_tmp52_ = fragmentfilename;
					_tmp53_ = fso_framework_file_handling_isPresent (_tmp52_);
					if (!_tmp53_) {
						result = FSO_GSM_SMS_STORAGE_SMS_MULTI_INCOMPLETE;
						_g_free0 (fragmentfilename);
						_g_free0 (filename);
						_g_free0 (smshash);
						return result;
					}
					_g_free0 (fragmentfilename);
				}
			}
		}
		result = (gint) max_msgs;
		_g_free0 (filename);
		_g_free0 (smshash);
		return result;
	}
	_g_free0 (smshash);
}


static GeeArrayList* fso_gsm_sms_storage_real_keys (FsoGsmISmsStorage* base) {
	FsoGsmSmsStorage * self;
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _result_;
	GDir* dir = NULL;
	GError * _inner_error_ = NULL;
	self = (FsoGsmSmsStorage*) base;
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	_result_ = _tmp0_;
	{
		const gchar* _tmp1_;
		GDir* _tmp2_ = NULL;
		GDir* _tmp3_;
		_tmp1_ = self->priv->storagedir;
		_tmp2_ = g_dir_open (_tmp1_, (guint) 0, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch58_g_error;
		}
		_g_dir_close0 (dir);
		dir = _tmp3_;
		{
			GDir* _tmp4_;
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			gchar* smshash;
			_tmp4_ = dir;
			_tmp5_ = g_dir_read_name (_tmp4_);
			_tmp6_ = g_strdup (_tmp5_);
			smshash = _tmp6_;
			{
				gboolean _tmp7_;
				_tmp7_ = TRUE;
				while (TRUE) {
					gboolean _tmp8_;
					const gchar* _tmp12_;
					GeeArrayList* _tmp13_;
					const gchar* _tmp14_;
					_tmp8_ = _tmp7_;
					if (!_tmp8_) {
						GDir* _tmp9_;
						const gchar* _tmp10_ = NULL;
						gchar* _tmp11_;
						_tmp9_ = dir;
						_tmp10_ = g_dir_read_name (_tmp9_);
						_tmp11_ = g_strdup (_tmp10_);
						_g_free0 (smshash);
						smshash = _tmp11_;
					}
					_tmp7_ = FALSE;
					_tmp12_ = smshash;
					if (!(_tmp12_ != NULL)) {
						break;
					}
					_tmp13_ = _result_;
					_tmp14_ = smshash;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp14_);
				}
			}
			_g_free0 (smshash);
		}
	}
	goto __finally58;
	__catch58_g_error:
	{
		GError* e = NULL;
		FsoFrameworkLogger* _tmp15_;
		GError* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		_tmp18_ = string_to_string (_tmp17_);
		_tmp19_ = g_strconcat ("Can't access SMS storage dir: ", _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		fso_framework_logger_error (_tmp15_, _tmp20_);
		_g_free0 (_tmp20_);
		_g_error_free0 (e);
	}
	__finally58:
	if (_inner_error_ != NULL) {
		_g_dir_close0 (dir);
		_g_object_unref0 (_result_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _result_;
	_g_dir_close0 (dir);
	return result;
}


static gchar* sms_to_string (struct sms* self) {
	gchar* result = NULL;
	GSList* list;
	GSList* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	list = NULL;
	list = g_slist_append (list, self);
	_tmp0_ = list;
	_tmp1_ = sms_decode_text (_tmp0_);
	result = _tmp1_;
	_g_slist_free0 (list);
	return result;
}


static gchar* sms_scts_to_string (struct sms_scts *self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gint8 _tmp1_;
	guint8 _tmp6_;
	guint8 _tmp7_;
	guint8 _tmp8_;
	guint8 _tmp9_;
	guint8 _tmp10_;
	guint8 _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	_tmp1_ = (*self).timezone;
	if (((gint) _tmp1_) > 0) {
		gint8 _tmp2_;
		gchar* _tmp3_ = NULL;
		_tmp2_ = (*self).timezone;
		_tmp3_ = g_strdup_printf ("+%02d", (gint) _tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gint8 _tmp4_;
		gchar* _tmp5_ = NULL;
		_tmp4_ = (*self).timezone;
		_tmp5_ = g_strdup_printf ("%02d", (gint) _tmp4_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = (*self).year;
	_tmp7_ = (*self).month;
	_tmp8_ = (*self).day;
	_tmp9_ = (*self).hour;
	_tmp10_ = (*self).minute;
	_tmp11_ = (*self).second;
	_tmp12_ = _tmp0_;
	_tmp13_ = g_strdup_printf ("%02u/%02u/%02u,%02u:%02u:%02u%s", (guint) _tmp6_, (guint) _tmp7_, (guint) _tmp8_, (guint) _tmp9_, (guint) _tmp10_, (guint) _tmp11_, _tmp12_);
	result = _tmp13_;
	_g_free0 (_tmp0_);
	return result;
}


static gchar* sms_timestamp (struct sms* self) {
	gchar* result = NULL;
	enum sms_type _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->type;
	switch (_tmp0_) {
		case SMS_TYPE_DELIVER:
		{
			gchar* _tmp1_ = NULL;
			_tmp1_ = sms_scts_to_string (&self->deliver.scts);
			result = _tmp1_;
			return result;
		}
		default:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("none");
			result = _tmp2_;
			return result;
		}
	}
}


static GVariant* _variant_new69 (gint value) {
	return g_variant_ref_sink (g_variant_new_int32 (value));
}


static GVariant* _variant_new70 (gint value) {
	return g_variant_ref_sink (g_variant_new_int32 (value));
}


static GVariant* _variant_new71 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static GVariant* _variant_new72 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static GVariant* _variant_new73 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static GVariant* _variant_new74 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static GVariant* _variant_new75 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static GVariant* _variant_new76 (guint8 value) {
	return g_variant_ref_sink (g_variant_new_byte (value));
}


static GVariant* _variant_new77 (guint8 value) {
	return g_variant_ref_sink (g_variant_new_byte (value));
}


static GVariant* _variant_new78 (guint8 value) {
	return g_variant_ref_sink (g_variant_new_byte (value));
}


static GVariant* _variant_new79 (gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant* _variant_new80 (gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static void sms_deliver_addProperties (struct sms_deliver *self, GHashTable* props) {
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	GVariant* _tmp3_;
	GHashTable* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	GVariant* _tmp7_;
	GHashTable* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
	GVariant* _tmp11_;
	GHashTable* _tmp12_;
	gchar* _tmp13_;
	gboolean _tmp14_;
	GVariant* _tmp15_;
	GHashTable* _tmp16_;
	gchar* _tmp17_;
	guint8 _tmp18_;
	GVariant* _tmp19_;
	GHashTable* _tmp20_;
	gchar* _tmp21_;
	guint8 _tmp22_;
	GVariant* _tmp23_;
	GHashTable* _tmp24_;
	gchar* _tmp25_;
	guint8 _tmp26_;
	GVariant* _tmp27_;
	GHashTable* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_ = NULL;
	GVariant* _tmp31_;
	gboolean _tmp32_;
	g_return_if_fail (props != NULL);
	_tmp0_ = props;
	_tmp1_ = g_strdup ("mms");
	_tmp2_ = (*self).mms;
	_tmp3_ = _variant_new72 (_tmp2_);
	g_hash_table_insert (_tmp0_, _tmp1_, _tmp3_);
	_tmp4_ = props;
	_tmp5_ = g_strdup ("sri");
	_tmp6_ = (*self).sri;
	_tmp7_ = _variant_new73 (_tmp6_);
	g_hash_table_insert (_tmp4_, _tmp5_, _tmp7_);
	_tmp8_ = props;
	_tmp9_ = g_strdup ("udhi");
	_tmp10_ = (*self).udhi;
	_tmp11_ = _variant_new74 (_tmp10_);
	g_hash_table_insert (_tmp8_, _tmp9_, _tmp11_);
	_tmp12_ = props;
	_tmp13_ = g_strdup ("rp");
	_tmp14_ = (*self).rp;
	_tmp15_ = _variant_new75 (_tmp14_);
	g_hash_table_insert (_tmp12_, _tmp13_, _tmp15_);
	_tmp16_ = props;
	_tmp17_ = g_strdup ("pid");
	_tmp18_ = (*self).pid;
	_tmp19_ = _variant_new76 (_tmp18_);
	g_hash_table_insert (_tmp16_, _tmp17_, _tmp19_);
	_tmp20_ = props;
	_tmp21_ = g_strdup ("dcs");
	_tmp22_ = (*self).dcs;
	_tmp23_ = _variant_new77 (_tmp22_);
	g_hash_table_insert (_tmp20_, _tmp21_, _tmp23_);
	_tmp24_ = props;
	_tmp25_ = g_strdup ("udl");
	_tmp26_ = (*self).udl;
	_tmp27_ = _variant_new78 (_tmp26_);
	g_hash_table_insert (_tmp24_, _tmp25_, _tmp27_);
	_tmp28_ = props;
	_tmp29_ = g_strdup ("timestamp");
	_tmp30_ = sms_scts_to_string (&(*self).scts);
	_tmp31_ = _variant_new79 (_tmp30_);
	g_hash_table_insert (_tmp28_, _tmp29_, _tmp31_);
	_tmp32_ = (*self).udhi;
	if (_tmp32_) {
		GHashTable* _tmp33_;
		gchar* _tmp34_;
		guint8 _tmp35_;
		guint8 _tmp36_;
		guint8 _tmp37_;
		guint8 _tmp38_;
		guint8 _tmp39_;
		guint8 _tmp40_;
		guint8 _tmp41_;
		gchar* _tmp42_ = NULL;
		GVariant* _tmp43_;
		_tmp33_ = props;
		_tmp34_ = g_strdup ("udh");
		_tmp35_ = (*self).ud[0];
		_tmp36_ = (*self).ud[1];
		_tmp37_ = (*self).ud[2];
		_tmp38_ = (*self).ud[4];
		_tmp39_ = (*self).ud[3];
		_tmp40_ = (*self).ud[6];
		_tmp41_ = (*self).ud[5];
		_tmp42_ = g_strdup_printf ("%02X %02X %02X %04X %04X", (guint) _tmp35_, (guint) _tmp36_, (guint) _tmp37_, (guint) (_tmp38_ + (_tmp39_ << 8)), (guint) (_tmp40_ + (_tmp41_ << 8)));
		_tmp43_ = _variant_new80 (_tmp42_);
		g_hash_table_insert (_tmp33_, _tmp34_, _tmp43_);
	}
}


static GHashTable* sms_properties (struct sms* self) {
	GHashTable* result = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* props;
	gint dst = 0;
	gint src = 0;
	gboolean is8bit = FALSE;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean hasAppPort;
	gboolean _tmp7_;
	enum sms_type _tmp20_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_variant_unref0_);
	props = _tmp2_;
	_tmp6_ = sms_extract_app_port (self, &_tmp3_, &_tmp4_, &_tmp5_);
	dst = _tmp3_;
	src = _tmp4_;
	is8bit = _tmp5_;
	hasAppPort = _tmp6_;
	_tmp7_ = hasAppPort;
	if (_tmp7_) {
		GHashTable* _tmp8_;
		gchar* _tmp9_;
		gint _tmp10_;
		GVariant* _tmp11_;
		GHashTable* _tmp12_;
		gchar* _tmp13_;
		gint _tmp14_;
		GVariant* _tmp15_;
		GHashTable* _tmp16_;
		gchar* _tmp17_;
		gboolean _tmp18_;
		GVariant* _tmp19_;
		_tmp8_ = props;
		_tmp9_ = g_strdup ("app-port-src");
		_tmp10_ = src;
		_tmp11_ = _variant_new69 (_tmp10_);
		g_hash_table_insert (_tmp8_, _tmp9_, _tmp11_);
		_tmp12_ = props;
		_tmp13_ = g_strdup ("app-port-dst");
		_tmp14_ = dst;
		_tmp15_ = _variant_new70 (_tmp14_);
		g_hash_table_insert (_tmp12_, _tmp13_, _tmp15_);
		_tmp16_ = props;
		_tmp17_ = g_strdup ("app-port-8bit");
		_tmp18_ = is8bit;
		_tmp19_ = _variant_new71 (_tmp18_);
		g_hash_table_insert (_tmp16_, _tmp17_, _tmp19_);
	}
	_tmp20_ = self->type;
	switch (_tmp20_) {
		case SMS_TYPE_DELIVER:
		{
			GHashTable* _tmp21_;
			_tmp21_ = props;
			sms_deliver_addProperties (&self->deliver, _tmp21_);
		}
		default:
		{
			break;
		}
	}
	result = props;
	return result;
}


static void fso_gsm_sms_storage_real_message (FsoGsmISmsStorage* base, const gchar* key, gint index, FreeSmartphoneGSMSIMMessage* result) {
	FsoGsmSmsStorage * self;
	gint _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	FreeSmartphoneGSMSIMMessage _result_ = {0};
	GeeArrayList* _tmp5_ = NULL;
	GeeArrayList* _tmp6_;
	const gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (FsoGsmSmsStorage*) base;
	g_return_if_fail (key != NULL);
	_tmp0_ = index;
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_variant_unref0_);
	_tmp4_ = _tmp3_;
	free_smartphone_gsm_sim_message_init (&_result_, _tmp0_, "unknown", "unknown", "unknown", "unknown", _tmp4_);
	_g_hash_table_unref0 (_tmp4_);
	_tmp5_ = fso_gsm_isms_storage_keys ((FsoGsmISmsStorage*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = key;
	_tmp8_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp6_, _tmp7_);
	_tmp9_ = !_tmp8_;
	_g_object_unref0 (_tmp6_);
	if (_tmp9_) {
		*result = _result_;
		return;
	}
	_tmp10_ = key;
	_tmp11_ = g_str_has_suffix (_tmp10_, "_1");
	if (_tmp11_) {
		gchar* contents = NULL;
		const gchar* _tmp23_;
		struct sms* message;
		gchar* _tmp24_;
		struct sms* _tmp25_;
		gchar* _tmp26_ = NULL;
		struct sms* _tmp27_;
		gchar* _tmp28_ = NULL;
		struct sms* _tmp29_;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_;
		const gchar* _tmp32_ = NULL;
		gchar* _tmp33_;
		struct sms* _tmp34_;
		GHashTable* _tmp35_ = NULL;
		{
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			gchar* _tmp16_ = NULL;
			_tmp12_ = self->priv->storagedir;
			_tmp13_ = key;
			_tmp14_ = g_build_filename (_tmp12_, _tmp13_, "001", NULL);
			_tmp15_ = _tmp14_;
			g_file_get_contents (_tmp15_, &_tmp16_, NULL, &_inner_error_);
			_g_free0 (contents);
			contents = _tmp16_;
			_g_free0 (_tmp15_);
			if (_inner_error_ != NULL) {
				goto __catch59_g_error;
			}
		}
		goto __finally59;
		__catch59_g_error:
		{
			GError* e = NULL;
			FsoFrameworkLogger* _tmp17_;
			GError* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp17_ = ((FsoFrameworkAbstractObject*) self)->logger;
			_tmp18_ = e;
			_tmp19_ = _tmp18_->message;
			_tmp20_ = string_to_string (_tmp19_);
			_tmp21_ = g_strconcat ("Can't access SMS storage dir: ", _tmp20_, NULL);
			_tmp22_ = _tmp21_;
			fso_framework_logger_error (_tmp17_, _tmp22_);
			_g_free0 (_tmp22_);
			*result = _result_;
			_g_error_free0 (e);
			_g_free0 (contents);
			return;
		}
		__finally59:
		if (_inner_error_ != NULL) {
			_g_free0 (contents);
			free_smartphone_gsm_sim_message_destroy (&_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp23_ = contents;
		message = (struct sms*) _tmp23_;
		_tmp24_ = g_strdup ("single");
		_g_free0 (_result_.status);
		_result_.status = _tmp24_;
		_tmp25_ = message;
		_tmp26_ = sms_number (_tmp25_);
		_g_free0 (_result_.number);
		_result_.number = _tmp26_;
		_tmp27_ = message;
		_tmp28_ = sms_to_string (_tmp27_);
		_g_free0 (_result_.contents);
		_result_.contents = _tmp28_;
		_tmp29_ = message;
		_tmp30_ = sms_timestamp (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = string_to_string (_tmp31_);
		_tmp33_ = g_strdup (_tmp32_);
		_g_free0 (_result_.timestamp);
		_result_.timestamp = _tmp33_;
		_g_free0 (_tmp31_);
		_tmp34_ = message;
		_tmp35_ = sms_properties (_tmp34_);
		_g_hash_table_unref0 (_result_.properties);
		_result_.properties = _tmp35_;
		_g_free0 (contents);
	} else {
		gchar* _tmp36_;
		const gchar* _tmp37_;
		gchar** _tmp38_;
		gchar** _tmp39_ = NULL;
		gchar** namecomponents;
		gint namecomponents_length1;
		gint _namecomponents_size_;
		gchar** _tmp40_;
		gint _tmp40__length1;
		gchar** _tmp41_;
		gint _tmp41__length1;
		const gchar* _tmp42_;
		gint _tmp43_ = 0;
		gint max_fragment;
		gint _tmp44_;
		struct sms** _tmp45_ = NULL;
		struct sms** smses;
		gint smses_length1;
		gint _smses_size_;
		gboolean complete;
		gboolean info;
		GSList* smslist;
		GSList* _tmp108_;
		gchar* _tmp109_ = NULL;
		gchar* text;
		const gchar* _tmp110_ = NULL;
		const gchar* _tmp111_;
		const gchar* _tmp113_;
		gchar* _tmp114_;
		_tmp36_ = g_strdup ("concatenated");
		_g_free0 (_result_.status);
		_result_.status = _tmp36_;
		_tmp37_ = key;
		_tmp39_ = _tmp38_ = g_strsplit (_tmp37_, "_", 0);
		namecomponents = _tmp39_;
		namecomponents_length1 = _vala_array_length (_tmp38_);
		_namecomponents_size_ = namecomponents_length1;
		_tmp40_ = namecomponents;
		_tmp40__length1 = namecomponents_length1;
		_tmp41_ = namecomponents;
		_tmp41__length1 = namecomponents_length1;
		_tmp42_ = _tmp40_[_tmp41__length1 - 1];
		_tmp43_ = atoi (_tmp42_);
		max_fragment = _tmp43_;
		_tmp44_ = max_fragment;
		_tmp45_ = g_new0 (struct sms*, (_tmp44_ - 1) + 1);
		smses = _tmp45_;
		smses_length1 = _tmp44_ - 1;
		_smses_size_ = smses_length1;
		complete = TRUE;
		info = FALSE;
		{
			gint i;
			i = 1;
			{
				gboolean _tmp46_;
				_tmp46_ = TRUE;
				while (TRUE) {
					gboolean _tmp47_;
					gint _tmp49_;
					gint _tmp50_;
					struct sms** _tmp51_;
					gint _tmp51__length1;
					gint _tmp52_;
					struct sms* _tmp53_;
					struct sms* _tmp54_;
					const gchar* _tmp55_;
					const gchar* _tmp56_;
					gint _tmp57_;
					gchar* _tmp58_ = NULL;
					gchar* _tmp59_;
					gchar* _tmp60_ = NULL;
					gchar* _tmp61_;
					gchar* filename;
					const gchar* _tmp62_;
					gboolean _tmp63_ = FALSE;
					_tmp47_ = _tmp46_;
					if (!_tmp47_) {
						gint _tmp48_;
						_tmp48_ = i;
						i = _tmp48_ + 1;
					}
					_tmp46_ = FALSE;
					_tmp49_ = i;
					_tmp50_ = max_fragment;
					if (!(_tmp49_ <= _tmp50_)) {
						break;
					}
					_tmp51_ = smses;
					_tmp51__length1 = smses_length1;
					_tmp52_ = i;
					_tmp53_ = sms_new ();
					_sms_free0 (_tmp51_[_tmp52_ - 1]);
					_tmp51_[_tmp52_ - 1] = _tmp53_;
					_tmp54_ = _tmp51_[_tmp52_ - 1];
					_tmp55_ = self->priv->storagedir;
					_tmp56_ = key;
					_tmp57_ = i;
					_tmp58_ = g_strdup_printf ("%03u", (guint) _tmp57_);
					_tmp59_ = _tmp58_;
					_tmp60_ = g_build_filename (_tmp55_, _tmp56_, _tmp59_, NULL);
					_tmp61_ = _tmp60_;
					_g_free0 (_tmp59_);
					filename = _tmp61_;
					_tmp62_ = filename;
					_tmp63_ = fso_framework_file_handling_isPresent (_tmp62_);
					if (!_tmp63_) {
						gchar* _tmp64_;
						struct sms** _tmp65_;
						gint _tmp65__length1;
						gint _tmp66_;
						struct sms* _tmp67_;
						complete = FALSE;
						_tmp64_ = g_strdup ("incomplete");
						_g_free0 (_result_.status);
						_result_.status = _tmp64_;
						_tmp65_ = smses;
						_tmp65__length1 = smses_length1;
						_tmp66_ = i;
						_sms_free0 (_tmp65_[_tmp66_ - 1]);
						_tmp65_[_tmp66_ - 1] = NULL;
						_tmp67_ = _tmp65_[_tmp66_ - 1];
					} else {
						gchar* contents = NULL;
						struct sms** _tmp76_;
						gint _tmp76__length1;
						gint _tmp77_;
						struct sms* _tmp78_;
						const gchar* _tmp79_;
						glong _tmp80_ = 0L;
						gboolean _tmp81_;
						{
							const gchar* _tmp68_;
							gchar* _tmp69_ = NULL;
							_tmp68_ = filename;
							g_file_get_contents (_tmp68_, &_tmp69_, NULL, &_inner_error_);
							_g_free0 (contents);
							contents = _tmp69_;
							if (_inner_error_ != NULL) {
								goto __catch60_g_error;
							}
						}
						goto __finally60;
						__catch60_g_error:
						{
							GError* e = NULL;
							FsoFrameworkLogger* _tmp70_;
							GError* _tmp71_;
							const gchar* _tmp72_;
							const gchar* _tmp73_ = NULL;
							gchar* _tmp74_ = NULL;
							gchar* _tmp75_;
							e = _inner_error_;
							_inner_error_ = NULL;
							_tmp70_ = ((FsoFrameworkAbstractObject*) self)->logger;
							_tmp71_ = e;
							_tmp72_ = _tmp71_->message;
							_tmp73_ = string_to_string (_tmp72_);
							_tmp74_ = g_strconcat ("Can't access SMS storage dir: ", _tmp73_, NULL);
							_tmp75_ = _tmp74_;
							fso_framework_logger_error (_tmp70_, _tmp75_);
							_g_free0 (_tmp75_);
							*result = _result_;
							_g_error_free0 (e);
							_g_free0 (contents);
							_g_free0 (filename);
							smses = (_vala_array_free (smses, smses_length1, (GDestroyNotify) sms_free), NULL);
							namecomponents = (_vala_array_free (namecomponents, namecomponents_length1, (GDestroyNotify) g_free), NULL);
							return;
						}
						__finally60:
						if (_inner_error_ != NULL) {
							_g_free0 (contents);
							_g_free0 (filename);
							smses = (_vala_array_free (smses, smses_length1, (GDestroyNotify) sms_free), NULL);
							namecomponents = (_vala_array_free (namecomponents, namecomponents_length1, (GDestroyNotify) g_free), NULL);
							free_smartphone_gsm_sim_message_destroy (&_result_);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_tmp76_ = smses;
						_tmp76__length1 = smses_length1;
						_tmp77_ = i;
						_tmp78_ = _tmp76_[_tmp77_ - 1];
						_tmp79_ = contents;
						_tmp80_ = sms_size ();
						memcpy (_tmp78_, _tmp79_, (gsize) _tmp80_);
						_tmp81_ = info;
						if (!_tmp81_) {
							struct sms** _tmp82_;
							gint _tmp82__length1;
							gint _tmp83_;
							struct sms* _tmp84_;
							gchar* _tmp85_ = NULL;
							struct sms** _tmp86_;
							gint _tmp86__length1;
							gint _tmp87_;
							struct sms* _tmp88_;
							gchar* _tmp89_ = NULL;
							gchar* _tmp90_;
							const gchar* _tmp91_ = NULL;
							gchar* _tmp92_;
							struct sms** _tmp93_;
							gint _tmp93__length1;
							gint _tmp94_;
							struct sms* _tmp95_;
							GHashTable* _tmp96_ = NULL;
							_tmp82_ = smses;
							_tmp82__length1 = smses_length1;
							_tmp83_ = i;
							_tmp84_ = _tmp82_[_tmp83_ - 1];
							_tmp85_ = sms_number (_tmp84_);
							_g_free0 (_result_.number);
							_result_.number = _tmp85_;
							_tmp86_ = smses;
							_tmp86__length1 = smses_length1;
							_tmp87_ = i;
							_tmp88_ = _tmp86_[_tmp87_ - 1];
							_tmp89_ = sms_timestamp (_tmp88_);
							_tmp90_ = _tmp89_;
							_tmp91_ = string_to_string (_tmp90_);
							_tmp92_ = g_strdup (_tmp91_);
							_g_free0 (_result_.timestamp);
							_result_.timestamp = _tmp92_;
							_g_free0 (_tmp90_);
							_tmp93_ = smses;
							_tmp93__length1 = smses_length1;
							_tmp94_ = i;
							_tmp95_ = _tmp93_[_tmp94_ - 1];
							_tmp96_ = sms_properties (_tmp95_);
							_g_hash_table_unref0 (_result_.properties);
							_result_.properties = _tmp96_;
							info = TRUE;
						}
						_g_free0 (contents);
					}
					_g_free0 (filename);
				}
			}
		}
		smslist = NULL;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp97_;
				_tmp97_ = TRUE;
				while (TRUE) {
					gboolean _tmp98_;
					gint _tmp100_;
					gint _tmp101_;
					struct sms** _tmp102_;
					gint _tmp102__length1;
					gint _tmp103_;
					struct sms* _tmp104_;
					_tmp98_ = _tmp97_;
					if (!_tmp98_) {
						gint _tmp99_;
						_tmp99_ = i;
						i = _tmp99_ + 1;
					}
					_tmp97_ = FALSE;
					_tmp100_ = i;
					_tmp101_ = max_fragment;
					if (!(_tmp100_ < _tmp101_)) {
						break;
					}
					_tmp102_ = smses;
					_tmp102__length1 = smses_length1;
					_tmp103_ = i;
					_tmp104_ = _tmp102_[_tmp103_];
					if (_tmp104_ != NULL) {
						struct sms** _tmp105_;
						gint _tmp105__length1;
						gint _tmp106_;
						struct sms* _tmp107_;
						_tmp105_ = smses;
						_tmp105__length1 = smses_length1;
						_tmp106_ = i;
						_tmp107_ = _tmp105_[_tmp106_];
						smslist = g_slist_append (smslist, _tmp107_);
					}
				}
			}
		}
		_tmp108_ = smslist;
		_tmp109_ = sms_decode_text (_tmp108_);
		text = _tmp109_;
		_tmp111_ = text;
		if (_tmp111_ != NULL) {
			const gchar* _tmp112_;
			_tmp112_ = text;
			_tmp110_ = _tmp112_;
		} else {
			_tmp110_ = "decode error";
		}
		_tmp113_ = _tmp110_;
		_tmp114_ = g_strdup (_tmp113_);
		_g_free0 (_result_.contents);
		_result_.contents = _tmp114_;
		_g_free0 (text);
		_g_slist_free0 (smslist);
		smses = (_vala_array_free (smses, smses_length1, (GDestroyNotify) sms_free), NULL);
		namecomponents = (_vala_array_free (namecomponents, namecomponents_length1, (GDestroyNotify) g_free), NULL);
	}
	*result = _result_;
	return;
}


static void _vala_array_add27 (FreeSmartphoneGSMSIMMessage** array, int* length, int* size, const FreeSmartphoneGSMSIMMessage* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (FreeSmartphoneGSMSIMMessage, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void _vala_FreeSmartphoneGSMSIMMessage_array_free (FreeSmartphoneGSMSIMMessage* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			free_smartphone_gsm_sim_message_destroy (&array[i]);
		}
	}
	g_free (array);
}


static FreeSmartphoneGSMSIMMessage* fso_gsm_sms_storage_real_messagebook (FsoGsmISmsStorage* base, int* result_length1) {
	FsoGsmSmsStorage * self;
	FreeSmartphoneGSMSIMMessage* result = NULL;
	FreeSmartphoneGSMSIMMessage* _tmp0_ = NULL;
	FreeSmartphoneGSMSIMMessage* mb;
	gint mb_length1;
	gint _mb_size_;
	gint index;
	FreeSmartphoneGSMSIMMessage* _tmp16_;
	gint _tmp16__length1;
	self = (FsoGsmSmsStorage*) base;
	_tmp0_ = g_new0 (FreeSmartphoneGSMSIMMessage, 0);
	mb = _tmp0_;
	mb_length1 = 0;
	_mb_size_ = mb_length1;
	index = 0;
	{
		GeeArrayList* _tmp1_ = NULL;
		GeeArrayList* _key_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _key_size;
		gint _key_index;
		_tmp1_ = fso_gsm_isms_storage_keys ((FsoGsmISmsStorage*) self);
		_key_list = _tmp1_;
		_tmp2_ = _key_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_key_size = _tmp4_;
		_key_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			gchar* key;
			FreeSmartphoneGSMSIMMessage* _tmp11_;
			gint _tmp11__length1;
			const gchar* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			FreeSmartphoneGSMSIMMessage _tmp15_ = {0};
			_tmp5_ = _key_index;
			_key_index = _tmp5_ + 1;
			_tmp6_ = _key_index;
			_tmp7_ = _key_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _key_list;
			_tmp9_ = _key_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			key = (gchar*) _tmp10_;
			_tmp11_ = mb;
			_tmp11__length1 = mb_length1;
			_tmp12_ = key;
			_tmp13_ = index;
			index = _tmp13_ + 1;
			index = _tmp13_;
			_tmp14_ = index;
			fso_gsm_isms_storage_message ((FsoGsmISmsStorage*) self, _tmp12_, _tmp14_, &_tmp15_);
			_vala_array_add27 (&mb, &mb_length1, &_mb_size_, &_tmp15_);
			_g_free0 (key);
		}
		_g_object_unref0 (_key_list);
	}
	_tmp16_ = mb;
	_tmp16__length1 = mb_length1;
	if (result_length1) {
		*result_length1 = _tmp16__length1;
	}
	result = _tmp16_;
	return result;
}


static guint16 fso_gsm_sms_storage_real_lastReferenceNumber (FsoGsmISmsStorage* base) {
	FsoGsmSmsStorage * self;
	guint16 result = 0U;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* filename;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gint _tmp4_ = 0;
	guint16 _tmp5_;
	self = (FsoGsmSmsStorage*) base;
	_tmp0_ = self->priv->storagedir;
	_tmp1_ = g_build_filename (_tmp0_, "refnum", NULL);
	filename = _tmp1_;
	_tmp2_ = fso_framework_file_handling_readIfPresent (filename);
	_tmp3_ = _tmp2_;
	_tmp4_ = atoi (_tmp3_);
	_tmp5_ = (guint16) _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	_g_free0 (filename);
	return result;
}


static guint16 fso_gsm_sms_storage_real_increasingReferenceNumber (FsoGsmISmsStorage* base) {
	FsoGsmSmsStorage * self;
	guint16 result = 0U;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* filename;
	gchar* _tmp2_ = NULL;
	gchar* number;
	gint _tmp3_ = 0;
	guint16 num;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	self = (FsoGsmSmsStorage*) base;
	_tmp0_ = self->priv->storagedir;
	_tmp1_ = g_build_filename (_tmp0_, "refnum", NULL);
	filename = _tmp1_;
	_tmp2_ = fso_framework_file_handling_readIfPresent (filename);
	number = _tmp2_;
	_tmp3_ = atoi (number);
	num = (guint16) (((guint16) _tmp3_) + 1);
	_tmp4_ = g_strdup_printf ("%hu", num);
	_tmp5_ = _tmp4_;
	fso_framework_file_handling_write (_tmp5_, filename, TRUE);
	_g_free0 (_tmp5_);
	result = num;
	_g_free0 (number);
	_g_free0 (filename);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void fso_gsm_sms_storage_real_storeTransactionIndizesForSentMessage (FsoGsmISmsStorage* base, GeeArrayList* hexpdus) {
	FsoGsmSmsStorage * self;
	guint16 _tmp0_ = 0U;
	gchar* _tmp1_ = NULL;
	gchar* refnum;
	gchar* _tmp2_;
	gchar* name;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_ = NULL;
	gchar* dirname;
	const gchar* _tmp25_;
	gboolean _tmp26_ = FALSE;
	self = (FsoGsmSmsStorage*) base;
	g_return_if_fail (hexpdus != NULL);
	_tmp0_ = fso_gsm_isms_storage_lastReferenceNumber ((FsoGsmISmsStorage*) self);
	_tmp1_ = g_strdup_printf ("%hu", _tmp0_);
	refnum = _tmp1_;
	_tmp2_ = g_strdup ("");
	name = _tmp2_;
	{
		GeeArrayList* _tmp3_;
		GeeArrayList* _tmp4_;
		GeeArrayList* _hexpdu_list;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _hexpdu_size;
		gint _hexpdu_index;
		_tmp3_ = hexpdus;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_hexpdu_list = _tmp4_;
		_tmp5_ = _hexpdu_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_hexpdu_size = _tmp7_;
		_hexpdu_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			GeeArrayList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_ = NULL;
			WrapHexPdu* hexpdu;
			const gchar* _tmp14_;
			WrapHexPdu* _tmp15_;
			gint _tmp16_;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp8_ = _hexpdu_index;
			_hexpdu_index = _tmp8_ + 1;
			_tmp9_ = _hexpdu_index;
			_tmp10_ = _hexpdu_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _hexpdu_list;
			_tmp12_ = _hexpdu_index;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp12_);
			hexpdu = (WrapHexPdu*) _tmp13_;
			_tmp14_ = name;
			_tmp15_ = hexpdu;
			_tmp16_ = _tmp15_->transaction_index;
			_tmp17_ = g_strdup_printf ("%i", _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strconcat (":", _tmp18_, NULL);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strconcat (_tmp14_, _tmp20_, NULL);
			_g_free0 (name);
			name = _tmp21_;
			_g_free0 (_tmp20_);
			_g_free0 (_tmp18_);
			_wrap_hex_pdu_unref0 (hexpdu);
		}
		_g_object_unref0 (_hexpdu_list);
	}
	_tmp22_ = self->priv->storagedir;
	_tmp23_ = name;
	_tmp24_ = g_build_filename (_tmp22_, FSO_GSM_SMS_STORAGE_SENT_UNCONFIRMED, _tmp23_, NULL);
	dirname = _tmp24_;
	_tmp25_ = dirname;
	_tmp26_ = fso_framework_file_handling_isPresent (_tmp25_);
	if (!_tmp26_) {
		const gchar* _tmp27_;
		_tmp27_ = dirname;
		g_mkdir_with_parents (_tmp27_, FSO_GSM_SMS_STORAGE_DIRECTORY_PERMISSIONS);
	}
	{
		GeeArrayList* _tmp28_;
		GeeArrayList* _tmp29_;
		GeeArrayList* _hexpdu_list;
		GeeArrayList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gint _hexpdu_size;
		gint _hexpdu_index;
		_tmp28_ = hexpdus;
		_tmp29_ = _g_object_ref0 (_tmp28_);
		_hexpdu_list = _tmp29_;
		_tmp30_ = _hexpdu_list;
		_tmp31_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_hexpdu_size = _tmp32_;
		_hexpdu_index = -1;
		while (TRUE) {
			gint _tmp33_;
			gint _tmp34_;
			gint _tmp35_;
			GeeArrayList* _tmp36_;
			gint _tmp37_;
			gpointer _tmp38_ = NULL;
			WrapHexPdu* hexpdu;
			const gchar* _tmp39_;
			WrapHexPdu* _tmp40_;
			gint _tmp41_;
			gchar* _tmp42_ = NULL;
			gchar* _tmp43_;
			gchar* _tmp44_ = NULL;
			gchar* _tmp45_;
			gchar* filename;
			const gchar* _tmp46_;
			const gchar* _tmp47_;
			_tmp33_ = _hexpdu_index;
			_hexpdu_index = _tmp33_ + 1;
			_tmp34_ = _hexpdu_index;
			_tmp35_ = _hexpdu_size;
			if (!(_tmp34_ < _tmp35_)) {
				break;
			}
			_tmp36_ = _hexpdu_list;
			_tmp37_ = _hexpdu_index;
			_tmp38_ = gee_abstract_list_get ((GeeAbstractList*) _tmp36_, _tmp37_);
			hexpdu = (WrapHexPdu*) _tmp38_;
			_tmp39_ = dirname;
			_tmp40_ = hexpdu;
			_tmp41_ = _tmp40_->transaction_index;
			_tmp42_ = g_strdup_printf ("%i", _tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = g_build_filename (_tmp39_, _tmp43_, NULL);
			_tmp45_ = _tmp44_;
			_g_free0 (_tmp43_);
			filename = _tmp45_;
			_tmp46_ = refnum;
			_tmp47_ = filename;
			fso_framework_file_handling_write (_tmp46_, _tmp47_, TRUE);
			_g_free0 (filename);
			_wrap_hex_pdu_unref0 (hexpdu);
		}
		_g_object_unref0 (_hexpdu_list);
	}
	_g_free0 (dirname);
	_g_free0 (name);
	_g_free0 (refnum);
}


static gint fso_gsm_sms_storage_real_confirmReceivedMessage (FsoGsmISmsStorage* base, gint netreference) {
	FsoGsmSmsStorage * self;
	gint result = 0;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* dirname;
	const gchar* _tmp2_;
	gint _tmp3_ = 0;
	gchar** _tmp4_ = NULL;
	gchar** listUnconfirmed;
	gint listUnconfirmed_length1;
	gint _listUnconfirmed_size_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	FsoFrameworkLogger* _tmp30_;
	gint _tmp31_;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_;
	self = (FsoGsmSmsStorage*) base;
	_tmp0_ = self->priv->storagedir;
	_tmp1_ = g_build_filename (_tmp0_, FSO_GSM_SMS_STORAGE_SENT_UNCONFIRMED, NULL);
	dirname = _tmp1_;
	_tmp2_ = dirname;
	_tmp4_ = fso_framework_file_handling_listDirectory (_tmp2_, &_tmp3_);
	listUnconfirmed = _tmp4_;
	listUnconfirmed_length1 = _tmp3_;
	_listUnconfirmed_size_ = listUnconfirmed_length1;
	_tmp5_ = listUnconfirmed;
	_tmp5__length1 = listUnconfirmed_length1;
	{
		gchar** unconfirmed_collection = NULL;
		gint unconfirmed_collection_length1 = 0;
		gint _unconfirmed_collection_size_ = 0;
		gint unconfirmed_it = 0;
		unconfirmed_collection = _tmp5_;
		unconfirmed_collection_length1 = _tmp5__length1;
		for (unconfirmed_it = 0; unconfirmed_it < _tmp5__length1; unconfirmed_it = unconfirmed_it + 1) {
			gchar* _tmp6_;
			gchar* unconfirmed = NULL;
			_tmp6_ = g_strdup (unconfirmed_collection[unconfirmed_it]);
			unconfirmed = _tmp6_;
			{
				const gchar* _tmp7_;
				gchar** _tmp8_;
				gchar** _tmp9_ = NULL;
				gchar** components;
				gint components_length1;
				gint _components_size_;
				gchar** _tmp10_;
				gint _tmp10__length1;
				_tmp7_ = unconfirmed;
				_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, ":", 0);
				components = _tmp9_;
				components_length1 = _vala_array_length (_tmp8_);
				_components_size_ = components_length1;
				_tmp10_ = components;
				_tmp10__length1 = components_length1;
				{
					gchar** component_collection = NULL;
					gint component_collection_length1 = 0;
					gint _component_collection_size_ = 0;
					gint component_it = 0;
					component_collection = _tmp10_;
					component_collection_length1 = _tmp10__length1;
					for (component_it = 0; component_it < _tmp10__length1; component_it = component_it + 1) {
						gchar* _tmp11_;
						gchar* component = NULL;
						_tmp11_ = g_strdup (component_collection[component_it]);
						component = _tmp11_;
						{
							const gchar* _tmp12_;
							gint _tmp13_ = 0;
							gint _tmp14_;
							_tmp12_ = component;
							_tmp13_ = atoi (_tmp12_);
							_tmp14_ = netreference;
							if (_tmp13_ == _tmp14_) {
								const gchar* _tmp15_;
								const gchar* _tmp16_;
								gchar* _tmp17_ = NULL;
								gchar* filedirname;
								const gchar* _tmp18_;
								const gchar* _tmp19_;
								gchar* _tmp20_ = NULL;
								gchar* filename;
								const gchar* _tmp21_;
								gchar* _tmp22_ = NULL;
								gchar* _tmp23_;
								gint _tmp24_ = 0;
								gint _tmp25_;
								gint transaction_index;
								const gchar* _tmp26_;
								const gchar* _tmp27_;
								gint _tmp28_ = 0;
								gint ok;
								gint _tmp29_;
								_tmp15_ = dirname;
								_tmp16_ = unconfirmed;
								_tmp17_ = g_build_filename (_tmp15_, _tmp16_, NULL);
								filedirname = _tmp17_;
								_tmp18_ = filedirname;
								_tmp19_ = component;
								_tmp20_ = g_build_filename (_tmp18_, _tmp19_, NULL);
								filename = _tmp20_;
								_tmp21_ = filename;
								_tmp22_ = fso_framework_file_handling_read (_tmp21_);
								_tmp23_ = _tmp22_;
								_tmp24_ = atoi (_tmp23_);
								_tmp25_ = _tmp24_;
								_g_free0 (_tmp23_);
								transaction_index = _tmp25_;
								_tmp26_ = filename;
								g_unlink (_tmp26_);
								_tmp27_ = filedirname;
								_tmp28_ = g_rmdir (_tmp27_);
								ok = _tmp28_;
								_tmp29_ = ok;
								if (_tmp29_ != 0) {
									result = -1;
									_g_free0 (filename);
									_g_free0 (filedirname);
									_g_free0 (component);
									components = (_vala_array_free (components, components_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (unconfirmed);
									listUnconfirmed = (_vala_array_free (listUnconfirmed, listUnconfirmed_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (dirname);
									return result;
								} else {
									result = transaction_index;
									_g_free0 (filename);
									_g_free0 (filedirname);
									_g_free0 (component);
									components = (_vala_array_free (components, components_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (unconfirmed);
									listUnconfirmed = (_vala_array_free (listUnconfirmed, listUnconfirmed_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (dirname);
									return result;
								}
								_g_free0 (filename);
								_g_free0 (filedirname);
							}
							_g_free0 (component);
						}
					}
				}
				components = (_vala_array_free (components, components_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (unconfirmed);
			}
		}
	}
	_tmp30_ = ((FsoFrameworkAbstractObject*) self)->logger;
	_tmp31_ = netreference;
	_tmp32_ = g_strdup_printf ("%i", _tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_strconcat ("Did not find unconfirmed SMS for reference ", _tmp33_, NULL);
	_tmp35_ = _tmp34_;
	fso_framework_logger_warning (_tmp30_, _tmp35_);
	_g_free0 (_tmp35_);
	_g_free0 (_tmp33_);
	result = -1;
	listUnconfirmed = (_vala_array_free (listUnconfirmed, listUnconfirmed_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (dirname);
	return result;
}


static void fso_gsm_sms_storage_class_init (FsoGsmSmsStorageClass * klass) {
	gchar* _tmp0_;
	fso_gsm_sms_storage_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FsoGsmSmsStoragePrivate));
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = fso_gsm_sms_storage_real_repr;
	G_OBJECT_CLASS (klass)->finalize = fso_gsm_sms_storage_finalize;
	_tmp0_ = g_strdup (FSO_GSM_SMS_STORAGE_DEFAULT_STORAGE_DIR);
	_g_free0 (fso_gsm_sms_storage_storagedirprefix);
	fso_gsm_sms_storage_storagedirprefix = _tmp0_;
}


static void fso_gsm_sms_storage_fso_gsm_isms_storage_interface_init (FsoGsmISmsStorageIface * iface) {
	fso_gsm_sms_storage_fso_gsm_isms_storage_parent_iface = g_type_interface_peek_parent (iface);
	iface->clean = (void (*)(FsoGsmISmsStorage*)) fso_gsm_sms_storage_real_clean;
	iface->addSms = (gint (*)(FsoGsmISmsStorage*, struct sms*)) fso_gsm_sms_storage_real_addSms;
	iface->keys = (GeeArrayList* (*)(FsoGsmISmsStorage*)) fso_gsm_sms_storage_real_keys;
	iface->message = (void (*)(FsoGsmISmsStorage*, const gchar*, gint, FreeSmartphoneGSMSIMMessage*)) fso_gsm_sms_storage_real_message;
	iface->messagebook = (FreeSmartphoneGSMSIMMessage* (*)(FsoGsmISmsStorage*, int*)) fso_gsm_sms_storage_real_messagebook;
	iface->lastReferenceNumber = (guint16 (*)(FsoGsmISmsStorage*)) fso_gsm_sms_storage_real_lastReferenceNumber;
	iface->increasingReferenceNumber = (guint16 (*)(FsoGsmISmsStorage*)) fso_gsm_sms_storage_real_increasingReferenceNumber;
	iface->storeTransactionIndizesForSentMessage = (void (*)(FsoGsmISmsStorage*, GeeArrayList*)) fso_gsm_sms_storage_real_storeTransactionIndizesForSentMessage;
	iface->confirmReceivedMessage = (gint (*)(FsoGsmISmsStorage*, gint)) fso_gsm_sms_storage_real_confirmReceivedMessage;
}


static void fso_gsm_sms_storage_instance_init (FsoGsmSmsStorage * self) {
	self->priv = FSO_GSM_SMS_STORAGE_GET_PRIVATE (self);
}


static void fso_gsm_sms_storage_finalize (GObject* obj) {
	FsoGsmSmsStorage * self;
	self = FSO_GSM_SMS_STORAGE (obj);
	_g_free0 (self->priv->imsi);
	_g_free0 (self->priv->storagedir);
	G_OBJECT_CLASS (fso_gsm_sms_storage_parent_class)->finalize (obj);
}


/**
     * @class SmsStorage
     *
     * A high level persistent SMS Storage abstraction.
     */
GType fso_gsm_sms_storage_get_type (void) {
	static volatile gsize fso_gsm_sms_storage_type_id__volatile = 0;
	if (g_once_init_enter (&fso_gsm_sms_storage_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoGsmSmsStorageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_gsm_sms_storage_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoGsmSmsStorage), 0, (GInstanceInitFunc) fso_gsm_sms_storage_instance_init, NULL };
		static const GInterfaceInfo fso_gsm_isms_storage_info = { (GInterfaceInitFunc) fso_gsm_sms_storage_fso_gsm_isms_storage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType fso_gsm_sms_storage_type_id;
		fso_gsm_sms_storage_type_id = g_type_register_static (FSO_FRAMEWORK_TYPE_ABSTRACT_OBJECT, "FsoGsmSmsStorage", &g_define_type_info, 0);
		g_type_add_interface_static (fso_gsm_sms_storage_type_id, FSO_GSM_TYPE_ISMS_STORAGE, &fso_gsm_isms_storage_info);
		g_once_init_leave (&fso_gsm_sms_storage_type_id__volatile, fso_gsm_sms_storage_type_id);
	}
	return fso_gsm_sms_storage_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



