/* mbpi.c generated by valac 0.14.2, the Vala compiler
 * generated from mbpi.vala, do not modify */

/**
 * Copyright (C) 2009-2011 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <gee.h>
#include <fsobasics.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <gobject/gvaluecollector.h>


#define FSO_DATA_MBPI_TYPE_COUNTRY (fso_data_mbpi_country_get_type ())
#define FSO_DATA_MBPI_COUNTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_DATA_MBPI_TYPE_COUNTRY, FsoDataMBPICountry))
#define FSO_DATA_MBPI_COUNTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_DATA_MBPI_TYPE_COUNTRY, FsoDataMBPICountryClass))
#define FSO_DATA_MBPI_IS_COUNTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_DATA_MBPI_TYPE_COUNTRY))
#define FSO_DATA_MBPI_IS_COUNTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_DATA_MBPI_TYPE_COUNTRY))
#define FSO_DATA_MBPI_COUNTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_DATA_MBPI_TYPE_COUNTRY, FsoDataMBPICountryClass))

typedef struct _FsoDataMBPICountry FsoDataMBPICountry;
typedef struct _FsoDataMBPICountryClass FsoDataMBPICountryClass;
typedef struct _FsoDataMBPICountryPrivate FsoDataMBPICountryPrivate;

#define FSO_DATA_MBPI_TYPE_PROVIDER (fso_data_mbpi_provider_get_type ())
#define FSO_DATA_MBPI_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_DATA_MBPI_TYPE_PROVIDER, FsoDataMBPIProvider))
#define FSO_DATA_MBPI_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_DATA_MBPI_TYPE_PROVIDER, FsoDataMBPIProviderClass))
#define FSO_DATA_MBPI_IS_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_DATA_MBPI_TYPE_PROVIDER))
#define FSO_DATA_MBPI_IS_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_DATA_MBPI_TYPE_PROVIDER))
#define FSO_DATA_MBPI_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_DATA_MBPI_TYPE_PROVIDER, FsoDataMBPIProviderClass))

typedef struct _FsoDataMBPIProvider FsoDataMBPIProvider;
typedef struct _FsoDataMBPIProviderClass FsoDataMBPIProviderClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FsoDataMBPIParamSpecCountry FsoDataMBPIParamSpecCountry;
typedef struct _FsoDataMBPIProviderPrivate FsoDataMBPIProviderPrivate;

#define FSO_DATA_MBPI_TYPE_ACCESS_POINT (fso_data_mbpi_access_point_get_type ())
#define FSO_DATA_MBPI_ACCESS_POINT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_DATA_MBPI_TYPE_ACCESS_POINT, FsoDataMBPIAccessPoint))
#define FSO_DATA_MBPI_ACCESS_POINT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_DATA_MBPI_TYPE_ACCESS_POINT, FsoDataMBPIAccessPointClass))
#define FSO_DATA_MBPI_IS_ACCESS_POINT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_DATA_MBPI_TYPE_ACCESS_POINT))
#define FSO_DATA_MBPI_IS_ACCESS_POINT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_DATA_MBPI_TYPE_ACCESS_POINT))
#define FSO_DATA_MBPI_ACCESS_POINT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_DATA_MBPI_TYPE_ACCESS_POINT, FsoDataMBPIAccessPointClass))

typedef struct _FsoDataMBPIAccessPoint FsoDataMBPIAccessPoint;
typedef struct _FsoDataMBPIAccessPointClass FsoDataMBPIAccessPointClass;
typedef struct _FsoDataMBPIParamSpecProvider FsoDataMBPIParamSpecProvider;
typedef struct _FsoDataMBPIAccessPointPrivate FsoDataMBPIAccessPointPrivate;
typedef struct _FsoDataMBPIParamSpecAccessPoint FsoDataMBPIParamSpecAccessPoint;

#define FSO_DATA_MBPI_TYPE_DATABASE (fso_data_mbpi_database_get_type ())
#define FSO_DATA_MBPI_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_DATA_MBPI_TYPE_DATABASE, FsoDataMBPIDatabase))
#define FSO_DATA_MBPI_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_DATA_MBPI_TYPE_DATABASE, FsoDataMBPIDatabaseClass))
#define FSO_DATA_MBPI_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_DATA_MBPI_TYPE_DATABASE))
#define FSO_DATA_MBPI_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_DATA_MBPI_TYPE_DATABASE))
#define FSO_DATA_MBPI_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_DATA_MBPI_TYPE_DATABASE, FsoDataMBPIDatabaseClass))

typedef struct _FsoDataMBPIDatabase FsoDataMBPIDatabase;
typedef struct _FsoDataMBPIDatabaseClass FsoDataMBPIDatabaseClass;
typedef struct _FsoDataMBPIDatabasePrivate FsoDataMBPIDatabasePrivate;
#define _fso_data_mbpi_country_unref0(var) ((var == NULL) ? NULL : (var = (fso_data_mbpi_country_unref (var), NULL)))
#define _fso_data_mbpi_provider_unref0(var) ((var == NULL) ? NULL : (var = (fso_data_mbpi_provider_unref (var), NULL)))
#define _fso_data_mbpi_access_point_unref0(var) ((var == NULL) ? NULL : (var = (fso_data_mbpi_access_point_unref (var), NULL)))

struct _FsoDataMBPICountry {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FsoDataMBPICountryPrivate * priv;
	gchar* code;
	gchar* name;
	gchar* dialprefix;
	GeeHashMap* providers;
	GeeHashMap* timezones;
};

struct _FsoDataMBPICountryClass {
	GTypeClass parent_class;
	void (*finalize) (FsoDataMBPICountry *self);
};

struct _FsoDataMBPIParamSpecCountry {
	GParamSpec parent_instance;
};

struct _FsoDataMBPIProvider {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FsoDataMBPIProviderPrivate * priv;
	gchar* name;
	GeeArrayList* codes;
	GeeHashMap* gsm;
	GeeHashMap* cdma;
};

struct _FsoDataMBPIProviderClass {
	GTypeClass parent_class;
	void (*finalize) (FsoDataMBPIProvider *self);
};

struct _FsoDataMBPIParamSpecProvider {
	GParamSpec parent_instance;
};

struct _FsoDataMBPIAccessPoint {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FsoDataMBPIAccessPointPrivate * priv;
	gchar* description;
	gchar* name;
	gchar* user;
	gchar* password;
	GeeArrayList* dns;
};

struct _FsoDataMBPIAccessPointClass {
	GTypeClass parent_class;
	void (*finalize) (FsoDataMBPIAccessPoint *self);
};

struct _FsoDataMBPIParamSpecAccessPoint {
	GParamSpec parent_instance;
};

struct _FsoDataMBPIDatabase {
	FsoFrameworkAbstractObject parent_instance;
	FsoDataMBPIDatabasePrivate * priv;
	GeeHashMap* countries;
};

struct _FsoDataMBPIDatabaseClass {
	FsoFrameworkAbstractObjectClass parent_class;
};

struct _FsoDataMBPIDatabasePrivate {
	FsoDataMBPICountry* country;
	FsoDataMBPIProvider* provider;
	FsoDataMBPIAccessPoint* accesspoint;
	gboolean gsm;
	gint depth;
};


static gpointer fso_data_mbpi_country_parent_class = NULL;
static gpointer fso_data_mbpi_provider_parent_class = NULL;
static gpointer fso_data_mbpi_access_point_parent_class = NULL;
static gpointer fso_data_mbpi_database_parent_class = NULL;
static FsoDataMBPIDatabase* fso_data_mbpi_database__instance;
static FsoDataMBPIDatabase* fso_data_mbpi_database__instance = NULL;

#define FSO_DATA_MBPI_ISO_3361_DATABASE PACKAGE_DATADIR "/iso3361+dialcode.txt"
#define FSO_DATA_MBPI_ISO_ZONE_DATABASE PACKAGE_DATADIR "/zone.tab"
gpointer fso_data_mbpi_country_ref (gpointer instance);
void fso_data_mbpi_country_unref (gpointer instance);
GParamSpec* fso_data_mbpi_param_spec_country (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void fso_data_mbpi_value_set_country (GValue* value, gpointer v_object);
void fso_data_mbpi_value_take_country (GValue* value, gpointer v_object);
gpointer fso_data_mbpi_value_get_country (const GValue* value);
GType fso_data_mbpi_country_get_type (void) G_GNUC_CONST;
gpointer fso_data_mbpi_provider_ref (gpointer instance);
void fso_data_mbpi_provider_unref (gpointer instance);
GParamSpec* fso_data_mbpi_param_spec_provider (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void fso_data_mbpi_value_set_provider (GValue* value, gpointer v_object);
void fso_data_mbpi_value_take_provider (GValue* value, gpointer v_object);
gpointer fso_data_mbpi_value_get_provider (const GValue* value);
GType fso_data_mbpi_provider_get_type (void) G_GNUC_CONST;
enum  {
	FSO_DATA_MBPI_COUNTRY_DUMMY_PROPERTY
};
FsoDataMBPICountry* fso_data_mbpi_country_new (void);
FsoDataMBPICountry* fso_data_mbpi_country_construct (GType object_type);
static void fso_data_mbpi_country_finalize (FsoDataMBPICountry* obj);
gpointer fso_data_mbpi_access_point_ref (gpointer instance);
void fso_data_mbpi_access_point_unref (gpointer instance);
GParamSpec* fso_data_mbpi_param_spec_access_point (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void fso_data_mbpi_value_set_access_point (GValue* value, gpointer v_object);
void fso_data_mbpi_value_take_access_point (GValue* value, gpointer v_object);
gpointer fso_data_mbpi_value_get_access_point (const GValue* value);
GType fso_data_mbpi_access_point_get_type (void) G_GNUC_CONST;
enum  {
	FSO_DATA_MBPI_PROVIDER_DUMMY_PROPERTY
};
FsoDataMBPIProvider* fso_data_mbpi_provider_new (void);
FsoDataMBPIProvider* fso_data_mbpi_provider_construct (GType object_type);
static void fso_data_mbpi_provider_finalize (FsoDataMBPIProvider* obj);
enum  {
	FSO_DATA_MBPI_ACCESS_POINT_DUMMY_PROPERTY
};
FsoDataMBPIAccessPoint* fso_data_mbpi_access_point_new (void);
FsoDataMBPIAccessPoint* fso_data_mbpi_access_point_construct (GType object_type);
static void fso_data_mbpi_access_point_finalize (FsoDataMBPIAccessPoint* obj);
GType fso_data_mbpi_database_get_type (void) G_GNUC_CONST;
#define FSO_DATA_MBPI_DATABASE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FSO_DATA_MBPI_TYPE_DATABASE, FsoDataMBPIDatabasePrivate))
enum  {
	FSO_DATA_MBPI_DATABASE_DUMMY_PROPERTY
};
static FsoDataMBPIDatabase* fso_data_mbpi_database_new (void);
static FsoDataMBPIDatabase* fso_data_mbpi_database_construct (GType object_type);
static void fso_data_mbpi_database_loadMbpi (FsoDataMBPIDatabase* self);
static void fso_data_mbpi_database_loadIso3361 (FsoDataMBPIDatabase* self);
static void fso_data_mbpi_database_loadZoneTab (FsoDataMBPIDatabase* self);
static gchar* fso_data_mbpi_database_real_repr (FsoFrameworkAbstractObject* base);
static void fso_data_mbpi_database_parseNode (FsoDataMBPIDatabase* self, xmlNode* node);
static void fso_data_mbpi_database_handleChildren (FsoDataMBPIDatabase* self, xmlNode* node);
FsoDataMBPIDatabase* fso_data_mbpi_database_instance (void);
GeeMap* fso_data_mbpi_database_allCountries (FsoDataMBPIDatabase* self);
GeeMap* fso_data_mbpi_database_providersForCountry (FsoDataMBPIDatabase* self, const gchar* code);
FsoDataMBPICountry* fso_data_mbpi_database_countryForMccMnc (FsoDataMBPIDatabase* self, const gchar* mccmnc);
GeeMap* fso_data_mbpi_database_accessPointsForMccMnc (FsoDataMBPIDatabase* self, const gchar* mccmnc);
static void fso_data_mbpi_database_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


FsoDataMBPICountry* fso_data_mbpi_country_construct (GType object_type) {
	FsoDataMBPICountry* self = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	self = (FsoDataMBPICountry*) g_type_create_instance (object_type);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FSO_DATA_MBPI_TYPE_PROVIDER, (GBoxedCopyFunc) fso_data_mbpi_provider_ref, fso_data_mbpi_provider_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->providers);
	self->providers = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->timezones);
	self->timezones = _tmp1_;
	return self;
}


FsoDataMBPICountry* fso_data_mbpi_country_new (void) {
	return fso_data_mbpi_country_construct (FSO_DATA_MBPI_TYPE_COUNTRY);
}


static void fso_data_mbpi_value_country_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void fso_data_mbpi_value_country_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		fso_data_mbpi_country_unref (value->data[0].v_pointer);
	}
}


static void fso_data_mbpi_value_country_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = fso_data_mbpi_country_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer fso_data_mbpi_value_country_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* fso_data_mbpi_value_country_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		FsoDataMBPICountry* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = fso_data_mbpi_country_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* fso_data_mbpi_value_country_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	FsoDataMBPICountry** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = fso_data_mbpi_country_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* fso_data_mbpi_param_spec_country (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	FsoDataMBPIParamSpecCountry* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FSO_DATA_MBPI_TYPE_COUNTRY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer fso_data_mbpi_value_get_country (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_DATA_MBPI_TYPE_COUNTRY), NULL);
	return value->data[0].v_pointer;
}


void fso_data_mbpi_value_set_country (GValue* value, gpointer v_object) {
	FsoDataMBPICountry* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_DATA_MBPI_TYPE_COUNTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FSO_DATA_MBPI_TYPE_COUNTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		fso_data_mbpi_country_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fso_data_mbpi_country_unref (old);
	}
}


void fso_data_mbpi_value_take_country (GValue* value, gpointer v_object) {
	FsoDataMBPICountry* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_DATA_MBPI_TYPE_COUNTRY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FSO_DATA_MBPI_TYPE_COUNTRY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fso_data_mbpi_country_unref (old);
	}
}


static void fso_data_mbpi_country_class_init (FsoDataMBPICountryClass * klass) {
	fso_data_mbpi_country_parent_class = g_type_class_peek_parent (klass);
	FSO_DATA_MBPI_COUNTRY_CLASS (klass)->finalize = fso_data_mbpi_country_finalize;
}


static void fso_data_mbpi_country_instance_init (FsoDataMBPICountry * self) {
	self->ref_count = 1;
}


static void fso_data_mbpi_country_finalize (FsoDataMBPICountry* obj) {
	FsoDataMBPICountry * self;
	self = FSO_DATA_MBPI_COUNTRY (obj);
	_g_free0 (self->code);
	_g_free0 (self->name);
	_g_free0 (self->dialprefix);
	_g_object_unref0 (self->providers);
	_g_object_unref0 (self->timezones);
}


GType fso_data_mbpi_country_get_type (void) {
	static volatile gsize fso_data_mbpi_country_type_id__volatile = 0;
	if (g_once_init_enter (&fso_data_mbpi_country_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { fso_data_mbpi_value_country_init, fso_data_mbpi_value_country_free_value, fso_data_mbpi_value_country_copy_value, fso_data_mbpi_value_country_peek_pointer, "p", fso_data_mbpi_value_country_collect_value, "p", fso_data_mbpi_value_country_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (FsoDataMBPICountryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_data_mbpi_country_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoDataMBPICountry), 0, (GInstanceInitFunc) fso_data_mbpi_country_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType fso_data_mbpi_country_type_id;
		fso_data_mbpi_country_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FsoDataMBPICountry", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&fso_data_mbpi_country_type_id__volatile, fso_data_mbpi_country_type_id);
	}
	return fso_data_mbpi_country_type_id__volatile;
}


gpointer fso_data_mbpi_country_ref (gpointer instance) {
	FsoDataMBPICountry* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void fso_data_mbpi_country_unref (gpointer instance) {
	FsoDataMBPICountry* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FSO_DATA_MBPI_COUNTRY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


FsoDataMBPIProvider* fso_data_mbpi_provider_construct (GType object_type) {
	FsoDataMBPIProvider* self = NULL;
	GeeArrayList* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	self = (FsoDataMBPIProvider*) g_type_create_instance (object_type);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	_g_object_unref0 (self->codes);
	self->codes = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FSO_DATA_MBPI_TYPE_ACCESS_POINT, (GBoxedCopyFunc) fso_data_mbpi_access_point_ref, fso_data_mbpi_access_point_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->gsm);
	self->gsm = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FSO_DATA_MBPI_TYPE_ACCESS_POINT, (GBoxedCopyFunc) fso_data_mbpi_access_point_ref, fso_data_mbpi_access_point_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->cdma);
	self->cdma = _tmp2_;
	return self;
}


FsoDataMBPIProvider* fso_data_mbpi_provider_new (void) {
	return fso_data_mbpi_provider_construct (FSO_DATA_MBPI_TYPE_PROVIDER);
}


static void fso_data_mbpi_value_provider_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void fso_data_mbpi_value_provider_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		fso_data_mbpi_provider_unref (value->data[0].v_pointer);
	}
}


static void fso_data_mbpi_value_provider_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = fso_data_mbpi_provider_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer fso_data_mbpi_value_provider_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* fso_data_mbpi_value_provider_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		FsoDataMBPIProvider* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = fso_data_mbpi_provider_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* fso_data_mbpi_value_provider_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	FsoDataMBPIProvider** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = fso_data_mbpi_provider_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* fso_data_mbpi_param_spec_provider (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	FsoDataMBPIParamSpecProvider* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FSO_DATA_MBPI_TYPE_PROVIDER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer fso_data_mbpi_value_get_provider (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_DATA_MBPI_TYPE_PROVIDER), NULL);
	return value->data[0].v_pointer;
}


void fso_data_mbpi_value_set_provider (GValue* value, gpointer v_object) {
	FsoDataMBPIProvider* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_DATA_MBPI_TYPE_PROVIDER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FSO_DATA_MBPI_TYPE_PROVIDER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		fso_data_mbpi_provider_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fso_data_mbpi_provider_unref (old);
	}
}


void fso_data_mbpi_value_take_provider (GValue* value, gpointer v_object) {
	FsoDataMBPIProvider* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_DATA_MBPI_TYPE_PROVIDER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FSO_DATA_MBPI_TYPE_PROVIDER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fso_data_mbpi_provider_unref (old);
	}
}


static void fso_data_mbpi_provider_class_init (FsoDataMBPIProviderClass * klass) {
	fso_data_mbpi_provider_parent_class = g_type_class_peek_parent (klass);
	FSO_DATA_MBPI_PROVIDER_CLASS (klass)->finalize = fso_data_mbpi_provider_finalize;
}


static void fso_data_mbpi_provider_instance_init (FsoDataMBPIProvider * self) {
	self->ref_count = 1;
}


static void fso_data_mbpi_provider_finalize (FsoDataMBPIProvider* obj) {
	FsoDataMBPIProvider * self;
	self = FSO_DATA_MBPI_PROVIDER (obj);
	_g_free0 (self->name);
	_g_object_unref0 (self->codes);
	_g_object_unref0 (self->gsm);
	_g_object_unref0 (self->cdma);
}


GType fso_data_mbpi_provider_get_type (void) {
	static volatile gsize fso_data_mbpi_provider_type_id__volatile = 0;
	if (g_once_init_enter (&fso_data_mbpi_provider_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { fso_data_mbpi_value_provider_init, fso_data_mbpi_value_provider_free_value, fso_data_mbpi_value_provider_copy_value, fso_data_mbpi_value_provider_peek_pointer, "p", fso_data_mbpi_value_provider_collect_value, "p", fso_data_mbpi_value_provider_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (FsoDataMBPIProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_data_mbpi_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoDataMBPIProvider), 0, (GInstanceInitFunc) fso_data_mbpi_provider_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType fso_data_mbpi_provider_type_id;
		fso_data_mbpi_provider_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FsoDataMBPIProvider", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&fso_data_mbpi_provider_type_id__volatile, fso_data_mbpi_provider_type_id);
	}
	return fso_data_mbpi_provider_type_id__volatile;
}


gpointer fso_data_mbpi_provider_ref (gpointer instance) {
	FsoDataMBPIProvider* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void fso_data_mbpi_provider_unref (gpointer instance) {
	FsoDataMBPIProvider* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FSO_DATA_MBPI_PROVIDER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


FsoDataMBPIAccessPoint* fso_data_mbpi_access_point_construct (GType object_type) {
	FsoDataMBPIAccessPoint* self = NULL;
	GeeArrayList* _tmp0_;
	self = (FsoDataMBPIAccessPoint*) g_type_create_instance (object_type);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	_g_object_unref0 (self->dns);
	self->dns = _tmp0_;
	return self;
}


FsoDataMBPIAccessPoint* fso_data_mbpi_access_point_new (void) {
	return fso_data_mbpi_access_point_construct (FSO_DATA_MBPI_TYPE_ACCESS_POINT);
}


static void fso_data_mbpi_value_access_point_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void fso_data_mbpi_value_access_point_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		fso_data_mbpi_access_point_unref (value->data[0].v_pointer);
	}
}


static void fso_data_mbpi_value_access_point_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = fso_data_mbpi_access_point_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer fso_data_mbpi_value_access_point_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* fso_data_mbpi_value_access_point_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		FsoDataMBPIAccessPoint* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = fso_data_mbpi_access_point_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* fso_data_mbpi_value_access_point_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	FsoDataMBPIAccessPoint** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = fso_data_mbpi_access_point_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* fso_data_mbpi_param_spec_access_point (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	FsoDataMBPIParamSpecAccessPoint* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FSO_DATA_MBPI_TYPE_ACCESS_POINT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer fso_data_mbpi_value_get_access_point (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_DATA_MBPI_TYPE_ACCESS_POINT), NULL);
	return value->data[0].v_pointer;
}


void fso_data_mbpi_value_set_access_point (GValue* value, gpointer v_object) {
	FsoDataMBPIAccessPoint* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_DATA_MBPI_TYPE_ACCESS_POINT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FSO_DATA_MBPI_TYPE_ACCESS_POINT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		fso_data_mbpi_access_point_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fso_data_mbpi_access_point_unref (old);
	}
}


void fso_data_mbpi_value_take_access_point (GValue* value, gpointer v_object) {
	FsoDataMBPIAccessPoint* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_DATA_MBPI_TYPE_ACCESS_POINT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FSO_DATA_MBPI_TYPE_ACCESS_POINT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fso_data_mbpi_access_point_unref (old);
	}
}


static void fso_data_mbpi_access_point_class_init (FsoDataMBPIAccessPointClass * klass) {
	fso_data_mbpi_access_point_parent_class = g_type_class_peek_parent (klass);
	FSO_DATA_MBPI_ACCESS_POINT_CLASS (klass)->finalize = fso_data_mbpi_access_point_finalize;
}


static void fso_data_mbpi_access_point_instance_init (FsoDataMBPIAccessPoint * self) {
	self->ref_count = 1;
}


static void fso_data_mbpi_access_point_finalize (FsoDataMBPIAccessPoint* obj) {
	FsoDataMBPIAccessPoint * self;
	self = FSO_DATA_MBPI_ACCESS_POINT (obj);
	_g_free0 (self->description);
	_g_free0 (self->name);
	_g_free0 (self->user);
	_g_free0 (self->password);
	_g_object_unref0 (self->dns);
}


GType fso_data_mbpi_access_point_get_type (void) {
	static volatile gsize fso_data_mbpi_access_point_type_id__volatile = 0;
	if (g_once_init_enter (&fso_data_mbpi_access_point_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { fso_data_mbpi_value_access_point_init, fso_data_mbpi_value_access_point_free_value, fso_data_mbpi_value_access_point_copy_value, fso_data_mbpi_value_access_point_peek_pointer, "p", fso_data_mbpi_value_access_point_collect_value, "p", fso_data_mbpi_value_access_point_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (FsoDataMBPIAccessPointClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_data_mbpi_access_point_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoDataMBPIAccessPoint), 0, (GInstanceInitFunc) fso_data_mbpi_access_point_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType fso_data_mbpi_access_point_type_id;
		fso_data_mbpi_access_point_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FsoDataMBPIAccessPoint", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&fso_data_mbpi_access_point_type_id__volatile, fso_data_mbpi_access_point_type_id);
	}
	return fso_data_mbpi_access_point_type_id__volatile;
}


gpointer fso_data_mbpi_access_point_ref (gpointer instance) {
	FsoDataMBPIAccessPoint* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void fso_data_mbpi_access_point_unref (gpointer instance) {
	FsoDataMBPIAccessPoint* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FSO_DATA_MBPI_ACCESS_POINT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static FsoDataMBPIDatabase* fso_data_mbpi_database_construct (GType object_type) {
	FsoDataMBPIDatabase * self = NULL;
	self = (FsoDataMBPIDatabase*) fso_framework_abstract_object_construct (object_type);
	fso_data_mbpi_database_loadMbpi (self);
	fso_data_mbpi_database_loadIso3361 (self);
	fso_data_mbpi_database_loadZoneTab (self);
	return self;
}


static FsoDataMBPIDatabase* fso_data_mbpi_database_new (void) {
	return fso_data_mbpi_database_construct (FSO_DATA_MBPI_TYPE_DATABASE);
}


static gchar* fso_data_mbpi_database_real_repr (FsoFrameworkAbstractObject* base) {
	FsoDataMBPIDatabase * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	self = (FsoDataMBPIDatabase*) base;
	_tmp1_ = self->countries;
	if (_tmp1_ == NULL) {
		_tmp0_ = "<null>";
	} else {
		_tmp0_ = "<loaded>";
	}
	_tmp2_ = _tmp0_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}


static void fso_data_mbpi_database_loadMbpi (FsoDataMBPIDatabase* self) {
	GeeHashMap* _tmp0_;
	xmlDoc* _tmp1_ = NULL;
	xmlDoc* doc;
	xmlDoc* _tmp2_;
	xmlDoc* _tmp4_;
	xmlNode* _tmp5_ = NULL;
	xmlNode* root;
	xmlNode* _tmp6_;
	xmlNode* _tmp9_;
	xmlDoc* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FSO_DATA_MBPI_TYPE_COUNTRY, (GBoxedCopyFunc) fso_data_mbpi_country_ref, fso_data_mbpi_country_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->countries);
	self->countries = _tmp0_;
	_tmp1_ = xmlParseFile (MBPI_DATABASE_PATH);
	doc = _tmp1_;
	_tmp2_ = doc;
	if (_tmp2_ == NULL) {
		FsoFrameworkLogger* _tmp3_;
		_tmp3_ = ((FsoFrameworkAbstractObject*) self)->logger;
		fso_framework_logger_warning (_tmp3_, "Could not load mobile broadband provider info from $(Config.MBPI_DATAB" \
"ASE)");
		return;
	}
	_tmp4_ = doc;
	_tmp5_ = xmlDocGetRootElement (_tmp4_);
	root = _tmp5_;
	_tmp6_ = root;
	if (_tmp6_ == NULL) {
		xmlDoc* _tmp7_;
		FsoFrameworkLogger* _tmp8_;
		_tmp7_ = doc;
		xmlFreeDoc (_tmp7_);
		_tmp8_ = ((FsoFrameworkAbstractObject*) self)->logger;
		fso_framework_logger_warning (_tmp8_, "Could not parse mobile broadband provider file");
		return;
	}
	_tmp9_ = root;
	fso_data_mbpi_database_parseNode (self, _tmp9_);
	_tmp10_ = doc;
	xmlFreeDoc (_tmp10_);
}


static void fso_data_mbpi_database_parseNode (FsoDataMBPIDatabase* self, xmlNode* node) {
	gint _tmp0_;
	xmlNode* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* name;
	xmlNode* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* content;
	GeeHashMap* _tmp6_;
	GeeHashMap* props;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GQuark _tmp23_ = 0U;
	static GQuark _tmp22_label0 = 0;
	static GQuark _tmp22_label1 = 0;
	static GQuark _tmp22_label2 = 0;
	static GQuark _tmp22_label3 = 0;
	static GQuark _tmp22_label4 = 0;
	static GQuark _tmp22_label5 = 0;
	static GQuark _tmp22_label6 = 0;
	static GQuark _tmp22_label7 = 0;
	static GQuark _tmp22_label8 = 0;
	static GQuark _tmp22_label9 = 0;
	static GQuark _tmp22_label10 = 0;
	gint _tmp78_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->depth;
	self->priv->depth = _tmp0_ + 1;
	_tmp1_ = node;
	_tmp2_ = _tmp1_->name;
	_tmp3_ = g_strdup (_tmp2_);
	name = _tmp3_;
	_tmp4_ = node;
	_tmp5_ = xmlNodeGetContent (_tmp4_);
	content = _tmp5_;
	_tmp6_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	props = _tmp6_;
	{
		xmlNode* _tmp7_;
		xmlAttr* _tmp8_;
		xmlAttr* prop;
		_tmp7_ = node;
		_tmp8_ = _tmp7_->properties;
		prop = _tmp8_;
		{
			gboolean _tmp9_;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp10_;
				xmlAttr* _tmp13_;
				GeeHashMap* _tmp14_;
				xmlAttr* _tmp15_;
				const gchar* _tmp16_;
				xmlAttr* _tmp17_;
				xmlNode* _tmp18_;
				const gchar* _tmp19_;
				_tmp10_ = _tmp9_;
				if (!_tmp10_) {
					xmlAttr* _tmp11_;
					xmlAttr* _tmp12_;
					_tmp11_ = prop;
					_tmp12_ = _tmp11_->next;
					prop = _tmp12_;
				}
				_tmp9_ = FALSE;
				_tmp13_ = prop;
				if (!(_tmp13_ != NULL)) {
					break;
				}
				_tmp14_ = props;
				_tmp15_ = prop;
				_tmp16_ = _tmp15_->name;
				_tmp17_ = prop;
				_tmp18_ = _tmp17_->children;
				_tmp19_ = _tmp18_->content;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, _tmp16_, _tmp19_);
			}
		}
	}
	_tmp20_ = name;
	_tmp21_ = _tmp20_;
	_tmp23_ = (NULL == _tmp21_) ? 0 : g_quark_from_string (_tmp21_);
	if (_tmp23_ == ((0 != _tmp22_label0) ? _tmp22_label0 : (_tmp22_label0 = g_quark_from_static_string ("serviceproviders")))) {
		switch (0) {
			default:
			{
				xmlNode* _tmp24_;
				_tmp24_ = node;
				fso_data_mbpi_database_handleChildren (self, _tmp24_);
				break;
			}
		}
	} else if (_tmp23_ == ((0 != _tmp22_label1) ? _tmp22_label1 : (_tmp22_label1 = g_quark_from_static_string ("country")))) {
		switch (0) {
			default:
			{
				GeeHashMap* _tmp25_;
				gpointer _tmp26_ = NULL;
				FsoDataMBPICountry* _tmp27_ = NULL;
				xmlNode* _tmp28_;
				GeeHashMap* _tmp29_;
				FsoDataMBPICountry* _tmp30_;
				const gchar* _tmp31_;
				FsoDataMBPICountry* _tmp32_;
				_tmp25_ = props;
				_tmp26_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp25_, "code");
				_tmp27_ = fso_data_mbpi_country_new ();
				_g_free0 (_tmp27_->code);
				_tmp27_->code = (gchar*) _tmp26_;
				_fso_data_mbpi_country_unref0 (self->priv->country);
				self->priv->country = _tmp27_;
				_tmp28_ = node;
				fso_data_mbpi_database_handleChildren (self, _tmp28_);
				_tmp29_ = self->countries;
				_tmp30_ = self->priv->country;
				_tmp31_ = _tmp30_->code;
				_tmp32_ = self->priv->country;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp29_, _tmp31_, _tmp32_);
				break;
			}
		}
	} else if (_tmp23_ == ((0 != _tmp22_label2) ? _tmp22_label2 : (_tmp22_label2 = g_quark_from_static_string ("provider")))) {
		switch (0) {
			default:
			{
				FsoDataMBPIProvider* _tmp33_;
				xmlNode* _tmp34_;
				FsoDataMBPICountry* _tmp35_;
				GeeHashMap* _tmp36_;
				FsoDataMBPIProvider* _tmp37_;
				const gchar* _tmp38_;
				FsoDataMBPIProvider* _tmp39_;
				_tmp33_ = fso_data_mbpi_provider_new ();
				_fso_data_mbpi_provider_unref0 (self->priv->provider);
				self->priv->provider = _tmp33_;
				_tmp34_ = node;
				fso_data_mbpi_database_handleChildren (self, _tmp34_);
				_tmp35_ = self->priv->country;
				_tmp36_ = _tmp35_->providers;
				_tmp37_ = self->priv->provider;
				_tmp38_ = _tmp37_->name;
				_tmp39_ = self->priv->provider;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp36_, _tmp38_, _tmp39_);
				break;
			}
		}
	} else if (_tmp23_ == ((0 != _tmp22_label3) ? _tmp22_label3 : (_tmp22_label3 = g_quark_from_static_string ("gsm")))) {
		switch (0) {
			default:
			{
				xmlNode* _tmp40_;
				self->priv->gsm = TRUE;
				_tmp40_ = node;
				fso_data_mbpi_database_handleChildren (self, _tmp40_);
				break;
			}
		}
	} else if (_tmp23_ == ((0 != _tmp22_label4) ? _tmp22_label4 : (_tmp22_label4 = g_quark_from_static_string ("cdma")))) {
		switch (0) {
			default:
			{
				xmlNode* _tmp41_;
				self->priv->gsm = FALSE;
				_tmp41_ = node;
				fso_data_mbpi_database_handleChildren (self, _tmp41_);
				break;
			}
		}
	} else if (_tmp23_ == ((0 != _tmp22_label5) ? _tmp22_label5 : (_tmp22_label5 = g_quark_from_static_string ("network-id")))) {
		switch (0) {
			default:
			{
				FsoDataMBPIProvider* _tmp42_;
				GeeArrayList* _tmp43_;
				GeeHashMap* _tmp44_;
				gpointer _tmp45_ = NULL;
				gchar* _tmp46_;
				GeeHashMap* _tmp47_;
				gpointer _tmp48_ = NULL;
				gchar* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				_tmp42_ = self->priv->provider;
				_tmp43_ = _tmp42_->codes;
				_tmp44_ = props;
				_tmp45_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp44_, "mcc");
				_tmp46_ = (gchar*) _tmp45_;
				_tmp47_ = props;
				_tmp48_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp47_, "mnc");
				_tmp49_ = (gchar*) _tmp48_;
				_tmp50_ = g_strconcat (_tmp46_, _tmp49_, NULL);
				_tmp51_ = _tmp50_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp43_, _tmp51_);
				_g_free0 (_tmp51_);
				_g_free0 (_tmp49_);
				_g_free0 (_tmp46_);
				break;
			}
		}
	} else if (_tmp23_ == ((0 != _tmp22_label6) ? _tmp22_label6 : (_tmp22_label6 = g_quark_from_static_string ("apn")))) {
		switch (0) {
			default:
			{
				GeeHashMap* _tmp52_;
				gpointer _tmp53_ = NULL;
				FsoDataMBPIAccessPoint* _tmp54_ = NULL;
				xmlNode* _tmp55_;
				gboolean _tmp56_;
				_tmp52_ = props;
				_tmp53_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp52_, "value");
				_tmp54_ = fso_data_mbpi_access_point_new ();
				_g_free0 (_tmp54_->name);
				_tmp54_->name = (gchar*) _tmp53_;
				_fso_data_mbpi_access_point_unref0 (self->priv->accesspoint);
				self->priv->accesspoint = _tmp54_;
				_tmp55_ = node;
				fso_data_mbpi_database_handleChildren (self, _tmp55_);
				_tmp56_ = self->priv->gsm;
				if (_tmp56_) {
					FsoDataMBPIProvider* _tmp57_;
					GeeHashMap* _tmp58_;
					FsoDataMBPIAccessPoint* _tmp59_;
					const gchar* _tmp60_;
					FsoDataMBPIAccessPoint* _tmp61_;
					_tmp57_ = self->priv->provider;
					_tmp58_ = _tmp57_->gsm;
					_tmp59_ = self->priv->accesspoint;
					_tmp60_ = _tmp59_->name;
					_tmp61_ = self->priv->accesspoint;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp58_, _tmp60_, _tmp61_);
				} else {
					g_debug ("mbpi.vala:184: CDMA APN FIXME");
				}
				break;
			}
		}
	} else if (_tmp23_ == ((0 != _tmp22_label7) ? _tmp22_label7 : (_tmp22_label7 = g_quark_from_static_string ("name")))) {
		switch (0) {
			default:
			{
				gint _tmp62_;
				_tmp62_ = self->priv->depth;
				if (_tmp62_ == 4) {
					FsoDataMBPIProvider* _tmp63_;
					const gchar* _tmp64_;
					gchar* _tmp65_;
					_tmp63_ = self->priv->provider;
					_tmp64_ = content;
					_tmp65_ = g_strdup (_tmp64_);
					_g_free0 (_tmp63_->name);
					_tmp63_->name = _tmp65_;
				} else {
					FsoDataMBPIAccessPoint* _tmp66_;
					const gchar* _tmp67_;
					gchar* _tmp68_;
					_tmp66_ = self->priv->accesspoint;
					_tmp67_ = content;
					_tmp68_ = g_strdup (_tmp67_);
					_g_free0 (_tmp66_->description);
					_tmp66_->description = _tmp68_;
				}
				break;
			}
		}
	} else if (_tmp23_ == ((0 != _tmp22_label8) ? _tmp22_label8 : (_tmp22_label8 = g_quark_from_static_string ("username")))) {
		switch (0) {
			default:
			{
				FsoDataMBPIAccessPoint* _tmp69_;
				const gchar* _tmp70_;
				gchar* _tmp71_;
				_tmp69_ = self->priv->accesspoint;
				_tmp70_ = content;
				_tmp71_ = g_strdup (_tmp70_);
				_g_free0 (_tmp69_->user);
				_tmp69_->user = _tmp71_;
				break;
			}
		}
	} else if (_tmp23_ == ((0 != _tmp22_label9) ? _tmp22_label9 : (_tmp22_label9 = g_quark_from_static_string ("password")))) {
		switch (0) {
			default:
			{
				FsoDataMBPIAccessPoint* _tmp72_;
				const gchar* _tmp73_;
				gchar* _tmp74_;
				_tmp72_ = self->priv->accesspoint;
				_tmp73_ = content;
				_tmp74_ = g_strdup (_tmp73_);
				_g_free0 (_tmp72_->password);
				_tmp72_->password = _tmp74_;
				break;
			}
		}
	} else if (_tmp23_ == ((0 != _tmp22_label10) ? _tmp22_label10 : (_tmp22_label10 = g_quark_from_static_string ("dns")))) {
		switch (0) {
			default:
			{
				FsoDataMBPIAccessPoint* _tmp75_;
				GeeArrayList* _tmp76_;
				const gchar* _tmp77_;
				_tmp75_ = self->priv->accesspoint;
				_tmp76_ = _tmp75_->dns;
				_tmp77_ = content;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp76_, _tmp77_);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	_tmp78_ = self->priv->depth;
	self->priv->depth = _tmp78_ - 1;
	_g_object_unref0 (props);
	_g_free0 (content);
	_g_free0 (name);
}


static void fso_data_mbpi_database_handleChildren (FsoDataMBPIDatabase* self, xmlNode* node) {
	g_return_if_fail (self != NULL);
	{
		xmlNode* _tmp0_;
		xmlNode* _tmp1_;
		xmlNode* iter;
		_tmp0_ = node;
		_tmp1_ = _tmp0_->children;
		iter = _tmp1_;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				xmlNode* _tmp6_;
				xmlNode* _tmp7_;
				xmlElementType _tmp8_;
				xmlNode* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* node_name;
				xmlNode* _tmp12_;
				gchar* _tmp13_ = NULL;
				gchar* node_content;
				xmlNode* _tmp14_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					xmlNode* _tmp4_;
					xmlNode* _tmp5_;
					_tmp4_ = iter;
					_tmp5_ = _tmp4_->next;
					iter = _tmp5_;
				}
				_tmp2_ = FALSE;
				_tmp6_ = iter;
				if (!(_tmp6_ != NULL)) {
					break;
				}
				_tmp7_ = iter;
				_tmp8_ = _tmp7_->type;
				if (_tmp8_ != XML_ELEMENT_NODE) {
					continue;
				}
				_tmp9_ = iter;
				_tmp10_ = _tmp9_->name;
				_tmp11_ = g_strdup (_tmp10_);
				node_name = _tmp11_;
				_tmp12_ = iter;
				_tmp13_ = xmlNodeGetContent (_tmp12_);
				node_content = _tmp13_;
				_tmp14_ = iter;
				fso_data_mbpi_database_parseNode (self, _tmp14_);
				_g_free0 (node_content);
				_g_free0 (node_name);
			}
		}
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void fso_data_mbpi_database_loadIso3361 (FsoDataMBPIDatabase* self) {
	gchar* _tmp0_ = NULL;
	gchar* file;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = fso_framework_file_handling_read (FSO_DATA_MBPI_ISO_3361_DATABASE);
	file = _tmp0_;
	_tmp1_ = file;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp3_;
		line_collection_length1 = _vala_array_length (_tmp2_);
		for (line_it = 0; line_it < _vala_array_length (_tmp2_); line_it = line_it + 1) {
			gchar* _tmp4_;
			gchar* line = NULL;
			_tmp4_ = g_strdup (line_collection[line_it]);
			line = _tmp4_;
			{
				const gchar* _tmp5_;
				gchar _tmp6_ = '\0';
				const gchar* _tmp7_;
				gchar** _tmp8_;
				gchar** _tmp9_ = NULL;
				gchar** elements;
				gint elements_length1;
				gint _elements_size_;
				gchar** _tmp10_;
				gint _tmp10__length1;
				gchar** _tmp11_;
				gint _tmp11__length1;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* ccode;
				gchar** _tmp14_;
				gint _tmp14__length1;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* name;
				gchar** _tmp17_;
				gint _tmp17__length1;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* dialprefix;
				GeeHashMap* _tmp20_;
				const gchar* _tmp21_;
				gpointer _tmp22_ = NULL;
				FsoDataMBPICountry* country;
				FsoDataMBPICountry* _tmp23_;
				_tmp5_ = line;
				_tmp6_ = string_get (_tmp5_, (glong) 0);
				if (_tmp6_ == '#') {
					_g_free0 (line);
					continue;
				}
				_tmp7_ = line;
				_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, "\t", 0);
				elements = _tmp9_;
				elements_length1 = _vala_array_length (_tmp8_);
				_elements_size_ = elements_length1;
				_tmp10_ = elements;
				_tmp10__length1 = elements_length1;
				if (_tmp10__length1 != 3) {
					elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					continue;
				}
				_tmp11_ = elements;
				_tmp11__length1 = elements_length1;
				_tmp12_ = _tmp11_[0];
				_tmp13_ = g_strdup (_tmp12_);
				ccode = _tmp13_;
				_tmp14_ = elements;
				_tmp14__length1 = elements_length1;
				_tmp15_ = _tmp14_[1];
				_tmp16_ = g_strdup (_tmp15_);
				name = _tmp16_;
				_tmp17_ = elements;
				_tmp17__length1 = elements_length1;
				_tmp18_ = _tmp17_[2];
				_tmp19_ = g_strdup (_tmp18_);
				dialprefix = _tmp19_;
				_tmp20_ = self->countries;
				_tmp21_ = ccode;
				_tmp22_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp20_, _tmp21_);
				country = (FsoDataMBPICountry*) _tmp22_;
				_tmp23_ = country;
				if (_tmp23_ != NULL) {
					FsoDataMBPICountry* _tmp24_;
					const gchar* _tmp25_;
					gchar* _tmp26_;
					FsoDataMBPICountry* _tmp27_;
					const gchar* _tmp28_;
					gchar* _tmp29_;
					_tmp24_ = country;
					_tmp25_ = name;
					_tmp26_ = g_strdup (_tmp25_);
					_g_free0 (_tmp24_->name);
					_tmp24_->name = _tmp26_;
					_tmp27_ = country;
					_tmp28_ = dialprefix;
					_tmp29_ = g_strdup (_tmp28_);
					_g_free0 (_tmp27_->dialprefix);
					_tmp27_->dialprefix = _tmp29_;
				} else {
					GeeHashMap* _tmp30_;
					const gchar* _tmp31_;
					const gchar* _tmp32_;
					gchar* _tmp33_;
					const gchar* _tmp34_;
					gchar* _tmp35_;
					const gchar* _tmp36_;
					gchar* _tmp37_;
					FsoDataMBPICountry* _tmp38_ = NULL;
					FsoDataMBPICountry* _tmp39_;
					_tmp30_ = self->countries;
					_tmp31_ = ccode;
					_tmp32_ = ccode;
					_tmp33_ = g_strdup (_tmp32_);
					_tmp34_ = name;
					_tmp35_ = g_strdup (_tmp34_);
					_tmp36_ = dialprefix;
					_tmp37_ = g_strdup (_tmp36_);
					_tmp38_ = fso_data_mbpi_country_new ();
					_g_free0 (_tmp38_->code);
					_tmp38_->code = _tmp33_;
					_g_free0 (_tmp38_->name);
					_tmp38_->name = _tmp35_;
					_g_free0 (_tmp38_->dialprefix);
					_tmp38_->dialprefix = _tmp37_;
					_tmp39_ = _tmp38_;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp30_, _tmp31_, _tmp39_);
					_fso_data_mbpi_country_unref0 (_tmp39_);
				}
				_fso_data_mbpi_country_unref0 (country);
				_g_free0 (dialprefix);
				_g_free0 (name);
				_g_free0 (ccode);
				elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_free0 (file);
}


static void fso_data_mbpi_database_loadZoneTab (FsoDataMBPIDatabase* self) {
	gchar* _tmp0_ = NULL;
	gchar* file;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = fso_framework_file_handling_read (FSO_DATA_MBPI_ISO_ZONE_DATABASE);
	file = _tmp0_;
	_tmp1_ = file;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp3_;
		line_collection_length1 = _vala_array_length (_tmp2_);
		for (line_it = 0; line_it < _vala_array_length (_tmp2_); line_it = line_it + 1) {
			gchar* _tmp4_;
			gchar* line = NULL;
			_tmp4_ = g_strdup (line_collection[line_it]);
			line = _tmp4_;
			{
				const gchar* _tmp5_;
				gchar _tmp6_ = '\0';
				const gchar* _tmp7_;
				gchar** _tmp8_;
				gchar** _tmp9_ = NULL;
				gchar** elements;
				gint elements_length1;
				gint _elements_size_;
				gchar** _tmp10_;
				gint _tmp10__length1;
				gchar** _tmp11_;
				gint _tmp11__length1;
				const gchar* _tmp12_;
				gchar* _tmp13_ = NULL;
				gchar* ccode;
				gchar** _tmp14_;
				gint _tmp14__length1;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* coords;
				gchar** _tmp17_;
				gint _tmp17__length1;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* tzname;
				GeeHashMap* _tmp20_;
				const gchar* _tmp21_;
				gpointer _tmp22_ = NULL;
				FsoDataMBPICountry* country;
				FsoDataMBPICountry* _tmp23_;
				_tmp5_ = line;
				_tmp6_ = string_get (_tmp5_, (glong) 0);
				if (_tmp6_ == '#') {
					_g_free0 (line);
					continue;
				}
				_tmp7_ = line;
				_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, "\t", 0);
				elements = _tmp9_;
				elements_length1 = _vala_array_length (_tmp8_);
				_elements_size_ = elements_length1;
				_tmp10_ = elements;
				_tmp10__length1 = elements_length1;
				if (_tmp10__length1 < 3) {
					elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					continue;
				}
				_tmp11_ = elements;
				_tmp11__length1 = elements_length1;
				_tmp12_ = _tmp11_[0];
				_tmp13_ = g_utf8_strdown (_tmp12_, (gssize) (-1));
				ccode = _tmp13_;
				_tmp14_ = elements;
				_tmp14__length1 = elements_length1;
				_tmp15_ = _tmp14_[1];
				_tmp16_ = g_strdup (_tmp15_);
				coords = _tmp16_;
				_tmp17_ = elements;
				_tmp17__length1 = elements_length1;
				_tmp18_ = _tmp17_[2];
				_tmp19_ = g_strdup (_tmp18_);
				tzname = _tmp19_;
				_tmp20_ = self->countries;
				_tmp21_ = ccode;
				_tmp22_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp20_, _tmp21_);
				country = (FsoDataMBPICountry*) _tmp22_;
				_tmp23_ = country;
				if (_tmp23_ != NULL) {
					FsoDataMBPICountry* _tmp24_;
					GeeHashMap* _tmp25_;
					const gchar* _tmp26_;
					const gchar* _tmp27_;
					_tmp24_ = country;
					_tmp25_ = _tmp24_->timezones;
					_tmp26_ = coords;
					_tmp27_ = tzname;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp25_, _tmp26_, _tmp27_);
				} else {
				}
				_fso_data_mbpi_country_unref0 (country);
				_g_free0 (tzname);
				_g_free0 (coords);
				_g_free0 (ccode);
				elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_free0 (file);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


FsoDataMBPIDatabase* fso_data_mbpi_database_instance (void) {
	FsoDataMBPIDatabase* result = NULL;
	FsoDataMBPIDatabase* _tmp0_;
	FsoDataMBPIDatabase* _tmp2_;
	FsoDataMBPIDatabase* _tmp3_;
	_tmp0_ = fso_data_mbpi_database__instance;
	if (_tmp0_ == NULL) {
		FsoDataMBPIDatabase* _tmp1_;
		_tmp1_ = fso_data_mbpi_database_new ();
		_g_object_unref0 (fso_data_mbpi_database__instance);
		fso_data_mbpi_database__instance = _tmp1_;
	}
	_tmp2_ = fso_data_mbpi_database__instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


GeeMap* fso_data_mbpi_database_allCountries (FsoDataMBPIDatabase* self) {
	GeeMap* result = NULL;
	GeeHashMap* _tmp0_;
	GeeMap* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->countries;
	_tmp1_ = _g_object_ref0 ((GeeMap*) _tmp0_);
	result = _tmp1_;
	return result;
}


GeeMap* fso_data_mbpi_database_providersForCountry (FsoDataMBPIDatabase* self, const gchar* code) {
	GeeMap* result = NULL;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_ = NULL;
	FsoDataMBPICountry* country;
	FsoDataMBPICountry* _tmp3_;
	FsoDataMBPICountry* _tmp4_;
	GeeHashMap* _tmp5_;
	GeeMap* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (code != NULL, NULL);
	_tmp0_ = self->countries;
	_tmp1_ = code;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	country = (FsoDataMBPICountry*) _tmp2_;
	_tmp3_ = country;
	if (_tmp3_ == NULL) {
		result = NULL;
		_fso_data_mbpi_country_unref0 (country);
		return result;
	}
	_tmp4_ = country;
	_tmp5_ = _tmp4_->providers;
	_tmp6_ = _g_object_ref0 ((GeeMap*) _tmp5_);
	result = _tmp6_;
	_fso_data_mbpi_country_unref0 (country);
	return result;
}


FsoDataMBPICountry* fso_data_mbpi_database_countryForMccMnc (FsoDataMBPIDatabase* self, const gchar* mccmnc) {
	FsoDataMBPICountry* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (mccmnc != NULL, NULL);
	{
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_;
		GeeIterator* _country_it;
		_tmp0_ = self->countries;
		_tmp1_ = gee_abstract_map_get_values ((GeeMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_country_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			FsoDataMBPICountry* country;
			_tmp6_ = _country_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _country_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			country = (FsoDataMBPICountry*) _tmp9_;
			{
				FsoDataMBPICountry* _tmp10_;
				GeeHashMap* _tmp11_;
				GeeCollection* _tmp12_;
				GeeCollection* _tmp13_;
				GeeCollection* _tmp14_;
				GeeIterator* _tmp15_ = NULL;
				GeeIterator* _tmp16_;
				GeeIterator* _provider_it;
				_tmp10_ = country;
				_tmp11_ = _tmp10_->providers;
				_tmp12_ = gee_abstract_map_get_values ((GeeMap*) _tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = _tmp13_;
				_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
				_tmp16_ = _tmp15_;
				_g_object_unref0 (_tmp14_);
				_provider_it = _tmp16_;
				while (TRUE) {
					GeeIterator* _tmp17_;
					gboolean _tmp18_ = FALSE;
					GeeIterator* _tmp19_;
					gpointer _tmp20_ = NULL;
					FsoDataMBPIProvider* provider;
					FsoDataMBPIProvider* _tmp21_;
					GeeArrayList* _tmp22_;
					const gchar* _tmp23_;
					gboolean _tmp24_ = FALSE;
					_tmp17_ = _provider_it;
					_tmp18_ = gee_iterator_next (_tmp17_);
					if (!_tmp18_) {
						break;
					}
					_tmp19_ = _provider_it;
					_tmp20_ = gee_iterator_get (_tmp19_);
					provider = (FsoDataMBPIProvider*) _tmp20_;
					_tmp21_ = provider;
					_tmp22_ = _tmp21_->codes;
					_tmp23_ = mccmnc;
					_tmp24_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp22_, _tmp23_);
					if (_tmp24_) {
						result = country;
						_fso_data_mbpi_provider_unref0 (provider);
						_g_object_unref0 (_provider_it);
						_g_object_unref0 (_country_it);
						return result;
					}
					_fso_data_mbpi_provider_unref0 (provider);
				}
				_g_object_unref0 (_provider_it);
			}
			_fso_data_mbpi_country_unref0 (country);
		}
		_g_object_unref0 (_country_it);
	}
	result = NULL;
	return result;
}


GeeMap* fso_data_mbpi_database_accessPointsForMccMnc (FsoDataMBPIDatabase* self, const gchar* mccmnc) {
	GeeMap* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (mccmnc != NULL, NULL);
	{
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_;
		GeeIterator* _country_it;
		_tmp0_ = self->countries;
		_tmp1_ = gee_abstract_map_get_values ((GeeMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_country_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			FsoDataMBPICountry* country;
			_tmp6_ = _country_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _country_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			country = (FsoDataMBPICountry*) _tmp9_;
			{
				FsoDataMBPICountry* _tmp10_;
				GeeHashMap* _tmp11_;
				GeeCollection* _tmp12_;
				GeeCollection* _tmp13_;
				GeeCollection* _tmp14_;
				GeeIterator* _tmp15_ = NULL;
				GeeIterator* _tmp16_;
				GeeIterator* _provider_it;
				_tmp10_ = country;
				_tmp11_ = _tmp10_->providers;
				_tmp12_ = gee_abstract_map_get_values ((GeeMap*) _tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = _tmp13_;
				_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
				_tmp16_ = _tmp15_;
				_g_object_unref0 (_tmp14_);
				_provider_it = _tmp16_;
				while (TRUE) {
					GeeIterator* _tmp17_;
					gboolean _tmp18_ = FALSE;
					GeeIterator* _tmp19_;
					gpointer _tmp20_ = NULL;
					FsoDataMBPIProvider* provider;
					FsoDataMBPIProvider* _tmp21_;
					GeeArrayList* _tmp22_;
					const gchar* _tmp23_;
					gboolean _tmp24_ = FALSE;
					_tmp17_ = _provider_it;
					_tmp18_ = gee_iterator_next (_tmp17_);
					if (!_tmp18_) {
						break;
					}
					_tmp19_ = _provider_it;
					_tmp20_ = gee_iterator_get (_tmp19_);
					provider = (FsoDataMBPIProvider*) _tmp20_;
					_tmp21_ = provider;
					_tmp22_ = _tmp21_->codes;
					_tmp23_ = mccmnc;
					_tmp24_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp22_, _tmp23_);
					if (_tmp24_) {
						FsoDataMBPIProvider* _tmp25_;
						GeeHashMap* _tmp26_;
						GeeMap* _tmp27_;
						_tmp25_ = provider;
						_tmp26_ = _tmp25_->gsm;
						_tmp27_ = _g_object_ref0 ((GeeMap*) _tmp26_);
						result = _tmp27_;
						_fso_data_mbpi_provider_unref0 (provider);
						_g_object_unref0 (_provider_it);
						_fso_data_mbpi_country_unref0 (country);
						_g_object_unref0 (_country_it);
						return result;
					}
					_fso_data_mbpi_provider_unref0 (provider);
				}
				_g_object_unref0 (_provider_it);
			}
			_fso_data_mbpi_country_unref0 (country);
		}
		_g_object_unref0 (_country_it);
	}
	result = NULL;
	return result;
}


static void fso_data_mbpi_database_class_init (FsoDataMBPIDatabaseClass * klass) {
	fso_data_mbpi_database_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FsoDataMBPIDatabasePrivate));
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = fso_data_mbpi_database_real_repr;
	G_OBJECT_CLASS (klass)->finalize = fso_data_mbpi_database_finalize;
}


static void fso_data_mbpi_database_instance_init (FsoDataMBPIDatabase * self) {
	self->priv = FSO_DATA_MBPI_DATABASE_GET_PRIVATE (self);
}


static void fso_data_mbpi_database_finalize (GObject* obj) {
	FsoDataMBPIDatabase * self;
	self = FSO_DATA_MBPI_DATABASE (obj);
	_g_object_unref0 (self->countries);
	_fso_data_mbpi_country_unref0 (self->priv->country);
	_fso_data_mbpi_provider_unref0 (self->priv->provider);
	_fso_data_mbpi_access_point_unref0 (self->priv->accesspoint);
	G_OBJECT_CLASS (fso_data_mbpi_database_parent_class)->finalize (obj);
}


GType fso_data_mbpi_database_get_type (void) {
	static volatile gsize fso_data_mbpi_database_type_id__volatile = 0;
	if (g_once_init_enter (&fso_data_mbpi_database_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoDataMBPIDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_data_mbpi_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoDataMBPIDatabase), 0, (GInstanceInitFunc) fso_data_mbpi_database_instance_init, NULL };
		GType fso_data_mbpi_database_type_id;
		fso_data_mbpi_database_type_id = g_type_register_static (FSO_FRAMEWORK_TYPE_ABSTRACT_OBJECT, "FsoDataMBPIDatabase", &g_define_type_info, 0);
		g_once_init_leave (&fso_data_mbpi_database_type_id__volatile, fso_data_mbpi_database_type_id);
	}
	return fso_data_mbpi_database_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



