////////////////////////////////////////////////////////////////////////////
//	GENERATED FILE
//	INPUT FILE: src/HttpSessionBindingEvent.java
//	TAGS USED: SERVLET_2_2
//
//	DO NOT EDIT!
////////////////////////////////////////////////////////////////////////////

/*
 * HttpSessionBindingEvent.java -- Passed on to a HttpSessionBindingListener
 *                                 whenever it is bound or unbound from a
 *                                 HttpSession value
 *
 * Copyright (c) 1998 by Free Software Foundation, Inc.
 * Written by Paul Siegmann (pauls@euronet.nl)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation, version 2. (see COPYING.LIB)
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation
 * Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307 USA
 */

package javax.servlet.http;

import java.util.EventObject;

/**
 * Send to an Object that implements <code>HttpSessionBindingListener</code>
 * when bound into a session or unbound from a session. Gives access to the
 * session and the name used to bind the Object to the session.
 *
 * @see javax.servlet.http.HttpSession
 * @see javax.servlet.http.HttpSession#putValue(java.lang.String, java.lang.Object)
 * @see javax.servlet.http.HttpSession#removeValue(java.lang.String)
 * @see javax.servlet.http.HttpSession#invalidate()
 * @see javax.servlet.http.HttpSessionBindingListener
 *
 * @version Servlet API 2.2
 * @since Servlet API 2.0
 */
public class HttpSessionBindingEvent
	extends EventObject 
{
	private String myName;

	/**
	 * Creates a new <code>HttpSessionBindingEvent</code> given the session
	 * and the name used.
	 *
	 * @since Servlet API 2.0
	 *
	 * @param session which the Object was bound to or unbound from
	 * @param name which was used to refer to the object
	 */
	public HttpSessionBindingEvent(HttpSession session, String name) {
		super(session);
		myName = name;
	}


	/**
	 * Returns the name used to refer to this Object.
	 *
	 * @since Servlet API 2.0
	 */
	public String getName() {
		return myName;
	}


	/**
	 * Returns the session the Object was bound to or unbound from.
	 *
	 * @since Servlet API 2.0
	 */
	public HttpSession getSession() {
		return (HttpSession)getSource();
	}
}
