package freenet.transport;
import freenet.*;
import java.io.*;
import java.net.*;

final class tcpListener implements Listener {
    
    private int port;
    private ServerSocket sock;
    private tcpListeningAddress address;
    private int designator = -1;

    private final tcpTransport t;
    
    tcpListener(tcpTransport t, tcpListeningAddress addr) 
                                        throws ListenException {
        this(t, addr, null, -1);
    }

    tcpListener(tcpTransport t, tcpListeningAddress addr,
                InetAddress bindAddr, int designator) throws ListenException {
        this.t = t;
        try {
            port = addr.getPort();
            sock = t.getServerSocketFactory().createServerSocket(addr.getPort(), 50, bindAddr);
            // if addr.port == 0, then the port is set randomly.
            // find out which one we got
            if (port == 0) port = sock.getLocalPort();
            address = new tcpListeningAddress(t, bindAddr, designator, port);
            this.designator = designator;
        } catch (IOException e) {
            throw new ListenException(this+": "+e.getMessage());
        }
    }

    public final ListeningAddress getAddress() {
        return address;
    }

    public final Connection accept() throws IOException {
        Socket a = sock.accept();
        //    a.setSoLinger(true, 0);
        return new tcpConnection(t, a, designator);
    }

    public final void setTimeout(int n) throws IOException {
        sock.setSoTimeout(n);
    }

    public final String toString() {
        return t.getName()+'/'+port;
    }

    public final void close() {
        try { sock.close(); }
        catch(IOException e) {}
        sock=null;
    }
}


