package freenet.support;

/**
 * Multiplexes a set of Walk instances into a single Walk.
 */
public class MultiWalk implements Walk {

    protected final Walk[] walks;
    protected int i=0;

    public MultiWalk(Walk wa, Walk wb) {
        this(new Walk[] {wa,wb});
    }
    
    public MultiWalk(Walk[] walks) {
        this.walks = walks;
    }

    public Object getNext() {
        while (i < walks.length) {
            Object o = walks[i].getNext();
            if (o == null)
                ++i;
            else
                return o;
        }
        return null;
    }
}


