package freenet.support;
import java.util.Vector;
import java.util.Enumeration;
import java.io.IOException;
import java.io.File;

public class FileBucketFactory implements BucketFactory {
    
    private int enum = 0;
    private Vector files = new Vector();
    
    public FileBucketFactory() {

    }

    public Bucket makeBucket(long size) throws IOException {
        File f;
        do {
            f = new File("bffile_" + ++enum);
        } while (f.exists());
        Bucket b = new FileBucket(f);
        files.addElement(f);
        return b;
    }

    public void freeBucket(Bucket b) throws IOException {
        if (!(b instanceof FileBucket)) throw new IOException("not a FileBucket!");
        File f = ((FileBucket) b).getFile();
        if (files.removeElement(f))
            f.delete();
    }
}
