package freenet.node.states.FNP;

import freenet.*;
import freenet.node.*;
import freenet.node.states.request.*;
import freenet.message.*;

/**
 * This is the state pertaining to InsertRequests in their
 * initial state.
 */

public class NewInsertRequest extends NewRequest {

    public NewInsertRequest(long id) {
        super(id);
    }
    
    /**
     * Returns the name.
     * @return "New InsertRequest"
     */
    public String getName() {
        return "New InsertRequest";
    }

    public State received(Node n, MessageObject mo) throws StateException {
        if (!(mo instanceof InsertRequest)) {
            throw new BadStateException("expecting DataRequest");
        }
        InsertRequest irmo = (InsertRequest) mo;
        try {
            genReceived(n, irmo);
            FeedbackToken ft    = new FNPFeedbackToken(id, origRec);
            RequestInitiator ri = new RequestInitiator(id);
            Pending p = new InsertPending(id, (int) irmo.hopsToLive,
                                          irmo.searchKey, origRec, ft, ri);
	    n.diagnostics.occurrenceCounting("incomingInserts", 1);
            return p.received(n, ri);
        } catch (RequestAbortException rae) {
            return rae.state;
        }
    }
}


