package freenet.node.states.FCP;

import freenet.*;
import freenet.node.*;
import freenet.message.client.*;
import freenet.client.*;

public class NewGenerateSVKPair extends NewClientRequest {

    public NewGenerateSVKPair(long id, ConnectionHandler source) {
        super(id, source);
    }
    
    public String getName() {
        return "New Client GenerateSVKPair";
    }

    public State received(Node n, MessageObject mo) throws BadStateException {
        if (!(mo instanceof GenerateSVKPair))
            throw new BadStateException("expecting GenerateSVKPair");
        ClientSVK svk = new ClientSVK(n.randSource);
        FieldSet fs = new FieldSet();
        fs.put("PrivateKey", Base64.encode(svk.getPrivateKey()));
        fs.put("PublicKey",  Base64.encode(svk.getPublicKeyFingerPrint()));
        sendMessage(new Success(id, fs));
        return null;
    }
}

