package freenet.node.rt;

import freenet.Key;
import freenet.Identity;
import freenet.node.NodeReference;

/**
 * @author tavin
 */
public interface RoutingTable {

    /**
     * Associates a NodeReference with a key.
     *
     * @param k  The key to store the reference under
     * @param nr  The node to associate with the key
     */
    void reference(Key k, NodeReference nr);

    /**
     * @return  true, if the routing table references a node
     *          with the given Identity
     */
    boolean references(Identity id);

    /**
     * Returns a Routing object which can be used to get
     * a sequence of NodeReference objects in order of
     * routing preference, and which accepts feedback
     * about the results of routing.
     *
     * @param k  the key to find routes for
     * @return   the generated Routing object
     */
    Routing route(Key k);

    /**
     * NOTE:  It is important to hold the sync-lock
     *        while using the RoutingStore.
     * @see semaphore()
     * @return  the underlying RoutingStore
     */
    RoutingStore getRoutingStore();

    /**
     * Actions on the routing table are naturally synchronized.
     * This returns the synchronization lock so that it can be
     * held between method calls.
     * @return  an object to synchronize on when doing multiple
     *          correlated operations on the routing table
     */
    Object semaphore();
    
    /**
     * Returns diagnostic information about the current
     * state of the RoutingTable implementation.
     *
     * @return The diagnostic info. This can be null.
     */
    RTDiagSnapshot getSnapshot();
}



