package freenet.message;
import freenet.*;
import freenet.node.*;
import freenet.support.Fields;
import freenet.support.KeyList;
import java.io.*;

/**
 * The third message in a complete announcement chain. This message 
 * contains the revealed commit values (trailing), as well as Alice' signature 
 * of the final result.
 *
 * @author oskar
 */

public class AnnouncementExecute extends NodeMessage {

    
    public static final String messageName = "AnnouncementExecute";

    private KeyList vals;
    private String refSignature;
    private InputStream in;

    public AnnouncementExecute(long id, KeyList vals, String refSignature) {
        super(id, null);
        this.vals = vals;
        this.refSignature = refSignature;
    }

    public AnnouncementExecute(ConnectionHandler ch, RawMessage raw) 
        throws InvalidMessageException {
        
        super(ch, raw);

        refSignature = otherFields.get("RefSignature");
        
        if (refSignature == null || refSignature.equals("")) {
            throw new InvalidMessageException("Lacking reference signature");
        } else if (raw.trailingFieldLength == 0) {
            throw new InvalidMessageException("Lacks value list");
        }

        otherFields.remove("RefSignature");
        vals = new KeyList();
        in = raw.trailingFieldStream;
    }

    public RawMessage toRawMessage(Presentation p) {
        RawMessage raw = super.toRawMessage(p);
        ////raw.messageType = messageName;
        raw.fs.add("RefSignature", refSignature);
        raw.trailingFieldName = "Values";
        raw.trailingFieldLength = vals.streamLength();
        //raw.trailingFieldStream = vals.getStream();

        return raw;
    }

    public String getMessageName() {
        return messageName;
    }

    /** Read up to limit values from the stream into the list.
      */
    public void readValueList(int limit) throws IOException {
        try {
            KeyList.readKeyList(in, vals, limit);
        }
        finally {
            try { in.close(); }
            catch (IOException e) {}
        }
    }

    public KeyList getValueList() {
        return vals;
    }

    public String getRefSignature() {
        return refSignature;
    }
}
