package freenet.fs.acct;

import freenet.support.*;
import freenet.support.Comparable;
import java.io.*;

/**
 * The SharedAccountingInitializer is used to initialize a set
 * of AccountingStruct instances that are using SharedAccountingProcess
 * objects sharing the same SingleAccountingProcess.
 *
 * The AccountingStruct instances are registered with this object
 * and then it is passed to AccountingInitializer.initialize().
 *
 * @see AccountingInitializer
 * @see SharedAccountingProcess
 * @see AccountingStruct
 * 
 * @author tavin
 */
public class SharedAccountingInitializer implements AccountingStruct {

    //private int quota = 0;

    private final OrderedVector structMap = new OrderedVector();
    
    private static final class TagStructPair implements Comparable {

        final int tag;
        final AccountingStruct struct;
        
        TagStructPair(int tag, AccountingStruct struct) {
            this.tag = tag;
            this.struct = struct;
        }

        public final int compareTo(Object o) {
            return compareTo((TagStructPair) o);
        }

        public final int compareTo(TagStructPair p) {
            return tag == p.tag ? 0 : (tag > p.tag ? 1 : -1);
        }
    }
    

    
    private final AccountingStruct get(int tag) {
        synchronized (structMap) {
            int i = structMap.search(new TagStructPair(tag, null));
            return i == -1 ? null : ((TagStructPair) structMap.elementAt(i)).struct;
        }
    }


    /**
     * Registers an AccountingStruct for initialization.
     * @param tag     the 2-byte tag for the given struct
     * @param struct  the AccountingStruct to register
     */
    public final void add(int tag, AccountingStruct struct) {
        structMap.insert(new TagStructPair(tag, struct));
        //quota += struct.getBlockQuota();
    }

    public void found(int bnum, DataInput din) throws IOException {
        AccountingStruct struct = get(din.readUnsignedShort());
        if (struct != null)
            struct.found(bnum, din);
    }

    public void found(int bnum, DataInput din, BlockTransaction btx) throws IOException {
        AccountingStruct struct = get(din.readUnsignedShort());
        if (struct != null)
            struct.found(bnum, din, btx);
    }

    //public void found(BlockTransaction btx, DataInput din) throws IOException {
    public void found(BlockTransaction btx) throws IOException {
        if (btx.getAnnotationLength() > 2) {
            DataInput din = btx.readAnnotation();
            AccountingStruct struct = get(din.readUnsignedShort());
            if (struct != null)
                struct.found(btx);
        }
    }

    //public final int getBlockQuota() {
    //    return quota;
    //}
}


