package freenet.fs.acct;

import java.io.*;

abstract class ControlBlock extends BlockElement {

    static final int CONTROL_TYPE_WIDTH = 2,
                     CONTROL_HEADER_WIDTH = 4;

    static final int SYNCHRONIZATION_BLOCK = 0x0001,
                     ANNOTATION_BLOCK      = 0x0002;

    ControlBlock next = null;

    final int type;
    final int antecedent;
    
    
    ControlBlock(int bnum, int type, int antecedent) {
        super(bnum);
        this.type = type;
        this.antecedent = antecedent;
    }

    public String toString() {
        return super.toString()
               + " Type: 0x" + Integer.toHexString(type)
               + " Antecedent: " + antecedent;
    }
    

    void writeTo(DataOutput out) throws IOException {
        out.writeShort(type);
        out.writeInt(antecedent);
        writeBody(out);
    }
    
 
    abstract void writeBody(DataOutput out) throws IOException;

    abstract int getBodySize();
    

    static ControlBlock read(int bnum, DataInput din) throws IOException {
        int type = din.readUnsignedShort();
        if (type == 0) {
            return null;
        }
        int antecedent = din.readInt();
        switch (type) {
            case SYNCHRONIZATION_BLOCK:
                return new SynchronizationBlock(bnum, antecedent, din);
            case ANNOTATION_BLOCK:
                return new AnnotationBlock(bnum, antecedent, din);
            default:
                throw new AccountingException("what the fuck was that? huh?");
        }
    }
}

