package freenet.fs.acct;

import java.io.DataInput;
import java.io.IOException;

/**
 * The AccountingStruct can be used with an AccountingInitializer to
 * facilitate initialization of the higher-level structures using
 * an AccountingProcess in a standard way.  Once the AccountingInitializer
 * has been instantiated, an AccountingStruct can be passed into
 * its initialize() method.
 *
 * This is really optional, since the same data can just be read from
 * the AccountingInitializer, but it is useful nevertheless (particularly
 * when it comes to the shared accounting processes).
 *
 * @see SharedAccountingInitializer
 * @see SharedAccountingProcess
 *
 * @see AccountingInitializer.initialize()
 * @author tavin
 */
public interface AccountingStruct {

    /**
     * Found an existing block.
     */
    void found(int bnum, DataInput din) throws IOException;

    /**
     * Found an in-progress modification of an existing block.
     */
    void found(int bnum, DataInput din, BlockTransaction btx) throws IOException;

    /**
     * Found an in-progress creation of a new block.
     */
    void found(BlockTransaction btx) throws IOException;
}


