package freenet.client;
import freenet.client.listeners.DoneListener;
import freenet.client.events.GeneratedURIEvent;
import freenet.support.Bucket;
import freenet.support.ArrayBucket;
import freenet.support.BucketFactory;
import freenet.support.NullBucket;
import freenet.client.metadata.Metadata;
import freenet.client.metadata.DocumentCommand;
import java.io.IOException;
import java.io.OutputStream;
/*
 * This is just an example. Obviously the advanced redirect features
 * need to be added.
 */
public class PutRequestProcess extends ControlRequestProcess {

    private String cipherName;

    public PutRequestProcess(FreenetURI uri, int htl, String cipherName, 
                             Metadata metadata, Bucket data, 
                             BucketFactory ptBuckets,
                             int recursionLevel, boolean descend) {
        super(uri, htl, data, ptBuckets, recursionLevel, descend);
        this.metadata = metadata;
        //        System.err.println("LALA a: " + this.metadata);
        this.cipherName = cipherName;
        nextLevel = true; // puts start at the next level.
    }

    public synchronized Request getNextRequest() {
        if (aborted || failed)
            return null;
        if (nextLevel) {
            if (next == null && metadata != null) {
                DocumentCommand d = 
                    (uri.getMetaString() == null ? 
                     null : 
                     metadata.getDocument(uri.getMetaString()));
                FreenetURI nuri;
                if (d != null) {
                    nuri = uri.popMetaString();
                } else {
                    d = metadata.getDefaultDocument();
                    nuri = uri;
                }
                if (d != null)
                    next = d.getPutProcess(nuri, htl, cipherName, data, 
                                           ptBuckets, recursionLevel, 
                                           follow);
            }
            //System.err.println(recursionLevel +  " LALA " + next);

            Request nr = null;
            if (next != null) {
                nr = next.getNextRequest();
                if (next.failed()) {
                    failed = true;
                    return null;
                }
            }

            if (next == null || (nr == null && follow)) {

                Bucket mdBucket = new ArrayBucket();
                //System.err.println("I'm spawning myself: " + recursionLevel);
                try {
                    OutputStream md = mdBucket.getOutputStream();
                    if (metadata != null)
                        metadata.writeTo(md);
                    md.close();
                    r = new PutRequest(htl, uri, // .setMetaString(null), 
                                       cipherName, mdBucket, 
                                       next == null ? data : new NullBucket());
                } catch (IOException e) {
                    throw new Error("IOException when reading to memory: " +
                                    e);
                } catch (InsertSizeException e) {
                    failed = true;
                    return null;
                }
                nextLevel = false;
                //                next = null; // it's over
                //System.err.println("I've spawned myself: " + recursionLevel);
                dl = new DoneListener();
                r.addEventListener(dl);
                r.addEventListener(new NewURIListener());
                return r;
            } else {
                //System.err.println("GOT NULL: " + recursionLevel);
                return nr;
            }
        } else if (dl == null) {
            return null;
        } else {
            //System.err.println("WAITING:  " + recursionLevel);
            dl.strongWait();
            if (r.state() != r.DONE)
                failed = true;
            //System.err.println("WAITED: " + recursionLevel);
            //   if (recursionLevel == 1)
            //    throw new RuntimeException("tag");
            return null;
        }
    }

    private class NewURIListener implements ClientEventListener {

        public void receive(ClientEvent ce) {
            if (ce instanceof GeneratedURIEvent) {
              
                uri = ((GeneratedURIEvent) ce).getURI(); 
                // System.err.println(recursionLevel + " LALA Setting URI " +
                //                   uri);
            }
        }

    }

}






