package freenet.client;

import freenet.support.Bucket;
import java.net.MalformedURLException;

/** Represents a request to retrieve a file.
  * @author tavin
  */
public class GetRequest extends Request {

    int htl;
    FreenetURI uri;
    Bucket meta, data;

    /** Prepares a request for data identified by a Freenet URI.
      * @param htl   The HopsToLive to give the request.
      * @param uri   The URI to request.
      * @param meta  A bucket to place the metadata in (if there is any)
      * @param data  A bucket to place the data in
      * @throws MalformedURLException  if the URI string is bad
      */
    public GetRequest(int htl, String uri, Bucket meta, Bucket data)
                                        throws MalformedURLException {
        this(htl, new FreenetURI(uri), meta, data);
    }

    /** Prepares a request for data identified by a Freenet URI.
      * @param htl   The HopsToLive to give the request.
      * @param uri   The URI to request.
      * @param meta  A bucket to place the metadata in (if there is any)
      * @param data  A bucket to place the data in
      */
    public GetRequest(int htl, FreenetURI uri, Bucket meta, Bucket data) {
        super();
        this.htl  = htl;
        this.uri  = uri;
        this.meta = meta;
        this.data = data;
    }
}





