//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: BoundaryPOVRay.hpp,v 1.2 2004/08/28 08:28:03 delpinux Exp $

#ifndef BOUNDARYPOVRAY_HPP
#define BOUNDARYPOVRAY_HPP

#include <Boundary.hpp>

/**
 * @file   BoundaryPOVRay.hpp
 * @author Stephane Del Pino
 * @date   Fri Aug 27 23:49:48 2004
 * 
 * @brief  POVRay boundaries description
 * 
 * 
 */
class BoundaryPOVRay
  : public Boundary
{
private:
  //! list of POV-Ray like boundary references (colors).
  std::vector<TinyVector<3,real_t> > __povRef;

  void put(std::ostream& os) const {
    if (__povRef.size() > 0) {
      os << " POVref : ";
      os << '<' << __povRef[0][0]
	 << ',' << __povRef[0][1]
	 << ',' << __povRef[0][2] << '>';
    }
  }

public:
  //! Number POV-Ray references.
  const size_t nbPOVRef() const
  {
    return __povRef.size();
  }

  //! Adds a POV-Ray reference.
  void addPOVRef(const TinyVector<3,real_t>& ref)
  {
    for(size_t i=0; i<__povRef.size(); ++i) {
      if (__povRef[i] == ref)
	return;
    }
    __povRef.push_back(ref);
  }

  //! read only access to the ith POV-Ray reference.
  const TinyVector<3,real_t>& POVRef(const size_t i) const
  {
    assert(i<__povRef.size());
    return __povRef[i];
  }


  BoundaryPOVRay(const BoundaryPOVRay& B)
    : Boundary(B),
      __povRef(B.__povRef)
  {
    ;
  }


  BoundaryPOVRay()
    : Boundary(Boundary::povRay)
  {
    ;
  }

  ~BoundaryPOVRay()
  {
    ;
  }
};

#endif // BOUNDARYPOVRAY_HPP

