//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: Cone.cpp,v 1.2 2003/08/08 08:39:56 delpinux Exp $


// This class provides a toolkit to manipulate Cones. It inherits from
// the Shape class.

#include <Cone.hpp>

//! copies a the Cone \a C.
const Cone&  Cone::operator = (const Cone& C)
{
  __center1  = C.__center1;
  __center2 = C.__center2;
  __axisVector = C.__axisVector;
  __height = C.__height;
  __radius1  = C.__radius2;
  __trans = C.__trans;
  return *this;
}

//! Default constructor.
Cone::Cone()
  : Shape(cone)
{
  ;
}

/*!
  Builds a Cone based on vertices \a a and \a b.
  The edges of the Cone are parallel to the axis.
*/
Cone::Cone(const Vertex& a, const Vertex& b,
	   const real_t r1, const real_t r2)
  : Shape(cone),
    __center1(a),
    __center2(b),
    __axisVector(b-a),
    __height(Norm(__axisVector)),
    __radius1(r1),
    __radius2(r2)
{
  ;
}

//! Copy constructor.
Cone::Cone(const Cone& C)
  : Shape(C),
    __center1(C.__center1),
    __center2(C.__center2),
    __axisVector(C.__axisVector),
    __height(C.__height),
    __radius1(C.__radius1),
    __radius2(C.__radius2)
{
  ;
}

//! Prints the Cone informations using the stream \a s.
std::ostream& Cone::put(std::ostream& s) const
{
  s << "cone {\n" << __center1 << ',' << __radius1
    << ',' << __center2 << ',' << __radius2 << "\n}\n";
  return s;
}

