//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: HexahedronByEdges.hpp,v 1.1.1.1 2003/02/17 16:32:51 delpinux Exp $

#ifndef HEXAHEDRONBYEDGES_HPP
#define HEXAHEDRONBYEDGES_HPP

#include <CellByEdges.hpp>
/**
 * @file   HexahedronByEdges.hpp
 * @author Stphane Del Pino
 * @date   Sat Jul 27 17:08:53 2002
 * 
 * @brief  describes Hexahedron (defined using 12 edges)
 * 
 * @todo use numberOfEdges() in constructor instead of 12 when compiler allows it.
 */
class HexahedronByEdges
  : public CellByEdges
{
public:
  inline const size_t numberOfEdges() const
  {
    return 12;
  }

  HexahedronByEdges(const Edge& e0,
		    const Edge& e1,
		    const Edge& e2,
		    const Edge& e3,
		    const Edge& e4,
		    const Edge& e5,
		    const Edge& e6,
		    const Edge& e7,
		    const Edge& e8,
		    const Edge& e9,
		    const Edge& e10,
		    const Edge& e11)
    : CellByEdges(12)
  {
    __edges[ 0] = const_cast<Edge*>(&e0);
    __edges[ 1] = const_cast<Edge*>(&e1);
    __edges[ 2] = const_cast<Edge*>(&e2);
    __edges[ 3] = const_cast<Edge*>(&e3);
    __edges[ 4] = const_cast<Edge*>(&e4);
    __edges[ 5] = const_cast<Edge*>(&e5);
    __edges[ 6] = const_cast<Edge*>(&e6);
    __edges[ 7] = const_cast<Edge*>(&e7);
    __edges[ 8] = const_cast<Edge*>(&e8);
    __edges[ 9] = const_cast<Edge*>(&e9);
    __edges[10] = const_cast<Edge*>(&e10);
    __edges[11] = const_cast<Edge*>(&e11);
  }
};

#endif // HEXAHEDRONBYEDGES_HPP

