//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: Information.hpp,v 1.2 2004/03/27 16:16:07 delpinux Exp $

#ifndef _INFORMATION_HPP_
#define _INFORMATION_HPP_

#include <ReferenceCounting.hpp>
class MeshExpression;
class Scene;
class UnknownListExpression;

#include <stack>
#include <StaticBase.hpp>
/*!
  \class Information

  \author Stephane Del Pino
*/

class Information
  : public StaticBase<Information>
{
private:
  typedef StaticBase<Information> Mother;
  //! if not NULL contains the mesh which is used in the instruction
  std::stack<ReferenceCounting<MeshExpression> > __mesh;

  //! the last defined scene.
  ReferenceCounting<Scene> __scene;

  //! The current Unknown list.
  ReferenceCounting<UnknownListExpression> __unknownListExpression;

public:
  ReferenceCounting<MeshExpression> getMesh();

  void setMesh(ReferenceCounting<MeshExpression> mesh);

  void unsetMesh();

  const bool usesMesh() const;

  ReferenceCounting<UnknownListExpression> getUnknownList();

  void setUnknownList(ReferenceCounting<UnknownListExpression> ul);

  void unsetUnknownList();

  const bool usesUnknownList() const;

  ReferenceCounting<Scene> getScene();

  void setScene(ReferenceCounting<Scene> scene);

  void unsetScene();

  const bool usesScene() const;

  Information();

  Information(const Information& I);

  ~Information();
};

#endif // _INFORMATION_HPP_

