===================
Freeciv Version 2.1
===================

Bienvenue à Freeciv !

Cette archive contient Freeciv, un clone libre de Civilization, principalement
pour X sous Unix. Il permet les parties multijoueurs locales ou
à travers un réseau, et inclut une IA qui donne du fil à retordre à la
plupart des joueurs.

Le but de Freeciv est d'avoir des règles compatibles avec Civilization
II [tm], publié par Sid Meier et Microprose [tm]. Quelques règles
diffèrent (lorsque nous avons jugé que c'était plus logique), et il y a
beaucoup de paramètres réglables pour permettre la personnalisation des
parties.

Freeciv a été implémenté totalement indépendamment de Civilization ;
vous n'avez pas besoin de posséder Civilization pour jouer à Freeciv.


Site web :
==========

Le site web de Freeciv se trouve à cette adresse :

  http://www.freeciv.org/

Nous vous invitons à le visiter. Vous pourrez y connaître les dernières
nouvelles concernant Freeciv, télécharger les dernières versions et
patches, trouver des informations à propos des listes de diffusion et
consulter le métaserveur Freeciv, qui répertorie des parties du monde
entier.


Licence :
=========

Freeciv est distribué sous la GNU GPL. En bref, vous pouvez copier ce
programme (y compris ses sources) librement. Tous les détails se
trouvent dans le fichier COPYING.


Compilation et installation :
=============================

Merci de lire attentivement le fichier INSTALL.fr pour savoir comment
compiler et installer Freeciv sur votre machine.


Commencer une partie :
======================

Freeciv se compose en fait de deux programmes : un serveur et un
client. Lorsqu'une partie est en cours, il y a un programme serveur qui
tourne, et autant de programmes clients que de joueurs humains. Le
serveur, au contraire des clients, n'a pas besoin de X.

  NOTE :
  Les exemples suivants partent du principe que Freeciv a été installé
  sur votre système, et que le répertoire contenant les programmes
  "civclient" et "civserver" est dans votre PATH. Si Freeciv n'est pas
  installé, vous pouvez utiliser les programmes "civ" et "ser", qui se
  trouvent dans le répertoire racine de Freeciv. Ils s'utilisent
  exactement de la même façon que "civclient" et "civserver".


Jouer à Freeciv implique de lancer le serveur, puis le(s) client(s) et de
créer la ou les IA. Ensuite, vous devez lancer la partie depuis le
serveur. Voici les étapes :


Serveur :

  Pour lancer le serveur :

  |  % civserver

  Ou pour la liste des options en ligne de commande :

  |  % civserver --help

  Une fois que le serveur est lancé, une invite doit apparaître :
  |  Pour obtenir une aide sommaire, tapez 'help'.
  |  >
  
  [ si ce message n'est pas en Français, et que vous voulez absolument
  jouer dans notre langue, positionnez la variable d'environnement LANG
  à "fr". Pour plus de détails, consultez le fichier INSTALL.fr ]


  En tapant la commande 'help', vous pouvez donc voir ceci :
  |  > help
  |  Bienvenue - ceci est le texte d'aide introductif du serveur Freeciv.
  |
  |  Les commandes et les options sont deux concepts importants pour le 
  |  serveur.
  |  Les commandes, comme 'help', sont utilisées pour interagir avec le
  |  serveur. Certaines commandes prennent un ou plusieurs arguments, séparés
  |  par des espaces. Dans la plupart des cas, les commands et les arguments
  |  des commandes peuvent être abrégés. Les options sont des paramètres qui
  |  contrôlent le serveur.
  |
  |  Pour savoir comment obtenir plus d'informations sur les commandes et
  |  les options, utilisez 'help help'.
  |
  |  Pour l'impatient, les commandes principales pour commencer sont :
  |  show  - pour voir les options actuelles
  |  set   - pour régler des options
  |  start - pour lancer la partie une fois que les joueurs sont connectés
  |  save  - pour sauver la partie en cours
  |  quit  - pour quitter
  |  >

  Si vous le désirez, vous pouvez utiliser la commande 'set' pour régler
  certaines options de la partie. Vous pouvez obtenir une liste des
  options grâce à la commande 'show', et une description détaillée de
  chacune avec 'help <nom-de-l'option>'.

  Par exemple :
  |  > help xsize
  |  Option : xsize  -  Largeur en cases de la carte
  |  État : modifiable
  |  Valeur : 80, Minimum : 40, Défaut : 80, Maximum : 200

  Et :
  |  > set xsize 100
  |  > set ysize 80

  En faisant ceci, la carte aura une taille deux fois plus grande que
  celle, par défaut, de 80x50.

Client :

  À présent, tous les joueurs humains devraient se connecter en lançant
  le client Freeciv :

  |  % civclient

  Ceci part du principe que le serveur tourne sur la même
  machine. Sinon, vous pouvez le spécifier en ligne de commande à l'aide
  de l'option '--server' ou le saisir dans la première boîte de dialogue
  lorsque le client est lancé.

  Par exemple, supposons que le serveur tourne sur une machine
  différente appelée 'neptune'. Dans ce cas, les joueurs rejoignent la
  partie avec une commande de ce style :

  |  % civclient --server neptune

  Si vous êtes le seul joueur humain, un seul client a besoin d'être
  lancé. Vous pouvez lancer le client "en tâche de fond" de la manière
  standard sous Unix en ajoutant un "&" à la suite de "civclient" :

  |  % civclient &

  Une autre option du client que vous devriez apprécier est '--tiles',
  qui peut être utilisée pour choisir des "tilesets" différents
  (c'est-à-dire des graphismes différents pour le terrain, les unités,
  etc). La distribution fournit deux tilesets principaux, appelés
  "trident" et "engels" et deux variantes, "trident_shields" et
  "engels_shields". Dans cette distribution, "trident" est le tileset
  par défaut (dans certaines distributions précédentes, c'était
  "engels"). Les deux tilesets principaux ont des styles graphiques
  différents ; vous pouvez préférer l'un ou l'autre. Les variantes
  "_shields" utilisent des drapeaux de la forme de boucliers, plus
  petits. Les tiles trident sont petites, et peuvent donc être plus
  adaptées si vous avez un petit écran. Prenez vous-même une décision en
  les essayant toutes. Pour tester le tileset engels : lancez le client
  ainsi :

  |  % civclient --tiles engels

  D'autres tilesets sont disponibles sur le site ftp.

  Les clients peuvent être autorisés à utiliser des commandes du
  serveur. Pour les autoriser à n'utiliser que des commandes
  "d'information", tapez ce qui suit à l'invite du serveur :

  |  > cmdlevel info

  Les clients peuvent à présent utiliser '/help', '/list', '/show
  settlers', etc.


Joueurs IA :

  Il y a deux façons de créer des joueurs IA. La première est de régler
  le nombre total de joueurs (humains et IA) à l'aide de l'option
  'aifill' du serveur. Par exemple :

  |  > set aifill 7

  Après avoir utilisé la commande 'start' du serveur pour commencer la
  partie, tous les joueurs qui ne sont pas contrôlés par des humains
  seront des joueurs IA. Dans l'exemple ci-dessus, si 2 joueurs humains
  ont rejoint la partie, 5 joueurs IA seront créés.

  La deuxième façon est de créer explicitement une IA avec la commande
  'create' du serveur. Par exemple :

  |  > create TueurdHumains

  Ceci créera un joueur IA appelé TueurdHumains.

  Des nations sont assignées aux joueurs IA après que tous les joueurs
  humains aient choisi les leurs, mais vous pouvez choisir une nation
  particulière pour un joueur IA en utilisant le nom normal pour le chef
  de cette nation. Par exemple, pour jouer contre des Romains contrôlés
  par l'IA, utilisez la commande du serveur suivante :

  |  > create César

  Note : ceci n'est qu'un préférence. Si aucun joueur humain ne choisit
  de jouer les Romains, alors cette IA les prendra.

Serveur :

  Une fois que tout le monde a rejoint la partie (utilisez la commande
  "list" pour savoir qui est là), lancez la partie avec la commande
  "start" :

  |  > start

Et la partie est lancée !


Annoncer la partie :
====================

Si vous ne voulez pas limiter la concurrence à vos amis ou aux joueurs
IA, visitez le métaserveur Freeciv :

  http://meta.freeciv.org/metaserver.phtml/

C'est une liste de serveurs Freeciv. Pour que votre propre serveur
s'y annonce lui-même, lancez civserver avec l'option '--meta', ou '-m'.

Remarques :

 1) Étant donnée l'inclusion de nouvelles fonctionnalités, des versions
    différentes du client et du serveur sont souvent
    incompatibles. Par exemple, un client de version 2.0.0 est incompatible
    avec un serveur de version 1.14.2.

 2) Si le bouton Métaserveur dans la boîte de dialogue de connexion ne
    fonctionne pas, vérifiez si votre fournisser d'accès utilise un
    proxy WWW et signalez-le au client à l'aide de la variable
    d'environnement $http_proxy. Ainsi, si le proxy est
    proxy.monfournisseur.com, sur le port 8888, positionnez $http_proxy
    à http://proxy.monfournisseur.com:8888/ avant de lancer le client.

 3) Parfois, il n'y a pas de partie sur le métaserveur. Ceci peut venir
    du fait que le métaserveur a changé d'hôte et que les anciennes
    versions de Freeciv ne connaissent pas la nouvelle adresse. Dans ce
    cas, les parties n'apparaissent plus sur le métaserveur par défaut
    et vous devez utilisez l'option '--meta'. Si vous voulez jouer à une
    partie sur le métaserveur et qu'il n'y en a pas, essayez d'en lancer
    une vous-même !


Jouer :
=======

La partie peut être sauvée à n'importe quel moment en utilisant la
commande 'save' du serveur :

  |  > save mapartie.sav

Si votre serveur est compilé avec le support de la compression et que
l'option 'compress' du serveur a une autre valeur que 0 (zéro), alors le
fichier peut être compressé et sauvé sous un nom comme
'mapartie.sav.gz'.

Le client Freeciv fonctionne pour une partie de Civilization en
multijoueurs de la façon qu'on peut espérer. C'est à dire que les
joueurs humains se déplacent tous en même temps, puis tous les joueurs
IA se déplacent lorsque tous les joueurs humains ont terminé leur
tour. Il y a une valeur de timeout pour les tours, qui est par défaut de
0 seconde (pas de timeout). L'administrateur du serveur peut modifier
cette valeur à n'importe quel moment grâce à la commande 'set'.

Jetez un oeil au système d'aide en ligne. Les trois boutons de la souris
sont utilisés, et documentés dans l'aide.

Les joueurs peuvent appuyer sur la touche 'Entrée' pour annoncer la fin
de leur tour, ou simplement cliquer sur le bouton 'Fin du tour'.

Utilisez la boîte de dialogue 'Joueurs' pour savoir qui a annoncé la fin
de son tour, et qui vous attendez ("Hé ! Tu t'es endormi ou quoi ?" ;-) ).

Utilisez la ligne de saisie en bas de la fenêtre pour envoyer des
messages aux autres joueurs.

Vous pouvez envoyer un message à un seul joueur (par exemple 'pascal') :

  |  pascal: enlève ce tank *maintenant* !

Le serveur est suffisamment intelligent pour "compléter" les
noms. Ainsi, si vous avez tapez "pas:", il cherchera un nom de joueur
qui commence par 'pas'.

Vous pouvez exécuter des commandes du serveur depuis la ligne de saisie
du client en les préfixant de '/' :

  |  /list
  |  /set settlers 4
  |  /save mapartie.sav

L'administrateur du serveur vous laissera probablement uniquement lancer
des commandes "d'information". Ceci vient en partie de considérations
liées à la sécurité. Imaginez un joueur qui essaye :

  |  /save /etc/passwd

Bien sûr, le serveur ne devrait pas être lancé avec les privilèges du
super-utilisateur pour réduire ce genre de risques.

Si vous débutez et désirez avoir une idée de stratégies possibles,
consultez le "Freeciv playing HOWTO", dans le fichier HOWTOPLAY.fr.

Pour avoir beaucoup plus de renseignements à propos du client, du
serveur et des concepts et règles du jeu, consultez le manuel de Freeciv
disponible sur le site web :

  http://www.freeciv.org/wiki/Manual


Fin de la partie :
==================

Il y a trois façons de terminer une partie :

1) Il ne reste q'une seule nation.
2) L'année de fin est atteinte.
3) Un joueur construit et lance un vaisseau spatial qui atteint Alpha
   du Centaure le premier.

Un tableau des scores sera montré dans tous les cas. Truc :
l'administrateur du serveur peut changer l'année de fin pendant que la
partie est en cours en modifiant l'option 'end-year'. C'est utile
lorsque l'on connaît déjà le vainqueur et que l'on veut pas avoir à
supporter la phase ennuyeuse de "nettoyage".


Chargement des parties :
========================

Vous pouvez charger une partie sauvée en utilisant l'option '-f' du
serveur :

  |  % civserver -f notresauvegarde2001.sav

Ou, si le fichier de sauvegarde est compressé :

  |  % civserver -f notresauvegarde2001.sav.gz

À présent, les joueurs peuvent rejoindre la partie :

  |  % civclient -n Alexandre

Remarquez que l'on peut préciser le nom du joueur avec l'option '-n'. Il
est primordial que les joueurs utilisent le même nom que lorsque la
partie était en cours, s'ils veulent pouvoir la rejoindre.

La partie peut ensuite être redémarrée avec la commande 'start', comme
d'habitude.


Localisation :
==============

Freeciv supporte un certain nombre de langues (dont le Français ;) ).

Vous pouvez choisir quel langue vous souhaitez en précisant une
"locale". Chaque locale a un nom standard (par exemple, 'fr' pour
Français). Si vous avez installé Freeciv, vous pouvez choisir une locale
en positionnant la variable d'environnement LANG correctement, avant de
lancer civserver et civclient.

Par exemple, pour utiliser la localisation française :

  export LANG; LANG=fr   (avec un shell Bourne (sh)),
ou
  setenv LANG fr         (avec le shell C (csh)).

(Vous pouvez faire ceci dans votre .profile ou votre .login)


Journal :
=========

Le client et le serveur affichent des messages de log ("journal"). Il y
a cinq catégories de messages : "fatal", "erreur" (error), "normal",
"verbeux" (verbose) et "deboguage" (debug).

Par défaut, les messages fatals, d'erreur et normaux sont affichés sur
la sortie standard à l'endroit où le client et le serveur ont été
lancés. Vous pouvez rediriger les messages vers un fichier au lieu de
l'écran avec l'option en ligne de commande "--log fichier" (ou "-l
fichier").

Vous pouvez modifier le niveau des messages affichés avec "--debug
niveau" ou "-d niveau" (ou "-de level" pour le client Xaw, car "-d" est
ambigu : "-debug" et "-display"), où "niveau" vaut 0, 1, 2 ou 3. 0
correspond aux messages fatals uniquement ; 1 montre les messages fatals
et les messages d'erreur ; 2 les messages fatals, d'erreur et normaux
(défaut) ; et 3 montre tous les messages.

Si vous avez compilé Freeciv en définissant DEBUG (vous pouvez
facilement le faire en lançant ./configure avec --enable-debug), vous
pouvez avoir les messages de niveau "deboguage" en réglant le niveau à
4. De plus, il est possible de contrôler le niveau des messages de
déboguage (mais pas les autres) par fichier et par ligne. Pour ce faire,
utilisez "--debug 4:chaîne1:chaîne2" (autant de chaînes que vous voulez,
séparées par des virgules) et tous les noms de fichiers sources qui
contiennent ces sous-chaînes seront activés, tandis que tous les autres
seront supprimés. Pour contrôler les lignes, utilisez : "--debug
4:chaîne1,min,max" et, pour les fichiers qui correspondent à chaîne1,
seuls les messages de déboguage ayant entre min et max lignes seront
affichés. Seulement un couple (min,max) peut être appliqué à chaque
fichier.

Exemple :

  |  % civserver -l mon.log -d 3

Ceci met tous les messages de log du serveur dans le fichier "mon.log",
y compris les messages de niveau verbeux.

Exemple:

  |  % civclient --debug 0

Ceci supprime tous les messages de log non fatals du client.

Exemple:

  |  % civserver -d 4:log:civserver,120,500:autoattack

Ceci active tous les messages pour le serveur, et les messages de
déboguage pour certains modules. Notez que "log" s'applique autant à
"gamelog.c" qu'à "log.c". Pour "civserver.c", les messages de déboguage
entre les lignes 120 et 500 seront affichés. Cet exemple ne fonctionne
que si le serveur à été compilé avec DEBUG.


Bogues :
========

Vous avez trouvé un bogue ? Prévenez-nous, afin que nous puissions le
corriger. Consultez le fichier BUGS.fr pour avoir une liste des bogues
connus dans cette distribution, ainsi que des renseignements pour
signaler de nouveaux bogues.


Listes de diffusion :
=====================

Nous maintenons 6 listes de diffusion :

  freeciv-announce Annonces d'intérêt général.
		   C'est une liste en "lecture seule", avec des messages
		   peu fréquents. En d'autres termes, vous ne pouvez que
		   la lire, et pas y écrire. Les annonces qui y sont
		   envoyées le sont aussi sur freeciv.
  freeciv-i18n     Traduction de Freeciv.
                   Toutes les discussions à propos des traductions du code
                   de Freeciv, documentation et du website, vers d'autre
                   langues que l'anglais.
  freeciv-dev      Développement de Freeciv.
  freeciv-commits  Annonces de changements sur le SVN.
		   C'est une liste en "lecture seule", diffusant des
		   messages automatisés. En d'autres termes, vous ne
		   pouvez que la lire, et pas y écrire.

Toutes ces listes sont publiques et chacun est le bienvenu pour s'y
inscrire. Seuls les contributeurs peuvent poster des items sur les listes
-announce et -commits.

Les listes sont hebergées à gna.org. Pour plus d'informations, pour se joindre,
ou quitter ces listes, allez à https://gna.org/mail/?group=freeciv


Internet Relay Chat (IRC)
=========================

Certains joueurs et programmateurs sont disponibles sur les canaux #freeciv et
#freeciv-dev du réseau freenode. Essayez de connecter le serveur

	irc.freenode.net


Et pour conclure :
==================

Amusez-vous bien et envoyez les en enfer !

				   -- L'équipe de Freeciv
