{
    $Id: setjump.inc,v 1.4 2004/03/23 19:13:09 florian Exp $

    This file is part of the Free Pascal run time library.
    Copyright (c) 2003 by the Free Pascal development team.

    SetJmp and LongJmp implementation for exception handling

    See the file COPYING.FPC, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}

function setjmp(var S : jmp_buf) : longint;assembler;
  label FPC_SETJMP;
  asm
    // the usual entry code would mix up things here
  .globl FPC_SETJMP
  FPC_SETJMP:
     stmia   r0,{v1-v6, sl, fp, sp, lr}
     mov     r0,#0
     mov     pc,lr
  end;

procedure longjmp(var S : jmp_buf;value : longint);assembler;[Public, alias : 'FPC_LONGJMP'];
  asm
     mov     ip, r0
     movs    r0, r1
     moveq   r0, #1
     ldmia   ip,{v1-v6, sl, fp, sp, pc}
  end;


{
  $Log: setjump.inc,v $
  Revision 1.4  2004/03/23 19:13:09  florian
    * setjmp fixed

  Revision 1.3  2004/01/20 21:01:57  florian
    * fixed setjump
    * fixed syscalls

  Revision 1.2  2003/09/03 14:09:37  florian
    * arm fixes to the common rtl code
    * some generic math code fixed
    * ...

  Revision 1.1  2003/08/21 16:41:54  florian
    * empty dummy files
    + [long|set]jmp implemented
}
