#!/bin/sh
### install.sh - installation skript for German fortunes
### -- Andreas Tille <tille@debian.org>
###
VERSION="0.5"

PREFIX=${PREFIX-"/usr/local"}

### Databases
FORTUNES=`find data -type f -maxdepth 1 | sed "s?data/??"`
DIRS=`find data -type d -maxdepth 1 | sed "s?data/??" | sed "/data/d"`

DOC="README AUTHORS ChangeLog LIESMICH GPL-Deutsch"
DOCDIR=$PREFIX/${DOCDIR:-"doc/fortune-de-$VERSION"}
BINDIR=$PREFIX/${BINDIR:-"games"}
MANDIR=$PREFIX/${MANDIR:-"man"}
FORTUNEDIR=${FORTUNEDIR:-"$PREFIX/games"}
# SCRIPTS="spruch regeln"

FORTUNESDIR=$PREFIX/${FORTUNESDIR:-"share/games/fortunes"}
INSTDIR=$FORTUNESDIR/de

SCRIPTSEARCH=${SCRIPTSEARCH:-"$INSTDIR"}

### Rezepte
REZEPTE=`find rezepte -type d -maxdepth 1 | sed "s?rezepte/??" | sed "/rezepte/d"`
REZEPTTMP=rezept.tmp.$$

if [ -d $DOCDIR ] || mkdir -p $DOCDIR
then cp -a -f $DOC $DOCDIR
else 
 echo "Unable to create $DOCDIR."
 exit 2
fi

if [ -d $INSTDIR ] || mkdir -p $INSTDIR
then
# nicht vernderte Datenfiles
 for spruch in $FORTUNES
 do
  cp -a -f data/$spruch $INSTDIR
  strfile -s $INSTDIR/$spruch
 done
# Datenfiles, die einzeln besser pflegbar sind, aber zu einem
# Fortune-File zusammengefat werden
 for dir in $DIRS
 do
  cat `find data/$dir -type f | sort` > $INSTDIR/$dir
  strfile -s $INSTDIR/$dir
 done
# zu formatierende Daten
 cd predata 
# komische Namen
 sed "s/.*/Wie man sein Kind nicht nennen sollte: \\
  & \\
%/" prenamen | sed "\$d" > $INSTDIR/namen
 strfile -s $INSTDIR/namen
# "Warmduscher"
 sed "s/.*/Hallo &!\\
%/" prewarmduscher | sed "\$d" > $INSTDIR/warmduscher
 strfile -s $INSTDIR/warmduscher
 cd ..
# Rezepte
 for typ in $REZEPTE
 do
  rm -f ${REZEPTTMP}
  for rezept in `ls rezepte/$typ | sort`
  do
   cat rezepte/$typ/$rezept >> ${REZEPTTMP}
   echo "%" >> ${REZEPTTMP}
  done
  sed "$d" ${REZEPTTMP} > $INSTDIR/$typ
  strfile -s $INSTDIR/$typ
  rm -f ${REZEPTTMP}
 done
else
  echo "Unable to create $FORTUNESDIR."
  exit 3
fi

# Script-Pfade anpassen
mainsh="spruch"
if [ -d $BINDIR ] || mkdir -p $BINDIR
then
  cat bin/$mainsh.sh | \
      sed "s?/usr/local/share/games/fortunes/de?$SCRIPTSEARCH?" | \
      sed "s?\(FORTUNEPATH=\)/usr/local/games/?\1$FORTUNEDIR/?" \
      > $BINDIR/$mainsh
    chmod 755 $BINDIR/$mainsh
  for sh in `ls rezepte`
  do
    ln -sf $mainsh $BINDIR/$sh
  done
else
  echo  "Unable to create $BINDIR"
fi

MANLOCALES="/ /de/"
mainman="spruch.6"
for loc in ${MANLOCALES} ; do
  MAN6DIR=$MANDIR${loc}man6
  if [ -d $MAN6DIR ] || mkdir -p $MAN6DIR
  then
    cp -a man${loc}$mainman $MAN6DIR
    for man in `ls rezepte` ; do
      ln -sf $mainman $MAN6DIR/${man}.6
    done
    if [ "$loc" == "/de/" ] ; then
      ln -sf $mainman $MAN6DIR/fortune.6
    fi
  else
    echo  "Unable to create $MAN6DIR"
  fi
done

if [ -f ${BINDIR}/fortune ] ; then
  if [ -f ${BINDIR}/fortune.en -o -L ${BINDIR}/fortune ] ; then
    echo "Es scheint schon eine frhere Version von fortunes-de installiert worden zu sein."
    echo "Verzichte auf das Umbenennen von ${BINDIR}/fortune."
  else
    mv ${BINDIR}/fortune ${BINDIR}/fortune.en
  fi
fi
ln -sf $mainsh ${BINDIR}/fortune

MAN6DIR=$MANDIR/man6
if [ -f ${MAN6DIR}/fortune.6 ] ; then
  if [ -f ${MAN6DIR}/fortune.en.6 -o -L ${MAN6DIR}/fortune.6 ] ; then
    echo "Verzichte auf das Umbenennen von ${MAN6DIR}/fortune.en.6."
  else
    mv ${MAN6DIR}/fortune.6 ${MAN6DIR}/fortune.en.6
  fi
fi
if [ -f ${MAN6DIR}/fortune.6.gz ] ; then
  if [ -f ${MAN6DIR}/fortune.en.6.gz -o -L ${MAN6DIR}/fortune.6.gz ] ; then
    echo "Verzichte auf das Umbenennen von ${MAN6DIR}/fortune.en.6.gz."
  else
    mv ${MAN6DIR}/fortune.6.gz ${MAN6DIR}/fortune.en.6.gz
  fi
fi
ln -sf $mainman $MAN6DIR/fortune.6

exit $?

