/***************************************************************************
 *		
 *		File		: mboxlib.c
 *
 *		Title		: Mbox connect library
 *
 *		Description	: Reads a mbox file and checks for new mail
 *
 *		Author		: Marcus Leyman, 2001
 *
 *		License		: GPL
 *
 *		Date		: 06 May 2001
 *
 ***************************************************************************/

#include <sys/stat.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <gnome.h>

#include "mboxlib.h"


int mboxStatistics (char *path)
{

    FILE *file;
    struct stat s;
    static int headerNB = 0;
    char line[256];
    int headerFlag;
    int msgs = 0;

    if (stat(path, &s) != 0)
    {
	    return (-1);
    }	

    if ((file = fopen (path, "r")) == NULL) 
    {
		return (-2);
    }
    while (fgets (line, 255, file)) 
    {

		if ((char *) strstr (line, "From ") == line) 
		{
	    	    headerFlag = 0;		
		}
		if (((char *) strstr(line, "\n") == line) && (headerFlag == 0)) 
		{
	    	    headerFlag = 1;
			    headerNB++;
		}
    }

    if (fclose (file) != 0) 
    {
		return (msgs);
    }
    msgs = 0;
    msgs = headerNB;
    headerNB = 0;
    return msgs;

}
