/*---[ druid-choices.c ]----------------------------------------------
 * Copyright (C) 2000 Tomas Junnonen (majix@sci.fi)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Functions dealing with saving/restoring the users druid choices
 *--------------------------------------------------------------------*/

#include "druid-choices.h"
#include "druid.h"

void
load_choices (Druid *data)
{
	/* Internal/External devices */
	gtk_entry_set_text (GTK_ENTRY (data->extdevice),
		gnome_config_get_string ("/firestarter/Druid/extdevice"));

	gtk_entry_set_text (GTK_ENTRY (data->intdevice),
		gnome_config_get_string ("/firestarter/Druid/intdevice"));

	/* Internal network IP range (manual setting) */
	gnome_config_set_string ("/firestarter/Druid/intrange",
		gtk_entry_get_text (GTK_ENTRY (data->intrange)));
		
	/* Advanced wizard flow toggle */
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->advanced),
		gnome_config_get_bool ("/firestarter/Druid/advanced"));

	/* Autodetect internal network IP range */
	gtk_widget_set_sensitive (data->auto_int_ip,
		gnome_config_get_bool ("/firestarter/Druid/auto_int_ip"));

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->pppcheck),
		gnome_config_get_bool ("/firestarter/Druid/pppcheck"));

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->dhcpcheck),
		gnome_config_get_bool ("/firestarter/Druid/dhcpcheck"));

	/* Sensitivity toggles for the pages */
	gtk_widget_set_sensitive (data->services,
		gnome_config_get_bool ("/firestarter/Druid/services"));
	gtk_widget_set_sensitive (data->icmp,
		gnome_config_get_bool ("/firestarter/Druid/icmp"));
	gtk_widget_set_sensitive (data->tos,
		gnome_config_get_bool ("/firestarter/Druid/tos"));
	gtk_widget_set_sensitive (data->masq,
		gnome_config_get_bool ("/firestarter/Druid/masq"));

	/* Services */
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->ftp),
		gnome_config_get_bool ("/firestarter/Druid/ftp"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->ssh),
		gnome_config_get_bool ("/firestarter/Druid/ssh"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->telnet),
		gnome_config_get_bool ("/firestarter/Druid/telnet"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->smtp),
		gnome_config_get_bool ("/firestarter/Druid/smtp"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->dns),
		gnome_config_get_bool ("/firestarter/Druid/dns"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->finger),
		gnome_config_get_bool ("/firestarter/Druid/finger"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->www),
		gnome_config_get_bool ("/firestarter/Druid/www"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->sslweb),
		gnome_config_get_bool ("/firestarter/Druid/sslweb"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->pop),
		gnome_config_get_bool ("/firestarter/Druid/pop"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->imap),
		gnome_config_get_bool ("/firestarter/Druid/imap"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->ident),
		gnome_config_get_bool ("/firestarter/Druid/ident"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->nntp),
		gnome_config_get_bool ("/firestarter/Druid/nntp"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->ntp),
		gnome_config_get_bool ("/firestarter/Druid/ntp"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->samba),
		gnome_config_get_bool ("/firestarter/Druid/samba"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->ipsec),
		gnome_config_get_bool ("/firestarter/Druid/ipsec"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->routed),
		gnome_config_get_bool ("/firestarter/Druid/routed"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->nfs),
		gnome_config_get_bool ("/firestarter/Druid/nfs"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->x),
		gnome_config_get_bool ("/firestarter/Druid/x"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->dhcp),
		gnome_config_get_bool ("/firestarter/Druid/dhcp"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->upnp),
		gnome_config_get_bool ("/firestarter/Druid/upnp"));

	/* ICMP filtering */
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->icmp_echo),
		gnome_config_get_bool ("/firestarter/Druid/icmp_echo"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->icmp_traceroute),
		gnome_config_get_bool ("/firestarter/Druid/icmp_traceroute"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->icmp_tracert),
		gnome_config_get_bool ("/firestarter/Druid/icmp_tracert"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->icmp_unreach),
		gnome_config_get_bool ("/firestarter/Druid/icmp_unreach"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->icmp_timestamp),
		gnome_config_get_bool ("/firestarter/Druid/icmp_timestamp"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->icmp_masking),
		gnome_config_get_bool ("/firestarter/Druid/icmp_masking"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->icmp_redir),
		gnome_config_get_bool ("/firestarter/Druid/icmp_redir"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->icmp_quench),
		gnome_config_get_bool ("/firestarter/Druid/icmp_quench"));

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->tos_client),
		gnome_config_get_bool ("/firestarter/Druid/tos_client"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->tos_server),
		gnome_config_get_bool ("/firestarter/Druid/tos_server"));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->tos_X),
		gnome_config_get_bool ("/firestarter/Druid/tos_X"));

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->tos_option_throughput),
		gnome_config_get_bool ("/firestarter/Druid/tos_option_throughput"));

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->tos_option_reliability),
		gnome_config_get_bool ("/firestarter/Druid/tos_option_reliability"));

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (data->tos_option_delay),
		gnome_config_get_bool ("/firestarter/Druid/tos_option_delay"));
}

void
save_choices (Druid *data)
{
	/* Internal/External devices */
	gnome_config_set_string ("/firestarter/Druid/extdevice",
		gtk_entry_get_text (GTK_ENTRY (data->extdevice)));
	gnome_config_set_string ("/firestarter/Druid/intdevice",
		gtk_entry_get_text (GTK_ENTRY (data->intdevice)));

	/* Internal network IP range (manual setting) */
	gnome_config_set_string ("/firestarter/Druid/intrange",
		gtk_entry_get_text (GTK_ENTRY (data->intrange)));
		
	/* Advanced wizard flow toggle */
	gnome_config_set_bool ("/firestarter/Druid/advanced",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->advanced)));		
		
	/* Autodetect internal network IP range */
	gnome_config_set_bool ("/firestarter/Druid/auto_int_ip",
		GTK_WIDGET_IS_SENSITIVE (GTK_WIDGET (data->auto_int_ip)));

	gnome_config_set_bool ("/firestarter/Druid/pppcheck",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->pppcheck)));
	gnome_config_set_bool ("/firestarter/Druid/dhcpcheck",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->dhcpcheck)));

	/* Sensitivity toggles for the pages */
	gnome_config_set_bool ("/firestarter/Druid/services",
		GTK_WIDGET_IS_SENSITIVE (data->services));
	gnome_config_set_bool ("/firestarter/Druid/icmp",
		GTK_WIDGET_IS_SENSITIVE (data->icmp));
	gnome_config_set_bool ("/firestarter/Druid/tos",
		GTK_WIDGET_IS_SENSITIVE (data->tos));
	gnome_config_set_bool ("/firestarter/Druid/masq",
		GTK_WIDGET_IS_SENSITIVE (data->masq));

	/* Services */
	gnome_config_set_bool ("/firestarter/Druid/ftp",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->ftp)));
	gnome_config_set_bool ("/firestarter/Druid/ssh",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->ssh)));
	gnome_config_set_bool ("/firestarter/Druid/telnet",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->telnet)));
	gnome_config_set_bool ("/firestarter/Druid/smtp",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->smtp)));
	gnome_config_set_bool ("/firestarter/Druid/dns",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->dns)));
	gnome_config_set_bool ("/firestarter/Druid/finger",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->finger)));
	gnome_config_set_bool ("/firestarter/Druid/www",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->www)));
	gnome_config_set_bool ("/firestarter/Druid/sslweb",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->sslweb)));
	gnome_config_set_bool ("/firestarter/Druid/pop",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->pop)));
	gnome_config_set_bool ("/firestarter/Druid/imap",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->imap)));
	gnome_config_set_bool ("/firestarter/Druid/ident",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->ident)));
	gnome_config_set_bool ("/firestarter/Druid/nntp",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->nntp)));
	gnome_config_set_bool ("/firestarter/Druid/ntp",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->ntp)));
	gnome_config_set_bool ("/firestarter/Druid/samba",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->samba)));
	gnome_config_set_bool ("/firestarter/Druid/ipsec",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->ipsec)));
	gnome_config_set_bool ("/firestarter/Druid/routed",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->routed)));
	gnome_config_set_bool ("/firestarter/Druid/nfs",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->nfs)));
	gnome_config_set_bool ("/firestarter/Druid/x",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->x)));
	gnome_config_set_bool ("/firestarter/Druid/dhcp",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->dhcp)));
	gnome_config_set_bool ("/firestarter/Druid/upnp",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->upnp)));

	/* ICMP filtering */
	gnome_config_set_bool ("/firestarter/Druid/icmp_echo",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->icmp_echo)));
	gnome_config_set_bool ("/firestarter/Druid/icmp_traceroute",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->icmp_traceroute)));
	gnome_config_set_bool ("/firestarter/Druid/icmp_tracert",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->icmp_tracert)));
	gnome_config_set_bool ("/firestarter/Druid/icmp_unreach",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->icmp_unreach)));
	gnome_config_set_bool ("/firestarter/Druid/icmp_timestamp",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->icmp_timestamp)));
	gnome_config_set_bool ("/firestarter/Druid/icmp_masking",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->icmp_masking)));
	gnome_config_set_bool ("/firestarter/Druid/icmp_redir",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->icmp_redir)));
	gnome_config_set_bool ("/firestarter/Druid/icmp_quench",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->icmp_quench)));

	/* TOS filtering */
	gnome_config_set_bool ("/firestarter/Druid/tos_client",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->tos_client)));
	gnome_config_set_bool ("/firestarter/Druid/tos_server",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->tos_server)));
	gnome_config_set_bool ("/firestarter/Druid/tos_X",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->tos_X)));

	gnome_config_set_bool ("/firestarter/Druid/tos_option_throughput",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->tos_option_throughput)));
	gnome_config_set_bool ("/firestarter/Druid/tos_option_reliability",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->tos_option_reliability)));
	gnome_config_set_bool ("/firestarter/Druid/tos_option_delay",
		gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data->tos_option_delay)));

	gnome_config_sync ();
}
